<?php


$product_id = get_the_ID();
		if ( ! $product_id ) { Main::restore_preview(); return; }

		$teachers = get_post_meta( $product_id, '_woodmart_product_teachers', true );
		if ( empty( $teachers ) || ! is_array( $teachers ) ) {
			Main::restore_preview();
			return;
		}

?>

<div class="course-teacher-details">

<div class="wd-product-teachers">

			<?php foreach ( $teachers as $teacher_id ) : ?>

				<?php if ( get_post_type( $teacher_id ) !== 'teacher' ) continue; ?>

				<?php
					$title    = get_the_title( $teacher_id );
					$link     = get_permalink( $teacher_id );
					$thumb    = get_the_post_thumbnail( $teacher_id, 'thumbnail' );
					$job_role = get_post_meta( $teacher_id, '_woodmart_teacher_second_title', true );
				?>

				<div class="wd-teacher-item <?php echo esc_attr( $layout_class ); ?>">

					<a href="<?php echo esc_url( $link ); ?>" class="wd-teacher-thumb">
						<?php echo $thumb; ?>
					</a>

					<div class="wd-teacher-content">
						<div class="wd-teacher-name">
							<a href="<?php echo esc_url( $link ); ?>">
								<?php echo esc_html( $title ); ?>
							</a>
						</div>

						<?php if ( ! empty( $job_role ) ) : ?>
							<p class="wd-teacher-excerpt"><?php echo esc_html( $job_role ); ?></p>
						<?php endif; ?>
					</div>

				</div>

			<?php endforeach; ?>

</div>
</div>

