<?php
global $product;

if ( ! $product ) {
    return;
}

$preview_url  = get_post_meta( $product->get_id(), '_woodmart_product_preview', true );
$preview_text = get_post_meta( $product->get_id(), '_woodmart_product_preview_text', true );

do_action( 'woocommerce_before_shop_loop_item' );

woodmart_enqueue_js_script( 'btns-tooltip' );
?>

<div class="product-wrapper">

	<div class="product-element-top wd-quick-shop">

		<a href="<?php echo esc_url( get_permalink() ); ?>" 
		   class="product-image-link" 
		   tabindex="-1" 
		   aria-label="<?php echo esc_attr( get_the_title() ); ?>">

			<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>

		</a>

		<?php 
		if (
			! woodmart_loop_prop( 'grid_gallery' ) ||
			( 
				! woodmart_get_opt( 'grid_gallery' ) && 
				empty( woodmart_loop_prop( 'grid_gallery_control', 'hover' ) ) &&
				empty( woodmart_loop_prop( 'grid_gallery_enable_arrows', 'none' ) ) 
			)
		) {
			woodmart_hover_image();
		}
		?>

		<div class="wd-buttons wd-pos-r-t<?php echo esc_attr( woodmart_get_old_classes( ' woodmart-buttons' ) ); ?>">
			<?php do_action( 'woodmart_product_action_buttons' ); ?>
		</div>

	</div>

	<div class="product-element-bottom">

		<div class="wd-product-header">
			<?php do_action( 'woocommerce_shop_loop_item_title' ); ?>
		</div>

		<?php
			woodmart_product_categories();
			woodmart_product_brands_links();
			woodmart_stock_status_after_title();
		?>

		<div class="product-flex">

			<div class="wrap-price">

				<?php
				// =============== درصد تخفیف به‌صورت تمیز ==================
				$percentage = 0;

				if ( $product->is_on_sale() ) {

					if ( $product->is_type( 'simple' ) ) {

						$regular = (float) $product->get_regular_price();
						$sale    = (float) $product->get_sale_price();

						if ( $regular > 0 && $sale > 0 ) {
							$percentage = round( ( ( $regular - $sale ) / $regular ) * 100 );
						}

					} elseif ( $product->is_type( 'variable' ) ) {

						$percents = [];

						foreach ( $product->get_children() as $child_id ) {
							$variation      = wc_get_product( $child_id );
							$reg            = (float) $variation->get_regular_price();
							$sal            = (float) $variation->get_sale_price();

							if ( $reg > 0 && $sal > 0 ) {
								$percents[] = round( ( ( $reg - $sal ) / $reg ) * 100 );
							}
						}

						if ( ! empty( $percents ) ) {
							$percentage = max( $percents );
						}
					}
				}

				if ( $percentage > 0 ) :
				?>
					<span class="hooshali-discount"><?php echo esc_html( $percentage ); ?>%</span>
				<?php endif; ?>

				<?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>

			</div>

			<?php echo wp_kses_post( woodmart_get_product_rating( 'simple', 1 ) ); ?>

			<div class="wrap-total-sale">

				<?php 
					$total_sold = get_post_meta( $product->get_id(), 'total_sales', true );
					echo esc_html( $total_sold );
				?>

				<!-- آیکون سبد -->
				<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24" color="#878F9B" style="color:#878F9B" height="16" width="16" xmlns="http://www.w3.org/2000/svg">
					<path d="M4.00436 6.41686L0.761719 3.17422L2.17593 1.76001L5.41857 5.00265H20.6603C21.2126 5.00265 21.6603 5.45037 21.6603 6.00265C21.6603 6.09997 21.6461 6.19678 21.6182 6.29L19.2182 14.29C19.0913 14.713 18.7019 15.0027 18.2603 15.0027H6.00436V17.0027H17.0044V19.0027H5.00436C4.45207 19.0027 4.00436 18.5549 4.00436 18.0027V6.41686ZM6.00436 7.00265V13.0027H17.5163L19.3163 7.00265H6.00436ZM5.50436 23.0027C4.67593 23.0027 4.00436 22.3311 4.00436 21.5027C4.00436 20.6742 4.67593 20.0027 5.50436 20.0027C6.33279 20.0027 7.00436 20.6742 7.00436 21.5027C7.00436 22.3311 6.33279 23.0027 5.50436 23.0027ZM17.5044 23.0027C16.6759 23.0027 16.0044 22.3311 16.0044 21.5027C16.0044 20.6742 16.6759 20.0027 17.5044 20.0027C18.3328 20.0027 19.0044 20.6742 19.0044 21.5027C19.0044 22.3311 18.3328 23.0027 17.5044 23.0027Z"></path>
				</svg>

			</div>

		</div>

		<?php do_action( 'woocommerce_after_shop_loop_item' ); ?>

		<?php woodmart_product_sku(); ?>

		<?php if ( woodmart_loop_prop( 'progress_bar' ) ) : ?>
			<?php woodmart_stock_progress_bar(); ?>
		<?php endif; ?>

		<?php if ( woodmart_loop_prop( 'timer' ) ) : ?>
			<?php woodmart_product_sale_countdown(); ?>
		<?php endif; ?>

		<div class="wd-product-footer">

			<div class="wd-action-buttons">
				<a class="btn btn-style-semi-round pre-link" 
				   href="<?php echo esc_url( $preview_url ); ?>" 
				   aria-label="<?php echo esc_attr( get_the_title() ); ?>" 
				   target="_blank" rel="nofollow">
					<span class="wd-btn-text">پیشنمایش</span>
				</a>
			</div>

			<div class="wd-add-btn wd-add-btn-replace<?php echo esc_attr( woodmart_get_old_classes( ' woodmart-add-btn' ) ); ?>">
				<?php do_action( 'woodmart_add_loop_btn' ); ?>
			</div>

		</div>

	</div>
</div>
