<?php

	global $product;
	$image_icon = get_post_meta( get_the_ID(), '_woodmart_iconimage', true );
	if ( is_array( $image_icon ) && isset( $image_icon['id'] ) ) {
				$image_icon = wp_get_attachment_image_url( $image_icon['id'], 'full' );
			}

?>

<div class="product-wrapper icon-product">

	<?php
global $product;

if ( ! $product ) {
	return;
}

// بررسی نوع محصول
if ( $product->is_type( 'simple' ) ) {
	$regular_price = (float) $product->get_regular_price();
	$sale_price    = (float) $product->get_sale_price();

	if ( $regular_price > 0 && $sale_price > 0 && $sale_price < $regular_price ) {
		$discount = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
		echo '<span class="hooshali-discount">' . $discount . '%</span>';
	}

} elseif ( $product->is_type( 'variable' ) ) {
	$regular_price = (float) $product->get_variation_regular_price( 'max' );
	$sale_price    = (float) $product->get_variation_sale_price( 'min' );

	if ( $regular_price > 0 && $sale_price > 0 && $sale_price < $regular_price ) {
		$discount = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
		echo '<span class="hooshali-discount">' . $discount . '%</span>';
	}
}
?>

		
	<?php studiare_thumbnail_product_item() ?>
		<div class="wd-product-header">
			<?php
			do_action( 'woocommerce_shop_loop_item_title' );
			?>
		</div>
</div>