<?php
/**
 * Default Single Teacher Post Template
 */

get_header();


$teacher_id = get_the_ID(); // آی دی مدرس فعلی
$comment_count = get_comments_number(get_the_ID());

$args = array(
	'post_type' => 'product',
	'post_status' => 'publish',
	'meta_query' => array(
		array(
			'key' => '_woodmart_product_teachers',
			'value' => '"' . $teacher_id . '"',
			'compare' => 'LIKE',
		)
	),
	'fields' => 'ids', // فقط آی‌دی‌ها برای سبک‌تر شدن
	'posts_per_page' => -1
);

$query = new WP_Query($args);
$products_count = $query->found_posts;

// Container start
$site_inner = array('site-content-inner container');
$container = array('main-page-content default-margin');
$status = get_post_meta(get_the_ID(), '_woodmart_expert_status', true);
$archive_link = get_post_type_archive_link('expert');

$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');
$teacer_second_title = get_post_meta(get_the_ID(), '_woodmart_teacher_second_title', true);
$expert_id = get_the_ID();
$course_expert = get_post_meta($expert_id, '_woodmart_product_experts', true);


$tell_expert = get_post_meta(get_the_ID(), 'expert_tell', true);
$telegram_expert = get_post_meta(get_the_ID(), 'expert_telegram', true);
$instagram_expert = get_post_meta(get_the_ID(), 'expert_instagram', true);
$whatsapp_expert = get_post_meta(get_the_ID(), 'expert_whatsapp', true);


$teacher_id = get_the_ID();
$medals = get_post_meta($teacher_id, '_woodmart_teacher_medals', true);


?>






<!-- Modal -->
<!-- Modal -->
<div id="expert-contact" class="kt-modal-wrap">
	<div class="kt-modal-content">

		<div class="kt-modal-header">
			<div class="kt-modal-title">اطلاعات تماس</div>
			<span class="kt-modal-close">&times;</span>
		</div>

		<div class="kt-modal-body py-25 px-20">

			<?php if (!empty($tell_expert)): ?>
				<a href="tel:<?php echo esc_html($tell_expert); ?>" class="kt-expert-contact-modal-item mobile">
					<i class="fal fa-phone"></i>
					<span>شماره تماس</span>
					<strong><?php echo esc_html($tell_expert); ?></strong>
				</a>
			<?php endif; ?>

			<?php if (!empty($instagram_expert)): ?>
				<a href="<?php echo esc_html($instagram_expert); ?>" class="kt-expert-contact-modal-item instagram">
					<i class="fal fa-instagram"></i>
					<span>صفحه اینستاگرام</span>
					<i class="fal fa-angle-left"></i>
				</a>
			<?php endif; ?>

			<?php if (!empty($telegram_expert)): ?>
				<a href="<?php echo esc_html($telegram_expert); ?>" class="kt-expert-contact-modal-item telegram">
					<i class="fal fa-telegram"></i>
					<span>تماس از طریق تلگرام</span>
					<i class="fal fa-angle-left"></i>
				</a>
			<?php endif; ?>

			<?php if (!empty($whatsapp_expert)): ?>
				<a href="whatsapp://send?phone=<?php echo esc_html($whatsapp_expert); ?>"
					class="kt-expert-contact-modal-item whatsapp">
					<i class="fal fa-whatsapp"></i>
					<span>تماس از طریق واتس‌اپ</span>
					<i class="fal fa-angle-left"></i>
				</a>
			<?php endif; ?>

		</div>


	</div>
</div>





<div class="<?php echo esc_attr(implode(' ', $container)); ?>" id="content">

	<div class="<?php echo esc_attr(implode(' ', $site_inner)); ?>" role="main">

		<?php if (have_posts()):
			while (have_posts()):
				the_post(); ?>
				<div class="teacher-single">

					<div class="expert-profile-holder">
						<div class="expert-profile-header-holder">

							<div class="expert-profile-header-bg-holder">
								<div class="expert-profile-header-bg"
									style="background-image:url('<?php echo esc_url($thumbnail_url); ?>');"></div>
							</div>

							<div class="breadcrumb-holder">
								<?php custom_breadcrumb(); ?>
							</div>

							<div class="expert-profile-header">
								<img class="expert-profile-avatar" src="<?php echo esc_url($thumbnail_url); ?>" width="160"
									height="160" alt="<?php echo esc_attr(get_the_title()); ?>">
								<div class="expert-profile-name-holder ml-auto">
									<div class="expert-profile-label">
										<svg class="mr-2" xmlns="http://www.w3.org/2000/svg" width="20" height="20"
											viewBox="0 0 20 20">
											<g id="web-app" transform="translate(-2 -2)">
												<g id="check-verified">
													<path id="Shape"
														d="M4.252,14H4a2,2,0,0,1,0-4h.252a7.952,7.952,0,0,1,.856-2.064l-.179-.179A2,2,0,0,1,7.757,4.929l.179.179A7.952,7.952,0,0,1,10,4.252V4a2,2,0,0,1,4,0v.252a7.952,7.952,0,0,1,2.064.856l.179-.179a2,2,0,0,1,2.829,2.828l-.179.179A7.957,7.957,0,0,1,19.748,10H20a2,2,0,0,1,0,4h-.252a7.957,7.957,0,0,1-.856,2.064l.179.179a2,2,0,0,1-2.829,2.829l-.179-.179A7.957,7.957,0,0,1,14,19.748V20a2,2,0,0,1-4,0v-.252a7.957,7.957,0,0,1-2.064-.856l-.179.179a2,2,0,0,1-2.828-2.829l.179-.179A7.952,7.952,0,0,1,4.252,14ZM9,10,7,12l4,4,6-6L15,8l-4,4Z"
														fill-rule="evenodd"></path>
												</g>
											</g>
										</svg>
										<span><?php echo '<div class="teacher-product-count">دارای ' . $products_count . ' دوره تدریس شده</div>'; ?></span>

									</div>

									<h1 class="expert-profile-name font-weight-bold"><?php the_title(); ?></h1>
									<div class="text-muted font-weight-normal"><?php echo esc_html($teacer_second_title); ?>
									</div>
								</div>


								<div class="wd-product-medals">
									<?php if (!empty($medals) && is_array($medals)): ?>
										<?php foreach ($medals as $medal_id):

											// جلوگیری از نمایش پست تایپ غیر از مدال
											if (get_post_type($medal_id) !== 'cms_medal') {
												continue;
											}

											$title = get_the_title($medal_id);
											$thumb = get_the_post_thumbnail($medal_id, 'thumbnail');

											// اگر مدال تصویر نداشت رد شود
											if (empty($thumb)) {
												continue;
											}
											?>
											<div class="wd-medal-item" data-title="<?php echo esc_attr($title); ?>">
												<div class="wd-medal-thumb"><?php echo $thumb; ?></div>
											</div>

										<?php endforeach; ?>
									<?php endif; ?>
								</div>




								<?php
								$post_id = get_the_ID();

								if (comments_open($post_id)) {
									echo '<a href="#reviews-techaer" class="teacher-comment-count">';
									echo '<i class="fal fa-message"></i>';
									echo ' (' . $comment_count . ') ';
									echo 'نظرات دانشجویان';
									echo '</a>';
								}
								?>




								<button type="button" class="button button-blue expert-profile-contact-btn kt-modal-button"
									data-modal="expert-contact">
									<i class="fal fa-phone"></i>
									<span>اطلاعات تماس</span>
								</button>
							</div>

						</div>

						<div class="expert-profile-content">

							<div class="expert-profile-about text-dark">
								<?php the_content(); ?>
							</div>

						</div>
					</div>

				</div>



				<div class="expert-profile-similar">

					<h3 class="expert-profile-section-title">دوره های تدریس شده</h3>

					<?php
					$teacher_id = get_the_ID();

					$args = array(
						'post_type' => 'product',
						'post_status' => 'publish',
						'posts_per_page' => -1,
						'meta_query' => array(
							array(
								'key' => '_woodmart_product_teachers',
								'value' => '"' . $teacher_id . '"',
								'compare' => 'LIKE',
							),
						),
					);

					$products = new WP_Query($args);

					if ($products->have_posts()) {

						// شروع حلقه ووکامرس
						woocommerce_product_loop_start();

						while ($products->have_posts()) {
							$products->the_post();

							// کارت محصول استاندارد قالب
							wc_get_template_part('content', 'product');
						}

						// پایان حلقه ووکامرس
						woocommerce_product_loop_end();

					} else {
						echo '<p>هنوز دوره‌ای برای این مدرس ثبت نشده است.</p>';
					}

					wp_reset_postdata();
					?>

				</div>


				<?php if (comments_open() || get_comments_number()): ?>

					<div id="reviews-techaer" class="expert-profile-similar">
						<h3 class="expert-profile-section-title">دیدگاه ها</h3>
						<?php comments_template(); ?>
					</div>

				<?php endif; ?>







			</div>
		<?php endwhile; endif; ?>

</div>

</div>

<?php get_footer(); ?>