<?php
/**
 * Default Single Teacher Post Template
 */

get_header();

// Container start
$site_inner = array('site-content-inner container');
$container = array('main-page-content default-margin');
$status = get_post_meta(get_the_ID(), '_woodmart_expert_status', true);
$archive_link = get_post_type_archive_link('expert'); 

$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');
$job_title = get_post_meta(get_the_ID(), '_woodmart_expert_job', true);
$expert_id = get_the_ID();
$course_expert = get_post_meta($expert_id, '_woodmart_product_experts', true);


$tell_expert = get_post_meta(get_the_ID(), 'expert_tell', true);
$telegram_expert = get_post_meta(get_the_ID(), 'expert_telegram', true);
$instagram_expert = get_post_meta(get_the_ID(), 'expert_instagram', true);
$whatsapp_expert = get_post_meta(get_the_ID(), 'expert_whatsapp', true);

?>






<!-- Modal -->
<!-- Modal -->
<div id="expert-contact" class="kt-modal-wrap">
	<div class="kt-modal-content">

		<div class="kt-modal-header">
			<div class="kt-modal-title">اطلاعات تماس</div>
			<span class="kt-modal-close">&times;</span>
		</div>

		<div class="kt-modal-body py-25 px-20">
			<a href="tel:<?php echo esc_html($tell_expert); ?>" class="kt-expert-contact-modal-item mobile">
				<i class="fal fa-phone"></i>
				<span>شماره تماس</span>
				<strong><?php echo esc_html($tell_expert); ?></strong>
			</a>
			<a href="<?php echo esc_html($instagram_expert); ?>" class="kt-expert-contact-modal-item instagram">
				<i class="fal fa-instagram"></i>
				<span>صفحه اینستاگرام</span>
				<i class="fal fa-angle-left"></i>
			</a>
			<a href="<?php echo esc_html($telegram_expert); ?>" class="kt-expert-contact-modal-item telegram">
				<i class="fal fa-telegram"></i>
				<span>تماس از طریق تلگرام</span>
				<i class="fal fa-angle-left"></i>
			</a>
			<a href="whatsapp://send?phone=<?php echo esc_html($whatsapp_expert); ?>"
				class="kt-expert-contact-modal-item whatsapp">
				<i class="fal fa-whatsapp"></i>
				<span>تماس از طریق واتس‌اپ</span>
				<i class="fal fa-angle-left"></i>
			</a>
		</div>

	</div>
</div>





<div class="<?php echo esc_attr(implode(' ', $container)); ?>" id="content">

	<div class="<?php echo esc_attr(implode(' ', $site_inner)); ?>" role="main">

		<?php if (have_posts()):
			while (have_posts()):
				the_post(); ?>
				<div class="teacher-single">

					<div class="expert-profile-holder">
						<div class="expert-profile-header-holder">

							<div class="expert-profile-header-bg-holder">
								<div class="expert-profile-header-bg"
									style="background-image:url('<?php echo esc_url($thumbnail_url); ?>');"></div>
							</div>

							<div class="breadcrumb-holder">
								<?php custom_breadcrumb(); ?>
							</div>

							<div class="expert-profile-header">
								<img class="expert-profile-avatar" src="<?php echo esc_url($thumbnail_url); ?>" width="160"
									height="160" alt="<?php echo esc_attr(get_the_title()); ?>">
								<div class="expert-profile-name-holder ml-auto">
									<div class="expert-profile-label">
										<svg class="mr-2" xmlns="http://www.w3.org/2000/svg" width="20" height="20"
											viewBox="0 0 20 20">
											<g id="web-app" transform="translate(-2 -2)">
												<g id="check-verified">
													<path id="Shape"
														d="M4.252,14H4a2,2,0,0,1,0-4h.252a7.952,7.952,0,0,1,.856-2.064l-.179-.179A2,2,0,0,1,7.757,4.929l.179.179A7.952,7.952,0,0,1,10,4.252V4a2,2,0,0,1,4,0v.252a7.952,7.952,0,0,1,2.064.856l.179-.179a2,2,0,0,1,2.829,2.828l-.179.179A7.957,7.957,0,0,1,19.748,10H20a2,2,0,0,1,0,4h-.252a7.957,7.957,0,0,1-.856,2.064l.179.179a2,2,0,0,1-2.829,2.829l-.179-.179A7.957,7.957,0,0,1,14,19.748V20a2,2,0,0,1-4,0v-.252a7.957,7.957,0,0,1-2.064-.856l-.179.179a2,2,0,0,1-2.828-2.829l.179-.179A7.952,7.952,0,0,1,4.252,14ZM9,10,7,12l4,4,6-6L15,8l-4,4Z"
														fill-rule="evenodd"></path>
												</g>
											</g>
										</svg>
										<span>آموزش‌دیده در دوره های ما</span>
									</div>
									<h1 class="expert-profile-name font-weight-bold"><?php the_title(); ?></h1>

									<div class="text-muted font-weight-normal"><?php echo esc_html($job_title); ?></div>
								</div>
								<button type="button" class="button button-blue expert-profile-contact-btn kt-modal-button"
									data-modal="expert-contact">
									<i class="fal fa-phone"></i>
									<span>اطلاعات تماس</span>
								</button>
							</div>

						</div>

						<?php if ($status === 'is-hired'): ?>
						<div class="expert-profile-content-holder <?php echo esc_attr($status); ?>">
							<div class="expert-profile-hired">
									<i class="fal fa-check"></i>
									<h4 class="text-lg mb-2 text-secondary">این متخصص استخدام شده است!</h4>
									<div class="text-sm text-dark">نیرو استخدام شد، سایر آگهی ها را ببینید</div>
									<a href="<?php echo esc_url($archive_link); ?>" class="btn btn-style-default btn-shape-curv btn-color-primary">سایر متخصص‌ها</a>
							</div>
						<?php endif; ?>


							<div class="expert-profile-content">
								<div class="row">
									<div class="column kt-col-xs-12 kt-col-sm-6">
										<div class="expert-profile-about text-dark">
											<?php the_content(); ?>
										</div>
									</div>
									<div class="column kt-col-xs-12 kt-col-sm-6">
										<div class="row expert-profile-details">
											<div class="column kt-col-xs-12">
												<h3 class="expert-profile-section-title">
													مهارت ها:
												</h3>
												<ul class="expert-profile-list">
													<?php
													$terms = get_the_terms(get_the_ID(), 'expert_skill');
													if ($terms && !is_wp_error($terms)) {
														foreach ($terms as $term) {
															echo '<li>' . esc_html($term->name) . '</li>';
														}
													}
													?>
												</ul>
											</div>
											<div class="column kt-col-xs-12 kt-col-md-6">
												<h3 class="expert-profile-section-title">
													نحوه همکاری:
												</h3>
												<ul class="expert-profile-list">
													<?php
													$terms = get_the_terms(get_the_ID(), 'expert_contract');
													if ($terms && !is_wp_error($terms)) {
														foreach ($terms as $term) {
															echo '<li>' . esc_html($term->name) . '</li>';
														}
													}
													?>
												</ul>
											</div>
											<div class="column kt-col-xs-12 kt-col-md-6">
												<h3 class="expert-profile-section-title">
													محل سکونت:
												</h3>
												<ul class="expert-profile-list">
													<?php
													$terms = get_the_terms(get_the_ID(), 'expert_location');
													if ($terms && !is_wp_error($terms)) {
														foreach ($terms as $term) {
															echo '<li>' . esc_html($term->name) . '</li>';
														}
													}
													?>
												</ul>
											</div>

											<div class="column kt-col-xs-12 kt-col-md-6">
												<h3 class="expert-profile-section-title">وضعیت:</h3>
												<ul class="expert-profile-list">
													<?php
													// اگر استخدام شده بود نمایش بده
													if ($status === 'is-hired'): ?>
														<div class="experts-list-item-hired">
															<i class="fal fa-check"></i>
															<span>استخدام شده</span>
														</div>
													<?php else: ?>
														<div class="experts-list-item-hired not_hired">
															<i class="fal fa-check"></i>
															<span>آماده برای همکاری</span>
														</div>

													<?php endif; ?>
												</ul>
											</div>

											<div class="column kt-col-xs-12 kt-col-md-6">
												<h3 class="expert-profile-section-title">حقوق مورد نظر:</h3>
												<div class="expert-profile-salary">
													<?php
													$terms = get_the_terms(get_the_ID(), 'expert_salary');
													if ($terms && !is_wp_error($terms)) {
														foreach ($terms as $term) {
															echo '<span>' . esc_html($term->name) . '</span>';
														}
													}
													?>
												</div>
											</div>


										</div>
									</div>
								</div>

								<div class="experts-list-item-skills-holder">
									<h3 class="expert-profile-section-title">
										دوره های گذرانده شده ی متخصص</h3>
									<?php
									$expert_id = get_the_ID();
									$course_expert = get_post_meta($expert_id, '_woodmart_product_experts', true);

									if (!empty($course_expert) && is_array($course_expert)): ?>
										<ul class="expert-profile-list passed-courses">
											<?php foreach ($course_expert as $product_id):
												$product_link = get_permalink($product_id);
												$product_title = get_the_title($product_id);
												?>
												<li>
													<a href="<?php echo esc_url($product_link); ?>" target="_blank">
														<?php echo esc_html($product_title); ?>
													</a>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php endif; ?>
								</div>


								<?php
								$portfolio_raw = get_post_meta(get_the_ID(), '_woodmart_expert_portfolio', true);

								
								$portfolio = array_filter(array_map('trim', explode(',', $portfolio_raw)));

								if (!empty($portfolio)): ?>
									<div class="expert-profile-portfolio">
										<h3 class="expert-profile-section-title">نمونه کارهای متخصص</h3>
										<div class="experts-gallery five-grid">
											<?php foreach ($portfolio as $image_id):

												// گرفتن نسخه های مختلف تصویر
												$thumb = wp_get_attachment_image_url($image_id, 'medium');
												$full = wp_get_attachment_image_url($image_id, 'full');

												if (empty($thumb))
													continue;
												?>
												<a href="<?php echo esc_url($full); ?>" class="experts-gallery glightbox"
													data-gallery="expert-portfolio">
													<div class="experts-list-gallery-inner">
														<img alt="" src="<?php echo esc_url($thumb); ?>">
													</div>
												</a>
											<?php endforeach; ?>
										</div>
									</div>
								<?php endif; ?>
							</div>
						</div>

					</div>





					<div class="expert-profile-similar">
						<div class="expert-profile-similar-header">
							<h3 class="expert-profile-section-title">سایر متخصص‌ها</h3>
							<a href="<?php echo esc_url($archive_link); ?>" class="btn btn-style-default btn-shape-curv btn-color-primary">مشاهده همه</a>
						</div>
						<?php
						// =======================
						// //  Related Experts
						// // =======================
				
						$current_id = get_the_ID();
						$taxonomies = array('expert_skill', 'expert_location', 'expert_salary', 'expert_contract');

						// گرفتن term های پست فعلی
						$terms = wp_get_post_terms($current_id, $taxonomies, array('fields' => 'ids'));

						if (!empty($terms)) {

							// آماده‌سازی کوئری
							$related_args = array(
								'post_type' => 'expert',
								'posts_per_page' => 4,
								'post__not_in' => array($current_id),
								'tax_query' => array('relation' => 'OR'),
							);

							// اضافه کردن تک‌تک taxonomyها
							foreach ($taxonomies as $tax) {
								$related_args['tax_query'][] = array(
									'taxonomy' => $tax,
									'field' => 'term_id',
									'terms' => $terms,
								);
							}

							$related = new WP_Query($related_args);

							if ($related->have_posts()):
								?>

								<div class="related-experts">

									<div class="related-experts-grid">
										<?php
										while ($related->have_posts()):
											$related->the_post();

											// کارت اختصاصی که خودت ساختی
											get_template_part('content', 'expert');

										endwhile;
										?>
									</div>
								</div>

								<?php
							endif;

							wp_reset_postdata();
						}
						?>

					</div>





				</div>
			<?php endwhile; endif; ?>

	</div>

</div>

<?php get_footer(); ?>