jQuery(document).ready(function($){
    // تب‌ها
    $('.wp-notifications-tabs li').on('click', function(e){
        e.preventDefault();
        var tab = $(this).data('tab');
        $('.wp-notifications-tabs li').removeClass('active');
        $(this).addClass('active');
        $('#wp-notifications-content').html('<p>در حال بارگذاری...</p>');

        $.post(notif_ajax.ajax_url, { action:'load_notifications_tab', tab:tab }, function(response){
            if(response.success) $('#wp-notifications-content').html(response.data);
            else $('#wp-notifications-content').html('<p>'+response.data+'</p>');
        });
    });

    // اطلاعیه تکی
    $(document).on('click','.notification-link',function(e){
        e.preventDefault();
        var post_id = $(this).data('postid');
        $('#wp-notifications-content').html('<p>در حال بارگذاری...</p>');

        $.post(notif_ajax.ajax_url,{ action:'load_single_notification', post_id:post_id },function(response){
            if(response.success) $('#wp-notifications-content').html(response.data);
            else $('#wp-notifications-content').html('<p>'+response.data+'</p>');
        });
    });

    // دکمه بازگشت
    $(document).on('click','.notif-back',function(e){
        e.preventDefault();
        $('#wp-notifications-content').html('<p>در حال بارگذاری...</p>');

        $.post(notif_ajax.ajax_url,{ action:'load_notifications_tab', tab:'all' },function(response){
            if(response.success){
                $('#wp-notifications-content').html(response.data);
                $('.wp-notifications-tabs li').removeClass('active');
                $('.wp-notifications-tabs li[data-tab="all"]').addClass('active');
            } else {
                $('#wp-notifications-content').html('<p>'+response.data+'</p>');
            }
        });
    });
});



jQuery(document).ready(function($){
    $(document).on('click','.notif-load-more',function(e){
        e.preventDefault();
        var button = $(this);
        var page = button.data('page');

        $.post(notif_ajax.ajax_url, {
            action: 'load_notifications_more',
            page: page
        }, function(response){
            if(response.success){
                button.remove(); // دکمه قبلی را حذف می‌کنیم
                $('#wp-notifications-content ul.wp-notifications-list').append(response.data);
            }
        });
    });
});



jQuery(document).ready(function($){

    // وقتی کاربر روی یک اعلان کلیک می‌کند
    $(document).on('click','.notification-link',function(e){
        e.preventDefault();
        var postId = $(this).data('postid');
        var link = $(this);

        $.post(notif_ajax.ajax_url, {
            action: 'load_single_notification',
            post_id: postId
        }, function(response){
            if(response.success){
                $('#wp-notifications-content').html(response.data);

                // بعد از نمایش اعلان، شمارشگر را بروزرسانی کن
                $.post(notif_ajax.ajax_url, {
                    action: 'get_new_notifications_count'
                }, function(countResponse){
                    if(countResponse.success){
                        var newCount = parseInt(countResponse.data);
                        var badge = $('.wp-notifications-tabs .notification-count');
                        if(newCount>0){
                            badge.text(newCount);
                        } else {
                            badge.remove();
                        }
                    }
                });
            }
        });
    });

});
