jQuery(function($){
    $(document).on('submit', '.register_version_form', function(e){
        e.preventDefault();
        const starter = $(this).find('.license_key').val();
        const resultBox = $(this).find('.result_text');
        resultBox.text(iwpShieldAjax.messages.wait);
        $.post(iwpShieldAjax.ajax_url, {
            action: iwpShieldAjax.action,
            starter: starter,
            nonce: iwpShieldAjax.nonce
        })
        .done(res => {
            resultBox.text(res.data);
        })
        .fail(err => {
            resultBox.text(iwpShieldAjax.messages.error);
        });
    });

    $(document).on('click', '.wpmlr_revalidate', function(e){
        e.preventDefault();
        const starter = $(this).data('key');
        const box = $(this).closest('.current_license').find('.check_result .result_text');
        box.text(iwpShieldAjax.messages.wait);
        $.post(iwpShieldAjax.ajax_url, {
            action: iwpShieldAjax.action_revalidate,
            starter: starter,
            nonce: iwpShieldAjax.nonce
        })
        .done(res => box.text(res.data))
        .fail(() => box.text(iwpShieldAjax.messages.error));
    });

    $(document).on('click', '.zhk_guard_new_key', function(e){
        e.preventDefault();
        $(this).closest('.current_license').find('.register_version_form').slideDown(200);
    });
});
