jQuery(document).ready(function($){
    let page = 1;
    let loading = false;
    let allLoaded = false;

    function loadExperts(reset = false){
        if(loading) return;
        loading = true;
        $('#expert-loading').show();

        if(reset){
            page = 1;
            allLoaded = false;
        }

        let data = $('#expert-filter-form').serialize();
        data += '&action=filter_experts&page=' + page;

        $.ajax({
            url: expert_ajax_obj.ajaxurl,
            type: 'POST',
            data: data,
            success: function(res){
                $('#expert-loading').hide();

                if(reset){
                    $('#expert-results').html(res);
                    allLoaded = $('.no-results', $('#expert-results')).length > 0;
                    $('#expert-no-results').toggle(allLoaded);
                    $(window).scrollTop(0);
                } else {
                    if(res.trim() === '' || $('.no-results', res).length > 0){
                        allLoaded = true;
                    } else {
                        $('#expert-results').append(res);
                    }
                }

                loading = false;
            },
            error: function(){
                $('#expert-loading').hide();
                loading = false;
            }
        });
    }

    // فیلتر چک‌باکس با delegation (حتی بعد از append)
    $(document).on('change', '#expert-filter-form input[type=checkbox]', function(){
        loadExperts(true);
    });

    // Infinite Scroll
    $(window).on('scroll', function(){
        if(loading || allLoaded) return;
        if($(window).scrollTop() + $(window).height() > $(document).height() - 200){
            page++;
            loadExperts();
        }
    });
});



jQuery(document).ready(function($){

    $('.kt-modal-button').on('click', function(){
        let modalID = $(this).data('modal');
        $('#' + modalID).addClass('active');
    });

    $('.kt-modal-close, .kt-modal-wrap').on('click', function(e){
        if (e.target !== this) return;
        $(this).closest('.kt-modal-wrap').removeClass('active');
    });

});




document.addEventListener('DOMContentLoaded', function() {

    const toggleBtn  = document.getElementById('expert-filter-toggle');
    const sidebar    = document.getElementById('expert-sidebar');
    const backdrop   = document.getElementById('expert-sidebar-backdrop');
    const filterForm = document.getElementById('expert-filter-form');

    function openSidebar() {
        sidebar?.classList.add('active');
        backdrop?.classList.add('active');
    }

    function closeSidebar() {
        sidebar?.classList.remove('active');
        backdrop?.classList.remove('active');
    }

    // باز/بسته کردن با دکمه
    if (toggleBtn) {
        toggleBtn.addEventListener('click', () => {
            if (sidebar?.classList.contains('active')) {
                closeSidebar();
            } else {
                openSidebar();
            }
        });
    }

    // بستن با لمس بک‌دراپ
    if (backdrop) {
        backdrop.addEventListener('click', closeSidebar);
    }

    // بستن بعد از انتخاب هر فیلتر
    if (filterForm) {
        filterForm.addEventListener('change', () => {
            if (window.innerWidth <= 768) {
                closeSidebar();
            }
        });
    }

});
