<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );

/**
* ------------------------------------------------------------------------------------------------
* Share and follow buttons shortcode
* ------------------------------------------------------------------------------------------------
*/

if( ! function_exists( 'woodmart_shortcode_social' )) {
	function woodmart_shortcode_social( $atts, $content = '' ) {
		$classes = apply_filters( 'vc_shortcodes_css_class', '', '', $atts );

		$links_atts = array(
			'fb_link'         => '',
			'twitter_link'    => '',
			'bluesky_link'    => '',
			'isntagram_link'  => '',
			'threads_link'    => '',
			'pinterest_link'  => '',
			'youtube_link'    => '',
			'tumblr_link'     => '',
			'linkedin_link'   => '',
			'vimeo_link'      => '',
			'flickr_link'     => '',
			'github_link'     => '',
			'dribbble_link'   => '',
			'behance_link'    => '',
			'soundcloud_link' => '',
			'spotify_link'    => '',
			'ok_link'         => '',
			'vk_link'         => '',
			'whatsapp_link'   => '',
			'snapchat_link'   => '',
			'tg_link'         => '',
			'viber_link'      => '',
			'tiktok_link'     => '',
			'discord_link'    => '',
			'yelp_link'       => '',
		);

		$default_atts = array(
			'show_label'          => 'no',
			'label_text'          => esc_html__( 'Share: ', 'studiare-plus' ),
			'is_element'          => false,
			'layout'              => '',
			'type'                => 'share',
			'social_links_source' => 'theme_settings',
			'align'               => 'center',
			'tooltip'             => 'no',
			'style'               => 'default',
			'size'                => 'default',
			'form'                => 'circle',
			'color'               => '',
			'css_animation'       => 'none',
			'el_class'            => '',
			'el_id'               => '',
			'title_classes'       => '',
			'page_link'           => false,
			'elementor'           => false,
			'sticky'              => false,
			'css'                 => '',
		);

		$atts = shortcode_atts( array_merge( $default_atts, $links_atts ), $atts );

		if ( 'follow' === $atts['type'] && 'theme_settings' === $atts['social_links_source'] ) {
			foreach ( array_keys( $links_atts ) as $link_option_name ) {
				$atts[ $link_option_name ] = woodmart_get_opt( $link_option_name, '' );
			}
		}

		extract( $atts );

		$target        = '_blank';
		$title_classes = $title_classes ? ' ' . $title_classes : '';
		$classes      .= ' wd-social-icons';

		if ( function_exists( 'vc_shortcode_custom_css_class' ) ) {
			$classes .= ' ' . vc_shortcode_custom_css_class( $css );
		}

		$classes .= woodmart_get_old_classes( ' woodmart-social-icons' );
		$classes .= ! empty( $layout ) ? ' wd-layout-' . $layout : '';
		$classes .= $style ? ' wd-style-' . $style : '';
		$classes .= $size ? ' wd-size-' . $size : '';
		$classes .= ' social-' . $type;
		$classes .= $form ? ' wd-shape-' . $form : '';
		$classes .= ( $el_class ) ? ' ' . $el_class : '';

		if ( $color ) {
			$classes .= ' color-scheme-' . $color;
		}

		$classes .= woodmart_get_css_animation( $css_animation );

		if ( $align ) {
			$classes .= ' text-' . $align;
		}

		$thumb_id   = get_post_thumbnail_id();
		$thumb_url  = wp_get_attachment_image_src( $thumb_id, 'thumbnail-size', true );
		$page_title = get_the_title();

		if ( ! $page_link ) {
			$page_link = get_the_permalink();
		}

		if ( woodmart_woocommerce_installed() ) {
			if ( is_shop() ) {
				$page_link = get_permalink( get_option( 'woocommerce_shop_page_id' ) );
			} elseif ( is_product_category() || is_category() ) {
				$page_link = get_category_link( get_queried_object()->term_id );
			} elseif ( is_tax() ) {
				$page_link = get_term_link( get_queried_object()->term_id );
			}
		}

		if ( is_home() && ! is_front_page() ) {
			$page_link = get_permalink( get_option( 'page_for_posts' ) );
		}

		if ( ! $elementor ) {
			ob_start();
		}

		woodmart_enqueue_inline_style( 'social-icons' );

		if ( 'default' !== $style ) {
			woodmart_enqueue_inline_style( 'social-icons-styles' );
		}
		?>
			<div
			<?php if ( $el_id ) : ?>
			id="<?php echo esc_attr( $el_id ); ?>"
			<?php endif ?>
			class="<?php echo esc_attr( $classes ); ?>">
				<?php echo do_shortcode( $content ); ?>

				<?php if ( 'yes' === $show_label && $label_text ) : ?>
					<span class="wd-label<?php echo esc_attr( $title_classes ); ?>"><?php echo esc_html( $label_text ); ?></span>
				<?php endif; ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_fb') ) || ( $type == 'follow' && $fb_link != '')): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $fb_link ) : 'https://www.facebook.com/sharer/sharer.php?u=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-facebook" aria-label="<?php esc_attr_e( 'Facebook social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Facebook', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_twitter') ) || ( $type == 'follow' && $twitter_link != '')): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $twitter_link ) : 'https://x.com/share?url=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-twitter" aria-label="<?php esc_attr_e( 'X social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('X', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( 'follow' === $type && '' !== $bluesky_link ) : ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $bluesky_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php echo 'yes' === $tooltip ? 'wd-tooltip' : ''; ?> wd-social-icon social-bluesky" aria-label="<?php esc_attr_e( 'Bluesky social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e( 'Bluesky', 'studiare-plus' ); ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_email') ) || ( $type == 'follow' && woodmart_get_opt( 'social_email_links' ) ) ): ?>
					<a rel="noopener noreferrer nofollow" href="mailto:<?php echo '?subject=' . esc_html__('Check%20this%20', 'studiare-plus') . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-email" aria-label="<?php esc_attr_e( 'Email social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Email', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $isntagram_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $isntagram_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-instagram" aria-label="<?php esc_attr_e( 'Instagram social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Instagram', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( 'follow' === $type && '' !== $threads_link ) : ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $threads_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php echo 'yes' === $tooltip ? 'wd-tooltip' : ''; ?> wd-social-icon social-threads" aria-label="<?php esc_attr_e( 'Threads social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e( 'Threads', 'studiare-plus' ); ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $youtube_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $youtube_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-youtube" aria-label="<?php esc_attr_e( 'YouTube social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('YouTube', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_pinterest') ) || ( $type == 'follow' && $pinterest_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $pinterest_link ) : 'https://pinterest.com/pin/create/button/?url=' . $page_link . '&media=' . $thumb_url[0] . '&description=' . urlencode( $page_title ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-pinterest" aria-label="<?php esc_attr_e( 'Pinterest social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Pinterest', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $tumblr_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $tumblr_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-tumblr" aria-label="<?php esc_attr_e( 'Tumblr social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Tumblr', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_linkedin') ) || ( $type == 'follow' && $linkedin_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $linkedin_link ) : 'https://www.linkedin.com/shareArticle?mini=true&url=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-linkedin" aria-label="<?php esc_attr_e( 'Linkedin social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('linkedin', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $vimeo_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $vimeo_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-vimeo" aria-label="<?php esc_attr_e( 'Vimeo social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Vimeo', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $flickr_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $flickr_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-flickr" aria-label="<?php esc_attr_e( 'Flickr social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Flickr', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $github_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $github_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-github" aria-label="<?php esc_attr_e( 'GitHub social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('GitHub', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $dribbble_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $dribbble_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-dribbble" aria-label="<?php esc_attr_e( 'Dribbble social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Dribbble', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $behance_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $behance_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-behance" aria-label="<?php esc_attr_e( 'Behance social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Behance', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $soundcloud_link != ''): ?>
						<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $soundcloud_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-soundcloud" aria-label="<?php esc_attr_e( 'Soundcloud social link', 'studiare-plus' ); ?>">
							<span class="wd-icon"></span>
							<?php if ( $sticky ) : ?>
								<span class="wd-icon-name"><?php esc_html_e('Soundcloud', 'studiare-plus') ?></span>
							<?php endif; ?>
						</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $spotify_link != ''): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $spotify_link ) : '' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-spotify" aria-label="<?php esc_attr_e( 'Spotify social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Spotify', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt('share_ok') ) || ( $type == 'follow' && $ok_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $ok_link ) : 'https://connect.ok.ru/offer?url=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-ok" aria-label="<?php esc_attr_e( 'Odnoklassniki social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Odnoklassniki', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'share' && woodmart_get_opt('share_whatsapp') || ( $type == 'follow' && $whatsapp_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $whatsapp_link ) : 'https://api.whatsapp.com/send?text=' . urlencode( $page_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="wd-hide-md <?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-whatsapp" aria-label="<?php esc_attr_e( 'WhatsApp social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('WhatsApp', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>

					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $whatsapp_link ) : 'whatsapp://send?text=' . urlencode( $page_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="wd-hide-lg <?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-whatsapp" aria-label="<?php esc_attr_e( 'WhatsApp social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('WhatsApp', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'share' && woodmart_get_opt('share_vk') || ( $type == 'follow' && $vk_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $vk_link ) : 'https://vk.com/share.php?url=' . $page_link . '&image=' . $thumb_url[0] . '&title=' . $page_title; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-vk" aria-label="<?php esc_attr_e( 'VK social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('VK', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $snapchat_link != '' ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $snapchat_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-snapchat" aria-label="<?php esc_attr_e( 'Snapchat social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Snapchat', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $tiktok_link != '' ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $tiktok_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-tiktok" aria-label="<?php esc_attr_e( 'TikTok social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('TikTok', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && $discord_link != '' ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $discord_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-discord" aria-label="<?php esc_attr_e( 'Discord social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Discord', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'follow' && '' !== $yelp_link ) : ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo esc_url( $yelp_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php echo 'yes' === $tooltip ? 'wd-tooltip' : ''; ?> wd-social-icon social-yelp" aria-label="<?php esc_attr_e( 'Yelp social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e( 'Yelp', 'studiare-plus' ); ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( $type == 'share' && woodmart_get_opt('share_tg') || ( $type == 'follow' && $tg_link != '' ) ): ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo 'follow' === $type ? esc_url( $tg_link ) : 'https://telegram.me/share/url?url=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-tg" aria-label="<?php esc_attr_e( 'Telegram social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Telegram', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

				<?php if ( ( $type == 'share' && woodmart_get_opt( 'share_viber' ) ) || ( $type == 'follow' && $viber_link ) ) : ?>
					<a rel="noopener noreferrer nofollow" href="<?php echo $type == 'follow' ? $viber_link : 'viber://forward?text=' . $page_link; ?>" target="<?php echo esc_attr( $target ); ?>" class="<?php if( $tooltip == "yes" ) echo 'wd-tooltip'; ?> wd-social-icon social-viber" aria-label="<?php esc_attr_e( 'Viber social link', 'studiare-plus' ); ?>">
						<span class="wd-icon"></span>
						<?php if ( $sticky ) : ?>
							<span class="wd-icon-name"><?php esc_html_e('Viber', 'studiare-plus') ?></span>
						<?php endif; ?>
					</a>
				<?php endif ?>

			</div>

		<?php
		if ( ! $elementor ) {
			$output = ob_get_contents();
			ob_end_clean();

			return $output;
		}
	}
}
