<?php
/**
 * Page title map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_page_title' ) ) {
	/**
	 * Page title map.
	 */
	function woodmart_get_vc_map_page_title() {
		return array(
			'base'        => 'woodmart_page_title',
			'name'        => esc_html__( 'Page title', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Site', 'studiare-plus' ) ),
			'description' => esc_html__( 'Main page title section', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/wc-icons/wc-page-title.svg',
			'params'      => array(
				array(
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
