<?php
/**
 * Meta map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_single_product_product_meta' ) ) {
	/**
	 * Meta map.
	 */
	function woodmart_get_vc_map_single_product_product_meta() {
		$typography = array();

		if ( function_exists( 'woodmart_get_typography_map' ) ) {
			$typography = woodmart_get_typography_map(
				array(
					'key'      => 'label',
					'selector' => '{{WRAPPER}} .meta-label',
					'group'    => esc_html__( 'Style', 'js_composer' ),
				)
			);
		}

		return array(
			'base'        => 'woodmart_single_product_meta',
			'name'        => esc_html__( 'Product meta', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Single product elements', 'studiare-plus' ), 'single_product' ),
			'description' => esc_html__( 'SKU, category, and tags', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sp-icons/sp-meta.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
					'group'      => esc_html__( 'Style', 'js_composer' ),
				),
				/**
				 * Style tab.
				 */
				// General.
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'General', 'studiare-plus' ),
					'param_name' => 'style_general_divider',
					'group'      => esc_html__( 'Style', 'js_composer' ),
				),
				array(
					'heading'          => esc_html__( 'Show SKU', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'show_sku',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'yes',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Show categories', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'show_categories',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'yes',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Show tags', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'show_tags',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'yes',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Show brand', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'show_brand',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Layout', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'layout',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Inline', 'studiare-plus' )  => 'inline',
						esc_html__( 'Justify', 'studiare-plus' ) => 'justify',
					),
					'wood_tooltip'     => true,
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'alignment',
					'style'            => 'images',
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => 'left',
						),
					),
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images'           => array(
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'dependency'       => array(
						'element'            => 'layout',
						'value_not_equal_to' => 'justify',
					),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				// Label.
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Label', 'studiare-plus' ),
					'param_name' => 'style_label_divider',
					'group'      => esc_html__( 'Style', 'js_composer' ),
				),
				function_exists( 'woodmart_get_typography_map' ) ? $typography['font_family'] : '',
				function_exists( 'woodmart_get_typography_map' ) ? $typography['font_size'] : '',
				function_exists( 'woodmart_get_typography_map' ) ? $typography['font_weight'] : '',
				function_exists( 'woodmart_get_typography_map' ) ? $typography['text_transform'] : '',
				function_exists( 'woodmart_get_typography_map' ) ? $typography['font_style'] : '',
				function_exists( 'woodmart_get_typography_map' ) ? $typography['line_height'] : '',
				array(
					'heading'          => esc_html__( 'Label color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'label_color',
					'selectors'        => array(
						'{{WRAPPER}} .meta-label' => array(
							'color: {{VALUE}};',
						),
					),
					'group'            => esc_html__( 'Style', 'js_composer' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
