<?php
/**
 * Product extra content map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_single_product_extra_content' ) ) {
	/**
	 * Product extra content map.
	 */
	function woodmart_get_vc_map_single_product_extra_content() {
		return array(
			'base'        => 'woodmart_single_product_extra_content',
			'name'        => esc_html__( 'Product extra content', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Single product elements', 'studiare-plus' ), 'single_product' ),
			'description' => esc_html__( 'HTML Block set as extra content', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sp-icons/sp-extra-content.svg',
			'params'      => array(
				array(
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
		);
	}
}
