<?php
/**
 * Product brands map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_single_product_brands' ) ) {
	/**
	 * Product brands map.
	 */
	function woodmart_get_vc_map_single_product_brands() {
		$typography = woodmart_get_typography_map(
			array(
				'key'        => 'tabs_title',
				'selector'   => '{{WRAPPER}} .wd-label',
				'dependency' => array(
					'element' => 'show_label',
					'value'   => 'yes',
				),
			)
		);

		return array(
			'base'        => 'woodmart_single_product_brands',
			'name'        => esc_html__( 'Product brands', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Single product elements', 'studiare-plus' ), 'single_product' ),
			'description' => esc_html__( 'Brands assigned to the product', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sp-icons/sp-brands.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				// Label.
				array(
					'title'      => esc_html__( 'Label', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'label_divider',
				),

				array(
					'heading'          => esc_html__( 'Show label', 'studiare-plus' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'show_label',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Label text', 'studiare-plus' ),
					'type'             => 'textfield',
					'param_name'       => 'label_text',
					'value'            => esc_html__( 'Brands: ', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'show_label',
						'value'   => 'yes',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Label color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-label' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'show_label',
						'value'   => 'yes',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				$typography['font_family'],
				$typography['font_size'],
				$typography['font_weight'],
				$typography['text_transform'],
				$typography['font_style'],
				$typography['line_height'],

				// General.
				array(
					'title'      => esc_html__( 'General', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'label_divider',
				),

				array(
					'heading'          => esc_html__( 'Layout', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'layout',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' )  => 'default',
						esc_html__( 'Justify', 'studiare-plus' )  => 'justify',
						esc_html__( 'Inline', 'studiare-plus' )   => 'inline',
					),
					'dependency'       => array(
						'element'            => 'show_label',
						'value_not_equal_to' => 'no',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'alignment',
					'style'            => 'images',
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => 'left',
						),
					),
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images'           => array(
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				// Image.
				array(
					'title'      => esc_html__( 'Image', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'label_divider',
				),

				array(
					'heading'    => esc_html__( 'Style', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'dropdown',
					'param_name' => 'style',
					'value'      => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Shadow', 'studiare-plus' )  => 'shadow',
					),
				),

				array(
					'heading'    => esc_html__( 'Width', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'wd_slider',
					'param_name' => 'vertical_gap',
					'selectors'  => array(
						'{{WRAPPER}} img' => array(
							'max-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
						'tablet'  => array(
							'value' => '',
							'unit'  => 'px',
						),
						'mobile'  => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 300,
							'step' => 1,
						),
					),
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
