<?php
/**
 * View map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_shop_archive_view' ) ) {
	/**
	 * View map.
	 */
	function woodmart_get_vc_map_shop_archive_view() {
		return array(
			'base'        => 'woodmart_shop_archive_view',
			'name'        => esc_html__( 'Products view', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Products archive', 'studiare-plus' ), 'shop_archive' ),
			'description' => esc_html__( 'Product columns switcher', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sa-icons/sa-product-view.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				array(
					'heading'          => esc_html__( 'Products columns', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'products_columns_variations',
					'style'            => 'select2',
					'multiple'         => true,
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => array( 2, 3, 4 ),
						),
					),
					'value'            => array(
						esc_html__( '1', 'studiare-plus' ) => '1',
						esc_html__( '2', 'studiare-plus' ) => '2',
						esc_html__( '3', 'studiare-plus' ) => '3',
						esc_html__( '4', 'studiare-plus' ) => '4',
						esc_html__( '5', 'studiare-plus' ) => '5',
						esc_html__( '6', 'studiare-plus' ) => '6',
						esc_html__( 'List', 'studiare-plus' ) => 'list',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				/**
				 * Advanced Tab.
				 */
				woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
