<?php
/**
 * Products per page map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_shop_archive_per_page' ) ) {
	/**
	 * Products per page map.
	 */
	function woodmart_get_vc_map_shop_archive_per_page() {
		return array(
			'base'        => 'woodmart_shop_archive_per_page',
			'name'        => esc_html__( 'Products per page', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Products archive', 'studiare-plus' ), 'shop_archive' ),
			'description' => esc_html__( 'Number of products per page selector', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sa-icons/sa-products-per-page.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				array(
					'heading'     => esc_html__( 'Products per page variations', 'studiare-plus' ),
					'description' => esc_html__( 'For ex.: 12,24,36,-1. Use -1 to show all products on the page', 'studiare-plus' ),
					'type'        => 'textfield',
					'param_name'  => 'per_page_options',
					'value'       => '9,12,18,24',
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				/**
				 * Advanced Tab.
				 */
				woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
