<?php
/**
 * Archive products map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_shop_archive_products' ) ) {
	/**
	 * Archive products map.
	 */
	function woodmart_get_vc_map_shop_archive_products() {
		return array(
			'base'        => 'woodmart_shop_archive_products',
			'name'        => esc_html__( 'Archive products', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Products archive', 'studiare-plus' ), 'shop_archive' ),
			'description' => esc_html__( 'Show WooCommerce product grid', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/sa-icons/sa-archive-products.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				array(
					'heading'          => esc_html__( 'Products view', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'products_view',
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Grid', 'studiare-plus' ) => 'grid',
						esc_html__( 'List', 'studiare-plus' ) => 'list',
					),
					'std'              => 'inherit',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Products columns', 'studiare-plus' ),
					'hint'             => esc_html__( 'How many products you want to show per row.', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'products_columns',
					'style'            => 'select',
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => 'inherit',
						),
						'tablet'  => array(
							'value' => 'inherit',
						),
						'mobile'  => array(
							'value' => 'inherit',
						),
					),
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( '1', 'studiare-plus' ) => '1',
						esc_html__( '2', 'studiare-plus' ) => '2',
						esc_html__( '3', 'studiare-plus' ) => '3',
						esc_html__( '4', 'studiare-plus' ) => '4',
						esc_html__( '5', 'studiare-plus' ) => '5',
						esc_html__( '6', 'studiare-plus' ) => '6',
					),
					'dependency'       => array(
						'element'            => 'products_view',
						'value_not_equal_to' => 'list',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Space between products', 'studiare-plus' ),
					'hint'             => esc_html__( 'You can set different spacing between blocks on shop page.', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'products_spacing',
					'style'            => 'select',
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => 'inherit',
						),
						'tablet'  => array(
							'value' => 'inherit',
						),
						'mobile'  => array(
							'value' => 'inherit',
						),
					),
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( '0', 'studiare-plus' )  => '0',
						esc_html__( '2', 'studiare-plus' )  => '2',
						esc_html__( '6', 'studiare-plus' )  => '6',
						esc_html__( '10', 'studiare-plus' ) => '10',
						esc_html__( '20', 'studiare-plus' ) => '20',
						esc_html__( '30', 'studiare-plus' ) => '30',
					),
					'dependency'       => array(
						'element'            => 'products_view',
						'value_not_equal_to' => 'list',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Products pagination', 'studiare-plus' ),
					'hint'             => esc_html__( 'Choose a type for the pagination on your shop page.', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'shop_pagination',
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' )    => 'inherit',
						esc_html__( 'Pagination', 'studiare-plus' ) => 'pagination',
						__( '"Load more" button', 'studiare-plus' ) => 'more-btn',
						esc_html__( 'Infinite scrolling', 'studiare-plus' ) => 'infinit',
					),
					'std'              => 'inherit',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'      => esc_html__( 'Hover on product', 'studiare-plus' ),
					'group'        => esc_html__( 'Design', 'studiare-plus' ),
					'hint'         => esc_html__( 'Choose one of those hover effects for products', 'studiare-plus' ),
					'type'         => 'woodmart_image_select',
					'param_name'   => 'product_hover',
					'value'        => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Full info on hover', 'studiare-plus' ) => 'info-alt',
						esc_html__( 'Full info on image', 'studiare-plus' ) => 'info',
						esc_html__( 'Icons and "add to cart" on hover', 'studiare-plus' ) => 'alt',
						esc_html__( 'Icons on hover', 'studiare-plus' ) => 'icons',
						esc_html__( 'Quick', 'studiare-plus' ) => 'quick',
						esc_html__( 'Show button on hover on image', 'studiare-plus' ) => 'button',
						esc_html__( 'Show summary on hover', 'studiare-plus' ) => 'base',
						esc_html__( 'Standard button', 'studiare-plus' ) => 'standard',
						esc_html__( 'Tiled', 'studiare-plus' ) => 'tiled',
						esc_html__( 'Full width button', 'studiare-plus' ) => 'fw-button',
						esc_html__( 'Buttons on hover', 'studiare-plus' ) => 'buttons-on-hover',
					),
					'images_value' => array(
						'inherit'          => WOODMART_ASSETS_IMAGES . '/settings/empty.jpg',
						'info-alt'         => WOODMART_ASSETS_IMAGES . '/settings/hover/info-alt.jpg',
						'info'             => WOODMART_ASSETS_IMAGES . '/settings/hover/info.jpg',
						'alt'              => WOODMART_ASSETS_IMAGES . '/settings/hover/alt.jpg',
						'icons'            => WOODMART_ASSETS_IMAGES . '/settings/hover/icons.jpg',
						'quick'            => WOODMART_ASSETS_IMAGES . '/settings/hover/quick.jpg',
						'button'           => WOODMART_ASSETS_IMAGES . '/settings/hover/button.jpg',
						'base'             => WOODMART_ASSETS_IMAGES . '/settings/hover/base.jpg',
						'standard'         => WOODMART_ASSETS_IMAGES . '/settings/hover/standard.jpg',
						'tiled'            => WOODMART_ASSETS_IMAGES . '/settings/hover/tiled.jpg',
						'fw-button'        => WOODMART_ASSETS_IMAGES . '/settings/hover/fw-button.jpg',
						'buttons-on-hover' => WOODMART_ASSETS_IMAGES . '/settings/hover/buttons-on-hover.jpg',
					),
					'dependency'   => array(
						'element'            => 'products_view',
						'value_not_equal_to' => 'list',
					),
				),

				array(
					'heading'          => esc_html__( 'Images size', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'type'             => 'textfield',
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'Products color scheme', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'type'       => 'dropdown',
					'param_name' => 'products_color_scheme',
					'std'        => 'inherit',
					'value'      => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
					),
				),

				array(
					'heading'          => esc_html__( 'Products border', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'products_bordered_grid',
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Enable', 'studiare-plus' ) => 'enable',
						esc_html__( 'Disable', 'studiare-plus' ) => 'disable',
					),
					'std'              => 'inherit',
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),

				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Border position', 'studiare-plus' ),
					'param_name'       => 'products_bordered_grid_style',
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Outside', 'studiare-plus' ) => 'outside',
						esc_html__( 'Inside', 'studiare-plus' ) => 'inside',
					),
					'std'              => 'inherit',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'products_bordered_grid',
						'value'   => 'enable',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Custom products border color', 'studiare-plus' ),
					'hint'             => esc_html__( 'Set custom border color for products.', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'products_border_color',
					'selectors'        => array(
						'{{WRAPPER}} [class*="products-bordered-grid"], {{WRAPPER}} [class*="products-bordered-grid"] .wd-product' => array(
							'--wd-bordered-brd:{{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'products_bordered_grid',
						'value'   => 'enable',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'Products background', 'studiare-plus' ),
					'hint'       => esc_html__( 'Add a background to the products in your grid.', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'type'       => 'dropdown',
					'param_name' => 'products_with_background',
					'std'        => 'inherit',
					'value'      => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Yes', 'studiare-plus' ) => 'yes',
						esc_html__( 'No', 'studiare-plus' )  => 'no',
					),
				),

				array(
					'heading'    => esc_html__( 'Custom products background color', 'studiare-plus' ),
					'hint'       => esc_html__( 'Set custom background color for products.', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'type'       => 'wd_colorpicker',
					'param_name' => 'products_background',
					'selectors'  => array(
						'{{WRAPPER}} .products.wd-products-with-bg, {{WRAPPER}} .products.wd-products-with-bg :is(.wd-product,.wd-cat)' => array(
							'--wd-prod-bg:{{VALUE}}; --wd-bordered-bg:{{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'products_with_background',
						'value'   => array( 'yes' ),
					),
				),

				array(
					'heading'    => esc_html__( 'Products shadow', 'studiare-plus' ),
					'hint'       => esc_html__( 'Add a shadow to products if the initial product style did not have one.', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'type'       => 'dropdown',
					'param_name' => 'products_shadow',
					'default'    => 'inherit',
					'value'      => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Yes', 'studiare-plus' ) => 'yes',
						esc_html__( 'No', 'studiare-plus' )  => 'no',
					),
				),

				array(
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
					'type'       => 'css_editor',
					'param_name' => 'css',
				),
				woodmart_get_vc_responsive_spacing_map(),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
