<?php
/**
 * Post content map.
 *
 * @package studiare plus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'woodmart_get_vc_map_my_account_nav' ) ) {
	/**
	 * Post content map.
	 */
	function woodmart_get_vc_map_my_account_nav() {
		$item_typography = woodmart_get_typography_map(
			array(
				'key'      => 'item_typography',
				'group'    => esc_html__( 'Style', 'studiare-plus' ),
				'selector' => '{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a',
			)
		);

		return array(
			'base'        => 'woodmart_my_account_nav',
			'name'        => esc_html__( 'My account navigation', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'My account elements', 'studiare-plus' ) ),
			'description' => esc_html__( 'My account navigation menu', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/ma-icons/navigation.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'General', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'general_divider',
				),
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Orientation', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'orientation',
					'value'            => array(
						esc_html__( 'Vertical', 'studiare-plus' )   => 'vertical',
						esc_html__( 'Horizontal', 'studiare-plus' ) => 'horizontal',
					),
					'std'              => 'vertical',
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'layout_type',
					'heading'    => esc_html__( 'Layout', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Inline', 'studiare-plus' ) => 'inline',
						esc_html__( 'Grid', 'studiare-plus' )   => 'grid',
					),
					'dependency' => array(
						'element' => 'orientation',
						'value'   => array( 'horizontal' ),
					),
					'std'        => 'inline',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Columns', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'columns_tabs',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'default'          => 'desktop',
					'edit_field_class' => 'wd-res-control wd-custom-width vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_columns',
					'value'            => array(
						'1'  => '1',
						'2'  => '2',
						'3'  => '3',
						'4'  => '4',
						'5'  => '5',
						'6'  => '6',
						'7'  => '7',
						'8'  => '8',
						'9'  => '9',
						'10' => '10',
						'11' => '11',
						'12' => '12',
					),
					'std'              => '3',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'desktop' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_columns_tablet',
					'value'            => array(
						esc_html__( 'Auto', 'studiare-plus' ) => 'auto',
						'1'                              => '1',
						'2'                              => '2',
						'3'                              => '3',
						'4'                              => '4',
						'5'                              => '5',
						'6'                              => '6',
						'7'                              => '7',
						'8'                              => '8',
						'9'                              => '9',
						'10'                             => '10',
						'11'                             => '11',
						'12'                             => '12',
					),
					'std'              => 'auto',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'tablet' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_columns_mobile',
					'value'            => array(
						esc_html__( 'Auto', 'studiare-plus' ) => 'auto',
						'1'                              => '1',
						'2'                              => '2',
						'3'                              => '3',
						'4'                              => '4',
						'5'                              => '5',
						'6'                              => '6',
						'7'                              => '7',
						'8'                              => '8',
						'9'                              => '9',
						'10'                             => '10',
						'11'                             => '11',
						'12'                             => '12',
					),
					'std'              => 'auto',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'mobile' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Space between', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'spacing_tabs',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'default'          => 'desktop',
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'edit_field_class' => 'wd-res-control wd-custom-width vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_spacing',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						30 => 30,
						20 => 20,
						10 => 10,
						6  => 6,
						2  => 2,
						0  => 0,
					),
					'std'              => '',
					'wd_dependency'    => array(
						'element' => 'spacing_tabs',
						'value'   => array( 'desktop' ),
					),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_spacing_tablet',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						30 => 30,
						20 => 20,
						10 => 10,
						6  => 6,
						2  => 2,
						0  => 0,
					),
					'std'              => '',
					'wd_dependency'    => array(
						'element' => 'spacing_tabs',
						'value'   => array( 'tablet' ),
					),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'nav_spacing_mobile',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						30 => 30,
						20 => 20,
						10 => 10,
						6  => 6,
						2  => 2,
						0  => 0,
					),
					'std'              => '',
					'wd_dependency'    => array(
						'element' => 'spacing_tabs',
						'value'   => array( 'mobile' ),
					),
					'dependency'       => array(
						'element' => 'layout_type',
						'value'   => array( 'grid' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'wood_tooltip'     => true,
					'dependency'       => array(
						'element' => 'orientation',
						'value'   => array( 'horizontal' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'dropdown',
					'param_name'       => 'tabs_title_text_color_scheme',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Items', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'items_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Style', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'nav_design',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'simple',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'default',
						esc_html__( 'Background', 'studiare-plus' ) => 'with-bg',
					),
					'std'              => 'simple',
					'dependency'       => array(
						'element' => 'orientation',
						'value'   => array( 'vertical' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Style', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' )    => 'default',
						esc_html__( 'Underline', 'studiare-plus' )  => 'underline',
					),
					'std'              => 'default',
					'dependency'       => array(
						'element' => 'orientation',
						'value'   => array( 'horizontal' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Gap', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'vertical_items_gap',
					'std'              => 'm',
					'value'            => array(
						esc_html__( 'Small', 'studiare-plus' )  => 's',
						esc_html__( 'Medium', 'studiare-plus' ) => 'm',
						esc_html__( 'Large', 'studiare-plus' )  => 'l',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'dependency'       => array(
						'element' => 'nav_design',
						'value'   => array( 'simple' ),
					),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Gap', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'items_gap',
					'value'            => array(
						esc_html__( 'Small', 'studiare-plus' )  => 's',
						esc_html__( 'Medium', 'studiare-plus' ) => 'm',
						esc_html__( 'Large', 'studiare-plus' )  => 'l',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'std'              => 'm',
					'dependency'       => array(
						'element' => 'orientation',
						'value'   => array( 'horizontal' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Custom gap', 'studiare-plus' ),
					'param_name'    => 'custom_vertical_items_gap',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
						'tablet'  => array(
							'value' => '',
							'unit'  => 'px',
						),
						'mobile'  => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 1,
							'max'  => 100,
							'step' => 1,
						),
					),
					'dependency'    => array(
						'element' => 'orientation',
						'value'   => array( 'vertical' ),
					),
					'wd_dependency' => array(
						'element' => 'vertical_items_gap',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Custom gap', 'studiare-plus' ),
					'param_name'    => 'custom_items_gap',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
						'tablet'  => array(
							'value' => '',
							'unit'  => 'px',
						),
						'mobile'  => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 1,
							'max'  => 100,
							'step' => 1,
						),
					),
					'dependency'    => array(
						'element' => 'orientation',
						'value'   => array( 'horizontal' ),
					),
					'wd_dependency' => array(
						'element' => 'items_gap',
						'value'   => array( 'custom' ),
					),
				),
				$item_typography['font_family'],
				$item_typography['font_size'],
				$item_typography['font_weight'],
				$item_typography['text_transform'],
				$item_typography['font_style'],
				$item_typography['line_height'],
				array(
					'type'             => 'woodmart_button_set',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'items_tabs',
					'value'            => array(
						esc_html__( 'Idle', 'studiare-plus' )   => 'idle',
						esc_html__( 'Hover', 'studiare-plus' )  => 'hover',
						esc_html__( 'Active', 'studiare-plus' ) => 'active',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-color: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_color_hover',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-color-hover: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_color_active',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-color-active: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				// Background.
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'nav_bg_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_bg_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-bg: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'nav_bg_color_enable',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'nav_bg_hover_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_bg_color_hover',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-bg-hover: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'nav_bg_hover_color_enable',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'nav_bg_active_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'nav_bg_color_active',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-bg-active: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'nav_bg_active_color_enable',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
				),
				/**
				 * Border idle.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'nav_border_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'nav_border_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'       => array(
						'element' => 'nav_border_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'nav_border_width',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'nav_border_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border radius', 'studiare-plus' ),
					'param_name'    => 'nav_border_radius',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-radius: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Border hover.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'nav_border_hover_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'nav_border_hover_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li:hover > a' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'       => array(
						'element' => 'nav_border_hover_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'nav_border_hover_width',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li:hover > a' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_hover_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'nav_border_hover_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li:hover > a' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_hover_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Border active.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'nav_border_active_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'nav_border_active_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li.wd-active > a' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'       => array(
						'element' => 'nav_border_active_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'nav_border_active_width',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li.wd-active > a' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_active_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'nav_border_active_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li.wd-active > a' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'    => array(
						'element' => 'nav_border_active_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Box shadow idle.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'nav_box_shadow_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'nav_box_shadow',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'       => array(
						'element' => 'nav_box_shadow_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Box shadow hover.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'nav_box_shadow_hover_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'nav_box_shadow_hover',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li:hover > a' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'       => array(
						'element' => 'nav_box_shadow_hover_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Box shadow active.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Style', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'nav_box_shadow_active_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'nav_box_shadow_active',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li.wd-active > a' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'items_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'       => array(
						'element' => 'nav_box_shadow_active_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Padding.
				 */
				array(
					'heading'    => esc_html__( 'Padding', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'type'       => 'wd_dimensions',
					'param_name' => 'items_padding',
					'selectors'  => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-pd: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'      => array(
						'px' => array(),
					),
				),
				// Icons.
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Icons', 'studiare-plus' ),
					'group'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'icons_divider',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Show icons', 'studiare-plus' ),
					'param_name'       => 'show_icons',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'yes',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'param_name'       => 'icon_alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
						esc_html__( 'Top', 'studiare-plus' )   => 'top',
					),
					'wd_dependency'    => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
					'std'              => 'left',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'icon_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 1,
							'max'  => 50,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc' => array(
							'--nav-icon-size: {{VALUE}}{{UNIT}};',
						),
					),
					'dependency'       => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'       => 'icons_color_tabs',
					'value'            => array(
						esc_html__( 'Idle', 'studiare-plus' )   => 'idle',
						esc_html__( 'Hover', 'studiare-plus' )  => 'hover',
						esc_html__( 'Active', 'studiare-plus' ) => 'active',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'dependency'       => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'icons_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li > a > .wd-nav-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'icons_color_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'icons_color_hover',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li:hover > a > .wd-nav-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'icons_color_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'icons_color_active',
					'selectors'        => array(
						'{{WRAPPER}}.wd-el-my-acc-nav .wd-nav-my-acc > li.wd-active > a > .wd-nav-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'show_icons',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'icons_color_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'studiare-plus' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
