<?php
/**
 * Product Teachers Widget (Elementor)
 */

namespace XTS\Modules\Layouts;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit;

class Teacher extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_teacher';
	}

	public function get_title() {
		return esc_html__( 'مدرسین دوره', 'woodmart' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'wd-single-product-elements' ];
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	/**
	 * ---------------------------------
	 *  Elementor Controls
	 * ---------------------------------
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_style',
			[
				'label' => 'استایل مدرسین',
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		/**
		 * چیدمان
		 */
		$this->add_control(
			'layout_type',
			[
				'label'   => 'چیدمان تصویر و متن',
				'type'    => Controls_Manager::SELECT,
				'default' => 'top',
				'options' => [
					'top'   => 'تصویر بالا / متن پایین',
					'left'  => 'تصویر چپ / متن راست',
					'right' => 'تصویر راست / متن چپ',
				],
			]
		);

		

		/**
		 * فاصله بین تصویر و متن
		 */
		$this->add_control(
			'spacing',
			[
				'label' => 'فاصله تصویر و متن',
				'type'  => Controls_Manager::SLIDER,
				'default' => [ 'size' => 12 ],
				'selectors' => [
					'{{WRAPPER}} .wd-teacher-item' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/**
		 * سایز تصویر
		 */
		$this->add_control(
			'teacher_image_size',
			[
				'label' => 'عرض تصویر مدرس',
				'type'  => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [ 'size' => 70 ],
				'range' => [
					'px' => [ 'min' => 30, 'max' => 200 ]
				],
				'selectors' => [
					'{{WRAPPER}} .wd-teacher-thumb img' =>
						'width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; height: auto; flex-shrink:0;',
				],
			]
		);

		/**
		 * گردی تصویر
		 */
		$this->add_control(
			'image_radius',
			[
				'label' => 'گردی تصویر',
				'type'  => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'default' => [ 'size' => 50, 'unit' => '%' ],
				'selectors' => [
					'{{WRAPPER}} .wd-teacher-thumb img' =>
						'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/**
		 * سایه تصویر
		 */
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'teacher_image_shadow',
				'label'    => 'سایه تصویر',
				'selector' => '{{WRAPPER}} .wd-teacher-thumb img',
			]
		);

		/**
		 * تایپوگرافی نام
		 */
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'teacher_name_typography',
				'label'    => 'تایپوگرافی نام مدرس',
				'selector' => '{{WRAPPER}} .wd-teacher-name',
			]
		);


		/**
		 * تایپوگرافی توضیحات مدرس
		 */
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'teacher_tozih_typography',
				'label'    => 'تایپوگرافی متن توضیحات مدرس',
				'selector' => '{{WRAPPER}} .wd-teacher-excerpt',
			]
		);


		/**
		 * ترازبندی متن
		 */
		$this->add_control(
			'text_align',
			[
				'label'   => 'ترازبندی متن',
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [ 'title' => 'چپ', 'icon' => 'eicon-text-align-left' ],
					'center' => [ 'title' => 'وسط', 'icon' => 'eicon-text-align-center' ],
					'right' => [ 'title' => 'راست', 'icon' => 'eicon-text-align-right' ],
				],
				'selectors' => [
					'{{WRAPPER}} .wd-teacher-content' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * ---------------------------------
	 *  Render HTML
	 * ---------------------------------
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		$layout_class = 'layout-' . $settings['layout_type'];

		Main::setup_preview();

		$product_id = get_the_ID();
		if ( ! $product_id ) { Main::restore_preview(); return; }

		$teachers = get_post_meta( $product_id, '_woodmart_product_teachers', true );
		if ( empty( $teachers ) || ! is_array( $teachers ) ) {
			Main::restore_preview();
			return;
		}
		?>

		<div class="wd-product-teachers">

			<?php foreach ( $teachers as $teacher_id ) : ?>

				<?php if ( get_post_type( $teacher_id ) !== 'teacher' ) continue; ?>

				<?php
					$title    = get_the_title( $teacher_id );
					$link     = get_permalink( $teacher_id );
					$thumb    = get_the_post_thumbnail( $teacher_id, 'thumbnail' );
					$job_role = get_post_meta( $teacher_id, '_woodmart_teacher_second_title', true );
				?>

				<div class="wd-teacher-item <?php echo esc_attr( $layout_class ); ?>">

					<a href="<?php echo esc_url( $link ); ?>" class="wd-teacher-thumb">
						<?php echo $thumb; ?>
					</a>

					<div class="wd-teacher-content">
						<div class="wd-teacher-name">
							<a href="<?php echo esc_url( $link ); ?>">
								<?php echo esc_html( $title ); ?>
							</a>
						</div>

						<?php if ( ! empty( $job_role ) ) : ?>
							<p class="wd-teacher-excerpt"><?php echo esc_html( $job_role ); ?></p>
						<?php endif; ?>
					</div>

				</div>

			<?php endforeach; ?>

		</div>

		<?php
		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Teacher() );
