<?php
/**
 * Product Seller Widget
 *
 * @package studiare plus
 */

namespace XTS\Modules\Layouts;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Seller extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_seller';
	}

	public function get_title() {
		return esc_html__( 'فروشنده محصول', 'studiare-plus' );
	}

	public function get_icon() {
		return 'wd-icon-sp-rating';
	}

	public function get_categories() {
		return array( 'wd-single-product-elements' );
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	protected function register_controls() {

		// 🔹 بخش محتوای اصلی
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'محتوا', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		// کنترل عنوان شغلی نویسنده (قابل ویرایش در المنتور)
		$this->add_control(
			'seller_title_text',
			[
				'label'       => esc_html__( 'عنوان فروشنده', 'studiare-plus' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'توسعه دهنده:', 'studiare-plus' ),
				'placeholder' => esc_html__( 'مثلاً: مدرس، طراح، فروشنده', 'studiare-plus' ),
			]
		);

		$this->end_controls_section();

		// 🔹 تنظیمات استایل نام نویسنده
		$this->start_controls_section(
			'author_name_style',
			[
				'label' => esc_html__( 'استایل نام نویسنده', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'author_name_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .product-author .author-name',
			]
		);

		$this->add_control(
			'author_name_color',
			[
				'label'     => esc_html__( 'رنگ نام نویسنده', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-author .author-name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
	Main::setup_preview();

	global $product;

	if ( ! $product ) {
		Main::restore_preview();
		return;
	}

	$settings   = $this->get_settings_for_display();
	$product_id = get_the_ID();
	$author_id  = get_post_field( 'post_author', $product_id );

	// مقادیر پیش‌فرض برای نویسنده
	$author_name   = get_the_author_meta( 'display_name', $author_id );
	$author_avatar = get_avatar( $author_id, 30 );
	$author_url    = get_author_posts_url( $author_id );

	// اگر دکان فعال بود، از اطلاعات فروشنده دکان استفاده کن
	if ( function_exists( 'dokan_get_store_info' ) ) {
		$store_info = dokan_get_store_info( $author_id );

		if ( ! empty( $store_info ) ) {
			$author_name = isset( $store_info['store_name'] ) ? $store_info['store_name'] : $author_name;
			$author_url  = dokan_get_store_url( $author_id );

			$store_avatar_id = isset( $store_info['gravatar'] ) ? absint( $store_info['gravatar'] ) : 0;
			if ( $store_avatar_id ) {
				$author_avatar = wp_get_attachment_image( $store_avatar_id, [30, 30], false, [ 'class' => 'dokan-store-avatar' ] );
			}
		}
	}

	?>
	<div class="product-author" style="display:flex; align-items:center; gap:10px;">
		<div class="author-avatar">
			<?php echo $author_avatar; ?>
		</div>
		<div class="author-name">
			<?php echo esc_html( $settings['seller_title_text'] ); ?>
			<a href="<?php echo esc_url( $author_url ); ?>" target="_blank" rel="nofollow">
				<?php echo esc_html( $author_name ); ?>
			</a>
		</div>
	</div>
	<?php

	Main::restore_preview();
}

}

Plugin::instance()->widgets_manager->register( new Seller() );
