<?php
/**
 * Product Sales Count Widget.
 *
 * @package studiare plus
 */

namespace XTS\Modules\Layouts;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Sales extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_sales';
	}

	public function get_title() {
		return esc_html__( 'تعداد فروش محصول', 'studiare-plus' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return array( 'wd-single-product-elements' );
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	protected function register_controls() {

		/**
		 * Style section
		 */
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل تعداد فروش', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// کنترل تایپوگرافی
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sales_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .wd-sales-count',
			]
		);

		// کنترل رنگ متن
		$this->add_control(
			'sales_color',
			[
				'label'     => esc_html__( 'رنگ متن', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wd-sales-count' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		Main::setup_preview();

		global $product;

		if ( ! $product ) {
			Main::restore_preview();
			return;
		}

		// دریافت تعداد فروش
		$total_sold = (int) get_post_meta( $product->get_id(), 'total_sales', true );

		// نمایش حتی اگر صفر باشد
		echo '<div class="wd-sales-count">' . esc_html( $total_sold ) . '</div>';

		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register( new Sales() );
