<?php
/**
 * Progress lessons Widget (Elementor)
 */

namespace XTS\Modules\Layouts;

use Elementor\Plugin;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
	exit;
}

class Progress_lessons extends Widget_Base
{

	public function get_name()
	{
		return 'wd_single_product_progress_lessons';
	}

	public function get_title()
	{
		return esc_html__('درصد تکمیل دوره کاربر', 'woodmart');
	}

	public function get_icon()
	{
		return 'wd-icon-button';
	}

	public function get_categories()
	{
		return ['wd-single-product-elements'];
	}

	public function show_in_panel()
	{
		return Main::is_layout_type('single_product');
	}

	protected function register_controls()
	{
		// این ویجت فقط نمایش درصد دارد، کنترل خاصی لازم نیست
		$this->end_controls_section();
	}

	protected function render()
	{
		Main::setup_preview();

	

		Main::restore_preview();
	}

}

Plugin::instance()->widgets_manager->register_widget_type(new Progress_lessons());
