<?php
/**
 * Product Preview Button Widget (Elementor)
 */

namespace XTS\Modules\Layouts;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Preview extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_preview';
	}

	public function get_title() {
		return esc_html__( 'پیش نمایش محصول', 'woodmart' );
	}

	public function get_icon() {
		return 'wd-icon-button';
	}

	public function get_categories() {
		return [ 'wd-single-product-elements' ];
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل دکمه', 'woodmart' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// --- آیکون ---
		$this->add_control(
			'button_icon',
			[
				'label'       => esc_html__( 'آیکون دکمه', 'woodmart' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'skin'        => 'inline',
				'default'     => [
					'value'   => '',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'icon_position',
			[
				'label'   => esc_html__( 'موقعیت آیکون', 'woodmart' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'  => [ 'title' => esc_html__( 'قبل از متن', 'woodmart' ), 'icon' => 'eicon-arrow-left' ],
					'right' => [ 'title' => esc_html__( 'بعد از متن', 'woodmart' ), 'icon' => 'eicon-arrow-right' ],
				],
				'default' => 'right',
				'toggle'  => false,
				'condition' => [
					'button_icon[value]!' => '',
				],
			]
		);

		// ✅ کنترل جدید: اندازه آیکون
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'اندازه آیکون', 'woodmart' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 8,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .preview_link .wd-btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .preview_link .wd-btn-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'button_icon[value]!' => '',
				],
			]
		);

		// ✅ کنترل جدید: پدینگ دکمه
		$this->add_responsive_control(
			'button_padding',
			[
				'label'      => esc_html__( 'پدینگ دکمه', 'woodmart' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .preview_link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// --- تایپوگرافی و رنگ ---
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography',
				'selector' => '{{WRAPPER}} .preview_link',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[ 'label' => esc_html__( 'عادی', 'woodmart' ) ]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'رنگ متن', 'woodmart' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .preview_link' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'background',
				'selector' => '{{WRAPPER}} .preview_link',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'border',
				'selector' => '{{WRAPPER}} .preview_link',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label'      => esc_html__( 'انحنای گوشه‌ها', 'woodmart' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .preview_link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .preview_link',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[ 'label' => esc_html__( 'هاور', 'woodmart' ) ]
		);

		$this->add_control(
			'hover_text_color',
			[
				'label'     => esc_html__( 'رنگ متن هاور', 'woodmart' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .preview_link:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'hover_background',
				'selector' => '{{WRAPPER}} .preview_link:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'hover_border',
				'selector' => '{{WRAPPER}} .preview_link:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'hover_box_shadow',
				'selector' => '{{WRAPPER}} .preview_link:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		// Alignment
		$this->add_responsive_control(
			'align',
			[
				'label'     => esc_html__( 'چیدمان', 'woodmart' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [ 'title' => esc_html__( 'چپ', 'woodmart' ), 'icon' => 'eicon-text-align-left' ],
					'center' => [ 'title' => esc_html__( 'وسط', 'woodmart' ), 'icon' => 'eicon-text-align-center' ],
					'right'  => [ 'title' => esc_html__( 'راست', 'woodmart' ), 'icon' => 'eicon-text-align-right' ],
				],
				'default'   => 'center',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);

        // ✅ کنترل جدید: تمام عرض
$this->add_control(
    'full_width',
    [
        'label'        => esc_html__( 'تمام عرض', 'woodmart' ),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__( 'بله', 'woodmart' ),
        'label_off'    => esc_html__( 'خیر', 'woodmart' ),
        'return_value' => 'yes',
        'default'      => '',
        'selectors'    => [
            '{{WRAPPER}} .preview_link' => 'display: block; width: 100%;',
        ],
    ]
);

		$this->end_controls_section();
	}

	protected function render() {
		Main::setup_preview();

		$product_id = get_the_ID();

		if ( method_exists( 'XTS\Modules\Layouts\Main', 'get_preview_product_id' ) ) {
			$preview_id = Main::get_preview_product_id();
			if ( $preview_id ) {
				$product_id = $preview_id;
			}
		}

		$preview_url  = get_post_meta( $product_id, '_woodmart_product_preview', true );
		$preview_text = get_post_meta( $product_id, '_woodmart_product_preview_text', true );

		$settings = $this->get_settings_for_display();

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() && empty( $preview_text ) ) {
			$preview_url  = '#';
			$preview_text = esc_html__( 'پیش‌نمایش محصول (نمونه)', 'woodmart' );
		}

		if ( empty( $preview_url ) ) {
			Main::restore_preview();
			return;
		}

		$has_icon = ! empty( $settings['button_icon']['value'] );

		?>
		<a class="preview_link elementor-button" href="<?php echo esc_url( $preview_url ); ?>" target="_blank" rel="nofollow">
			<?php if ( $has_icon && $settings['icon_position'] === 'left' ) : ?>
				<span class="wd-btn-icon wd-icon-left">
					<?php Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</span>
			<?php endif; ?>

			<span class="wd-btn-text"><?php echo esc_html( $preview_text ); ?></span>

			<?php if ( $has_icon && $settings['icon_position'] === 'right' ) : ?>
				<span class="wd-btn-icon wd-icon-right">
					<?php Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</span>
			<?php endif; ?>
		</a>
		<?php

		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Preview() );
