<?php
/**
 * Product Sales Count Widget.
 *
 * @package studiare plus
 */

namespace XTS\Modules\Layouts;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Percent extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_percent';
	}

	public function get_title() {
		return esc_html__( 'درصد تخفیف محصول', 'studiare-plus' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return array( 'wd-single-product-elements' );
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	protected function register_controls() {

		/**
		 * Style section
		 */
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل درصد تخفیف ', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// کنترل تایپوگرافی
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sales_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .splus-discount',
			]
		);

		// کنترل رنگ متن
		$this->add_control(
			'sales_color',
			[
				'label'     => esc_html__( 'رنگ متن', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .splus-discount' => 'color: {{VALUE}};',
				],
			]
		);

		// 🎨 کنترل پس‌زمینه (رنگ یا گرادینت)
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'sales_background',
				'label'    => esc_html__( 'پس‌زمینه', 'studiare-plus' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .splus-discount',
			]
		);

		// 🧱 کنترل حاشیه
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'sales_border',
				'label'    => esc_html__( 'حاشیه', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .splus-discount',
			]
		);

		// 🟢 کنترل انحنای حاشیه
		$this->add_control(
			'sales_border_radius',
			[
				'label'      => esc_html__( 'انحنای حاشیه', 'studiare-plus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .splus-discount' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// 📦 کنترل پدینگ
		$this->add_responsive_control(
			'sales_padding',
			[
				'label'      => esc_html__( 'فاصله داخلی (Padding)', 'studiare-plus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .splus-discount' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		Main::setup_preview();

		global $product;

		if ( ! $product ) {
			Main::restore_preview();
			return;
		}

		// بررسی نوع محصول
		if ( $product->is_type( 'simple' ) ) {
			$regular_price = (float) $product->get_regular_price();
			$sale_price    = (float) $product->get_sale_price();

			if ( $regular_price > 0 && $sale_price > 0 && $sale_price < $regular_price ) {
				$discount = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
				echo '<span class="splus-discount">' . $discount . '%</span>';
			}

		} elseif ( $product->is_type( 'variable' ) ) {
			$regular_price = (float) $product->get_variation_regular_price( 'max' );
			$sale_price    = (float) $product->get_variation_sale_price( 'min' );

			if ( $regular_price > 0 && $sale_price > 0 && $sale_price < $regular_price ) {
				$discount = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
				echo '<span class="splus-discount">' . $discount . '%</span>';
			}
		}

		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register( new Percent() );
