<?php
namespace XTS\Modules\Layouts;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit;

class Nav extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_navbari';
	}

	public function get_title() {
		return esc_html__( 'منوی ناوبری صفحه', 'studiare-plus' );
	}

	public function get_icon() {
		return 'eicon-table-of-contents';
	}

	public function get_categories() {
		return ['wd-single-product-elements'];
	}

	public function show_in_panel() {
		return Main::is_layout_type('single_product');
	}

	protected function register_controls() {

		// =======================
		// Items
		// =======================
		$this->start_controls_section(
			'nav_items_section',
			[
				'label' => 'آیتم‌ها',
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control('text', [
			'label'   => 'متن آیتم',
			'type'    => Controls_Manager::TEXT,
			'default' => 'عنوان سکشن',
		]);

		$repeater->add_control('section_id', [
			'label'   => 'شناسه سکشن (id)',
			'type'    => Controls_Manager::TEXT,
			'default' => 'section-id',
		]);

		$repeater->add_control('icon', [
			'label' => 'آیکون',
			'type'  => Controls_Manager::ICONS,
		]);

		$this->add_control('nav_items', [
			'label'   => 'آیتم‌ها',
			'type'    => Controls_Manager::REPEATER,
			'fields'  => $repeater->get_controls(),
			'default' => [],
		]);

		$this->end_controls_section();

		// =======================
		// Style
		// =======================
		$this->start_controls_section('style_section', [
			'label' => 'استایل آیتم',
			'tab'   => Controls_Manager::TAB_STYLE,
		]);

		// Scroll offset
		$this->add_control('scroll_offset', [
			'label'       => 'ارتفاع هدر (افست اسکرول) px',
			'type'        => Controls_Manager::NUMBER,
			'default'     => 0,
			'description' => 'اگر هدر ثابت دارید، این مقدار را وارد کنید تا اسکرول درست برسد',
		]);

		// Orientation
		$this->add_control('orientation', [
			'label'   => 'جهت ناوبری',
			'type'    => Controls_Manager::SELECT,
			'default' => 'vertical',
			'options' => [
				'vertical'   => 'عمودی',
				'horizontal' => 'افقی',
			],
		]);

		// Gap between items
		$this->add_responsive_control('items_gap', [
			'label'   => 'فاصله بین آیتم‌ها',
			'type'    => Controls_Manager::SLIDER,
			'default' => ['size' => 10],
			'range'   => ['px' => ['min' => 0, 'max' => 100]],
		]);

		// Padding
		$this->add_responsive_control('item_padding', [
			'label'      => 'پدینگ آیتم',
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%'],
			'selectors'  => [
				'{{WRAPPER}} .nav-scroll .item-nav' =>
					'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		// Icon size
		$this->add_control('icon_size', [
			'label' => 'سایز آیکون (px)',
			'type'  => Controls_Manager::NUMBER,
			'default' => 18,
			'selectors' => [
				'{{WRAPPER}} .nav-scroll .item-nav i, {{WRAPPER}} .nav-scroll .item-nav svg' => 'font-size: {{VALUE}}px; width: {{VALUE}}px; height: {{VALUE}}px;',
			],
		]);

		// Icon spacing
		$this->add_control('icon_spacing', [
			'label' => 'فاصله آیکون تا متن (px)',
			'type'  => Controls_Manager::NUMBER,
			'default' => 5,
			'selectors' => [
				'{{WRAPPER}} .nav-scroll .item-nav span' => 'margin-right: {{VALUE}}px;',
			],
		]);

		// Border
		$this->add_group_control(Group_Control_Border::get_type(), [
			'name'     => 'item_border',
			'selector' => '{{WRAPPER}} .item-nav',
		]);

		// Radius
		$this->add_control('item_radius', [
			'label'     => 'گردی گوشه',
			'type'      => Controls_Manager::DIMENSIONS,
			'selectors' => [
				'{{WRAPPER}} .item-nav' =>
					'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
			],
		]);

		// Shadow
		$this->add_group_control(Group_Control_Box_Shadow::get_type(), [
			'name'     => 'item_shadow',
			'selector' => '{{WRAPPER}} .item-nav',
		]);

		// Typography
		$this->add_group_control(Group_Control_Typography::get_type(), [
			'name'     => 'item_typo',
			'label'    => 'تایپوگرافی',
			'selector' => '{{WRAPPER}} .item-nav',
		]);

		// Colors
		$this->add_control('item_color', [
			'label'     => 'رنگ متن',
			'type'      => Controls_Manager::COLOR,
			'selectors' => ['{{WRAPPER}} .item-nav' => 'color: {{VALUE}};'],
		]);

		$this->add_control('item_color_hover', [
			'label'     => 'رنگ متن هاور',
			'type'      => Controls_Manager::COLOR,
			'selectors' => ['{{WRAPPER}} .item-nav:hover' => 'color: {{VALUE}};'],
		]);

		$this->add_control('item_bg', [
			'label'     => 'پس‌زمینه',
			'type'      => Controls_Manager::COLOR,
			'selectors' => ['{{WRAPPER}} .item-nav' => 'background-color: {{VALUE}};'],
		]);

		$this->add_control('item_bg_hover', [
			'label'     => 'پس‌زمینه هاور',
			'type'      => Controls_Manager::COLOR,
			'selectors' => ['{{WRAPPER}} .item-nav:hover' => 'background-color: {{VALUE}};'],
		]);

		$this->end_controls_section();
	}

	protected function render() {
		Main::setup_preview();
		$settings = $this->get_settings_for_display();

		if (empty($settings['nav_items'])) {
			Main::restore_preview();
			return;
		}

		$orientation = $settings['orientation'] === 'horizontal' ? 'row' : 'column';
		$gap = $settings['items_gap']['size'] ?? 10;
		$offset = (int) $settings['scroll_offset'];
	?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const navLinks = document.querySelectorAll('.nav-scroll .item-nav');
    const offset = <?php echo esc_js($offset); ?>;

    navLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const targetId = this.getAttribute('data-scrollto');
            const targetElement = document.getElementById(targetId);

            if (targetElement) {
                const elementPosition = targetElement.getBoundingClientRect().top + window.pageYOffset;
                const offsetPosition = elementPosition - offset;

                window.scrollTo({
                    top: offsetPosition,
                    behavior: 'smooth'
                });
            }
        });
    });
});
</script>
		<div class="nav-scroll-wrapper">
		<div class="nav-scroll" style="display:flex; flex-direction:<?php echo esc_attr($orientation); ?>; gap:<?php echo esc_attr($gap); ?>px;">
			<?php foreach ($settings['nav_items'] as $item):
				$target = !empty($item['section_id']) ? '#' . esc_attr($item['section_id']) : '#';
				?>
				<a href="<?php echo esc_url($target); ?>" class="item-nav" data-scrollto="<?php echo esc_attr($item['section_id']); ?>" style="display:flex; align-items:center; text-decoration:none;">
					<?php if (!empty($item['icon'])): ?>
						<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
					<?php endif; ?>
					<span><?php echo esc_html($item['text']); ?></span>
				</a>
			<?php endforeach; ?>
		</div>
		</div>

	<?php
		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register(new Nav());
