<?php
/**
 * Product Medals Widget (Elementor)
 */

namespace XTS\Modules\Layouts;

use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
	exit;
}

class Medal extends Widget_Base
{

	public function get_name()
	{
		return 'wd_single_product_medal';
	}

	public function get_title()
	{
		return esc_html__('مدال های محصول', 'woodmart');
	}

	public function get_icon()
	{
		return 'wd-icon-button';
	}

	public function get_categories()
	{
		return ['wd-single-product-elements'];
	}

	public function show_in_panel()
	{
		return Main::is_layout_type('single_product');
	}

	/**
	 * -------------------------
	 *  Elementor Controls
	 * -------------------------
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__('تنظیمات مدال', 'woodmart'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/**
		 * ✔ کنترل سایز تصویر مدال
		 */
		$this->add_control(
			'medal_size',
			[
				'label' => esc_html__('عرض تصویر مدال (px)', 'woodmart'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 60,
					'unit' => 'px'
				],
				'selectors' => [
					'{{WRAPPER}} .wd-medal-thumb img' => 'width: {{SIZE}}{{UNIT}}; height:auto;',
				],
			]
		);

		/**
		 * ✔ کنترل فاصله بین مدال‌ها (Gap)
		 */
		$this->add_control(
			'medal_gap',
			[
				'label' => esc_html__('فاصله بین مدال‌ها (px)', 'woodmart'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 15,
					'unit' => 'px'
				],
				'selectors' => [
					'{{WRAPPER}} .wd-product-medals' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * -------------------------
	 *  Render HTML Output
	 * -------------------------
	 */
	protected function render()
	{
		Main::setup_preview();

		$product_id = get_the_ID();

		if (!$product_id) {
			Main::restore_preview();
			return;
		}

		$medals = get_post_meta($product_id, '_woodmart_product_medal_tab_html_block', true);

		if (empty($medals) || !is_array($medals)) {
			Main::restore_preview();
			return;
		}

		?>
		<div class="wd-product-medals">
			<?php foreach ($medals as $medal_id):

				// جلوگیری از نمایش پست تایپ غیر از مدال
				if (get_post_type($medal_id) !== 'cms_medal') {
					continue;
				}

				$title = get_the_title($medal_id);
				$thumb = get_the_post_thumbnail($medal_id, 'thumbnail');

				// اگر مدال تصویر نداشت رد شود
				if (empty($thumb)) {
					continue;
				}
				?>
				<div class="wd-medal-item" data-title="<?php echo esc_attr($title); ?>">
					<div class="wd-medal-thumb"><?php echo $thumb; ?></div>
				</div>

			<?php endforeach; ?>
		</div>
		<?php

		Main::restore_preview();
	}

}

Plugin::instance()->widgets_manager->register_widget_type(new Medal());
