<?php
/**
 * Product Downloads Widget (Accordion Version)
 *
 * @package studiare plus
 */

namespace XTS\Modules\Layouts;

use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Downloads extends Widget_Base {

	public function get_name() {
		return 'wd_single_product_downloads';
	}

	public function get_title() {
		return esc_html__( 'فایل های دانلودی محصول', 'studiare-plus' );
	}

	public function get_icon() {
		return 'eicon-download-button';
	}

	public function get_categories() {
		return array( 'wd-single-product-elements' );
	}

	public function show_in_panel() {
		return Main::is_layout_type( 'single_product' );
	}

	protected function register_controls() {}

	protected function render() {

		Main::setup_preview();

		$product_id = get_the_ID();

		if ( ! $product_id || ! is_user_logged_in() ) {
			Main::restore_preview();
			return;
		}

		$user_id = get_current_user_id();

		if ( ! wc_customer_bought_product( '', $user_id, $product_id ) ) {
			Main::restore_preview();
			return;
		}

		$product = wc_get_product( $product_id );

		if ( ! $product || ! $product->is_downloadable() ) {
			Main::restore_preview();
			return;
		}

		$downloads = $product->get_downloads();

		if ( empty( $downloads ) ) {
			Main::restore_preview();
			return;
		}
		?>

		<div class="wdp-product-downloads-box">

			<h3 class="wdp-product-downloads-title js-wdp-accordion-toggle">
				<i class="fal fa-download"></i>
				سابقه خرید این محصول توسط شما
				<span class="wdp-acc-arrow"></span>
			</h3>

			<ul class="wdp-product-downloads-list js-wdp-accordion-content">
				<?php foreach ( $downloads as $download ) : ?>
					<li class="wdp-product-download-item">
						<a href="<?php echo esc_url( $download->get_file() ); ?>"
						   class="wdp-download-link"
						   download> 
							<?php echo esc_html( $download->get_name() ); ?>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>

		<?php

		Main::restore_preview();
	}
}

Plugin::instance()->widgets_manager->register( new Downloads() );
