<?php
/**
 * Condition template.
 *
 * @package studiare plus
 */

?>
<div class="xts-popup-condition-template xts-hidden">
	<div class="xts-popup-condition">
		<select id="wd_layout_condition_comparison" class="xts-popup-condition-comparison" name="wd_layout_condition_comparison" aria-label="<?php esc_attr_e( 'Condition comparison', 'studiare-plus' ); ?>">
			<option value="include">
				<?php esc_html_e( 'Include', 'studiare-plus' ); ?>
			</option>
			<option value="exclude">
				<?php esc_html_e( 'Exclude', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="shop_archive" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All product archives', 'studiare-plus' ); ?>
			</option>
			<option value="shop_page">
				<?php esc_html_e( 'Shop page', 'studiare-plus' ); ?>
			</option>
			<option value="product_search">
				<?php esc_html_e( 'Shop search results', 'studiare-plus' ); ?>
			</option>
			<option value="product_cats">
				<?php esc_html_e( 'Product categories', 'studiare-plus' ); ?>
			</option>
			<option value="product_tags">
				<?php esc_html_e( 'Product tags', 'studiare-plus' ); ?>
			</option>
			<?php if ( taxonomy_exists( 'product_brand' ) ) : ?>
				<option value="product_brands">
					<?php esc_html_e( 'Product brand', 'studiare-plus' ); ?>
				</option>
			<?php endif; ?>
			<option value="product_attr">
				<?php esc_html_e( 'Product attribute', 'studiare-plus' ); ?>
			</option>
			<option value="product_term">
				<?php esc_html_e( 'Product term (category, tag, brand, attribute)', 'studiare-plus' ); ?>
			</option>
			<option value="product_cat_children">
				<?php esc_html_e( 'Child product categories', 'studiare-plus' ); ?>
			</option>
			<option value="filtered_product_term">
				<?php esc_html_e( 'Filtered by attribute', 'studiare-plus' ); ?>
			</option>
			<option value="filtered_product_by_term">
				<?php esc_html_e( 'Filtered by term', 'studiare-plus' ); ?>
			</option>
			<option value="filtered_product_term_any">
				<?php esc_html_e( 'Filtered by any attribute', 'studiare-plus' ); ?>
			</option>
			<option value="filtered_product_stock_status">
				<?php esc_html_e( 'Filtered by stock status', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="single_product" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All products', 'studiare-plus' ); ?>
			</option>
			<option value="product">
				<?php esc_html_e( 'Single product id', 'studiare-plus' ); ?>
			</option>
			<option value="product_cat">
				<?php esc_html_e( 'Product category', 'studiare-plus' ); ?>
			</option>
			<option value="product_cat_children">
				<?php esc_html_e( 'Child product categories', 'studiare-plus' ); ?>
			</option>
			<option value="product_tag">
				<?php esc_html_e( 'Product tag', 'studiare-plus' ); ?>
			</option>
			<?php if ( taxonomy_exists( 'product_brand' ) ) : ?>
				<option value="product_brand">
					<?php esc_html_e( 'Product brand', 'studiare-plus' ); ?>
				</option>
			<?php endif; ?>
			<option value="product_attr_term">
				<?php esc_html_e( 'Product attribute', 'studiare-plus' ); ?>
			</option>
			<option value="product_type">
				<?php esc_html_e( 'Product type', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="checkout_form" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="checkout_form">
				<?php esc_html_e( 'Checkout page form', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="checkout_content" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="checkout_content">
				<?php esc_html_e( 'Checkout page content', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="cart" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="cart">
				<?php esc_html_e( 'Cart page', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="empty_cart" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="empty_cart">
				<?php esc_html_e( 'Empty cart page', 'studiare-plus' ); ?>
			</option>
		</select>
		
		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="single_post" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All posts', 'studiare-plus' ); ?>
			</option>
			<option value="post_id">
				<?php esc_html_e( 'Single post id', 'studiare-plus' ); ?>
			</option>
			<option value="post_cat">
				<?php esc_html_e( 'Post category', 'studiare-plus' ); ?>
			</option>
			<option value="post_tag">
				<?php esc_html_e( 'Post tag', 'studiare-plus' ); ?>
			</option>
			<option value="post_format">
				<?php esc_html_e( 'Post format', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="single_portfolio" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
			<?php esc_html_e( 'All projects', 'studiare-plus' ); ?>
			</option>
			<option value="project_id">
				<?php esc_html_e( 'Single project id', 'studiare-plus' ); ?>
			</option>
			<option value="project_cat">
				<?php esc_html_e( 'Project category', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="blog_archive" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All blog archives', 'studiare-plus' ); ?>
			</option>
			<option value="blog_search_result">
				<?php esc_html_e( 'Blog search results', 'studiare-plus' ); ?>
			</option>
			<option value="blog_category"> 
				<?php esc_html_e( 'Blog categories', 'studiare-plus' ); ?>
			</option>
			<option value="blog_tag">
				<?php esc_html_e( 'Blog tags', 'studiare-plus' ); ?>
			</option>
			<option value="blog_author">
				<?php esc_html_e( 'Blog author page', 'studiare-plus' ); ?>
			</option>
			<option value="blog_date">
				<?php esc_html_e( 'Blog archives by date', 'studiare-plus' ); ?>
			</option>
		</select>
		
		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="portfolio_archive" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All portfolio archives', 'studiare-plus' ); ?>
			</option>
			<option value="portfolio_search_result">
				<?php esc_html_e( 'Portfolio search results', 'studiare-plus' ); ?>
			</option>
			<option value="portfolio_category">
				<?php esc_html_e( 'Portfolio categories', 'studiare-plus' ); ?>
			</option>
		</select>

		<select class="xts-popup-condition-type" name="wd_layout_condition_type" data-type="my_account_page" aria-label="<?php esc_attr_e( 'Condition type', 'studiare-plus' ); ?>">
			<option value="all">
				<?php esc_html_e( 'All endpoints', 'studiare-plus' ); ?>
			</option>
			<?php
			if ( woodmart_woocommerce_installed() ) :
				$menu_items                  = wc_get_account_menu_items();
				$menu_items['waitlist']      = __( 'Waitlist', 'studiare-plus' );
				$menu_items['wishlist']      = __( 'Wishlist', 'studiare-plus' );
				$menu_items['price-tracker'] = __( 'Price tracker', 'studiare-plus' );
				unset( $menu_items['customer-logout'] );
				foreach ( $menu_items as $endpoint => $label ) :
					?>
					<option value="<?php echo esc_attr( $endpoint ); ?>">
						<?php echo esc_html( $label ); ?>
					</option>
				<?php endforeach; ?>
			<?php endif; ?>
		</select>

		<select class="xts-popup-condition-query xts-hidden" name="wd_layout_condition_query" placeholder="<?php echo esc_attr__( 'Start typing...', 'studiare-plus' ); ?>" aria-label="<?php esc_attr_e( 'Condition query', 'studiare-plus' ); ?>"></select>

		<a href="javascript:void(0);" class="xts-popup-condition-remove xts-bordered-btn xts-color-warning xts-style-icon xts-i-close" title="<?php esc_attr_e( 'Remove condition', 'studiare-plus' ); ?>"></a>
	</div>
</div>
