<?php

namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 * Social buttons element
 * ------------------------------------------------------------------------------------------------
 */
class Social extends Element {

	public function __construct() {
		parent::__construct();

		$this->template_name = 'social';
	}

	public function map() {
		$this->args = array(
			'type'            => 'social',
			'title'           => esc_html__( 'Social links icons', 'studiare-plus' ),
			'text'            => esc_html__( 'Social links icons', 'studiare-plus' ),
			'icon'            => 'xts-i-social',
			'editable'        => true,
			'container'       => false,
			'edit_on_create'  => true,
			'drag_target_for' => array(),
			'drag_source'     => 'content_element',
			'removable'       => true,
			'addable'         => true,
			'params'          => array(
				'type'             => array(
					'id'      => 'type',
					'title'   => esc_html__( 'Buttons type', 'studiare-plus' ),
					'tab'     => esc_html__( 'General', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'share',
					'options' => array(
						'share'  => array(
							'label' => esc_html__( 'Share', 'studiare-plus' ),
							'value' => 'share',
						),
						'follow' => array(
							'label' => esc_html__( 'Follow', 'studiare-plus' ),
							'value' => 'follow',
						),
					),
				),
				'el_class'         => array(
					'id'          => 'el_class',
					'title'       => esc_html__( 'Additional CSS class', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'value'       => '',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				'style'            => array(
					'id'      => 'style',
					'title'   => esc_html__( 'Button style', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Icons', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'default',
					'options' => array(
						'default'     => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/default.png',
						),
						'simple'      => array(
							'label' => esc_html__( 'Simple', 'studiare-plus' ),
							'value' => 'simple',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/simple.png',
						),
						'colored'     => array(
							'label' => esc_html__( 'Colored', 'studiare-plus' ),
							'value' => 'colored',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/colored.png',
						),
						'colored-alt' => array(
							'label' => esc_html__( 'Colored alternative', 'studiare-plus' ),
							'value' => 'colored-alt',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/colored-alt.png',
						),
						'bordered'    => array(
							'label' => esc_html__( 'Bordered', 'studiare-plus' ),
							'value' => 'bordered',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/bordered.png',
						),
						'primary'     => array(
							'label' => esc_html__( 'Primary color', 'studiare-plus' ),
							'value' => 'primary',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/primary.png',
						),
					),
				),
				'form'             => array(
					'id'      => 'form',
					'title'   => esc_html__( 'Button shape', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Icons', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'circle',
					'options' => array(
						'circle'  => array(
							'label' => esc_html__( 'Circle', 'studiare-plus' ),
							'value' => 'circle',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/circle.png',
						),
						'square'  => array(
							'label' => esc_html__( 'Square', 'studiare-plus' ),
							'value' => 'square',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/square.png',
						),
						'rounded' => array(
							'label' => esc_html__( 'Rounded', 'studiare-plus' ),
							'value' => 'rounded',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/rounded.png',
						),
					),
				),
				'size'             => array(
					'id'      => 'size',
					'title'   => esc_html__( 'Button size', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Icons', 'studiare-plus' ),
					'type'    => 'select',
					'value'   => '',
					'options' => array(
						''      => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'small' => array(
							'label' => esc_html__( 'Small', 'studiare-plus' ),
							'value' => 'small',
						),
						'large' => array(
							'label' => esc_html__( 'Large', 'studiare-plus' ),
							'value' => 'large',
						),
					),
				),
				'color'            => array(
					'id'      => 'color',
					'title'   => esc_html__( 'Color', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Icons', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'dark',
					'options' => array(
						'dark'  => array(
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
							'value' => 'dark',
						),
						'light' => array(
							'label' => esc_html__( 'Light', 'studiare-plus' ),
							'value' => 'light',
						),
					),
				),
			),
		);
	}
}
