<?php
namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 *  Basic structure element - row
 * ------------------------------------------------------------------------------------------------
 */
class Row extends Element {

	public function __construct() {
		parent::__construct();

		$this->template_name = 'row';
	}

	public function map() {
		$this->args = array(
			'type'            => 'row',
			'title'           => esc_html__( 'Row', 'studiare-plus' ),
			'text'            => esc_html__( 'Row', 'studiare-plus' ),
			'editable'        => true,
			'container'       => false,
			'edit_on_create'  => false,
			'drag_target_for' => array(),
			'drag_source'     => '',
			'removable'       => false,
			'addable'         => false,
			'it_works'        => 'row',
			'class'           => '',
			'content'         => array(),
			'params'          => array(
				'row_columns'   => array(
					'id'      => 'row_columns',
					'title'   => esc_html__( 'Row columns', 'studiare-plus' ),
					'type'    => 'selector',
					'tab'     => esc_html__( 'General', 'studiare-plus' ),
					'group'   => esc_html__( 'Layout', 'studiare-plus' ),
					'value'   => '3',
					'options' => array(
						'1' => array(
							'label' => 1,
							'value' => '1',
						),
						'3' => array(
							'label' => 3,
							'value' => '3',
						),
					),
				),
				'flex_layout'   => array(
					'id'          => 'flex_layout',
					'title'       => esc_html__( 'Row flex layout', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Layout', 'studiare-plus' ),
					'value'       => 'flex-middle',
					'options'     => array(
						'flex-middle' => array(
							'label' => esc_html__( 'Flexible middle column', 'studiare-plus' ),
							'value' => 'flex-middle',
							'image' => WOODMART_ASSETS . '/images/header-builder/header-layout-2.jpg',
						),
						'equal-sides' => array(
							'label' => esc_html__( 'Equal right and left columns', 'studiare-plus' ),
							'value' => 'equal-sides',
							'image' => WOODMART_ASSETS . '/images/header-builder/header-layout-1.jpg',
						),
					),
					'requires'    => array(
						'row_columns' => array(
							'comparison' => 'equal',
							'value'      => '3',
						),
					),
				),
				'height'        => array(
					'id'          => 'height',
					'title'       => esc_html__( 'Row height', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Height', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 200,
					'value'       => 50,
					'units'       => 'px',
					'description' => esc_html__( 'Determine the header height value in pixels.', 'studiare-plus' ),
				),
				'mobile_height' => array(
					'id'          => 'mobile_height',
					'title'       => esc_html__( 'Row height on mobile devices', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Height', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 200,
					'value'       => 40,
					'units'       => 'px',
					'description' => esc_html__( 'Determine the header height for mobile devices value in pixels.', 'studiare-plus' ),
				),
				'hide_desktop'  => array(
					'id'          => 'hide_desktop',
					'title'       => esc_html__( 'Hide on desktop', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Responsive', 'studiare-plus' ),
					'value'       => false,
					'description' => esc_html__( 'Disable this row for desktop devices.', 'studiare-plus' ),
					'extra_class' => 'xts-col-6',
				),
				'hide_mobile'   => array(
					'id'          => 'hide_mobile',
					'title'       => esc_html__( 'Hide on mobile', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Responsive', 'studiare-plus' ),
					'value'       => false,
					'description' => esc_html__( 'Disable this row for mobile devices.', 'studiare-plus' ),
					'extra_class' => 'xts-col-6',
				),
				'sticky'        => array(
					'id'          => 'sticky',
					'title'       => esc_html__( 'Make it sticky', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_row_sticky.mp4" autoplay loop muted></video>',
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Sticky', 'studiare-plus' ),
					'value'       => false,
				),
				'sticky_height' => array(
					'id'          => 'sticky_height',
					'title'       => esc_html__( 'Row height on sticky header', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Sticky', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 200,
					'value'       => 60,
					'units'       => 'px',
					'description' => esc_html__( 'Determine the header height for sticky header value in pixels.', 'studiare-plus' ),
					'requires'    => array(
						'sticky' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
				),
				'color_scheme'  => array(
					'id'          => 'color_scheme',
					'title'       => esc_html__( 'Text color scheme', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'value'       => 'dark',
					'options'     => array(
						'dark'  => array(
							'value' => 'dark',
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
						),
						'light' => array(
							'value' => 'light',
							'label' => esc_html__( 'Light', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'Select different text color scheme depending on your background.', 'studiare-plus' ),
				),
				'background'    => array(
					'id'          => 'background',
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'type'        => 'bg',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'backdrop'    => true,
					'value'       => '',
					'description' => '',
				),
				'border'        => array(
					'id'              => 'border',
					'group'           => esc_html__( 'Border bottom', 'studiare-plus' ),
					'type'            => 'border',
					'sides'           => array( 'bottom' ),
					'tab'             => esc_html__( 'Style', 'studiare-plus' ),
					'colorpicker_top' => true,
					'container'       => true,
					'value'           => '',
					'description'     => esc_html__( 'Set border bottom for this header row.', 'studiare-plus' ),
				),
				'shadow'        => array(
					'id'          => 'shadow',
					'title'       => esc_html__( 'Shadow', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Shadow', 'studiare-plus' ),
					'value'       => false,
					'description' => esc_html__( 'Add shadow to the header section.', 'studiare-plus' ),
				),
			),
		);
	}
}
