<?php

namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 *  Main navigation menu element
 * ------------------------------------------------------------------------------------------------
 */
class Mainmenu extends Element {

	public function __construct() {
		parent::__construct();

		$this->template_name = 'main-menu';
	}

	public function map() {
		$this->args = array(
			'type'            => 'mainmenu',
			'title'           => esc_html__( 'Main menu', 'studiare-plus' ),
			'text'            => esc_html__( 'Main navigation', 'studiare-plus' ),
			'icon'            => 'xts-i-main-menu',
			'editable'        => true,
			'container'       => false,
			'drg'             => false,
			'drag_target_for' => array(),
			'drag_source'     => 'content_element',
			'edit_on_create'  => true,
			'removable'       => true,
			'desktop'         => true,
			'addable'         => true,
			'params'          => array(
				'menu_id'             => array(
					'id'          => 'menu_id',
					'title'       => esc_html__( 'Choose menu', 'studiare-plus' ),
					'type'        => 'select',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'value'       => '',
					'callback'    => 'get_menu_options_with_empty',
					'description' => esc_html__( 'Choose which menu to display in the header.', 'studiare-plus' ),
				),
				'full_screen'         => array(
					'id'          => 'full_screen',
					'title'       => esc_html__( 'Full screen menu', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_full_screen.mp4" autoplay loop muted></video>',
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'value'       => false,
					'description' => esc_html__( 'Enable to show your menu in full screen style on burger icon click.', 'studiare-plus' ),
				),
				'style'               => array(
					'id'          => 'style',
					'title'       => esc_html__( 'Display', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'value'       => 'text',
					'options'     => array(
						'icon' => array(
							'value' => 'icon',
							'label' => esc_html__( 'Icon', 'studiare-plus' ),
						),
						'text' => array(
							'value' => 'text',
							'label' => esc_html__( 'Icon with text', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'You can show the icon only or display "Menu" text too.', 'studiare-plus' ),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
				),
				'icon_design'         => array(
					'id'       => 'icon_design',
					'title'    => esc_html__( 'Icon design', 'studiare-plus' ),
					'type'     => 'selector',
					'tab'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'    => esc_html__( 'Icon', 'studiare-plus' ),
					'value'    => '1',
					'options'  => array(
						'1' => array(
							'value' => '1',
							'label' => esc_html__( 'First', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/mobile-menu-icons/first.jpg',
						),
						'6' => array(
							'value' => '6',
							'label' => esc_html__( 'Second', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/mobile-menu-icons/second.jpg',
						),
						'7' => array(
							'value' => '7',
							'label' => esc_html__( 'Third', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/mobile-menu-icons/third.jpg',
						),
						'8' => array(
							'value' => '8',
							'label' => esc_html__( 'Fourth', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/mobile-menu-icons/fourth.jpg',
						),
					),
					'requires' => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
				),
				'wrap_type'           => array(
					'id'       => 'wrap_type',
					'title'    => esc_html__( 'Background wrap type', 'studiare-plus' ),
					'type'     => 'selector',
					'tab'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'    => esc_html__( 'Icon', 'studiare-plus' ),
					'value'    => 'icon_only',
					'options'  => array(
						'icon_only'     => array(
							'value' => 'icon_only',
							'label' => esc_html__( 'Icon only', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/bg-wrap-type/menu-wrap-icon.jpg',
						),
						'icon_and_text' => array(
							'value' => 'icon_and_text',
							'label' => esc_html__( 'Icon and text', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/bg-wrap-type/menu-wrap-icon-and-text.jpg',
						),
					),
					'requires' => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'style'       => array(
							'comparison' => 'equal',
							'value'      => 'text',
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => array( '6', '7' ),
						),
					),
				),
				'color'               => array(
					'id'          => 'color',
					'title'       => esc_html__( 'Color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'whb-row .{{WRAPPER}}.wd-tools-element .wd-tools-inner, .whb-row .{{WRAPPER}}.wd-tools-element > a > .wd-tools-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => array( '7', '8' ),
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'hover_color'         => array(
					'id'          => 'hover_color',
					'title'       => esc_html__( 'Hover color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'whb-row .{{WRAPPER}}.wd-tools-element:hover .wd-tools-inner, .whb-row .{{WRAPPER}}.wd-tools-element:hover > a > .wd-tools-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => array( '7', '8' ),
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_color'            => array(
					'id'          => 'bg_color',
					'title'       => esc_html__( 'Background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'whb-row .{{WRAPPER}}.wd-tools-element .wd-tools-inner, .whb-row .{{WRAPPER}}.wd-tools-element > a > .wd-tools-icon' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => array( '7', '8' ),
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_hover_color'      => array(
					'id'          => 'bg_hover_color',
					'title'       => esc_html__( 'Hover background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'whb-row .{{WRAPPER}}.wd-tools-element:hover .wd-tools-inner, .whb-row .{{WRAPPER}}.wd-tools-element:hover > a > .wd-tools-icon' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => array( '7', '8' ),
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_color'          => array(
					'id'          => 'icon_color',
					'title'       => esc_html__( 'Icon color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}}.wd-tools-element.wd-design-8 .wd-tools-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => '8',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_hover_color'    => array(
					'id'          => 'icon_hover_color',
					'title'       => esc_html__( 'Hover icon color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}}.wd-tools-element.wd-design-8:hover .wd-tools-icon' => array(
							'color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => '8',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_bg_color'       => array(
					'id'          => 'icon_bg_color',
					'title'       => esc_html__( 'Icon background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}}.wd-tools-element.wd-design-8 .wd-tools-icon' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => '8',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_bg_hover_color' => array(
					'id'          => 'icon_bg_hover_color',
					'title'       => esc_html__( 'Hover icon background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}}.wd-tools-element.wd-design-8:hover .wd-tools-icon' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
						'icon_design' => array(
							'comparison' => 'equal',
							'value'      => '8',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_type'           => array(
					'id'       => 'icon_type',
					'title'    => esc_html__( 'Icon type', 'studiare-plus' ),
					'type'     => 'selector',
					'tab'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'    => esc_html__( 'Icon', 'studiare-plus' ),
					'value'    => 'default',
					'options'  => array(
						'default' => array(
							'value' => 'default',
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/default-icons/burger-default.jpg',
						),
						'custom'  => array(
							'value' => 'custom',
							'label' => esc_html__( 'Custom', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/upload.jpg',
						),
					),
					'requires' => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
				),
				'custom_icon'         => array(
					'id'          => 'custom_icon',
					'title'       => esc_html__( 'Upload an image', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'value'       => '',
					'description' => '',
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'custom_icon_width'   => array(
					'id'          => 'custom_icon_width',
					'title'       => esc_html__( 'Icon width', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => 0,
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}}' => array(
							'--wd-tools-icon-width: {{VALUE}}px;',
						),
					),
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'menu_style'          => array(
					'id'          => 'menu_style',
					'title'       => esc_html__( 'Style', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu', 'studiare-plus' ),
					'value'       => 'default',
					'options'     => array(
						'default'   => array(
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/menu-style/default.jpg',
							'label' => esc_html__( 'Default', 'studiare-plus' ),
						),
						'underline' => array(
							'value' => 'underline',
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/menu-style/underline.jpg',
							'label' => esc_html__( 'Underline', 'studiare-plus' ),
						),
						'bordered'  => array(
							'value' => 'bordered',
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/menu-style/bordered.jpg',
							'label' => esc_html__( 'Bordered', 'studiare-plus' ),
						),
						'separated' => array(
							'value' => 'separated',
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/menu-style/separated.jpg',
							'label' => esc_html__( 'Separated', 'studiare-plus' ),
						),
						'bg'        => array(
							'value' => 'bg',
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/menu-style/background.jpg',
							'label' => esc_html__( 'Background', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'You can change menu style in the header.', 'studiare-plus' ),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => false,
						),
					),
				),
				'menu_align'          => array(
					'id'          => 'menu_align',
					'title'       => esc_html__( 'Menu align', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu', 'studiare-plus' ),
					'value'       => 'left',
					'options'     => array(
						'left'   => array(
							'value' => 'left',
							'label' => esc_html__( 'Left', 'studiare-plus' ),
						),
						'center' => array(
							'value' => 'center',
							'label' => esc_html__( 'Center', 'studiare-plus' ),
						),
						'right'  => array(
							'value' => 'right',
							'label' => esc_html__( 'Right', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'Set the menu items text align.', 'studiare-plus' ),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => false,
						),
					),
				),
				'items_gap'           => array(
					'id'          => 'items_gap',
					'title'       => esc_html__( 'Items gap', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu', 'studiare-plus' ),
					'value'       => 's',
					'options'     => array(
						's' => array(
							'value' => 's',
							'label' => esc_html__( 'Small', 'studiare-plus' ),
						),
						'm' => array(
							'value' => 'm',
							'label' => esc_html__( 'Medium', 'studiare-plus' ),
						),
						'l' => array(
							'value' => 'l',
							'label' => esc_html__( 'Large', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'Set the items gap.', 'studiare-plus' ),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => false,
						),
					),
				),
				'icon_width'          => array(
					'id'          => 'icon_width',
					'title'       => esc_html__( 'Width', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_icon_width.mp4" autoplay loop muted></video>',
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Items icon', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => '',
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}} > .wd-nav > li > a .wd-nav-img, .wd-fs-menu .wd-nav-fs > li > a .wd-nav-img' => array(
							'--nav-img-width: {{VALUE}}px;',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_height'         => array(
					'id'          => 'icon_height',
					'title'       => esc_html__( 'Height', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_icon_height.mp4" autoplay loop muted></video>',
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Items icon', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => '',
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}} > .wd-nav > li > a .wd-nav-img, .wd-fs-menu .wd-nav-fs > li > a .wd-nav-img' => array(
							'--nav-img-height: {{VALUE}}px;',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_overlay'          => array(
					'id'          => 'bg_overlay',
					'title'       => esc_html__( 'Background overlay', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_bg_overlay.mp4" autoplay loop muted></video>',
					'description' => __( 'Highlight dropdowns by darkening the background behind.', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'value'       => false,
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => false,
						),
					),
				),
				'inline'              => array(
					'id'          => 'inline',
					'title'       => esc_html__( 'Display inline', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'value'       => false,
					'description' => esc_html__( 'The width of the element will depend on its content', 'studiare-plus' ),
					'requires'    => array(
						'full_screen' => array(
							'comparison' => 'equal',
							'value'      => false,
						),
					),
				),
			),
		);
	}
}
