<?php

namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 *  Infobox element
 * ------------------------------------------------------------------------------------------------
 */
class Infobox extends Element {

	public function __construct() {
		parent::__construct();
		$this->template_name = 'info-box';
	}

	public function map() {
		$secondary_font = woodmart_get_opt( 'secondary-font' );
		$text_font      = woodmart_get_opt( 'text-font' );
		$primary_font   = woodmart_get_opt( 'primary-font' );

		$secondary_font_title = isset( $secondary_font[0]['font-family'] ) ? esc_html__( 'Secondary font', 'studiare-plus' ) . ' (' . $secondary_font[0]['font-family'] . ')' : esc_html__( 'Secondary font', 'studiare-plus' );
		$text_font_title      = isset( $text_font[0]['font-family'] ) ? esc_html__( 'Text font', 'studiare-plus' ) . ' (' . $text_font[0]['font-family'] . ')' : esc_html__( 'Text', 'studiare-plus' );
		$primary_font_title   = isset( $primary_font[0]['font-family'] ) ? esc_html__( 'Title font', 'studiare-plus' ) . ' (' . $primary_font[0]['font-family'] . ')' : esc_html__( 'Title font', 'studiare-plus' );

		$this->args = array(
			'type'            => 'infobox',
			'title'           => esc_html__( 'Information box', 'studiare-plus' ),
			'text'            => esc_html__( 'Text with icon', 'studiare-plus' ),
			'icon'            => 'xts-i-alert-info',
			'editable'        => true,
			'container'       => false,
			'edit_on_create'  => true,
			'drag_target_for' => array(),
			'drag_source'     => 'content_element',
			'removable'       => true,
			'addable'         => true,
			'params'          => array(
				'icon_type'                   => array(
					'id'          => 'icon_type',
					'title'       => esc_html__( 'Icon type', 'studiare-plus' ),
					'tab'         => esc_html__( 'Content', 'studiare-plus' ),
					'description' => esc_html__( 'You can display icon based on image or just write some text like 01., 02., M, X etc.', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'icon',
					'options'     => array(
						'icon' => array(
							'label' => esc_html__( 'Icon', 'studiare-plus' ),
							'value' => 'icon',
						),
						'text' => array(
							'label' => esc_html__( 'Text', 'studiare-plus' ),
							'value' => 'text',
						),
					),
				),
				'icon_text'                   => array(
					'id'       => 'icon_text',
					'title'    => esc_html__( 'Icon text', 'studiare-plus' ),
					'type'     => 'text',
					'tab'      => esc_html__( 'Content', 'studiare-plus' ),
					'group'    => esc_html__( 'Icon', 'studiare-plus' ),
					'value'    => '',
					'requires' => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'text',
						),
					),
				),
				'image'                       => array(
					'id'          => 'image',
					'title'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Content', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'value'       => '',
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'icon',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'img_size'                    => array(
					'id'          => 'img_size',
					'title'       => esc_html__( 'Image size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Content', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'value'       => '',
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'icon',
						),
					),
					'extra_class' => 'xts-col-6',
				),

				'subtitle'                    => array(
					'id'    => 'subtitle',
					'title' => esc_html__( 'Subtitle text', 'studiare-plus' ),
					'type'  => 'textarea',
					'tab'   => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'value' => '',
				),
				'title'                       => array(
					'id'    => 'title',
					'title' => esc_html__( 'Title text', 'studiare-plus' ),
					'type'  => 'textarea',
					'tab'   => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'value' => '',
				),
				'content'                     => array(
					'id'    => 'content',
					'title' => esc_html__( 'Content', 'studiare-plus' ),
					'type'  => 'editor',
					'tab'   => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'value' => '',
				),
				'btn_text'                    => array(
					'id'    => 'btn_text',
					'title' => esc_html__( 'Button text', 'studiare-plus' ),
					'type'  => 'text',
					'tab'   => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'value' => '',
				),
				'link'                        => array(
					'id'    => 'link',
					'title' => esc_html__( 'Link', 'studiare-plus' ),
					'type'  => 'link',
					'tab'   => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'value' => '',
				),
				'el_class'                    => array(
					'id'          => 'el_class',
					'title'       => esc_html__( 'Additional CSS class', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Content', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'value'       => '',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),

				'style'                       => array(
					'id'      => 'style',
					'title'   => esc_html__( 'Box style', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'General', 'studiare-plus' ),
					'type'    => 'select',
					'value'   => 'base',
					'options' => array(
						'base'     => array(
							'label' => esc_html__( 'Base', 'studiare-plus' ),
							'value' => 'base',
						),
						'border'   => array(
							'label' => esc_html__( 'Bordered', 'studiare-plus' ),
							'value' => 'border',
						),
						'shadow'   => array(
							'label' => esc_html__( 'Shadow', 'studiare-plus' ),
							'value' => 'shadow',
						),
						'bg-hover' => array(
							'label' => esc_html__( 'Background on hover', 'studiare-plus' ),
							'value' => 'bg-hover',
						),
					),
				),
				'woodmart_color_scheme'       => array(
					'id'          => 'woodmart_color_scheme',
					'title'       => esc_html__( 'Color scheme', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'General', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => '',
					'options'     => array(
						''      => array(
							'label' => esc_html__( 'Inherit', 'studiare-plus' ),
							'value' => '',
						),
						'light' => array(
							'label' => esc_html__( 'Light', 'studiare-plus' ),
							'value' => 'light',
						),
						'dark'  => array(
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
							'value' => 'dark',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'woodmart_hover_color_scheme' => array(
					'id'          => 'woodmart_hover_color_scheme',
					'title'       => esc_html__( 'Color scheme on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'General', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'light',
					'options'     => array(
						'light' => array(
							'label' => esc_html__( 'Light', 'studiare-plus' ),
							'value' => 'light',
						),
						'dark'  => array(
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
							'value' => 'dark',
						),
					),
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'alignment'                   => array(
					'id'      => 'alignment',
					'title'   => esc_html__( 'Text alignment', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'General', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'left',
					'options' => array(
						'left'   => array(
							'label' => esc_html__( 'Left', 'studiare-plus' ),
							'value' => 'left',
						),
						'center' => array(
							'label' => esc_html__( 'Center', 'studiare-plus' ),
							'value' => 'center',
						),
						'right'  => array(
							'label' => esc_html__( 'Right', 'studiare-plus' ),
							'value' => 'right',
						),
					),
				),
				'bg_color'                    => array(
					'id'        => 'bg_color',
					'title'     => esc_html__( 'Background color', 'studiare-plus' ),
					'tab'       => esc_html__( 'Style', 'studiare-plus' ),
					'group'     => esc_html__( 'Background', 'studiare-plus' ),
					'type'      => 'color',
					'value'     => '',
					'selectors' => array(
						'{{WRAPPER}} .wd-info-box' => array(
							'background-color: {{VALUE}};',
						),
					),
				),
				'bg_image_box'                => array(
					'id'          => 'bg_image_box',
					'title'       => esc_html__( 'Background image', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'bg_image_box_size'           => array(
					'id'          => 'bg_image_box_size',
					'title'       => esc_html__( 'Background image size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'description' => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'bg_image_box_position'       => array(
					'id'          => 'bg_image_box_position',
					'title'       => esc_html__( 'Background position', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''              => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'center center' => array(
							'label' => esc_html__( 'Center Center', 'studiare-plus' ),
							'value' => 'center center',
						),
						'center left'   => array(
							'label' => esc_html__( 'Center Left', 'studiare-plus' ),
							'value' => 'center left',
						),
						'center right'  => array(
							'label' => esc_html__( 'Center Right', 'studiare-plus' ),
							'value' => 'center right',
						),
						'top center'    => array(
							'label' => esc_html__( 'Top Center', 'studiare-plus' ),
							'value' => 'top center',
						),
						'top left'      => array(
							'label' => esc_html__( 'Top Left', 'studiare-plus' ),
							'value' => 'top left',
						),
						'top right'     => array(
							'label' => esc_html__( 'Top Right', 'studiare-plus' ),
							'value' => 'top right',
						),
						'bottom center' => array(
							'label' => esc_html__( 'Bottom Center', 'studiare-plus' ),
							'value' => 'bottom center',
						),
						'bottom left'   => array(
							'label' => esc_html__( 'Bottom Left', 'studiare-plus' ),
							'value' => 'bottom left',
						),
						'bottom right'  => array(
							'label' => esc_html__( 'Bottom Right', 'studiare-plus' ),
							'value' => 'bottom right',
						),
					),
					'extra_class' => 'xts-col-6',
					'requires'    => array(
						'bg_image_box' => array(
							'comparison' => 'not_equal',
							'value'      => '',
						),
					),
				),
				'bg_image_box_repeat'         => array(
					'id'          => 'bg_image_box_repeat',
					'title'       => esc_html__( 'Background repeat', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''          => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'no-repeat' => array(
							'label' => esc_html__( 'No-repeat', 'studiare-plus' ),
							'value' => 'no-repeat',
						),
						'repeat'    => array(
							'label' => esc_html__( 'Repeat', 'studiare-plus' ),
							'value' => 'repeat',
						),
						'repeat-x'  => array(
							'label' => esc_html__( 'Repeat-x', 'studiare-plus' ),
							'value' => 'repeat-x',
						),
						'repeat-y'  => array(
							'label' => esc_html__( 'Repeat-x', 'studiare-plus' ),
							'value' => 'repeat-y',
						),
					),
					'requires'    => array(
						'bg_image_box' => array(
							'comparison' => 'not_equal',
							'value'      => '',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_image_box_sizes'          => array(
					'id'          => 'bg_image_box_sizes',
					'title'       => esc_html__( 'Background size', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''        => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'cover'   => array(
							'label' => esc_html__( 'Cover', 'studiare-plus' ),
							'value' => 'cover',
						),
						'contain' => array(
							'label' => esc_html__( 'Contain', 'studiare-plus' ),
							'value' => 'contain',
						),
					),
					'requires'    => array(
						'bg_image_box' => array(
							'comparison' => 'not_equal',
							'value'      => '',
						),
					),
					'extra_class' => 'xts-col-6',
				),

				'bg_hover_color'              => array(
					'id'        => 'bg_hover_color',
					'title'     => esc_html__( 'Background color on hover', 'studiare-plus' ),
					'tab'       => esc_html__( 'Style', 'studiare-plus' ),
					'group'     => esc_html__( 'Background', 'studiare-plus' ),
					'type'      => 'color',
					'value'     => '',
					'selectors' => array(
						'{{WRAPPER}} .wd-info-box:after' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'  => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
				),
				'bg_hover_image'              => array(
					'id'          => 'bg_hover_image',
					'title'       => esc_html__( 'Background image  on hover', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'value'       => '',
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_hover_image_size'         => array(
					'id'          => 'bg_hover_image_size',
					'title'       => esc_html__( 'Background image on hover size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'description' => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'value'       => '',
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_hover_image_position'     => array(
					'id'          => 'bg_hover_image_position',
					'title'       => esc_html__( 'Background position', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''              => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'center center' => array(
							'label' => esc_html__( 'Center Center', 'studiare-plus' ),
							'value' => 'center center',
						),
						'center left'   => array(
							'label' => esc_html__( 'Center Left', 'studiare-plus' ),
							'value' => 'center left',
						),
						'center right'  => array(
							'label' => esc_html__( 'Center Right', 'studiare-plus' ),
							'value' => 'center right',
						),
						'top center'    => array(
							'label' => esc_html__( 'Top Center', 'studiare-plus' ),
							'value' => 'top center',
						),
						'top left'      => array(
							'label' => esc_html__( 'Top Left', 'studiare-plus' ),
							'value' => 'top left',
						),
						'top right'     => array(
							'label' => esc_html__( 'Top Right', 'studiare-plus' ),
							'value' => 'top right',
						),
						'bottom center' => array(
							'label' => esc_html__( 'Bottom Center', 'studiare-plus' ),
							'value' => 'bottom center',
						),
						'bottom left'   => array(
							'label' => esc_html__( 'Bottom Left', 'studiare-plus' ),
							'value' => 'bottom left',
						),
						'bottom right'  => array(
							'label' => esc_html__( 'Bottom Right', 'studiare-plus' ),
							'value' => 'bottom right',
						),
					),
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_hover_image_repeat'       => array(
					'id'          => 'bg_hover_image_repeat',
					'title'       => esc_html__( 'Background repeat', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''          => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'no-repeat' => array(
							'label' => esc_html__( 'No-repeat', 'studiare-plus' ),
							'value' => 'no-repeat',
						),
						'repeat'    => array(
							'label' => esc_html__( 'Repeat', 'studiare-plus' ),
							'value' => 'repeat',
						),
						'repeat-x'  => array(
							'label' => esc_html__( 'Repeat-x', 'studiare-plus' ),
							'value' => 'repeat-x',
						),
						'repeat-y'  => array(
							'label' => esc_html__( 'Repeat-x', 'studiare-plus' ),
							'value' => 'repeat-y',
						),
					),
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'bg_hover_image_sizes'        => array(
					'id'          => 'bg_hover_image_sizes',
					'title'       => esc_html__( 'Background size', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Background', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''        => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'cover'   => array(
							'label' => esc_html__( 'Cover', 'studiare-plus' ),
							'value' => 'cover',
						),
						'contain' => array(
							'label' => esc_html__( 'Contain', 'studiare-plus' ),
							'value' => 'contain',
						),
					),
					'requires'    => array(
						'style' => array(
							'comparison' => 'equal',
							'value'      => 'bg-hover',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'image_alignment'             => array(
					'id'          => 'image_alignment',
					'title'       => esc_html__( 'Alignment', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'top',
					'options'     => array(
						'left'  => array(
							'label' => esc_html__( 'Left', 'studiare-plus' ),
							'value' => 'left',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/left.png',
						),
						'top'   => array(
							'label' => esc_html__( 'Top', 'studiare-plus' ),
							'value' => 'top',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/top.png',
						),
						'right' => array(
							'label' => esc_html__( 'Right', 'studiare-plus' ),
							'value' => 'right',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/right.png',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'image_vertical_alignment'    => array(
					'id'          => 'image_vertical_alignment',
					'title'       => esc_html__( 'Vertical alignment', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'top',
					'options'     => array(
						'top'    => array(
							'label' => esc_html__( 'Top', 'studiare-plus' ),
							'value' => 'top',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/top.png',
						),
						'middle' => array(
							'label' => esc_html__( 'Middle', 'studiare-plus' ),
							'value' => 'middle',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/middle.png',
						),
						'bottom' => array(
							'label' => esc_html__( 'Bottom', 'studiare-plus' ),
							'value' => 'bottom',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/bottom.png',
						),
					),
					'requires'    => array(
						'image_alignment' => array(
							'comparison' => 'equal',
							'value'      => array( 'left', 'right' ),
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_style'                  => array(
					'id'      => 'icon_style',
					'title'   => esc_html__( 'Style', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Icon', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'simple',
					'options' => array(
						'simple'      => array(
							'label' => esc_html__( 'Simple', 'studiare-plus' ),
							'value' => 'simple',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/simple.png',
						),
						'with-bg'     => array(
							'label' => esc_html__( 'With background', 'studiare-plus' ),
							'value' => 'with-bg',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/with-bg.png',
						),
						'with-border' => array(
							'label' => esc_html__( 'With border', 'studiare-plus' ),
							'value' => 'with-border',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/with-border.png',
						),
					),
				),
				'icon_bg_color'               => array(
					'id'          => 'icon_bg_color',
					'title'       => esc_html__( 'Background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-icon' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'icon_style' => array(
							'comparison' => 'equal',
							'value'      => 'with-bg',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_bg_hover_color'         => array(
					'id'          => 'icon_bg_hover_color',
					'title'       => esc_html__( 'Background color on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-icon:hover' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'icon_style' => array(
							'comparison' => 'equal',
							'value'      => 'with-bg',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_border_color'           => array(
					'id'          => 'icon_border_color',
					'title'       => esc_html__( 'Border color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-icon' => array(
							'border-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'icon_style' => array(
							'comparison' => 'equal',
							'value'      => 'with-border',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_border_hover_color'     => array(
					'id'          => 'icon_border_hover_color',
					'title'       => esc_html__( 'Border color on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-icon:hover' => array(
							'border-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'icon_style' => array(
							'comparison' => 'equal',
							'value'      => 'with-border',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_text_size'              => array(
					'id'          => 'icon_text_size',
					'title'       => esc_html__( 'Text size', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'default',
					'options'     => array(
						'default' => array(
							'label' => esc_html__( 'Default (52px)', 'studiare-plus' ),
							'value' => 'default',
						),
						'small'   => array(
							'label' => esc_html__( 'Small (38px)', 'studiare-plus' ),
							'value' => 'small',
						),
						'large'   => array(
							'label' => esc_html__( 'Large (74px)', 'studiare-plus' ),
							'value' => 'large',
						),
					),
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'text',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_text_color'             => array(
					'id'          => 'icon_text_color',
					'title'       => esc_html__( 'Text color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Icon', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .box-with-text' => array(
							'color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'text',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_spacing'                => array(
					'id'        => 'icon_spacing',
					'title'     => esc_html__( 'Spacing', 'studiare-plus' ),
					'type'      => 'slider',
					'tab'       => esc_html__( 'Style', 'studiare-plus' ),
					'group'     => esc_html__( 'Icon', 'studiare-plus' ),
					'from'      => 5,
					'to'        => 50,
					'value'     => 10,
					'units'     => 'px',
					'selectors' => array(
						'{{WRAPPER}}.info-box-wrapper div.wd-info-box' => array(
							'--ib-icon-sp: {{VALUE}}px;',
						),
					),
				),

				'subtitle_style'              => array(
					'id'          => 'subtitle_style',
					'title'       => esc_html__( 'Style', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'default',
					'options'     => array(
						'default'    => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/default.png',
						),
						'background' => array(
							'label' => esc_html__( 'Background', 'studiare-plus' ),
							'value' => 'background',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/background.png',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_custom_bg_color'    => array(
					'id'          => 'subtitle_custom_bg_color',
					'title'       => esc_html__( 'Background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-subtitle' => array(
							'background-color: {{VALUE}};',
						),
					),
					'requires'    => array(
						'subtitle_style' => array(
							'comparison' => 'equal',
							'value'      => 'background',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_style_divider'      => array(
					'id'    => 'subtitle_style_divider',
					'type'  => 'divider',
					'tab'   => esc_html__( 'Style', 'studiare-plus' ),
					'group' => esc_html__( 'Subtitle', 'studiare-plus' ),
					'value' => '',
				),
				'subtitle_color'              => array(
					'id'          => 'subtitle_color',
					'title'       => esc_html__( 'Predefined color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'default',
					'options'     => array(
						'default' => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
						),
						'primary' => array(
							'label' => esc_html__( 'Primary', 'studiare-plus' ),
							'value' => 'primary',
						),
						'alt'     => array(
							'label' => esc_html__( 'Alternative', 'studiare-plus' ),
							'value' => 'alt',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_custom_color'       => array(
					'id'          => 'subtitle_custom_color',
					'title'       => esc_html__( 'Custom color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-subtitle' => array(
							'color: {{VALUE}};',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_font'               => array(
					'id'          => 'subtitle_font',
					'title'       => esc_html__( 'Font family', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''        => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'text'    => array(
							'label' => $text_font_title,
							'value' => 'text',
						),
						'primary' => array(
							'label' => $primary_font_title,
							'value' => 'primary',
						),
						'alt'     => array(
							'label' => $secondary_font_title,
							'value' => 'alt',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_font_weight'        => array(
					'id'          => 'subtitle_font_weight',
					'title'       => esc_html__( 'Font weight', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''  => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						100 => array(
							'label' => esc_html__( 'Ultra-Light 100', 'studiare-plus' ),
							'value' => 100,
						),
						200 => array(
							'label' => esc_html__( 'Light 200', 'studiare-plus' ),
							'value' => 200,
						),
						300 => array(
							'label' => esc_html__( 'Book 300', 'studiare-plus' ),
							'value' => 300,
						),
						400 => array(
							'label' => esc_html__( 'Normal 400', 'studiare-plus' ),
							'value' => 400,
						),
						500 => array(
							'label' => esc_html__( 'Medium 500', 'studiare-plus' ),
							'value' => 500,
						),
						600 => array(
							'label' => esc_html__( 'Semi-Bold 600', 'studiare-plus' ),
							'value' => 600,
						),
						700 => array(
							'label' => esc_html__( 'Bold 700', 'studiare-plus' ),
							'value' => 700,
						),
						800 => array(
							'label' => esc_html__( 'Extra-Bold 800', 'studiare-plus' ),
							'value' => 800,
						),
						900 => array(
							'label' => esc_html__( 'Ultra-Bold 900', 'studiare-plus' ),
							'value' => 900,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .info-box-subtitle' => array(
							'font-weight: {{VALUE}};',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'subtitle_font_size'          => array(
					'id'          => 'subtitle_font_size',
					'title'       => esc_html__( 'Font size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .info-box-subtitle' => array(
							'font-size: {{VALUE}};',
						),
					),
					'description' => esc_html__( 'Insert value including units. For example: "14px" or "1.5em".', 'studiare-plus' ),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'subtitle_line_height'        => array(
					'id'          => 'subtitle_line_height',
					'title'       => esc_html__( 'Line height', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Subtitle', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .wd-info-box .info-box-content .info-box-subtitle' => array(
							'line-height: {{VALUE}};',
						),
					),
					'value'       => '',
					'description' => esc_html__( 'Insert default or reletive value. For example: "14px" or "1.2".', 'studiare-plus' ),
					'extra_class' => 'xts-col-6',
				),

				'title_style'                 => array(
					'id'          => 'title_style',
					'title'       => esc_html__( 'Style', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'default',
					'options'     => array(
						'default'    => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/title-style/default.png',
						),
						'underlined' => array(
							'label' => esc_html__( 'Underline', 'studiare-plus' ),
							'value' => 'underlined',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/infobox/title-style/underlined.png',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'title_color'                 => array(
					'id'          => 'title_color',
					'title'       => esc_html__( 'Color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'color',
					'value'       => '',
					'selectors'   => array(
						'{{WRAPPER}} .info-box-title' => array(
							'color: {{VALUE}};',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'title_font'                  => array(
					'id'          => 'title_font',
					'title'       => esc_html__( 'Font family', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''        => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						'text'    => array(
							'label' => $text_font_title,
							'value' => 'text',
						),
						'primary' => array(
							'label' => $primary_font_title,
							'value' => 'primary',
						),
						'alt'     => array(
							'label' => $secondary_font_title,
							'value' => 'alt',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'title_font_weight'           => array(
					'id'          => 'title_font_weight',
					'title'       => esc_html__( 'Font weight', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => '',
					'options'     => array(
						''  => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => '',
						),
						100 => array(
							'label' => esc_html__( 'Ultra-Light 100', 'studiare-plus' ),
							'value' => 100,
						),
						200 => array(
							'label' => esc_html__( 'Light 200', 'studiare-plus' ),
							'value' => 200,
						),
						300 => array(
							'label' => esc_html__( 'Book 300', 'studiare-plus' ),
							'value' => 300,
						),
						400 => array(
							'label' => esc_html__( 'Normal 400', 'studiare-plus' ),
							'value' => 400,
						),
						500 => array(
							'label' => esc_html__( 'Medium 500', 'studiare-plus' ),
							'value' => 500,
						),
						600 => array(
							'label' => esc_html__( 'Semi-Bold 600', 'studiare-plus' ),
							'value' => 600,
						),
						700 => array(
							'label' => esc_html__( 'Bold 700', 'studiare-plus' ),
							'value' => 700,
						),
						800 => array(
							'label' => esc_html__( 'Extra-Bold 800', 'studiare-plus' ),
							'value' => 800,
						),
						900 => array(
							'label' => esc_html__( 'Ultra-Bold 900', 'studiare-plus' ),
							'value' => 900,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .info-box-title' => array(
							'font-weight: {{VALUE}};',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'title_size'                  => array(
					'id'          => 'title_size',
					'title'       => esc_html__( 'Predefined font size', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'default',
					'options'     => array(
						'default'     => array(
							'label' => esc_html__( 'Default (18px)', 'studiare-plus' ),
							'value' => 'default',
						),
						'small'       => array(
							'label' => esc_html__( 'Small (16px)', 'studiare-plus' ),
							'value' => 'small',
						),
						'large'       => array(
							'label' => esc_html__( 'Large (26px)', 'studiare-plus' ),
							'value' => 'primary',
						),
						'extra-large' => array(
							'label' => esc_html__( 'Extra Large (36px)', 'studiare-plus' ),
							'value' => 'extra-large',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'title_font_size'             => array(
					'id'          => 'title_font_size',
					'title'       => esc_html__( 'Font size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .wd-info-box .info-box-title' => array(
							'font-size: {{VALUE}};',
						),
					),
					'value'       => '',
					'description' => esc_html__( 'Insert value including units. For example: "14px" or "1.5em".', 'studiare-plus' ),
					'extra_class' => 'xts-col-6',
				),
				'title_line_height'           => array(
					'id'          => 'title_line_height',
					'title'       => esc_html__( 'Line height', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .wd-info-box .info-box-content .info-box-title' => array(
							'line-height: {{VALUE}};',
						),
					),
					'value'       => '',
					'extra_class' => 'xts-col-6',
					'description' => esc_html__( 'Insert default or reletive value. For example: "14px" or "1.2".', 'studiare-plus' ),
				),
				'title_tag'                   => array(
					'id'          => 'title_tag',
					'title'       => esc_html__( 'Tag', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Title', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'h4',
					'options'     => array(
						'h1'   => array(
							'label' => 'h1',
							'value' => 'h1',
						),
						'h2'   => array(
							'label' => 'h2',
							'value' => 'h2',
						),
						'h3'   => array(
							'label' => 'h3',
							'value' => 'h3',
						),
						'h4'   => array(
							'label' => 'h4',
							'value' => 'h4',
						),
						'h5'   => array(
							'label' => 'h5',
							'value' => 'h5',
						),
						'h6'   => array(
							'label' => 'h6',
							'value' => 'h6',
						),
						'p'    => array(
							'label' => 'p',
							'value' => 'p',
						),
						'div'  => array(
							'label' => 'div',
							'value' => 'div',
						),
						'span' => array(
							'label' => 'span',
							'value' => 'span',
						),
					),
					'extra_class' => 'xts-col-6',
				),

				'custom_text_color'           => array(
					'id'        => 'custom_text_color',
					'title'     => esc_html__( 'Text Color', 'studiare-plus' ),
					'tab'       => esc_html__( 'Style', 'studiare-plus' ),
					'group'     => esc_html__( 'Content', 'studiare-plus' ),
					'type'      => 'color',
					'value'     => '',
					'selectors' => array(
						'{{WRAPPER}} .info-box-content .info-box-inner' => array(
							'color: {{VALUE}};',
						),
					),
				),
				'content_font_size'           => array(
					'id'          => 'content_font_size',
					'title'       => esc_html__( 'Font size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Content', 'studiare-plus' ),
					'description' => esc_html__( 'Insert value including units. For example: "14px" or "1.5em".', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .info-box-content .info-box-inner' => array(
							'font-size: {{VALUE}};',
						),
					),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'content_line_height'         => array(
					'id'          => 'content_line_height',
					'title'       => esc_html__( 'Line height', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Content', 'studiare-plus' ),
					'description' => esc_html__( 'Insert default or reletive value. For example: "14px" or "1.2".', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}} .info-box-content .info-box-inner' => array(
							'line-height: {{VALUE}};',
						),
					),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),

				'btn_style'                   => array(
					'id'      => 'btn_style',
					'title'   => esc_html__( 'Style', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Button', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'default',
					'options' => array(
						'default'  => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/default.png',
						),
						'bordered' => array(
							'label' => esc_html__( 'Bordered', 'studiare-plus' ),
							'value' => 'bordered',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/bordered.png',
						),
						'link'     => array(
							'label' => esc_html__( 'Link button', 'studiare-plus' ),
							'value' => 'link',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/link.png',
						),
						'3d'       => array(
							'label' => esc_html__( '3D', 'studiare-plus' ),
							'value' => '3d',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/3d.png',
						),
					),
				),

				'btn_shape'                   => array(
					'id'       => 'btn_shape',
					'title'    => esc_html__( 'Shape', 'studiare-plus' ),
					'tab'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'    => esc_html__( 'Button', 'studiare-plus' ),
					'type'     => 'selector',
					'value'    => 'rectangle',
					'options'  => array(
						'rectangle'  => array(
							'label' => esc_html__( 'Rectangle', 'studiare-plus' ),
							'value' => 'rectangle',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/rectangle.jpeg',
						),
						'round'      => array(
							'label' => esc_html__( 'Round', 'studiare-plus' ),
							'value' => 'round',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/circle.jpeg',
						),
						'semi-round' => array(
							'label' => esc_html__( 'Rounded', 'studiare-plus' ),
							'value' => 'semi-round',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/round.jpeg',
						),
					),
					'requires' => array(
						'btn_style' => array(
							'comparison' => 'not_equal',
							'value'      => 'link',
						),
					),
				),
				'btn_size'                    => array(
					'id'          => 'btn_size',
					'title'       => esc_html__( 'Predefined size', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Button', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'default',
					'options'     => array(
						'default'     => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
						),
						'extra-small' => array(
							'label' => esc_html__( 'Extra Small', 'studiare-plus' ),
							'value' => 'extra-small',
						),
						'small'       => array(
							'label' => esc_html__( 'Small', 'studiare-plus' ),
							'value' => 'small',
						),
						'large'       => array(
							'label' => esc_html__( 'Large', 'studiare-plus' ),
							'value' => 'large',
						),
						'extra-large' => array(
							'label' => esc_html__( 'Extra Large', 'studiare-plus' ),
							'value' => 'extra-large',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'btn_color'                   => array(
					'id'          => 'btn_color',
					'title'       => esc_html__( 'Predefined color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Button', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'default',
					'options'     => array(
						'default' => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
						),
						'primary' => array(
							'label' => esc_html__( 'Primary color', 'studiare-plus' ),
							'value' => 'primary',
						),
						'alt'     => array(
							'label' => esc_html__( 'Alternative color', 'studiare-plus' ),
							'value' => 'alt',
						),
						'white'   => array(
							'label' => esc_html__( 'White', 'studiare-plus' ),
							'value' => 'white',
						),
						'black'   => array(
							'label' => esc_html__( 'Black', 'studiare-plus' ),
							'value' => 'black',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'btn_position'                => array(
					'id'      => 'btn_position',
					'title'   => esc_html__( 'Button position', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Button', 'studiare-plus' ),
					'type'    => 'select',
					'value'   => 'hover',
					'options' => array(
						'hover'  => array(
							'label' => esc_html__( 'Show on hover', 'studiare-plus' ),
							'value' => 'hover',
						),
						'static' => array(
							'label' => esc_html__( 'Static', 'studiare-plus' ),
							'value' => 'static',
						),
					),
				),
			),
		);
	}
}
