<?php

namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 *  Get categories dropdown vertical menu
 * ------------------------------------------------------------------------------------------------
 */
class Categories extends Element {

	public function __construct() {
		parent::__construct();

		$this->template_name = 'categories';
	}

	public function map() {
		$this->args = array(
			'type'            => 'categories',
			'title'           => esc_html__( 'Categories', 'studiare-plus' ),
			'text'            => esc_html__( 'Categories dropdown', 'studiare-plus' ),
			'icon'            => 'xts-i-dropdown',
			'editable'        => true,
			'container'       => false,
			'edit_on_create'  => true,
			'drag_target_for' => array(),
			'drag_source'     => 'content_element',
			'removable'       => true,
			'addable'         => true,
			'desktop'         => true,
			'params'          => array(
				'menu_id'               => array(
					'id'          => 'menu_id',
					'title'       => esc_html__( 'Choose menu', 'studiare-plus' ),
					'type'        => 'select',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu', 'studiare-plus' ),
					'value'       => '',
					'callback'    => 'get_menu_options_with_empty',
					'description' => esc_html__( 'Choose which menu to display in the header as a categories dropdown.', 'studiare-plus' ),
				),
				'categories_title'      => array(
					'id'          => 'categories_title',
					'title'       => esc_html__( 'Menu title', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu', 'studiare-plus' ),
					'value'       => '',
					'description' => esc_html__( 'Specify your custom title for this menu dropdown or leave it empty to keep "Browse categories".', 'studiare-plus' ),
				),
				'more_cat_button'       => array(
					'id'          => 'more_cat_button',
					'title'       => esc_html__( 'Limit categories', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_categories_more_cat_button.mp4" autoplay loop muted></video>',
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Dropdown', 'studiare-plus' ),
					'value'       => false,
					'description' => __( 'Display a certain number of categories and "show more" button.', 'studiare-plus' ),
				),
				'more_cat_button_count' => array(
					'id'          => 'more_cat_button_count',
					'title'       => esc_html__( 'Number of categories', 'studiare-plus' ),
					'description' => esc_html__( 'Specify the number of categories to be shown initially', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Dropdown', 'studiare-plus' ),
					'from'        => 1,
					'to'          => 100,
					'value'       => 5,
					'units'       => '',
					'requires'    => array(
						'more_cat_button' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
				),
				'mouse_event'           => array(
					'id'      => 'mouse_event',
					'title'   => esc_html__( 'Open on mouse event', 'studiare-plus' ),
					'type'    => 'selector',
					'tab'     => esc_html__( 'General', 'studiare-plus' ),
					'group'   => esc_html__( 'Dropdown', 'studiare-plus' ),
					'value'   => 'hover',
					'options' => array(
						'hover' => array(
							'value' => 'hover',
							'label' => esc_html__( 'Hover', 'studiare-plus' ),
						),
						'click' => array(
							'value' => 'click',
							'label' => esc_html__( 'Click', 'studiare-plus' ),
						),
					),
				),
				'open_dropdown'         => array(
					'id'          => 'open_dropdown',
					'title'       => esc_html__( 'Open menu item dropdown', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_categories_open_dropdown.mp4" autoplay loop muted></video>',
					'description' => __( 'Submenu dropdown stays open after cursor leaves the parent menu item. Stops working if "Open categories menu" options is enabled on a page.', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Dropdown', 'studiare-plus' ),
					'value'       => false,
				),
				'design'                => array(
					'id'      => 'design',
					'title'   => esc_html__( 'Dropdown design', 'studiare-plus' ),
					'type'    => 'selector',
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Dropdown', 'studiare-plus' ),
					'value'   => 'default',
					'options' => array(
						'default' => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'hint'  => '<img src="' . WOODMART_TOOLTIP_URL . 'hb_categories_design_default.jpg" alt="">',
							'value' => 'default',
						),
						'with-bg' => array(
							'label' => esc_html__( 'With background', 'studiare-plus' ),
							'hint'  => '<img src="' . WOODMART_TOOLTIP_URL . 'hb_categories_design_with_bg.jpg" alt="">',
							'value' => 'with-bg',
						),
					),
				),
				'bg_overlay'            => array(
					'id'          => 'bg_overlay',
					'title'       => esc_html__( 'Background overlay', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_categories_bg_overlay.mp4" autoplay loop muted></video>',
					'description' => __( 'Highlight dropdowns by darkening the background behind.', 'studiare-plus' ),
					'type'        => 'switcher',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Dropdown', 'studiare-plus' ),
					'value'       => false,
				),
				'color_scheme'          => array(
					'id'          => 'color_scheme',
					'title'       => esc_html__( 'Text color scheme', 'studiare-plus' ),
					'type'        => 'selector',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu title', 'studiare-plus' ),
					'value'       => 'light',
					'options'     => array(
						'dark'  => array(
							'value' => 'dark',
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
						),
						'light' => array(
							'value' => 'light',
							'label' => esc_html__( 'Light', 'studiare-plus' ),
						),
					),
					'description' => esc_html__( 'Select different text color scheme depending on your header background.', 'studiare-plus' ),
				),
				'background'            => array(
					'id'          => 'background',
					'type'        => 'bg',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu title', 'studiare-plus' ),
					'value'       => '',
					'description' => '',
				),
				'border'                => array(
					'id'              => 'border',
					'type'            => 'border',
					'sides'           => array( 'bottom', 'top', 'left', 'right' ),
					'tab'             => esc_html__( 'Style', 'studiare-plus' ),
					'group'           => esc_html__( 'Menu title', 'studiare-plus' ),
					'colorpicker_top' => true,
					'container'       => false,
					'value'           => '',
					'description'     => esc_html__( 'Border settings for menu title.', 'studiare-plus' ),
				),
				'icon_type'             => array(
					'id'      => 'icon_type',
					'title'   => esc_html__( 'Icon type', 'studiare-plus' ),
					'type'    => 'selector',
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Menu title', 'studiare-plus' ),
					'value'   => 'default',
					'options' => array(
						'default' => array(
							'value' => 'default',
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/default-icons/burger-default.jpg',
						),
						'custom'  => array(
							'value' => 'custom',
							'label' => esc_html__( 'Custom', 'studiare-plus' ),
							'image' => WOODMART_ASSETS_IMAGES . '/header-builder/upload.jpg',
						),
					),
				),
				'custom_icon'           => array(
					'id'          => 'custom_icon',
					'title'       => esc_html__( 'Upload an image', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu title', 'studiare-plus' ),
					'value'       => '',
					'description' => '',
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'custom_icon_width'     => array(
					'id'          => 'custom_icon_width',
					'title'       => esc_html__( 'Icon width', 'studiare-plus' ),
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Menu title', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => 0,
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}}' => array(
							'--wd-tools-icon-width: {{VALUE}}px;',
						),
					),
					'requires'    => array(
						'icon_type' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_width'            => array(
					'id'          => 'icon_width',
					'title'       => esc_html__( 'Width', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_icon_width.mp4" autoplay loop muted></video>',
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Items icon', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => '',
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}} .wd-dropdown-cats > .wd-nav > li > a .wd-nav-img' => array(
							'--nav-img-width: {{VALUE}}px;',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_height'           => array(
					'id'          => 'icon_height',
					'title'       => esc_html__( 'Height', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_icon_height.mp4" autoplay loop muted></video>',
					'type'        => 'slider',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Items icon', 'studiare-plus' ),
					'from'        => 0,
					'to'          => 60,
					'value'       => '',
					'units'       => 'px',
					'selectors'   => array(
						'{{WRAPPER}} .wd-dropdown-cats > .wd-nav > li > a .wd-nav-img' => array(
							'--nav-img-height: {{VALUE}}px;',
						),
					),
					'extra_class' => 'xts-col-6',
				),
			),
		);
	}
}
