<?php

namespace XTS\Modules\Header_Builder\Elements;

use XTS\Modules\Header_Builder\Element;

/**
 * ------------------------------------------------------------------------------------------------
 *  Button element
 * ------------------------------------------------------------------------------------------------
 */
class Button extends Element {

	public function __construct() {
		parent::__construct();

		$this->template_name = 'button';
	}

	public function map() {
		$this->args = array(
			'type'            => 'button',
			'title'           => esc_html__( 'Button', 'studiare-plus' ),
			'text'            => esc_html__( 'Button with link', 'studiare-plus' ),
			'icon'            => 'xts-i-button',
			'editable'        => true,
			'container'       => false,
			'edit_on_create'  => true,
			'drag_target_for' => array(),
			'drag_source'     => 'content_element',
			'removable'       => true,
			'addable'         => true,
			'params'          => array(
				'title'                       => array(
					'id'    => 'title',
					'title' => esc_html__( 'Title', 'studiare-plus' ),
					'tab'   => esc_html__( 'General', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'type'  => 'text',
					'value' => '',
				),
				'link'                        => array(
					'id'    => 'link',
					'title' => esc_html__( 'Link', 'studiare-plus' ),
					'tab'   => esc_html__( 'General', 'studiare-plus' ),
					'group' => esc_html__( 'Content', 'studiare-plus' ),
					'type'  => 'link',
					'value' => array( 'url' => '' ),
				),
				'button_smooth_scroll'        => array(
					'id'          => 'button_smooth_scroll',
					'title'       => esc_html__( 'Smooth scroll', 'studiare-plus' ),
					'hint'        => '<video src="' . WOODMART_TOOLTIP_URL . 'hb_button_smooth_scroll.mp4" autoplay loop muted></video>',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'type'        => 'switcher',
					'value'       => false,
					'description' => esc_html__( 'When you turn on this option you need to specify this button link with a hash symbol. For example #section-id Then you need to have a section with an ID of "section-id" and this button click will smoothly scroll the page to that section.', 'studiare-plus' ),
				),
				'button_smooth_scroll_time'   => array(
					'id'          => 'button_smooth_scroll_time',
					'title'       => esc_html__( 'Smooth scroll time (ms)', 'studiare-plus' ),
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'button_smooth_scroll' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'button_smooth_scroll_offset' => array(
					'id'          => 'button_smooth_scroll_offset',
					'title'       => esc_html__( 'Smooth scroll offset (px)', 'studiare-plus' ),
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'button_smooth_scroll' => array(
							'comparison' => 'equal',
							'value'      => true,
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'el_class'                    => array(
					'id'          => 'el_class',
					'title'       => esc_html__( 'Additional CSS class', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'General', 'studiare-plus' ),
					'group'       => esc_html__( 'Extra', 'studiare-plus' ),
					'value'       => '',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				'style'                       => array(
					'id'      => 'style',
					'title'   => esc_html__( 'Button style', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'General', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'default',
					'options' => array(
						'default'  => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/default.png',
						),
						'bordered' => array(
							'label' => esc_html__( 'Bordered', 'studiare-plus' ),
							'value' => 'bordered',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/bordered.png',
						),
						'link'     => array(
							'label' => esc_html__( 'Link button', 'studiare-plus' ),
							'value' => 'link',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/link.png',
						),
						'3d'       => array(
							'label' => esc_html__( '3D', 'studiare-plus' ),
							'value' => '3d',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/3d.png',
						),
					),
				),
				'shape'                       => array(
					'id'       => 'shape',
					'title'    => esc_html__( 'Button shape', 'studiare-plus' ),
					'tab'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'    => esc_html__( 'General', 'studiare-plus' ),
					'type'     => 'selector',
					'value'    => 'rectangle',
					'options'  => array(
						'rectangle'  => array(
							'label' => esc_html__( 'Rectangle', 'studiare-plus' ),
							'value' => 'rectangle',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/rectangle.jpeg',
						),
						'round'      => array(
							'label' => esc_html__( 'Circle', 'studiare-plus' ),
							'value' => 'round',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/circle.jpeg',
						),
						'semi-round' => array(
							'label' => esc_html__( 'Round', 'studiare-plus' ),
							'value' => 'semi-round',
							'image' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/round.jpeg',
						),
					),
					'requires' => array(
						'style' => array(
							'comparison' => 'not_equal',
							'value'      => array( 'round', 'link' ),
						),
					),
				),
				'size'                        => array(
					'id'      => 'size',
					'title'   => esc_html__( 'Button size', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'General', 'studiare-plus' ),
					'type'    => 'select',
					'value'   => 'default',
					'options' => array(
						'default'     => array(
							'label' => esc_html__( 'Default', 'studiare-plus' ),
							'value' => 'default',
						),
						'extra-small' => array(
							'label' => esc_html__( 'Extra Small', 'studiare-plus' ),
							'value' => 'extra-small',
						),
						'small'       => array(
							'label' => esc_html__( 'Small', 'studiare-plus' ),
							'value' => 'small',
						),
						'large'       => array(
							'label' => esc_html__( 'Large', 'studiare-plus' ),
							'value' => 'large',
						),
						'extra-large' => array(
							'label' => esc_html__( 'Extra Large', 'studiare-plus' ),
							'value' => 'extra-large',
						),
					),
				),
				'color'                       => array(
					'id'      => 'color',
					'title'   => esc_html__( 'Predefined button color', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Colors', 'studiare-plus' ),
					'type'    => 'select',
					'value'   => 'default',
					'options' => array(
						'default' => array(
							'label' => esc_html__( 'None', 'studiare-plus' ),
							'value' => 'default',
						),
						'primary' => array(
							'label' => esc_html__( 'Primary color', 'studiare-plus' ),
							'value' => 'primary',
						),
						'alt'     => array(
							'label' => esc_html__( 'Alternative color', 'studiare-plus' ),
							'value' => 'alt',
						),
						'white'   => array(
							'label' => esc_html__( 'White', 'studiare-plus' ),
							'value' => 'white',
						),
						'black'   => array(
							'label' => esc_html__( 'Black', 'studiare-plus' ),
							'value' => 'black',
						),
					),
				),
				'bg_color'                    => array(
					'id'          => 'bg_color',
					'title'       => esc_html__( 'Background color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'type'        => 'color',
					'selectors'   => array(
						'{{WRAPPER}} a:is(.btn-style-default, .btn-style-3d)' => array(
							'background-color: {{VALUE}};',
						),
						'{{WRAPPER}} a:is(.btn-style-bordered, .btn-style-link)' => array(
							'border-color: {{VALUE}};',
						),
					),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'bg_color_hover'              => array(
					'id'          => 'bg_color_hover',
					'title'       => esc_html__( 'Background color on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'type'        => 'color',
					'selectors'   => array(
						'{{WRAPPER}} a:is(.btn-style-bordered, .btn-style-default, .btn-style-3d):hover' => array(
							'background-color: {{VALUE}};',
						),
						'{{WRAPPER}} a:is(.btn-style-bordered, .btn-style-link):hover' => array(
							'border-color: {{VALUE}};',
						),
					),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'color_scheme'                => array(
					'id'          => 'color_scheme',
					'title'       => esc_html__( 'Text color scheme', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'light',
					'options'     => array(
						'light'  => array(
							'label' => esc_html__( 'Light', 'studiare-plus' ),
							'value' => 'light',
						),
						'dark'   => array(
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
							'value' => 'dark',
						),
						'custom' => array(
							'label' => esc_html__( 'Custom', 'studiare-plus' ),
							'value' => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'custom_color_scheme'         => array(
					'id'          => 'custom_color_scheme',
					'title'       => esc_html__( 'Custom text color', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}}.wd-button-wrapper a' => array(
							'color: {{VALUE}};',
						),
					),
					'type'        => 'color',
					'value'       => '',
					'requires'    => array(
						'color_scheme' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'color_scheme_divider'        => array(
					'id'    => 'color_scheme_divider',
					'type'  => 'divider',
					'tab'   => esc_html__( 'Style', 'studiare-plus' ),
					'group' => esc_html__( 'Colors', 'studiare-plus' ),
					'value' => '',
				),
				'color_scheme_hover'          => array(
					'id'          => 'color_scheme_hover',
					'title'       => esc_html__( 'Text color scheme on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'type'        => 'selector',
					'value'       => 'light',
					'options'     => array(
						'light'  => array(
							'label' => esc_html__( 'Light', 'studiare-plus' ),
							'value' => 'light',
						),
						'dark'   => array(
							'label' => esc_html__( 'Dark', 'studiare-plus' ),
							'value' => 'dark',
						),
						'custom' => array(
							'label' => esc_html__( 'Custom', 'studiare-plus' ),
							'value' => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'custom_color_scheme_hover'   => array(
					'id'          => 'custom_color_scheme_hover',
					'title'       => esc_html__( 'Custom text color on hover', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Colors', 'studiare-plus' ),
					'selectors'   => array(
						'{{WRAPPER}}.wd-button-wrapper a:hover' => array(
							'color: {{VALUE}};',
						),
					),
					'type'        => 'color',
					'value'       => '',
					'requires'    => array(
						'color_scheme_hover' => array(
							'comparison' => 'equal',
							'value'      => 'custom',
						),
					),
					'extra_class' => 'xts-col-6',
				),
				'icon_library'                => array(
					'id'          => 'icon_library',
					'title'       => esc_html__( 'Icon library', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'select',
					'value'       => 'fontawesome',
					'options'     => array(
						'fontawesome' => array(
							'label' => esc_html__( 'Font Awesome', 'studiare-plus' ),
							'value' => 'fontawesome',
						),
						'openiconic'  => array(
							'label' => esc_html__( 'Open Iconic', 'studiare-plus' ),
							'value' => 'openiconic',
						),
						'typicons'    => array(
							'label' => esc_html__( 'Typicons', 'studiare-plus' ),
							'value' => 'typicons',
						),
						'entypo'      => array(
							'label' => esc_html__( 'Entypo', 'studiare-plus' ),
							'value' => 'entypo',
						),
						'linecons'    => array(
							'label' => esc_html__( 'Linecons', 'studiare-plus' ),
							'value' => 'linecons',
						),
						'monosocial'  => array(
							'label' => esc_html__( 'Mono Social', 'studiare-plus' ),
							'value' => 'monosocial',
						),
						'material'    => array(
							'label' => esc_html__( 'Material', 'studiare-plus' ),
							'value' => 'material',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_fontawesome'            => array(
					'id'          => 'icon_fontawesome',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "fas fa-check".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'fontawesome',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_openiconic'             => array(
					'id'          => 'icon_openiconic',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "oi oi-check".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'openiconic',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_typicons'               => array(
					'id'          => 'icon_typicons',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "typcn typcn-input-checked".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'typicons',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_entypo'                 => array(
					'id'          => 'icon_entypo',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "entypo-icon entypo-icon-check".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'entypo',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_linecons'               => array(
					'id'          => 'icon_linecons',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "vc_li vc_li-star".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'linecons',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_monosocial'             => array(
					'id'          => 'icon_monosocial',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "vc-mono vc-mono-addme".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'monosocial',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'icon_material'               => array(
					'id'          => 'icon_material',
					'title'       => esc_html__( 'Icon', 'studiare-plus' ),
					'description' => esc_html__( 'Enter the class name of the icon. For example "vc-material vc-material-check".', 'studiare-plus' ),
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'text',
					'value'       => '',
					'requires'    => array(
						'icon_library' => array(
							'comparison' => 'equal',
							'value'      => 'material',
						),
					),
					'extra_class' => 'xts-hidden',
				),
				'image'                       => array(
					'id'          => 'image',
					'title'       => esc_html__( 'Image', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'type'        => 'image',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'value'       => '',
					'extra_class' => 'xts-col-6',
				),
				'img_size'                    => array(
					'id'          => 'img_size',
					'title'       => esc_html__( 'Image size', 'studiare-plus' ),
					'type'        => 'text',
					'tab'         => esc_html__( 'Style', 'studiare-plus' ),
					'group'       => esc_html__( 'Image', 'studiare-plus' ),
					'value'       => '',
					'description' => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'extra_class' => 'xts-col-6',
				),
				'icon_position'               => array(
					'id'      => 'icon_position',
					'title'   => esc_html__( 'Button image position', 'studiare-plus' ),
					'tab'     => esc_html__( 'Style', 'studiare-plus' ),
					'group'   => esc_html__( 'Image', 'studiare-plus' ),
					'type'    => 'selector',
					'value'   => 'left',
					'options' => array(
						'left'  => array(
							'label' => esc_html__( 'Left', 'studiare-plus' ),
							'value' => 'left',
						),
						'right' => array(
							'label' => esc_html__( 'Right', 'studiare-plus' ),
							'value' => 'right',
						),
					),
				),
			),
		);
	}
}
