<?php
/**
 * Popup metaboxes.
 *
 * @package studiare plus
 */

namespace XTS\Modules\Floating_Blocks\Integrations;

use XTS\Admin\Modules\Options\Metaboxes;
use XTS\Singleton;


/**
 * Popup metaboxes.
 */
class Popup_Metaboxes extends Singleton {
	/**
	 * Init.
	 */
	public function init() {
		add_action( 'init', array( $this, 'add_metaboxes' ), 20 );
	}

	/**
	 * Add popup metaboxes.
	 */
	public function add_metaboxes() {
		$metabox = Metaboxes::add_metabox(
			array(
				'id'           => 'wd_popup_metaboxes',
				'title'        => esc_html__( 'Settings', 'studiare-plus' ),
				'post_types'   => array( 'wd_popup' ),
				'css_selector' => '#popup-{{ID}}',
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'settings',
				'name'     => esc_html__( 'Popup', 'studiare-plus' ),
				'icon'     => 'xts-i-popup',
				'priority' => 10,
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'overlay',
				'name'     => esc_html__( 'Overlay', 'studiare-plus' ),
				'icon'     => 'xts-i-layout',
				'priority' => 20,
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'close_behavior',
				'name'     => esc_html__( 'Close behavior', 'studiare-plus' ),
				'icon'     => 'xts-i-close',
				'priority' => 30,
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'triggers',
				'name'     => esc_html__( 'Triggers', 'studiare-plus' ),
				'icon'     => 'xts-i-cog',
				'priority' => 40,
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'conditions',
				'name'     => esc_html__( 'Conditions', 'studiare-plus' ),
				'icon'     => 'xts-i-edit-write',
				'priority' => 50,
			)
		);

		$metabox->add_section(
			array(
				'id'       => 'advanced',
				'name'     => esc_html__( 'Advanced', 'studiare-plus' ),
				'icon'     => 'xts-i-setting-slider-in-square',
				'priority' => 60,
			)
		);

		// Popup section.

		// Layout group.

		$metabox->add_field(
			array(
				'id'            => 'width',
				'name'          => esc_html__( 'Width', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-width.mp4" autoplay loop muted></video>',
				'type'          => 'responsive_range',
				'group'         => esc_html__( 'Layout', 'studiare-plus' ),
				'section'       => 'settings',
				'selectors'     => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-popup-width: {{VALUE}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'value' => '',
						'unit'  => 'px',
					),
					'tablet'  => array(
						'value' => '',
						'unit'  => 'px',
					),
					'mobile'  => array(
						'value' => '',
						'unit'  => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => 0,
						'max'  => 2000,
						'step' => 1,
					),
					'vw' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'class'         => 'xts-col-6',
				'priority'      => 10,
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'height',
				'name'          => esc_html__( 'Height', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-height.mp4" autoplay loop muted></video>',
				'type'          => 'responsive_range',
				'group'         => esc_html__( 'Layout', 'studiare-plus' ),
				'section'       => 'settings',
				'selectors'     => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-popup-height: {{VALUE}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'value' => '',
						'unit'  => 'px',
					),
					'tablet'  => array(
						'value' => '',
						'unit'  => 'px',
					),
					'mobile'  => array(
						'value' => '',
						'unit'  => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => 0,
						'max'  => 2000,
						'step' => 1,
					),
					'vh' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'class'         => 'xts-col-6',
				'priority'      => 20,
			)
		);

		$metabox->add_field(
			array(
				'id'        => 'content_vertical_align',
				'name'      => esc_html__( 'Content vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-content-vertical-align.mp4" autoplay loop muted></video>',
				'type'      => 'buttons',
				'default'   => 'start',
				'group'     => esc_html__( 'Layout', 'studiare-plus' ),
				'section'   => 'settings',
				'selectors' => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'options'   => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'     => array(
					'id'       => 'content_settings_tabs',
					'tab'      => esc_html__( 'Desktop', 'studiare-plus' ),
					'title'    => esc_html__( 'Content position', 'studiare-plus' ),
					'icon'     => 'xts-i-desktop',
					'style'    => 'devices',
					'requires' => array(
						array(
							'key'     => 'height_type',
							'compare' => 'not_equals',
							'value'   => 'content',
						),
					),
				),
				'requires'  => array(
					array(
						'key'     => 'height_type',
						'compare' => 'not_equals',
						'value'   => 'content',
					),
				),
				'priority'  => 30,
				'class'     => 'xts-tab-field',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'content_vertical_align_tablet',
				'name'       => esc_html__( 'Content vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-content-vertical-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'css_device' => 'tablet',
				'options'    => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'content_settings_tabs',
					'tab'  => esc_html__( 'Tablet', 'studiare-plus' ),
					'icon' => 'xts-i-tablet',
				),
				'requires'   => array(
					array(
						'key'     => 'height_type',
						'compare' => 'not_equals',
						'value'   => 'content',
					),
				),
				'priority'   => 31,
				'class'      => 'xts-tab-field',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'content_vertical_align_mobile',
				'name'       => esc_html__( 'Content vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-content-vertical-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'css_device' => 'mobile',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'options'    => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'content_settings_tabs',
					'tab'  => esc_html__( 'Mobile', 'studiare-plus' ),
					'icon' => 'xts-i-phone',
				),
				'requires'   => array(
					array(
						'key'     => 'height_type',
						'compare' => 'not_equals',
						'value'   => 'content',
					),
				),
				'priority'   => 32,
				'class'      => 'xts-tab-field',
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'padding',
				'name'          => esc_html__( 'Padding', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-padding.mp4" autoplay loop muted></video>',
				'description'   => esc_html__( 'Sets the spacing between the popup’s borders and its content.', 'studiare-plus' ),
				'type'          => 'dimensions',
				'group'         => esc_html__( 'Layout', 'studiare-plus' ),
				'dimensions'    => array(
					'top'    => esc_html__( 'Top', 'studiare-plus' ),
					'right'  => esc_html__( 'Right', 'studiare-plus' ),
					'bottom' => esc_html__( 'Bottom', 'studiare-plus' ),
					'left'   => esc_html__( 'Left', 'studiare-plus' ),
				),
				'section'       => 'settings',
				'selectors'     => array(
					'{{WRAPPER}}.wd-popup .wd-popup-inner' => array(
						'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'unit' => 'px',
					),
					'tablet'  => array(
						'unit' => 'px',
					),
					'mobile'  => array(
						'unit' => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => 0,
						'step' => 1,
					),
					'%'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'class'         => 'xts-col-6',
				'priority'      => 40,
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'margin',
				'name'          => esc_html__( 'Margin', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-margin.mp4" autoplay loop muted></video>',
				'description'   => esc_html__( 'Sets the spacing between the popup and the edge of the screen.', 'studiare-plus' ),
				'type'          => 'dimensions',
				'group'         => esc_html__( 'Layout', 'studiare-plus' ),
				'dimensions'    => array(
					'top'    => esc_html__( 'Top', 'studiare-plus' ),
					'right'  => esc_html__( 'Right', 'studiare-plus' ),
					'bottom' => esc_html__( 'Bottom', 'studiare-plus' ),
					'left'   => esc_html__( 'Left', 'studiare-plus' ),
				),
				'section'       => 'settings',
				'selectors'     => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-popup-mt: {{TOP}}{{UNIT}};',
						'--wd-popup-mr: {{RIGHT}}{{UNIT}};',
						'--wd-popup-mb: {{BOTTOM}}{{UNIT}};',
						'--wd-popup-ml: {{LEFT}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'unit' => 'px',
					),
					'tablet'  => array(
						'unit' => 'px',
					),
					'mobile'  => array(
						'unit' => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'step' => 1,
					),
					'%'  => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
				),
				'class'         => 'xts-col-6',
				'priority'      => 50,
			)
		);

		$metabox->add_field(
			array(
				'id'        => 'vertical_align',
				'name'      => esc_html__( 'Vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-vertical-align.mp4" autoplay loop muted></video>',
				'type'      => 'buttons',
				'default'   => 'center',
				'group'     => esc_html__( 'Layout', 'studiare-plus' ),
				'section'   => 'settings',
				'selectors' => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'options'   => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'     => array(
					'id'    => 'vertical_align_tabs',
					'tab'   => esc_html__( 'Desktop', 'studiare-plus' ),
					'title' => esc_html__( 'Content position', 'studiare-plus' ),
					'icon'  => 'xts-i-desktop',
					'style' => 'devices',
					'class' => 'xts-col-6',
				),
				'priority'  => 60,
				'class'     => 'xts-tab-field xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'vertical_align_tablet',
				'name'       => esc_html__( 'Vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-vertical-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'css_device' => 'tablet',
				'options'    => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'vertical_align_tabs',
					'tab'  => esc_html__( 'Tablet', 'studiare-plus' ),
					'icon' => 'xts-i-tablet',
				),
				'priority'   => 61,
				'class'      => 'xts-tab-field xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'vertical_align_mobile',
				'name'       => esc_html__( 'Vertical align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-vertical-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'css_device' => 'mobile',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-align-items: {{VALUE}};',
					),
				),
				'options'    => array(
					'start'  => array(
						'name'  => esc_html__( 'Top', 'studiare-plus' ),
						'value' => 'start',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/top.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Middle', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/middle.svg',
					),
					'end'    => array(
						'name'  => esc_html__( 'Bottom', 'studiare-plus' ),
						'value' => 'end',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/bottom.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'vertical_align_tabs',
					'tab'  => esc_html__( 'Mobile', 'studiare-plus' ),
					'icon' => 'xts-i-phone',
				),
				'priority'   => 62,
				'class'      => 'xts-tab-field xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'        => 'horizontal_align',
				'name'      => esc_html__( 'Horizontal align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-horizontal-align.mp4" autoplay loop muted></video>',
				'group'     => esc_html__( 'Layout', 'studiare-plus' ),
				'section'   => 'settings',
				'type'      => 'buttons',
				'default'   => 'center',
				'selectors' => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-justify-content: {{VALUE}};',
					),
				),
				'options'   => array(
					'left'   => array(
						'name'  => esc_html__( 'Left', 'studiare-plus' ),
						'value' => 'left',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/left.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Center', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/center.svg',
					),
					'right'  => array(
						'name'  => esc_html__( 'Right', 'studiare-plus' ),
						'value' => 'right',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/right.svg',
					),
				),
				't_tab'     => array(
					'id'    => 'horizontal_align_tabs',
					'tab'   => esc_html__( 'Desktop', 'studiare-plus' ),
					'icon'  => 'xts-i-desktop',
					'style' => 'devices',
					'class' => 'xts-col-6',
				),
				'priority'  => 70,
				'class'     => 'xts-tab-field xts-last-tab-field xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'horizontal_align_tablet',
				'name'       => esc_html__( 'Horizontal align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-horizontal-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'css_device' => 'tablet',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-justify-content: {{VALUE}};',
					),
				),
				'options'    => array(
					'left'   => array(
						'name'  => esc_html__( 'Left', 'studiare-plus' ),
						'value' => 'left',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/left.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Center', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/center.svg',
					),
					'right'  => array(
						'name'  => esc_html__( 'Right', 'studiare-plus' ),
						'value' => 'right',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/right.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'horizontal_align_tabs',
					'tab'  => esc_html__( 'Tablet', 'studiare-plus' ),
					'icon' => 'xts-i-tablet',
				),
				'priority'   => 71,
				'class'      => 'xts-tab-field xts-last-tab-field xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'horizontal_align_mobile',
				'name'       => esc_html__( 'Horizontal align', 'studiare-plus' ),
				'hint'      => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-horizontal-align.mp4" autoplay loop muted></video>',
				'group'      => esc_html__( 'Layout', 'studiare-plus' ),
				'section'    => 'settings',
				'type'       => 'buttons',
				'css_device' => 'mobile',
				'selectors'  => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-justify-content: {{VALUE}};',
					),
				),
				'options'    => array(
					'left'   => array(
						'name'  => esc_html__( 'Left', 'studiare-plus' ),
						'value' => 'left',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/left.svg',
					),
					'center' => array(
						'name'  => esc_html__( 'Center', 'studiare-plus' ),
						'value' => 'center',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/center.svg',
					),
					'right'  => array(
						'name'  => esc_html__( 'Right', 'studiare-plus' ),
						'value' => 'right',
						'image' => WOODMART_ASSETS_IMAGES . '/settings/cmb2-align/right.svg',
					),
				),
				't_tab'      => array(
					'id'   => 'horizontal_align_tabs',
					'tab'  => esc_html__( 'Mobile', 'studiare-plus' ),
					'icon' => 'xts-i-phone',
				),
				'priority'   => 72,
				'class'      => 'xts-tab-field xts-last-tab-field xts-col-12',
			)
		);

		// Style group.

		$metabox->add_field(
			array(
				'id'           => 'animation',
				'name'         => esc_html__( 'Animation', 'studiare-plus' ),
				'group'        => esc_html__( 'Style', 'studiare-plus' ),
				'type'         => 'select',
				'section'      => 'settings',
				'description'  => esc_html__( 'Select a popup appearance animation.', 'studiare-plus' ),
				'options'      => array(
					'default'                => array(
						'name'  => esc_html__( 'From left to right', 'studiare-plus' ),
						'value' => 'default',
					),
					'slide-from-top'         => array(
						'name'  => esc_html__( 'Slide from top', 'studiare-plus' ),
						'value' => 'slide-from-right',
					),
					'slide-from-bottom'      => array(
						'name'  => esc_html__( 'Slide from bottom', 'studiare-plus' ),
						'value' => 'slide-from-right',
					),
					'slide-from-left'        => array(
						'name'  => esc_html__( 'Slide from left', 'studiare-plus' ),
						'value' => 'slide-from-left',
					),
					'slide-from-right'       => array(
						'name'  => esc_html__( 'Slide from right', 'studiare-plus' ),
						'value' => 'slide-from-right',
					),
					'slide-short-from-left'  => array(
						'name'  => esc_html__( 'Slide short from left', 'studiare-plus' ),
						'value' => 'slide-short-from-left',
					),
					'slide-short-from-right' => array(
						'name'  => esc_html__( 'Slide short from right', 'studiare-plus' ),
						'value' => 'slide-short-from-right',
					),
					'top-flip-x'             => array(
						'name'  => esc_html__( 'Top flip X', 'studiare-plus' ),
						'value' => 'top-flip-x',
					),
					'bottom-flip-x'          => array(
						'name'  => esc_html__( 'Bottom flip X', 'studiare-plus' ),
						'value' => 'bottom-flip-x',
					),
					'right-flip-y'           => array(
						'name'  => esc_html__( 'Right flip Y', 'studiare-plus' ),
						'value' => 'right-flip-y',
					),
					'left-flip-y'            => array(
						'name'  => esc_html__( 'Left flip Y', 'studiare-plus' ),
						'value' => 'left-flip-y',
					),
					'snap-in-top'            => array(
						'name'  => esc_html__( 'Snap in top', 'studiare-plus' ),
						'value' => 'snap-in-top',
					),
					'snap-in-bottom'         => array(
						'name'  => esc_html__( 'Snap in bottom', 'studiare-plus' ),
						'value' => 'snap-in-bottom',
					),
					'snap-in-left'           => array(
						'name'  => esc_html__( 'Snap in left', 'studiare-plus' ),
						'value' => 'snap-in-left',
					),
					'snap-in-right'          => array(
						'name'  => esc_html__( 'Snap in right', 'studiare-plus' ),
						'value' => 'snap-in-right',
					),
					'zoom-in'                => array(
						'name'  => esc_html__( 'Zoom in', 'studiare-plus' ),
						'value' => 'zoom-in',
					),
				),
				'value'        => '',
				'is_animation' => true,
				'default'      => 'default',
				'priority'     => 80,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'background',
				'name'        => esc_html__( 'Background', 'studiare-plus' ),
				'description' => esc_html__( 'Set background color or image for popup.', 'studiare-plus' ),
				'type'        => 'background',
				'section'     => 'settings',
				'group'       => esc_html__( 'Style', 'studiare-plus' ),
				'selector'    => '.mfp-wrap {{WRAPPER}}',
				't_tab'       => array(
					'id'    => 'background_tabs',
					'tab'   => esc_html__( 'Desktop', 'studiare-plus' ),
					'icon'  => 'xts-i-desktop',
					'style' => 'devices',
				),
				'priority'    => 90,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'background_tablet',
				'name'        => esc_html__( 'Background', 'studiare-plus' ),
				'description' => esc_html__( 'Set background color or image for popup.', 'studiare-plus' ),
				'type'        => 'background',
				'section'     => 'settings',
				'group'       => esc_html__( 'Style', 'studiare-plus' ),
				'selector'    => '.mfp-wrap {{WRAPPER}}',
				'css_device'  => 'tablet',
				't_tab'       => array(
					'id'    => 'background_tabs',
					'tab'   => esc_html__( 'Tablet', 'studiare-plus' ),
					'icon'  => 'xts-i-tablet',
					'style' => 'devices',
				),
				'priority'    => 91,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'background_mobile',
				'name'        => esc_html__( 'Background', 'studiare-plus' ),
				'description' => esc_html__( 'Set background color or image for popup.', 'studiare-plus' ),
				'type'        => 'background',
				'section'     => 'settings',
				'group'       => esc_html__( 'Style', 'studiare-plus' ),
				'selector'    => '.mfp-wrap {{WRAPPER}}',
				'css_device'  => 'mobile',
				't_tab'       => array(
					'id'    => 'background_tabs',
					'tab'   => esc_html__( 'Mobile', 'studiare-plus' ),
					'icon'  => 'xts-i-phone',
					'style' => 'devices',
				),
				'priority'    => 92,
			)
		);

		$metabox->add_field(
			array(
				'id'           => 'box_shadow_group',
				'name'         => esc_html__( 'Box shadow', 'studiare-plus' ),
				'group'        => esc_html__( 'Style', 'studiare-plus' ),
				'type'         => 'group',
				'style'        => 'dropdown',
				'btn_settings' => array(
					'label'   => esc_html__( 'Edit settings', 'studiare-plus' ),
					'classes' => 'xts-i-cog',
				),
				'selectors'    => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
						'box-shadow:{{BOX_SHADOW_OFFSET_X}} {{BOX_SHADOW_OFFSET_Y}} {{BOX_SHADOW_BLUR}} {{BOX_SHADOW_SPREAD}} {{BOX_SHADOW_COLOR}};',
					),
				),
				'section'      => 'settings',
				'inner_fields' => array(
					array(
						'id'       => 'box_shadow_color',
						'name'     => esc_html__( 'Color', 'studiare-plus' ),
						'type'     => 'color',
						'default'  => array(),
						'priority' => 10,
					),
					array(
						'id'       => 'box_shadow_offset_x',
						'name'     => esc_html__( 'Horizontal offset', 'studiare-plus' ),
						'type'     => 'responsive_range',
						'devices'  => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'    => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'priority' => 20,
					),
					array(
						'id'       => 'box_shadow_offset_y',
						'name'     => esc_html__( 'Vertical offset', 'studiare-plus' ),
						'type'     => 'responsive_range',
						'devices'  => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'    => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'priority' => 30,
					),
					array(
						'id'       => 'box_shadow_blur',
						'name'     => esc_html__( 'Blur', 'studiare-plus' ),
						'type'     => 'responsive_range',
						'devices'  => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'    => array(
							'px' => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'priority' => 40,
					),
					array(
						'id'       => 'box_shadow_spread',
						'name'     => esc_html__( 'Spread', 'studiare-plus' ),
						'type'     => 'responsive_range',
						'devices'  => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'    => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'priority' => 50,
					),
				),
				'class'        => 'xts-col-6 xts-dropdown-open-top',
				'priority'     => 100,
			)
		);

		$metabox->add_field(
			array(
				'id'           => 'border_group',
				'name'         => esc_html__( 'Border', 'studiare-plus' ),
				'group'        => esc_html__( 'Style', 'studiare-plus' ),
				'type'         => 'group',
				'style'        => 'dropdown',
				'btn_settings' => array(
					'label'   => esc_html__( 'Edit settings', 'studiare-plus' ),
					'classes' => 'xts-i-cog',
				),
				'section'      => 'settings',
				'inner_fields' => array(
					array(
						'id'            => 'border_radius',
						'name'          => esc_html__( 'Border radius', 'studiare-plus' ),
						'type'          => 'responsive_range',
						'selectors'     => array(
							'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
								'border-radius: {{VALUE}}{{UNIT}};',
							),
						),
						'generate_zero' => true,
						'devices'       => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'         => array(
							'px' => array(
								'min'  => 0,
								'max'  => 300,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							),
						),
						'priority'      => 10,
					),
					array(
						'id'        => 'border_style',
						'name'      => esc_html__( 'Border style', 'studiare-plus' ),
						'type'      => 'select',
						'options'   => array(
							''       => array(
								'name'  => esc_html__( 'None', 'studiare-plus' ),
								'value' => '',
							),
							'solid'  => array(
								'name'  => esc_html__( 'Solid', 'studiare-plus' ),
								'value' => 'solid',
							),
							'dotted' => array(
								'name'  => esc_html__( 'Dotted', 'studiare-plus' ),
								'value' => 'dotted',
							),
							'double' => array(
								'name'  => esc_html__( 'Double', 'studiare-plus' ),
								'value' => 'double',
							),
							'dashed' => array(
								'name'  => esc_html__( 'Dashed', 'studiare-plus' ),
								'value' => 'dashed',
							),
							'groove' => array(
								'name'  => esc_html__( 'Groove', 'studiare-plus' ),
								'value' => 'groove',
							),
						),
						'selectors' => array(
							'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
								'border-style: {{VALUE}};',
							),
						),
						'default'   => '',
						'priority'  => 20,
					),
					array(
						'id'        => 'border_color',
						'name'      => esc_html__( 'Color', 'studiare-plus' ),
						'type'      => 'color',
						'selectors' => array(
							'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
								'border-color: {{VALUE}};',
							),
						),
						'default'   => array(),
						'requires'  => array(
							array(
								'key'     => 'border_style',
								'compare' => 'not_equals',
								'value'   => '',
							),
						),
						'priority'  => 30,
					),
					array(
						'id'        => 'border_width',
						'name'      => esc_html__( 'Border width', 'studiare-plus' ),
						'type'      => 'responsive_range',
						'devices'   => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'     => array(
							'px' => array(
								'min'  => 0,
								'max'  => 20,
								'step' => 1,
							),
						),
						'requires'  => array(
							array(
								'key'     => 'border_style',
								'compare' => 'not_equals',
								'value'   => '',
							),
						),
						'selectors' => array(
							'.wd-mfp-popup-wrap-{{ID}} .wd-popup' => array(
								'border-width: {{VALUE}}{{UNIT}};',
							),
						),
						'priority'  => 40,
					),
				),
				'class'        => 'xts-col-6 xts-dropdown-open-top',
				'priority'     => 110,
			)
		);

		// Overlay section.

		$metabox->add_field(
			array(
				'id'          => 'overlay_color',
				'name'        => esc_html__( 'Background color', 'studiare-plus' ),
				'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-overlay-background-color.mp4" autoplay loop muted></video>',
				'group'       => esc_html__( 'Settings', 'studiare-plus' ),
				'type'        => 'color',
				'section'     => 'overlay',
				'description' => esc_html__( 'Overlay color. Set transparency to make the site partially visible beneath the overlay.', 'studiare-plus' ),
				'selectors'   => array(
					'body .wd-mfp-popup-bg-{{ID}}' => array(
						'background-color: {{VALUE}};',
					),
				),
				'default'     => array(),
				'class'       => 'xts-col-6 xts-dropdown-open-top',
				'priority'    => 10,
			)
		);

		// Close behavior section.

		$metabox->add_field(
			array(
				'id'          => 'close_btn',
				'name'        => esc_html__( 'Close button', 'studiare-plus' ),
				'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-close-behavior-close-button-desktop.mp4" autoplay loop muted></video>',
				'group'       => esc_html__( 'Close button', 'studiare-plus' ),
				'description' => esc_html__( 'Disable the default close button. After that, the popup can be closed via the background overlay or a custom button using the “Close by selector” option.', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'close_behavior',
				'default'     => true,
				'priority'    => 10,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'close_btn_display',
				'name'        => esc_html__( 'Display', 'studiare-plus' ),
				'type'        => 'buttons',
				'section'     => 'close_behavior',
				'description' => esc_html__( 'Choose the close button design.', 'studiare-plus' ),
				'group'       => esc_html__( 'Close button', 'studiare-plus' ),
				'default'     => 'icon',
				'options'     => array(
					'icon' => array(
						'name'  => esc_html__( 'Icon', 'studiare-plus' ),
						'value' => 'icon',
					),
					'text' => array(
						'name'  => esc_html__( 'Icon with text', 'studiare-plus' ),
						'value' => 'text',
					),
				),
				'priority'    => 20,
				'class'       => 'xts-col-12',
			)
		);

		$metabox->add_field(
			array(
				'id'        => 'close_btn_text_color',
				'name'      => esc_html__( 'Color', 'studiare-plus' ),
				'type'      => 'color',
				'section'   => 'close_behavior',
				'group'     => esc_html__( 'Close button', 'studiare-plus' ),
				'selectors' => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup-close' => array(
						'--wd-action-color: {{VALUE}};',
					),
				),
				'default'   => array(),
				'priority'  => 30,
				'class'     => 'xts-col-6',
			)
		);

		$metabox->add_field(
			array(
				'id'        => 'close_btn_text_color_hover',
				'name'      => esc_html__( 'Hover color', 'studiare-plus' ),
				'type'      => 'color',
				'section'   => 'close_behavior',
				'group'     => esc_html__( 'Close button', 'studiare-plus' ),
				'selectors' => array(
					'.wd-mfp-popup-wrap-{{ID}} .wd-popup-close' => array(
						'--wd-action-color-hover: {{VALUE}};',
					),
				),
				'default'   => array(),
				'priority'  => 40,
				'class'     => 'xts-col-6',
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'close_btn_offset_v',
				'name'          => esc_html__( 'Offset vertical', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-close-behavior-offset-vertical.mp4" autoplay loop muted></video>',
				'group'         => esc_html__( 'Close button', 'studiare-plus' ),
				'type'          => 'responsive_range',
				'section'       => 'close_behavior',
				'selectors'     => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-close-btn-offset-v: {{VALUE}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'value' => '',
						'unit'  => 'px',
					),
					'tablet'  => array(
						'value' => '',
						'unit'  => 'px',
					),
					'mobile'  => array(
						'value' => '',
						'unit'  => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => -1000,
						'max'  => 1000,
						'step' => 1,
					),
				),
				'priority'      => 50,
				'class'         => 'xts-col-6',
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'close_btn_offset_h',
				'name'          => esc_html__( 'Offset horizontal', 'studiare-plus' ),
				'hint'          => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-close-behavior-offset-horizontal.mp4" autoplay loop muted></video>',
				'group'         => esc_html__( 'Close button', 'studiare-plus' ),
				'type'          => 'responsive_range',
				'section'       => 'close_behavior',
				'selectors'     => array(
					'.wd-mfp-popup-wrap-{{ID}}' => array(
						'--wd-close-btn-offset-h: {{VALUE}}{{UNIT}};',
					),
				),
				'generate_zero' => true,
				'devices'       => array(
					'desktop' => array(
						'value' => '',
						'unit'  => 'px',
					),
					'tablet'  => array(
						'value' => '',
						'unit'  => 'px',
					),
					'mobile'  => array(
						'value' => '',
						'unit'  => 'px',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => -1000,
						'max'  => 1000,
						'step' => 1,
					),
				),
				'priority'      => 60,
				'class'         => 'xts-col-6',
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'close_by_overlay',
				'name'        => esc_html__( 'Close by overlay', 'studiare-plus' ),
				'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text'    => esc_html__( 'No', 'studiare-plus' ),
				'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'popup-close-behavior-close-by-overlay.mp4" autoplay loop muted></video>',
				'group'       => esc_html__( 'Settings', 'studiare-plus' ),
				'description' => esc_html__( 'Close the popup when clicking on the background overlay.', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'close_behavior',
				'default'     => true,
				'priority'    => 70,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'close_by_esc',
				'name'        => esc_html__( 'Close by ESC key', 'studiare-plus' ),
				'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text'    => esc_html__( 'No', 'studiare-plus' ),
				'group'       => esc_html__( 'Settings', 'studiare-plus' ),
				'description' => esc_html__( 'Close the popup when pressing the Escape key.', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'close_behavior',
				'default'     => true,
				'priority'    => 80,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'close_by_selector',
				'name'        => esc_html__( 'Close by selector', 'studiare-plus' ),
				'group'       => esc_html__( 'Settings', 'studiare-plus' ),
				'description' => esc_html__( 'Create an alternative popup close button. Enter a CSS selector (e.g., .wd-close-popup) that will close the popup when clicked.', 'studiare-plus' ),
				'type'        => 'text_input',
				'section'     => 'close_behavior',
				'default'     => '',
				'priority'    => 90,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'persistent_close',
				'name'        => esc_html__( 'Persistent close', 'studiare-plus' ),
				'group'       => esc_html__( 'Settings', 'studiare-plus' ),
				'description' => esc_html__( 'Once closed, the popup will stay hidden on reload until the cookie is cleared.', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'close_behavior',
				'default'     => true,
				'priority'    => 100,
			)
		);

		// Conditions section.

		$metabox->add_field(
			array(
				'id'             => 'conditions',
				'group'          => esc_html__( 'Display condition', 'studiare-plus' ),
				'type'           => 'conditions',
				'section'        => 'conditions',
				'priority'       => 20,
				'inner_fields'   => array(
					'type'  => array(
						'name'    => esc_html__( 'Condition type', 'studiare-plus' ),
						'options' => apply_filters(
							'woodmart_conditions_types',
							array(
								'all'                  => esc_html__( 'All', 'studiare-plus' ),
								'post_type'            => esc_html__( 'Post types', 'studiare-plus' ),
								'single_post_type'     => esc_html__( 'Post type single page', 'studiare-plus' ),
								'post_id'              => esc_html__( 'Post ID', 'studiare-plus' ),
								'taxonomy'             => esc_html__( 'Taxonomy', 'studiare-plus' ),
								'term_id'              => esc_html__( 'Term ID', 'studiare-plus' ),
								'single_posts_term_id' => esc_html__( 'Single posts from term', 'studiare-plus' ),
								'user_role'            => esc_html__( 'User role', 'studiare-plus' ),
								'custom'               => esc_html__( 'Custom', 'studiare-plus' ),
							)
						),
					),
					'query' => array(
						'name'     => esc_html__( 'Condition query', 'studiare-plus' ),
						'options'  => array(),
						'requires' => array(
							array(
								'key'     => 'type',
								'compare' => 'not_equals',
								'value'   => 'all',
							),
						),
					),
				),
				'exclude_fields' => array(
					'product-type-query',
				),
			)
		);

		// Triggers section.

		$metabox->add_field(
			array(
				'id'          => 'is_some_time_enabled',
				'name'        => esc_html__( 'Page loaded', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup after some time (in milliseconds).', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => true,
				'priority'    => 10,
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'time_to_show',
				'name'       => esc_html__( 'Time to show', 'studiare-plus' ),
				'type'       => 'text_input',
				'section'    => 'triggers',
				'attributes' => array(
					'type' => 'number',
					'min'  => 0,
				),
				'requires'   => array(
					array(
						'key'     => 'is_some_time_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'class'      => 'xts-col-5',
				'default'    => 0,
				'priority'   => 11,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'time_to_show_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_some_time_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 12,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 13,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_after_scroll_enabled',
				'name'        => esc_html__( 'User scroll', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup after user scrolls a certain percentage of the page.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 20,
			)
		);

		$metabox->add_field(
			array(
				'id'            => 'scroll_value',
				'name'          => esc_html__( 'Scroll value', 'studiare-plus' ),
				'type'          => 'responsive_range',
				'generate_zero' => true,
				'section'       => 'triggers',
				'class'         => 'xts-col-5',
				'requires'      => array(
					array(
						'key'     => 'is_after_scroll_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'devices'       => array(
					'desktop' => array(
						'value' => '',
						'unit'  => '%',
					),
				),
				'range'         => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10000,
						'step' => 1,
					),
					'%'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'       => 50,
				'priority'      => 21,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'after_scroll_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_after_scroll_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 22,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 23,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_scroll_to_selector_enabled',
				'name'        => esc_html__( 'Scroll to selector', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup when user scrolls to a specific CSS selector.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 30,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'scroll_to_selector',
				'name'     => esc_html__( 'Selector', 'studiare-plus' ),
				'type'     => 'text_input',
				'description' => esc_html__( 'Comma-separated list of selectors. For example: .wrapper .special-button, .newsletter-icon', 'studiare-plus' ),
				'section'  => 'triggers',
				'class'    => 'xts-col-5',
				'requires' => array(
					array(
						'key'     => 'is_scroll_to_selector_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'  => '',
				'priority' => 31,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'scroll_to_selector_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_scroll_to_selector_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 32,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 33,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_inactivity_time_enabled',
				'name'        => esc_html__( 'Inactivity time', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup after inactivity time (in milliseconds).', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 40,
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'inactivity_time',
				'name'       => esc_html__( 'Time to show', 'studiare-plus' ),
				'type'       => 'text_input',
				'section'    => 'triggers',
				'class'      => 'xts-col-5',
				'attributes' => array(
					'type' => 'number',
					'min'  => 1,
				),
				'requires'   => array(
					array(
						'key'     => 'is_inactivity_time_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'    => 10000,
				'priority'   => 41,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'inactivity_time_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_inactivity_time_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 42,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 43,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_exit_intent_enabled',
				'name'        => esc_html__( 'Exit intent', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Popup appears when the cursor exits the viewport, suggesting tab closure.', 'studiare-plus' ),
				'class'       => 'xts-col-10',
				'default'     => false,
				'priority'    => 50,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'exit_intent_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_exit_intent_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 51,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 52,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_on_click_enabled',
				'name'        => esc_html__( 'On click', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Number of clicks required to show popup.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 60,
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'click_times',
				'name'       => esc_html__( 'Click times', 'studiare-plus' ),
				'type'       => 'text_input',
				'section'    => 'triggers',
				'attributes' => array(
					'type' => 'number',
					'min'  => 1,
				),
				'requires'   => array(
					array(
						'key'     => 'is_on_click_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'class'      => 'xts-col-5',
				'default'    => 3,
				'priority'   => 61,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'click_times_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_on_click_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 62,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 63,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_on_selector_click_enabled',
				'name'        => esc_html__( 'On selector click', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'CSS selector to trigger popup on click.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 70,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'selector',
				'name'     => esc_html__( 'Selector', 'studiare-plus' ),
				'type'     => 'text_input',
				'section'  => 'triggers',
				'description' => esc_html__( 'Comma-separated list of selectors. For example: .wrapper .special-button, .newsletter-icon', 'studiare-plus' ),
				'class'    => 'xts-col-5',
				'requires' => array(
					array(
						'key'     => 'is_on_selector_click_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'  => '',
				'priority' => 71,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'selector_click_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_on_selector_click_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 72,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 73,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_url_parameter_enabled',
				'name'        => esc_html__( 'URL contains specific parameter', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Name of the URL parameter to check.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 80,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'parameters',
				'name'        => esc_html__( 'Parameters', 'studiare-plus' ),
				'description' => esc_html__( 'Comma-separated list of parameters. For example: utm_source=facebook, single_key', 'studiare-plus' ),
				'type'        => 'text_input',
				'section'     => 'triggers',
				'class'       => 'xts-col-5',
				'requires'    => array(
					array(
						'key'     => 'is_url_parameter_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'     => '',
				'priority'    => 81,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'url_parameter_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_url_parameter_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 82,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 83,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_url_hashtag_enabled',
				'name'        => esc_html__( 'URL contains specific hashtag', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Name of the URL hashtag to check.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 90,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'hashtags',
				'name'        => esc_html__( 'Hashtags', 'studiare-plus' ),
				'description' => esc_html__( 'Comma-separated list of hashtags. For example: #hashtag1,#hashtag2', 'studiare-plus' ),
				'type'        => 'text_input',
				'section'     => 'triggers',
				'class'       => 'xts-col-5',
				'requires'    => array(
					array(
						'key'     => 'is_url_hashtag_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'     => '',
				'priority'    => 91,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'url_hashtag_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_url_hashtag_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 92,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 93,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_after_page_views_enabled',
				'name'        => esc_html__( 'After page views', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup after a specific number of page views.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 100,
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'after_page_views',
				'name'       => esc_html__( 'Views', 'studiare-plus' ),
				'type'       => 'text_input',
				'section'    => 'triggers',
				'class'      => 'xts-col-5',
				'attributes' => array(
					'type' => 'number',
					'min'  => 1,
				),
				'requires'   => array(
					array(
						'key'     => 'is_after_page_views_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority'   => 101,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'after_page_views_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_after_page_views_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 102,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'clear',
				'type'     => 'clear',
				'section'  => 'triggers',
				'priority' => 103,
			)
		);

		$metabox->add_field(
			array(
				'id'          => 'is_after_sessions_enabled',
				'name'        => esc_html__( 'After sessions', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'triggers',
				'description' => esc_html__( 'Show popup after a specific number of user sessions.', 'studiare-plus' ),
				'class'       => 'xts-col-5',
				'default'     => false,
				'priority'    => 110,
			)
		);

		$metabox->add_field(
			array(
				'id'         => 'after_sessions',
				'name'       => esc_html__( 'Sessions', 'studiare-plus' ),
				'type'       => 'text_input',
				'section'    => 'triggers',
				'class'      => 'xts-col-5',
				'attributes' => array(
					'type' => 'number',
					'min'  => 1,
				),
				'requires'   => array(
					array(
						'key'     => 'is_after_sessions_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority'   => 111,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'after_sessions_once',
				'name'     => esc_html__( 'Trigger once', 'studiare-plus' ),
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'triggers',
				'default'  => false,
				'class'    => 'xts-col-2',
				'requires' => array(
					array(
						'key'     => 'is_after_sessions_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority' => 112,
			)
		);

		// Advanced section.

		$metabox->add_field(
			array(
				'id'       => 'enable_page_scrolling',
				'name'     => esc_html__( 'Enable page scrolling', 'studiare-plus' ),
				'group'    => esc_html__( 'Settings', 'studiare-plus' ),
				'type'     => 'switcher',
				'section'  => 'advanced',
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'default'  => false,
				'priority' => 10,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'hide_popup',
				'name'     => esc_html__( 'Hide on desktop', 'studiare-plus' ),
				'group'    => esc_html__( 'Responsive', 'studiare-plus' ),
				'section'  => 'advanced',
				'type'     => 'switcher',
				'class'    => 'xts-col-4',
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'default'  => false,
				'priority' => 20,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'hide_popup_tablet',
				'name'     => esc_html__( 'Hide on tablet', 'studiare-plus' ),
				'group'    => esc_html__( 'Responsive', 'studiare-plus' ),
				'section'  => 'advanced',
				'type'     => 'switcher',
				'class'    => 'xts-col-4',
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'default'  => false,
				'priority' => 21,
			)
		);

		$metabox->add_field(
			array(
				'id'       => 'hide_popup_mobile',
				'name'     => esc_html__( 'Hide on mobile', 'studiare-plus' ),
				'group'    => esc_html__( 'Responsive', 'studiare-plus' ),
				'section'  => 'advanced',
				'type'     => 'switcher',
				'class'    => 'xts-col-4',
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'default'  => false,
				'priority' => 22,
			)
		);
	}
}

Popup_Metaboxes::get_instance();
