<?php
/**
 * Elementor Popup_Document class file.
 *
 * @package studiare plus
 */

namespace XTS\Modules\Floating_Blocks\Integrations;

use Elementor\Core\DocumentTypes\PageBase;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Popup_Document class.
 */
class Popup_Document extends PageBase {

	/**
	 * Get type.
	 *
	 * @return string
	 */
	public static function get_type() {
		return 'wd_popup';
	}

	/**
	 * Get title.
	 *
	 * @return string
	 */
	public static function get_title() {
		return esc_html__( 'Popup', 'studiare-plus' );
	}

	/**
	 * Get plural title.
	 *
	 * @return string
	 */
	public static function get_plural_title() {
		return esc_html__( 'Popups', 'studiare-plus' );
	}

	/**
	 * Get properties.
	 *
	 * @return array
	 */
	public static function get_properties() {
		$properties = parent::get_properties();

		$properties['admin_tab_group']   = 'woodmart';
		$properties['show_in_finder']    = false;
		$properties['show_on_admin_bar'] = false;
		$properties['cpt']               = array( 'wd_popup' );
		$properties['support_kit']       = true;

		return $properties;
	}

	/**
	 * Get name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'wd_popup';
	}

	/**
	 * Removed Elementor style controls.
	 *
	 * @access public
	 * @static
	 * @param Document $document Elementor document.
	 */
	public static function register_style_controls( $document ) {}

	/**
	 * Removed hide title control.
	 *
	 * @access public
	 * @static
	 * @param Document $document Elementor document.
	 */
	public static function register_hide_title_control( $document ) {}

	/**
	 * Add document controls.
	 */
	public function register_controls() {
		$popup_id = $this->get_main_id();
		$prefix   = 'wd_popup_';

		// Settings tab.

		$this->start_controls_section(
			$prefix . 'settings_layout',
			array(
				'label' => esc_html__( 'Layout', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_responsive_control(
			$prefix . 'width',
			array(
				'label'      => esc_html__( 'Width', 'studiare-plus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vw' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 2000,
						'step' => 1,
					),
					'vw' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-popup-width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'height',
			array(
				'label'      => esc_html__( 'Height', 'studiare-plus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vh' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 2000,
						'step' => 1,
					),
					'vh' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-popup-height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'content_vertical_align',
			array(
				'label'     => esc_html__( 'Content position', 'studiare-plus' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'start'  => array(
						'title' => esc_html__( 'Top', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-top',
					),
					'center' => array(
						'title' => esc_html__( 'Middle', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'end'    => array(
						'title' => esc_html__( 'Bottom', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'selectors' => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup' => '--wd-align-items: {{VALUE}};',
				),
				'condition' => array(
					$prefix . 'height[size]!' => '',
				),
			)
		);

		$this->add_control(
			$prefix . 'heading_position',
			array(
				'label'     => esc_html__( 'Position', 'studiare-plus' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			$prefix . 'horizontal_align',
			array(
				'label'     => esc_html__( 'Horizontal', 'studiare-plus' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'studiare-plus' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'studiare-plus' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'studiare-plus' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-justify-content: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'vertical_align',
			array(
				'label'     => esc_html__( 'Vertical', 'studiare-plus' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'start'  => array(
						'title' => esc_html__( 'Top', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-top',
					),
					'center' => array(
						'title' => esc_html__( 'Middle', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'end'    => array(
						'title' => esc_html__( 'Bottom', 'studiare-plus' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'selectors' => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-align-items: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'settings_close_behavior',
			array(
				'label' => esc_html__( 'Close behavior', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			$prefix . 'close_btn',
			array(
				'label'             => esc_html__( 'Close button', 'studiare-plus' ),
				'type'              => Controls_Manager::SWITCHER,
				'description'       => esc_html__( 'Disable the default close button. After that, the popup can be closed via the background overlay or a custom button using the “Close by selector” option.', 'studiare-plus' ),
				'label_on'          => esc_html__( 'On', 'studiare-plus' ),
				'label_off'         => esc_html__( 'Off', 'studiare-plus' ),
				'return_value'      => '1',
				'default'           => '1',
				'wd_reload_preview' => true,
			)
		);

		$this->add_control(
			$prefix . 'close_btn_display',
			array(
				'label'             => esc_html__( 'Display', 'studiare-plus' ),
				'type'              => Controls_Manager::SELECT,
				'description'       => esc_html__( 'Choose the close button design.', 'studiare-plus' ),
				'options'           => array(
					'icon' => esc_html__( 'Icon', 'studiare-plus' ),
					'text' => esc_html__( 'Icon with text', 'studiare-plus' ),
				),
				'default'           => 'icon',
				'condition'         => array(
					$prefix . 'close_btn' => '1',
				),
				'wd_reload_preview' => true,
			)
		);

		$this->add_control(
			$prefix . 'close_by_overlay',
			array(
				'label'        => esc_html__( 'Close by overlay', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Close the popup when clicking on the background overlay.', 'studiare-plus' ),
				'return_value' => '1',
				'default'      => '1',
			)
		);

		$this->add_control(
			$prefix . 'close_by_esc',
			array(
				'label'        => esc_html__( 'Close by ESC key', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Close the popup when pressing the Escape key.', 'studiare-plus' ),
				'return_value' => '1',
				'default'      => '1',
			)
		);

		$this->add_control(
			$prefix . 'close_by_selector',
			array(
				'label'       => esc_html__( 'Close by selector', 'studiare-plus' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Create an alternative popup close button. Enter a CSS selector (e.g., .wd-close-popup) that will close the popup when clicked.', 'studiare-plus' ),
				'default'     => '',
			)
		);

		$this->add_control(
			$prefix . 'persistent_close',
			array(
				'label'        => esc_html__( 'Persistent close', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '1',
				'return_value' => '1',
				'description'  => esc_html__( 'Once closed, the popup will stay hidden on reload until the cookie is cleared.', 'studiare-plus' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'settings_advanced',
			array(
				'label' => esc_html__( 'Advanced', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			$prefix . 'enable_page_scrolling',
			array(
				'label'        => esc_html__( 'Enable page scrolling', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => '1',
				'default'      => '',
			)
		);

		$this->add_control(
			$prefix . 'responsive_title',
			array(
				'separator' => 'before',
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Responsive', 'studiare-plus' ),
			)
		);

		$this->add_control(
			$prefix . 'hide_popup',
			array(
				'label'             => esc_html__( 'Hide on desktop', 'studiare-plus' ),
				'type'              => Controls_Manager::SWITCHER,
				'wd_reload_preview' => true,
				'return_value'      => '1',
				'default'           => '',
			)
		);

		$this->add_control(
			$prefix . 'hide_popup_tablet',
			array(
				'label'             => esc_html__( 'Hide on tablet', 'studiare-plus' ),
				'type'              => Controls_Manager::SWITCHER,
				'wd_reload_preview' => true,
				'return_value'      => '1',
				'default'           => '',
			)
		);

		$this->add_control(
			$prefix . 'hide_popup_mobile',
			array(
				'label'             => esc_html__( 'Hide on mobile', 'studiare-plus' ),
				'type'              => Controls_Manager::SWITCHER,
				'wd_reload_preview' => true,
				'return_value'      => '1',
				'default'           => '',
			)
		);

		$this->end_controls_section();

		// Popup tab.

		$this->start_controls_section(
			$prefix . 'settings_popup',
			array(
				'label' => esc_html__( 'Popup', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'           => 'background',
				'fields_options' => array(
					'background' => array(
						'label' => esc_html__( 'Background type', 'studiare-plus' ),
					),
				),
				'description'    => esc_html__( 'Set background color or image for popup.', 'studiare-plus' ),
				'types'          => array( 'classic', 'gradient' ),
				'selector'       => '.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup',
			)
		);

		$this->add_control(
			$prefix . 'background_divider',
			array(
				'type'      => \Elementor\Controls_Manager::DIVIDER,
				'condition' => array(
					'background_background' => array( 'classic', 'gradient' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => $prefix . 'border',
				'selector'       => '.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup',
				'fields_options' => array(
					'border' => array(
						'label' => esc_html__( 'Border type', 'studiare-plus' ),
					),
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'border_radius',
			array(
				'label'      => esc_html__( 'Border radius', 'studiare-plus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => $prefix . 'box_shadow',
				'selector' => '.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup',
			)
		);

		$this->add_responsive_control(
			$prefix . 'padding',
			array(
				'label'       => esc_html__( 'Padding', 'studiare-plus' ),
				'description' => esc_html__( 'Sets the spacing between the popup’s borders and its content.', 'studiare-plus' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'size_units'  => array( 'px', '%' ),
				'selectors'   => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup .wd-popup-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'   => 'before',
				'default'     => array(
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
					'unit'   => 'px',
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'margin',
			array(
				'label'       => esc_html__( 'Margin', 'studiare-plus' ),
				'description' => esc_html__( 'Sets the spacing between the popup and the edge of the screen.', 'studiare-plus' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'size_units'  => array( 'px', '%' ),
				'selectors'   => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-popup-mt: {{TOP}}{{UNIT}}; --wd-popup-mr: {{RIGHT}}{{UNIT}}; --wd-popup-mb: {{BOTTOM}}{{UNIT}}; --wd-popup-ml: {{LEFT}}{{UNIT}};',
				),
				'default'     => array(
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
					'unit'   => 'px',
				),
			)
		);

		$this->add_control(
			$prefix . 'animation',
			array(
				'label'       => esc_html__( 'Animation', 'studiare-plus' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'default'                => esc_html__( 'From left to right', 'studiare-plus' ),
					'slide-from-top'         => esc_html__( 'Slide from top', 'studiare-plus' ),
					'slide-from-bottom'      => esc_html__( 'Slide from bottom', 'studiare-plus' ),
					'slide-from-left'        => esc_html__( 'Slide from left', 'studiare-plus' ),
					'slide-from-right'       => esc_html__( 'Slide from right', 'studiare-plus' ),
					'slide-short-from-left'  => esc_html__( 'Slide short from left', 'studiare-plus' ),
					'slide-short-from-right' => esc_html__( 'Slide short from right', 'studiare-plus' ),
					'top-flip-x'             => esc_html__( 'Top flip X', 'studiare-plus' ),
					'bottom-flip-x'          => esc_html__( 'Bottom flip X', 'studiare-plus' ),
					'right-flip-y'           => esc_html__( 'Right flip Y', 'studiare-plus' ),
					'left-flip-y'            => esc_html__( 'Left flip Y', 'studiare-plus' ),
					'snap-in-top'            => esc_html__( 'Snap in top', 'studiare-plus' ),
					'snap-in-bottom'         => esc_html__( 'Snap in bottom', 'studiare-plus' ),
					'snap-in-left'           => esc_html__( 'Snap in left', 'studiare-plus' ),
					'snap-in-right'          => esc_html__( 'Snap in right', 'studiare-plus' ),
					'zoom-in'                => esc_html__( 'Zoom in', 'studiare-plus' ),
				),
				'default'     => 'default',
				'separator'   => 'before',
				'description' => esc_html__( 'Select a popup appearance animation.', 'studiare-plus' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'settings_overlay',
			array(
				'label' => esc_html__( 'Overlay', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			$prefix . 'overlay_color',
			array(
				'label'       => esc_html__( 'Background color', 'studiare-plus' ),
				'type'        => Controls_Manager::COLOR,
				'description' => esc_html__( 'Overlay color. Set transparency to make the site partially visible beneath the overlay.', 'studiare-plus' ),
				'selectors'   => array(
					'.mfp-bg.wd-mfp-popup-bg-' . $popup_id => 'background-color: {{VALUE}};',
				),
				'default'     => '',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'style_close_button',
			array(
				'label' => esc_html__( 'Close button', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			$prefix . 'close_btn_offset_v',
			array(
				'label'      => esc_html__( 'Offset vertical', 'studiare-plus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => -500,
						'max'  => 500,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-close-btn-offset-v: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => '',
					'unit' => 'px',
				),
			)
		);

		$this->add_responsive_control(
			$prefix . 'close_btn_offset_h',
			array(
				'label'      => esc_html__( 'Offset horizontal', 'studiare-plus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => -500,
						'max'  => 500,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id => '--wd-close-btn-offset-h: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => '',
					'unit' => 'px',
				),
			)
		);

		$this->start_controls_tabs(
			'link_color_tabs'
		);

		$this->start_controls_tab(
			'link_color_tab',
			array(
				'label' => esc_html__( 'Idle', 'studiare-plus' ),
			)
		);

		$this->add_control(
			$prefix . 'close_btn_text_color',
			array(
				'label'     => esc_html__( 'Color', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup-close' => '--wd-action-color: {{VALUE}};',
				),
				'default'   => '',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'link_hover_color_tab',
			array(
				'label' => esc_html__( 'Hover', 'studiare-plus' ),
			)
		);

		$this->add_control(
			$prefix . 'close_btn_text_color_hover',
			array(
				'label'     => esc_html__( 'Color', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'.mfp-wrap.wd-mfp-popup-wrap-' . $popup_id . ' .wd-popup-close' => '--wd-action-color-hover: {{VALUE}};',
				),
				'default'   => '',
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'triggers',
			array(
				'label' => esc_html__( 'Triggers', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_ADVANCED,
			)
		);

		$this->add_control(
			$prefix . 'is_some_time_enabled',
			array(
				'label'        => esc_html__( 'Page loaded', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup after some time (in milliseconds).', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '1',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'time_to_show',
			array(
				'label'     => esc_html__( 'Time to show', 'studiare-plus' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 0,
				'default'   => '0',
				'condition' => array(
					$prefix . 'is_some_time_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'time_to_show_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_some_time_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_some_time',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_after_scroll_enabled',
			array(
				'label'        => esc_html__( 'User scroll', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup after user scrolls a certain percentage of the page.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'scroll_value',
			array(
				'label'      => esc_html__( 'Scroll value', 'studiare-plus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( '%', 'px' ),
				'range'      => array(
					'%'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'px' => array(
						'min'  => 0,
						'max'  => 10000,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 50,
					'unit' => '%',
				),
				'condition'  => array(
					$prefix . 'is_after_scroll_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'after_scroll_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_after_scroll_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_after_scroll',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_scroll_to_selector_enabled',
			array(
				'label'        => esc_html__( 'Scroll to selector', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup when user scrolls to a specific CSS selector.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'scroll_to_selector',
			array(
				'label'     => esc_html__( 'Selector', 'studiare-plus' ),
				'type'      => Controls_Manager::TEXT,
				'description' => esc_html__( 'Comma-separated list of selectors. For example: .wrapper .special-button, .newsletter-icon', 'studiare-plus' ),
				'default'   => '',
				'condition' => array(
					$prefix . 'is_scroll_to_selector_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'scroll_to_selector_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_scroll_to_selector_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_scroll_to_selector',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_inactivity_time_enabled',
			array(
				'label'        => esc_html__( 'Inactivity time', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup after inactivity time (in milliseconds).', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'inactivity_time',
			array(
				'label'     => esc_html__( 'Time to show', 'studiare-plus' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 0,
				'default'   => 10000,
				'condition' => array(
					$prefix . 'is_inactivity_time_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'inactivity_time_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_inactivity_time_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_inactivity_time',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_exit_intent_enabled',
			array(
				'label'        => esc_html__( 'Exit intent', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Popup appears when the cursor exits the viewport, suggesting tab closure.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'exit_intent_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_exit_intent_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_exit_intent',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_on_click_enabled',
			array(
				'label'        => esc_html__( 'On click', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Number of clicks required to show popup.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'click_times',
			array(
				'label'     => esc_html__( 'Click times', 'studiare-plus' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 1,
				'default'   => 3,
				'condition' => array(
					$prefix . 'is_on_click_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'click_times_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_on_click_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_click_times',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_on_selector_click_enabled',
			array(
				'label'        => esc_html__( 'On selector click', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'CSS selector to trigger popup on click.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'selector',
			array(
				'label'     => esc_html__( 'Selector', 'studiare-plus' ),
				'type'      => Controls_Manager::TEXT,
				'description'  => esc_html__( 'Comma-separated list of selectors. For example: .wrapper .special-button, .newsletter-icon', 'studiare-plus' ),
				'default'   => '',
				'condition' => array(
					$prefix . 'is_on_selector_click_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'selector_click_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_on_selector_click_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_selector_click',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_url_parameter_enabled',
			array(
				'label'        => esc_html__( 'URL contains specific parameter', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Name of the URL parameter to check.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'parameters',
			array(
				'label'       => esc_html__( 'Parameters', 'studiare-plus' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Comma-separated list of parameters. For example: utm_source=facebook, single_key', 'studiare-plus' ),
				'default'     => '',
				'condition'   => array(
					$prefix . 'is_url_parameter_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'url_parameter_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_url_parameter_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_url_parameter',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_url_hashtag_enabled',
			array(
				'label'        => esc_html__( 'URL contains specific hashtag', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Name of the URL hashtag to check.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'hashtags',
			array(
				'label'       => esc_html__( 'Hashtags', 'studiare-plus' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Comma-separated list of hashtags. For example: #hashtag1, #hashtag2', 'studiare-plus' ),
				'default'     => '',
				'condition'   => array(
					$prefix . 'is_url_hashtag_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'url_hashtag_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_url_hashtag_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_url_hashtag',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_after_page_views_enabled',
			array(
				'label'        => esc_html__( 'After page views', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup after a specific number of page views.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'after_page_views',
			array(
				'label'     => esc_html__( 'Views', 'studiare-plus' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 1,
				'default'   => 1,
				'condition' => array(
					$prefix . 'is_after_page_views_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'after_page_views_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_after_page_views_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'divider_after_page_views',
			array(
				'type' => Controls_Manager::DIVIDER,
			)
		);

		$this->add_control(
			$prefix . 'is_after_sessions_enabled',
			array(
				'label'        => esc_html__( 'After sessions', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Show popup after a specific number of user sessions.', 'studiare-plus' ),
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'default'      => '',
				'return_value' => '1',
			)
		);

		$this->add_control(
			$prefix . 'after_sessions',
			array(
				'label'     => esc_html__( 'Sessions', 'studiare-plus' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 1,
				'default'   => 1,
				'condition' => array(
					$prefix . 'is_after_sessions_enabled' => '1',
				),
			)
		);

		$this->add_control(
			$prefix . 'after_sessions_once',
			array(
				'label'        => esc_html__( 'Trigger once', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '0',
				'return_value' => '1',
				'condition'    => array(
					$prefix . 'is_after_sessions_enabled' => '1',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			$prefix . 'conditions_section',
			array(
				'label' => esc_html__( 'Conditions', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_ADVANCED,
			)
		);

		$this->add_control(
			$prefix . 'hidden_repeater',
			array(
				'type'    => Controls_Manager::REPEATER,
				'default' => array(),
				'fields'  => array(),
				'classes' => 'elementor-hidden',
			)
		);

		$this->add_control(
			$prefix . 'conditions',
			array(
				'label'   => esc_html__( 'Display conditions', 'studiare-plus' ),
				'type'    => Controls_Manager::REPEATER,
				'default' => array(
					array(
						'comparison' => 'include',
						'type'       => 'all',
					),
				),
				'fields'  => array(
					array(
						'name'    => 'comparison',
						'label'   => esc_html__( 'Comparison condition', 'studiare-plus' ),
						'type'    => Controls_Manager::SELECT,
						'default' => 'include',
						'options' => array(
							'include' => esc_html__( 'Include', 'studiare-plus' ),
							'exclude' => esc_html__( 'Exclude', 'studiare-plus' ),
						),
					),
					array(
						'name'    => 'type',
						'label'   => esc_html__( 'Condition type', 'studiare-plus' ),
						'type'    => Controls_Manager::SELECT,
						'default' => 'all',
						'options' => array(
							'all'                  => esc_html__( 'All', 'studiare-plus' ),
							'post_type'            => esc_html__( 'Post types', 'studiare-plus' ),
							'single_post_type'     => esc_html__( 'Post type single page', 'studiare-plus' ),
							'post_id'              => esc_html__( 'Post ID', 'studiare-plus' ),
							'taxonomy'             => esc_html__( 'Taxonomy', 'studiare-plus' ),
							'term_id'              => esc_html__( 'Term ID', 'studiare-plus' ),
							'single_posts_term_id' => esc_html__( 'Single posts from term', 'studiare-plus' ),
							'user_role'            => esc_html__( 'User role', 'studiare-plus' ),
							'custom'               => esc_html__( 'Custom', 'studiare-plus' ),
						),
					),
					array(
						'name'       => 'query_post_type',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'post_type',
						'default'    => '',
						'condition'  => array(
							'type' => 'post_type',
						),
					),
					array(
						'name'       => 'query_single_post_type',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'single_post_type',
						'default'    => '',
						'condition'  => array(
							'type' => 'single_post_type',
						),
					),
					array(
						'name'       => 'query_post_id',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'post_id',
						'default'    => '',
						'condition'  => array(
							'type' => 'post_id',
						),
					),
					array(
						'name'       => 'query_taxonomy',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'taxonomy',
						'default'    => '',
						'condition'  => array(
							'type' => 'taxonomy',
						),
					),
					array(
						'name'       => 'query_term_id',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'term_id',
						'default'    => '',
						'condition'  => array(
							'type' => 'term_id',
						),
					),
					array(
						'name'       => 'query_single_posts_term_id',
						'label'      => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'       => 'wd_autocomplete',
						'search'     => 'woodmart_get_posts_by_query',
						'render'     => 'woodmart_get_posts_title_by_id',
						'query_type' => 'single_posts_term_id',
						'default'    => '',
						'condition'  => array(
							'type' => 'single_posts_term_id',
						),
					),
					array(
						'name'      => 'query_user_role',
						'label'     => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'      => Controls_Manager::SELECT,
						'options'   => array_combine(
							array_keys( wp_roles()->roles ),
							array_column( wp_roles()->roles, 'name' )
						),
						'default'   => '',
						'condition' => array(
							'type' => 'user_role',
						),
					),
					array(
						'name'      => 'query_custom',
						'label'     => esc_html__( 'Condition query', 'studiare-plus' ),
						'type'      => Controls_Manager::SELECT,
						'options'   => woodmart_get_custom_conditions_list(),
						'default'   => 'search',
						'condition' => array(
							'type' => 'custom',
						),
					),
				),
			)
		);

		$this->end_controls_section();

		parent::register_controls();

		$this->remove_control( 'template' );
		$this->remove_control( 'template_default_description' );
		$this->remove_control( 'template_theme_description' );
		$this->remove_control( 'template_canvas_description' );
		$this->remove_control( 'template_header_footer_description' );
		$this->remove_control( 'reload_preview_description' );
	}
}
