<?php
/**
 * Popup template.
 *
 * @package studiare plus
 *
 * @var string $btn_text     Button text.
 * @var string $btn_classes  Button classes.
 * @var string $title_text   Title text.
 * @var string $content      Content.
 */

$btn_classes = isset( $btn_classes ) ? $btn_classes : '';
$classes     = isset( $_GET['create_template'] ) ? ' xts-opened' : '';
?>
<div class="xts-popup-holder<?php echo esc_attr( $classes ); ?>">
	<div class="xts-popup-overlay"></div>
	<?php if ( $btn_text ) : ?>
		<a href="javascript:void(0);" class="xts-popup-opener xts-btn xts-color-primary<?php echo esc_attr( $btn_classes ); ?>">
			<?php echo esc_html( $btn_text ); ?>
		</a>
	<?php endif; ?>

	<div class="xts-popup xts-size-l xts-add-new-floating-block xts-theme-style">
		<div class="xts-popup-inner">
			<div class="xts-popup-header">
				<div class="xts-popup-title">
					<?php echo esc_html( $title_text ); ?>
				</div>

				<a href="javascript:void(0);" class="xts-popup-close xts-i-close">
					<?php esc_html_e( 'Close', 'studiare-plus' ); ?>
				</a>
			</div>

			<div class="xts-popup-content">
				<div class="xts-notices-wrapper"></div>

				<?php echo $content; // phpcs:ignore ?>
			</div>
		</div>
	</div>
</div>
