<?php
/**
 * Review reminder class.
 *
 * @package studiare plus
 */

namespace XTS\Modules\Review_Reminder;

use XTS\Admin\Modules\Options;

/**
 * Review reminder class.
 */
class Main {
	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'add_options' ) );

		woodmart_include_files(
			__DIR__,
			array(
				'./class-admin',
				'./class-frontend',
				'./class-emails',
			)
		);
	}

	/**
	 * Add options in theme settings.
	 *
	 * @return void
	 */
	public function add_options() {
		Options::add_field(
			array(
				'id'          => 'review_reminder_enabled',
				'name'        => esc_html__( 'Review reminder', 'studiare-plus' ),
				'description' => esc_html__( 'Enable this option to automatically send review reminder emails to customers after they make a purchase.', 'studiare-plus' ),
				'type'        => 'switcher',
				'section'     => 'single_product_comments_section',
				'group'       => esc_html__( 'Review reminder', 'studiare-plus' ),
				'default'     => false,
				'priority'    => 320,
			)
		);

		Options::add_field(
			array(
				'id'           => 'review_reminder_sending_delay',
				'name'         => esc_html__( 'Sending delay', 'studiare-plus' ),
				'description'  => esc_html__( 'Set the delay after purchase before sending the review reminder email.', 'studiare-plus' ),
				'type'         => 'group',
				'section'      => 'single_product_comments_section',
				'group'        => esc_html__( 'Review reminder', 'studiare-plus' ),
				'inner_fields' => array(
					array(
						'id'         => 'review_reminder_sending_timeframe',
						'type'       => 'text_input',
						'attributes' => array(
							'type' => 'number',
							'min'  => 1,
						),
						'priority'   => 10,
						'default'    => 7,
					),
					array(
						'id'       => 'review_reminder_sending_timeframe_period',
						'type'     => 'select',
						'options'  => array(
							strval( MINUTE_IN_SECONDS ) => array(
								'name'  => esc_html__( 'Minutes', 'studiare-plus' ),
								'value' => strval( MINUTE_IN_SECONDS ),
							),
							strval( HOUR_IN_SECONDS )   => array(
								'name'  => esc_html__( 'Hours', 'studiare-plus' ),
								'value' => strval( HOUR_IN_SECONDS ),
							),
							strval( DAY_IN_SECONDS )    => array(
								'name'  => esc_html__( 'Days', 'studiare-plus' ),
								'value' => strval( DAY_IN_SECONDS ),
							),
						),
						'default'  => strval( DAY_IN_SECONDS ),
						'priority' => 20,
					),
				),
				'requires'    => array(
					array(
						'key'     => 'review_reminder_enabled',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'priority'     => 330,
			)
		);
	}
}

new Main();
