<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
* ------------------------------------------------------------------------------------------------
* Section title element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_title' ) ) {
	function woodmart_get_vc_map_title() {
		$secondary_font        = woodmart_get_opt( 'secondary-font' );
		$default_font          = woodmart_get_opt( 'text-font' );
		$alt_font_subtitle     = isset( $secondary_font[0]['font-family'] ) ? esc_html__( 'Alternative', 'studiare-plus' ) . ' (' . $secondary_font[0]['font-family'] . ')' : esc_html__( 'Alternative', 'studiare-plus' );
		$default_font_subtitle = isset( $default_font[0]['font-family'] ) ? esc_html__( 'Default', 'studiare-plus' ) . ' (' . $default_font[0]['font-family'] . ')' : esc_html__( 'Default', 'studiare-plus' );

		return array(
			'name'        => esc_html__( 'Section title', 'studiare-plus' ),
			'base'        => 'woodmart_title',
			'category'    => woodmart_get_tab_title_category_for_wpb(  esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'description' => esc_html__( 'Styled title for sections', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/section-title.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				 * Layout
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Layout', 'studiare-plus' ),
					'param_name' => 'layout_divider',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Align', 'studiare-plus' ),
					'param_name'       => 'align',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'center',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Width', 'studiare-plus' ),
					'param_name'       => 'title_width',
					'value'            => array(
						'100%' => '100',
						'90%'  => '90',
						'80%'  => '80',
						'70%'  => '70',
						'60%'  => '60',
						'50%'  => '50',
						'40%'  => '40',
						'30%'  => '30',
						'20%'  => '20',
						'10%'  => '10',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Custom title width', 'studiare-plus' ),
					'param_name'       => 'custom_title_width',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'default'          => 'desktop',
					'edit_field_class' => 'wd-res-control vc_col-sm-12 vc_column wd-custom-width',
					'dependency'       => array(
						'element' => 'title_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'param_name'       => 'title_desktop_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '600',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-control vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'desktop',
					),
					'wd_dependency'    => array(
						'element' => 'custom_title_width',
						'value'   => array( 'desktop' ),
					),
					'dependency'       => array(
						'element' => 'title_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'param_name'       => 'title_tablet_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '0',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-control vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'tablet',
					),
					'wd_dependency'    => array(
						'element' => 'custom_title_width',
						'value'   => array( 'tablet' ),
					),
					'dependency'       => array(
						'element' => 'title_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'param_name'       => 'title_mobile_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '0',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-control vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'mobile',
					),
					'wd_dependency'    => array(
						'element' => 'custom_title_width',
						'value'   => array( 'mobile' ),
					),
					'dependency'       => array(
						'element' => 'title_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'layout_divider',
				),
				array(
					'type'         => 'woodmart_image_select',
					'heading'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name'   => 'style',
					'value'        => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Simple', 'studiare-plus' ) => 'simple',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Underline', 'studiare-plus' ) => 'underlined',
						esc_html__( 'Underline 2', 'studiare-plus' ) => 'underlined-2',
						esc_html__( 'Overlined', 'studiare-plus' ) => 'overlined',
						esc_html__( 'Shadow', 'studiare-plus' ) => 'shadow',
						esc_html__( 'With image', 'studiare-plus' ) => 'image',
					),
					'images_value' => array(
						'default'      => WOODMART_ASSETS_IMAGES . '/settings/title-style/default.png',
						'simple'       => WOODMART_ASSETS_IMAGES . '/settings/title-style/simple.png',
						'bordered'     => WOODMART_ASSETS_IMAGES . '/settings/title-style/bordered.png',
						'underlined'   => WOODMART_ASSETS_IMAGES . '/settings/title-style/underlined.png',
						'underlined-2' => WOODMART_ASSETS_IMAGES . '/settings/title-style/underlined-2.png',
						'overlined'    => WOODMART_ASSETS_IMAGES . '/settings/title-style/overlined.png',
						'shadow'       => WOODMART_ASSETS_IMAGES . '/settings/title-style/shadow.png',
						'image'        => WOODMART_ASSETS_IMAGES . '/settings/title-style/image.png',
					),
				),
				array(
					'type'             => 'woodmart_dropdown',
					'heading'          => esc_html__( 'Predefined color scheme', 'studiare-plus' ),
					'param_name'       => 'color',
					'value'            => woodmart_section_title_color_variation(),
					'style'            => array(
						'default' => '#989898',
						'primary' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
						'alt'     => woodmart_get_color_value( 'secondary-color', '#fbbc34' ),
						'black'   => '#2d2a2a',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				woodmart_title_gradient_picker(),
				/**
				 * Image
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Image', 'studiare-plus' ),
					'param_name' => 'image_divider',
					'dependency' => array(
						'element' => 'style',
						'value'   => array( 'image' ),
					),
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'style',
						'value'   => array( 'image' ),
					),
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'style',
						'value'   => array( 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',

				woodmart_get_vc_animation_map( 'wd_animation' ),
				woodmart_get_vc_animation_map( 'wd_animation_delay' ),
				woodmart_get_vc_animation_map( 'wd_animation_duration' ),

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				/**
				 * Title
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Title', 'studiare-plus' ),
					'group'      => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type'       => 'textarea',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Title', 'studiare-plus' ),
					'group'      => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Predefined size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'size',
					'value'            => array(
						esc_html__( 'Default (22px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Small (18px)', 'studiare-plus' ) => 'small',
						esc_html__( 'Medium (26px)', 'studiare-plus' ) => 'medium',
						esc_html__( 'Large (36px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large (46px)', 'studiare-plus' ) => 'extra-large',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'title_font_size',
					'css_args'         => array(
						'font-size' => array(
							' .woodmart-title-container',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'title_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .woodmart-title-container',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Title', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Custom color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'title_custom_color',
					'css_args'         => array(
						'color' => array(
							' .woodmart-title-container',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Tag', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'tag',
					'value'            => array(
						'h1'   => 'h1',
						'h2'   => 'h2',
						'h3'   => 'h3',
						'h4'   => 'h4',
						'h5'   => 'h5',
						'h6'   => 'h6',
						'p'    => 'p',
						'div'  => 'div',
						'span' => 'span',
					),
					'std'              => 'h4',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Highlight text style', 'studiare-plus' ),
					'hint'             => esc_html__( 'The text must be wrapped with the <u></u> tag to highlight it.', 'studiare-plus' ),
					'group'            => esc_html__( 'Title', 'studiare-plus' ),
					'param_name'       => 'title_decoration_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' )  => 'default',
						esc_html__( 'Primary color', 'studiare-plus' )  => 'colored',
						esc_html__( 'Primary color + secondary font', 'studiare-plus' ) => 'colored-alt',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Gradient', 'studiare-plus' ) => 'gradient',
					),
					'std'              => 'colored',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_gradient',
					'heading'    => esc_html__( 'Highlight text gradient', 'studiare-plus' ),
					'group'      => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title_decoration_gradient',
					'selectors'  => array(
						'{{WRAPPER}}.wd-underline-gradient u' => array(
							'background-image: {{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'title_decoration_style',
						'value'   => array( 'gradient' ),
					),
				),
				/**
				 * Subtitle
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Subtitle', 'studiare-plus' ),
					'group'      => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name' => 'subtitle_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Subtitle', 'studiare-plus' ),
					'group'      => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name' => 'subtitle',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font',
					'value'            => array(
						$default_font_subtitle => 'default',
						$alt_font_subtitle     => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Font Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font_size',
					'css_args'         => array(
						'font-size' => array(
							' .title-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_line_height_size',
					'css_args'         => array(
						'line-height' => array(
							' .title-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Custom color', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_color',
					'css_args'         => array(
						'color' => array(
							' .title-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Style', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Background', 'studiare-plus' ) => 'background',
					),
					'images_value'     => array(
						'default'    => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/default.png',
						'background' => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/background.png',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .title-subtitle',
						),
					),
					'dependency'       => array(
						'element' => 'subtitle_style',
						'value'   => array( 'background' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Text after title
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Text', 'studiare-plus' ),
					'group'      => esc_html__( 'Text', 'studiare-plus' ),
					'param_name' => 'text_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Text after title', 'studiare-plus' ),
					'group'      => esc_html__( 'Text', 'studiare-plus' ),
					'param_name' => 'after_title',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Text', 'studiare-plus' ),
					'param_name'       => 'after_font_size',
					'css_args'         => array(
						'font-size' => array(
							' .title-after_title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Text', 'studiare-plus' ),
					'param_name'       => 'after_line_height_size',
					'css_args'         => array(
						'line-height' => array(
							' .title-after_title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_colorpicker',
					'heading'    => esc_html__( 'Color', 'studiare-plus' ),
					'group'      => esc_html__( 'Text', 'studiare-plus' ),
					'param_name' => 'after_color',
					'css_args'   => array(
						'color' => array(
							' .title-after_title',
						),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
				/**
				 * Advanced.
				 */

				woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ),

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}


if ( ! function_exists( 'woodmart_section_title_color_variation' ) ) {
	/**
	 * Get Section Title Color.
	 *
	 * @return array List of title color variation.
	 */
	function woodmart_section_title_color_variation() {

		$variation = array(
			esc_html__( 'Default', 'studiare-plus' )           => 'default',
			esc_html__( 'Primary color', 'studiare-plus' )     => 'primary',
			esc_html__( 'Alternative color', 'studiare-plus' ) => 'alt',
			esc_html__( 'Black', 'studiare-plus' )             => 'black',
			esc_html__( 'White', 'studiare-plus' )             => 'white',
		);

		if ( apply_filters( 'woodmart_gradients_enabled', true ) ) {
			$variation = array_merge(
				$variation,
				array(
					esc_html__( 'Gradient', 'studiare-plus' ) => 'gradient',
				)
			);
		}

		return $variation;
	}
}

if ( ! function_exists( 'woodmart_title_gradient_picker' ) ) {
	/**
	 * Get Gradient Section Title Color Picker.
	 *
	 * @return array List of title color variation.
	 */
	function woodmart_title_gradient_picker() {

		$title_color = array(
			'type'       => 'woodmart_gradient',
			'param_name' => 'woodmart_color_gradient',
			'heading'    => esc_html__( 'Gradient title color', 'studiare-plus' ),
			'dependency' => array(
				'element' => 'color',
				'value'   => array( 'gradient' ),
			),
		);

		if ( ! apply_filters( 'woodmart_gradients_enabled', true ) ) {
			$title_color = false;
		}

		return $title_color;
	}
}
