<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
* Timeline element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_timeline' ) ) {
	function woodmart_get_vc_map_timeline() {
		return array(
			'name' => esc_html__( 'Timeline', 'studiare-plus' ),
			'base' => 'woodmart_timeline',
			'as_parent' => array( 'only' => 'woodmart_timeline_item, woodmart_timeline_breakpoint' ),
			'content_element' => true,
			'show_settings_on_create' => true,
			'description' => esc_html__( 'Timeline for the history of your product', 'studiare-plus' ),
			'category' => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon' => WOODMART_ASSETS . '/images/vc-icon/timeline.svg',
			'params' => array(
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Genaral options', 'studiare-plus' ),
					'param_name' => 'general_divider'
				),
				array(
					'type' => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id'
				),
				array(
					'type' => 'woodmart_button_set',
					'heading' => esc_html__( 'Line style', 'studiare-plus' ),
					'param_name' => 'line_style',
					'value' => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed'
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_button_set',
					'heading' => esc_html__( 'Item style', 'studiare-plus' ),
					'param_name' => 'item_style',
					'value' => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'With shadow', 'studiare-plus' ) => 'shadow'
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_colorpicker',
					'heading' => esc_html__( 'Color of line', 'studiare-plus' ),
					'param_name' => 'line_color',
					'css_args' => array(
						'background-color' => array(
							' .dot-start',
							' .dot-end',
						),
						'border-color' => array(
							' .woodmart-timeline-line',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_colorpicker',
					'heading' => esc_html__( 'Color of dots', 'studiare-plus' ),
					'param_name' => 'dots_color',
					'css_args' => array(
						'background-color' => array(
							' .woodmart-timeline-dot',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
			'js_view' => 'VcColumnView'
		);
	}
}

if ( ! function_exists( 'woodmart_get_vc_map_timeline_item' ) ) {
	function woodmart_get_vc_map_timeline_item() {
		return array(
			'name' => esc_html__( 'Timeline item', 'studiare-plus'),
			'base' => 'woodmart_timeline_item',
			'as_child' => array( 'only' => 'woodmart_timeline' ),
			'content_element' => true,
			'category' => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon' => WOODMART_ASSETS . '/images/vc-icon/timeline-item.svg',
			'params' => array(
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Genaral options', 'studiare-plus' ),
					'param_name' => 'general_divider'
				),
				array(
					'type' => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id'
				),
				array(
					'type' => 'woodmart_button_set',
					'heading' => esc_html__( 'Position', 'studiare-plus' ),
					'param_name' => 'position',
					'value' => array(
						esc_html__( 'Left', 'studiare-plus' ) => 'left',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
						esc_html__( 'Full Width', 'studiare-plus' ) => 'full-width'
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_colorpicker',
					'heading' => esc_html__( 'Background color ', 'studiare-plus' ),
					'css_args' => array(
						'background-color' => array(
							'.wd-timeline-item',
							' .timeline-col-primary',
							' .timeline-col-secondary',
						),
						'color' => array(
							' .timeline-arrow',
						),
					),
					'param_name' => 'color_bg',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
				),
				/**
				 * Image
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Image', 'studiare-plus' ),
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'param_name' => 'primary_image_divider'
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image Primary', 'studiare-plus' ),
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'param_name' => 'image_primary',
					'value' => '',
					'hint' => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image size', 'studiare-plus' ),
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'param_name' => 'img_size_primary',
					'hint' => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Content
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'param_name' => 'primary_content_divider'
				),
				array(
					'type' => 'textarea',
					'holder' => 'div',
					'heading' => esc_html__( 'Title Primary', 'studiare-plus' ),
					'param_name' => 'title_primary',
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'hint' => esc_html__( 'Provide the title for primary timeline item.', 'studiare-plus' )
				),
				array(
					'type' => 'textarea_html',
					'heading' => esc_html__( 'Content Primary', 'studiare-plus' ),
					'group' => esc_html__( 'Primary section', 'studiare-plus' ),
					'param_name' => 'content',
					'hint' => esc_html__( 'Provide the description for primary timeline item.', 'studiare-plus' )
				),
				/**
				 * Image
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Image', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'secondary_image_divider'
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image Secondary', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'image_secondary',
					'value' => '',
					'hint' => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image size', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'img_size_secondary',
					'hint' => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Content
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Content', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'secondary_content_divider'
				),
				array(
					'type' => 'textarea',
					'holder' => 'div',
					'heading' => esc_html__( 'Title Secondary', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'title_secondary',
					'hint' => esc_html__( 'Provide the title for secondary timeline item.', 'studiare-plus' ),
				),
				array(
					'type' => 'textarea',
					'heading' => esc_html__( 'Content Secondary', 'studiare-plus' ),
					'group' => esc_html__( 'Secondary section', 'studiare-plus' ),
					'param_name' => 'content_secondary',
					'hint' => esc_html__( 'Provide the description for secondary timeline item.', 'studiare-plus' )
				)
			),
		);
	}
}

if ( ! function_exists( 'woodmart_get_vc_map_timeline_breakpoint' ) ) {
	function woodmart_get_vc_map_timeline_breakpoint() {
		return array(
			'name' => esc_html__( 'Timeline breakpoint', 'studiare-plus'),
			'base' => 'woodmart_timeline_breakpoint',
			'as_child' => array( 'only' => 'woodmart_timeline' ),
			'content_element' => true,
			'category' => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon' => WOODMART_ASSETS . '/images/vc-icon/timeline-breakpoint.svg',
			'params' => array(
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Genaral options', 'studiare-plus' ),
					'param_name' => 'general_divider'
				),
				array(
					'type' => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id'
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'heading' => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title',
					'hint' => esc_html__( 'Provide the title for this timeline item.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_colorpicker',
					'heading' => esc_html__( 'Background color ', 'studiare-plus' ),
					'param_name' => 'color_bg',
					'css_args' => array(
						'background-color' => array(
							' .woodmart-timeline-breakpoint-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
				)
			),
		);
	}
}

// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if( class_exists( 'WPBakeryShortCodesContainer' ) ){
	class WPBakeryShortCode_woodmart_timeline extends WPBakeryShortCodesContainer {}
}

// Replace Wbc_Inner_Item with your base name from mapping for nested element
if( class_exists( 'WPBakeryShortCode' ) ){
	class WPBakeryShortCode_woodmart_timeline_item extends WPBakeryShortCode {}
}
