<?php
/**
 * Maps for tabs element.
 *
 * @package Elements.
 */

if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

if ( ! function_exists( 'woodmart_get_vc_map_tabs' ) ) {
	/**
	 * Displays the shortcode settings fields in the admin.
	 */
	function woodmart_get_vc_map_tabs() {
		$typography = woodmart_get_typography_map(
			array(
				'title'    => esc_html__( 'Title typography', 'studiare-plus' ),
				'group'    => esc_html__( 'General', 'studiare-plus' ),
				'key'      => 'heading_title',
				'selector' => '{{WRAPPER}}.wd-wpb.wd-tabs .tabs-name',
			)
		);

		$secondary_font = woodmart_get_opt( 'secondary-font' );
		$primary_font   = woodmart_get_opt( 'primary-font' );
		$text_font      = woodmart_get_opt( 'text-font' );

		$secondary_font_title = isset( $secondary_font[0]['font-family'] ) ? esc_html__( 'Secondary font', 'studiare-plus' ) . ' (' . $secondary_font[0]['font-family'] . ')' : esc_html__( 'Secondary font', 'studiare-plus' );
		$text_font_title      = isset( $text_font[0]['font-family'] ) ? esc_html__( 'Text font', 'studiare-plus' ) . ' (' . $text_font[0]['font-family'] . ')' : esc_html__( 'Text', 'studiare-plus' );
		$primary_font_title   = isset( $primary_font[0]['font-family'] ) ? esc_html__( 'Title font', 'studiare-plus' ) . ' (' . $primary_font[0]['font-family'] . ')' : esc_html__( 'Title font', 'studiare-plus' );

		return array(
			'base'            => 'woodmart_tabs',
			'name'            => esc_html__( 'Tabs', 'studiare-plus' ),
			'description'     => esc_html__( 'Tabbed content', 'studiare-plus' ),
			'category'        => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/tabs.svg',
			'as_parent'       => array( 'only' => 'woodmart_tab' ),
			'content_element' => true,
			'js_view'         => 'VcColumnView',
			'default_content' => '[woodmart_tab title="Tab #1"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/woodmart_tab][woodmart_tab title="Tab #2"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. 2[/woodmart_tab]',
			'params'          => array(
				/**
				 * General tab.
				 * Heading section.
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Heading', 'studiare-plus' ),
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'param_name' => 'woodmart_css_id',
					'type'       => 'woodmart_css_id',
					'group'      => esc_html__( 'General', 'studiare-plus' ),
				),
				array(
					'heading'          => esc_html__( 'Design', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'woodmart_image_select',
					'param_name'       => 'design',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'simple',
						esc_html__( 'Space between', 'studiare-plus' ) => 'alt',
						esc_html__( 'Aside', 'studiare-plus' ) => 'aside',
					),
					'images_value'     => array(
						'default' => WOODMART_ASSETS_IMAGES . '/settings/ajax-tabs/default.png',
						'simple'  => WOODMART_ASSETS_IMAGES . '/settings/ajax-tabs/simple.png',
						'alt'     => WOODMART_ASSETS_IMAGES . '/settings/ajax-tabs/alternative.png',
						'aside'   => WOODMART_ASSETS_IMAGES . '/settings/ajax-tabs/aside.png',
					),
					'std'              => 'default',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-xs-12 vc_column tab-design',
				),
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'tabs_side_width',
					'heading'          => esc_html__( 'Side width', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 100,
							'max'  => 500,
							'step' => 1,
						),
						'%'  => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs' => array(
							'--wd-side-width: {{VALUE}}{{UNIT}};',
						),
					),
					'dependency'       => array(
						'element' => 'design',
						'value'   => array( 'aside' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'tabs_title_space_between_vertical',
					'heading'          => esc_html__( 'Spacing', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 0,
							'max'  => 150,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs' => array(
							'--wd-row-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'woodmart_switch',
					'param_name'       => 'enable_heading_bg',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'heading_bg',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs.wd-header-with-bg .wd-tabs-header' => array(
							'background-color:{{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'enable_heading_bg',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
				),
				array(
					'param_name'       => 'tabs_title_alignment',
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'center',
					'dependency'       => array(
						'element' => 'design',
						'value'   => array( 'default' ),
					),
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space_2',
				),
				$typography['font_family'],
				$typography['font_size'],
				$typography['font_weight'],
				$typography['text_transform'],
				$typography['font_style'],
				$typography['line_height'],
				array(
					'heading'          => esc_html__( 'Title color', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_title_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .tabs-name' => array(
							'color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Title border color', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_border_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs.tabs-design-simple .tabs-name' => array(
							'border-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'design',
						'value'   => array( 'simple' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Description color', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_description_color',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-tabs-desc' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'design',
						'value'   => array( 'default', 'aside' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * General tab.
				 * Heading content section.
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Heading content', 'studiare-plus' ),
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'studiare-plus' ),
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'param_name' => 'title',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Title image', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Images size', 'studiare-plus' ),
					'group'            => esc_html__( 'General', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Description', 'studiare-plus' ),
					'group'      => esc_html__( 'General', 'studiare-plus' ),
					'param_name' => 'description',
					'dependency' => array(
						'element' => 'design',
						'value'   => array( 'default', 'aside' ),
					),
				),
				/**
				 * Navigation tab.
				 * Items section.
				 */
				array(
					'param_name' => 'tabs_layout_divider',
					'type'       => 'woodmart_title_divider',
					'title'      => esc_html__( 'Items', 'studiare-plus' ),
					'group'      => esc_html__( 'Navigation', 'studiare-plus' ),
					'holder'     => 'div',
				),
				array(
					'param_name'       => 'tabs_style',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Style', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' )   => 'default',
						esc_html__( 'Underline', 'studiare-plus' ) => 'underline',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Navigation tab.
				 * Items tabs.
				 */
				array(
					'type'       => 'woodmart_button_set',
					'group'      => esc_html__( 'Navigation', 'studiare-plus' ),
					'param_name' => 'tabs_color_tabs',
					'tabs'       => true,
					'value'      => array(
						esc_html__( 'Idle', 'studiare-plus' )   => 'idle',
						esc_html__( 'Hover', 'studiare-plus' )  => 'hover',
						esc_html__( 'Active', 'studiare-plus' ) => 'active',
					),
					'default'    => 'idle',
				),
				/**
				 * Color.
				 */
				array(
					'heading'       => esc_html__( 'Color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_title_text_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_text_hover_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-color-hover: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_text_active_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-color-active: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
				),
				/**
				 * Background color.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'tabs_bg_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_bg_color_idle',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-bg: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'       => array(
						'element' => 'tabs_bg_color_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'tabs_bg_hover_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_bg_color_hover',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-bg-hover: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'       => array(
						'element' => 'tabs_bg_hover_color_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'param_name'       => 'tabs_bg_active_color_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'tabs_bg_color_active',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-bg-active: {{VALUE}};',
						),
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'       => array(
						'element' => 'tabs_bg_active_color_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'group'      => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space_3',
				),
				/**
				 * Border idle.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'tabs_border_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'tabs_border_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li > a' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'       => array(
						'element' => 'tabs_border_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'tabs_border_width',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li > a' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_title_border_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li > a' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border radius', 'studiare-plus' ),
					'param_name'    => 'tabs_border_radius',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-radius: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Border hover.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'tabs_border_hover_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'tabs_border_hover_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li:hover > a' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'       => array(
						'element' => 'tabs_border_hover_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'tabs_border_hover_width',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li:hover > a' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_hover_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_border_hover_color',
					'selectors'     => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li:hover > a' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_hover_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Border active.
				 */
				array(
					'type'             => 'woodmart_switch',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Border', 'studiare-plus' ),
					'param_name'       => 'tabs_border_active_enable',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'tabs_border_active_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}} :is(.wd-wpb.wd-tabs .wd-nav-tabs > li.wd-active > a, .wd-wpb.wd-tabs:not(.wd-inited) .wd-nav-tabs>li:first-child>a)' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )   => 'none',
						esc_html__( 'Solid', 'studiare-plus' )  => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' ) => 'dotted',
						esc_html__( 'Double', 'studiare-plus' ) => 'double',
						esc_html__( 'Dashed', 'studiare-plus' ) => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' ) => 'groove',
					),
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'       => array(
						'element' => 'tabs_border_active_enable',
						'value'   => array( 'yes' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'          => 'wd_slider',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Border width', 'studiare-plus' ),
					'param_name'    => 'tabs_border_active_width',
					'selectors'     => array(
						'{{WRAPPER}} :is(.wd-wpb.wd-tabs .wd-nav-tabs > li.wd-active > a, .wd-wpb.wd-tabs:not(.wd-inited) .wd-nav-tabs>li:first-child>a)' => array(
							'border-width: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_active_enable',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Border color', 'studiare-plus' ),
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'          => 'wd_colorpicker',
					'param_name'    => 'tabs_border_active_color',
					'selectors'     => array(
						'{{WRAPPER}} :is(.wd-wpb.wd-tabs .wd-nav-tabs > li.wd-active > a, .wd-wpb.wd-tabs:not(.wd-inited) .wd-nav-tabs>li:first-child>a)' => array(
							'border-color: {{VALUE}};',
						),
					),
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'    => array(
						'element' => 'tabs_border_active_enable',
						'value'   => array( 'yes' ),
					),
				),
				/**
				 * Box shadow idle.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'tabs_box_shadow_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'tabs_box_shadow',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li > a' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'idle' ),
					),
					'dependency'       => array(
						'element' => 'tabs_box_shadow_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Box shadow hover.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'tabs_box_shadow_hover_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'tabs_box_shadow_hover',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs > li:hover > a' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'hover' ),
					),
					'dependency'       => array(
						'element' => 'tabs_box_shadow_hover_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Box shadow active.
				 */
				array(
					'type'          => 'woodmart_switch',
					'group'         => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'       => esc_html__( 'Box shadow', 'studiare-plus' ),
					'param_name'    => 'tabs_box_shadow_active_enable',
					'true_state'    => 'yes',
					'false_state'   => 'no',
					'default'       => 'no',
					'wd_dependency' => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
				),
				array(
					'type'             => 'wd_box_shadow',
					'param_name'       => 'tabs_box_shadow_active',
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'selectors'        => array(
						'{{WRAPPER}} :is(.wd-wpb.wd-tabs .wd-nav-tabs > li.wd-active > a, .wd-wpb.wd-tabs:not(.wd-inited) .wd-nav-tabs>li:first-child>a)' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'wd_dependency'    => array(
						'element' => 'tabs_color_tabs',
						'value'   => array( 'active' ),
					),
					'dependency'       => array(
						'element' => 'tabs_box_shadow_active_enable',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => 'rgba(0, 0, 0, .15)',
					),
				),
				/**
				 * Gap.
				 */
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'tabs_title_space_between_horizontal',
					'heading'          => esc_html__( 'Gap', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 0,
							'max'  => 150,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				/**
				 * Padding.
				 */
				array(
					'heading'    => esc_html__( 'Padding', 'studiare-plus' ),
					'group'      => esc_html__( 'Navigation', 'studiare-plus' ),
					'type'       => 'wd_dimensions',
					'param_name' => 'tabs_padding',
					'selectors'  => array(
						'{{WRAPPER}}.wd-wpb.wd-tabs .wd-nav-tabs' => array(
							'--nav-pd: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'      => array(
						'px' => array(),
					),
				),
				// Icons.
				array(
					'param_name'       => 'icon_position',
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Icon position', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Top', 'studiare-plus' )   => 'top',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
					),
					'images_value'     => array(
						'top'   => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/top.png',
						'left'  => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/left.png',
						'right' => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/right.png',
					),
					'std'              => 'left',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				/**
				 * Navigation tab.
				 * Typography section.
				 */
				array(
					'param_name' => 'tabs_typography_divider',
					'type'       => 'woodmart_title_divider',
					'title'      => esc_html__( 'Typography', 'studiare-plus' ),
					'group'      => esc_html__( 'Navigation', 'studiare-plus' ),
					'holder'     => 'div',
				),
				array(
					'param_name'       => 'tabs_title_font_family',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font family', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						$primary_font_title   => 'primary',
						$text_font_title      => 'text',
						$secondary_font_title => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_title_font_weight',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'std'              => 600,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_title_font_size',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Predefined size', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Small (16px)', 'studiare-plus' ) => 's',
						esc_html__( 'Extra Small (14px)', 'studiare-plus' ) => 'xs',
						esc_html__( 'Medium (18px)', 'studiare-plus' ) => 'm',
						esc_html__( 'Large (22px)', 'studiare-plus' ) => 'l',
						esc_html__( 'Extra Large (26px)', 'studiare-plus' ) => 'xl',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_title_custom_font_size',
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom font size', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'css_args'         => array(
						'font-size' => array(
							' .wd-fontsize-custom',
						),
					),
					'dependency'       => array(
						'element' => 'tabs_title_font_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_title_line_height',
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'css_args'         => array(
						'line-height' => array(
							' .wd-fontsize-custom',
						),
					),
					'dependency'       => array(
						'element' => 'tabs_title_font_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_title_color_scheme',
					'type'             => 'woodmart_dropdown',
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'group'            => esc_html__( 'Navigation', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
					),
					'style'            => array(
						'dark' => '#2d2a2a',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				/**
				 * Content tab.
				 * Typography section.
				 */
				array(
					'param_name' => 'content_typography_divider',
					'type'       => 'woodmart_title_divider',
					'title'      => esc_html__( 'Typography', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'holder'     => 'div',
				),
				array(
					'param_name'       => 'content_font_family',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font family', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						$primary_font_title   => 'primary',
						$text_font_title      => 'text',
						$secondary_font_title => 'alt',
					),
					'std'              => '',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'content_font_size',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Predefined size', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Small (16px)', 'studiare-plus' ) => 's',
						esc_html__( 'Extra Small (14px)', 'studiare-plus' ) => 'xs',
						esc_html__( 'Medium (18px)', 'studiare-plus' ) => 'm',
						esc_html__( 'Large (22px)', 'studiare-plus' ) => 'l',
						esc_html__( 'Extra Large (26px)', 'studiare-plus' ) => 'xl',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'content_custom_font_size',
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom font size', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'css_args'         => array(
						'font-size' => array(
							' .wd-fontsize-custom',
						),
					),
					'dependency'       => array(
						'element' => 'content_font_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'content_line_height',
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'css_args'         => array(
						'line-height' => array(
							' .wd-fontsize-custom',
						),
					),
					'dependency'       => array(
						'element' => 'content_font_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'content_font_weight',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'content_text_color_scheme',
					'type'             => 'woodmart_dropdown',
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
						esc_html__( 'Dark', 'studiare-plus' )   => 'dark',
						esc_html__( 'Light', 'studiare-plus' )  => 'light',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'style'            => array(
						'dark' => '#2d2a2a',
					),
					'std'              => 'inherit',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name' => 'content_text_color_custom',
					'type'       => 'woodmart_colorpicker',
					'heading'    => esc_html__( 'Custom Color', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'css_args'   => array(
						'color' => array(
							' .wd-tab-content',
						),
					),
					'dependency' => array(
						'element' => 'content_text_color_scheme',
						'value'   => array( 'custom' ),
					),

				),

				/**
				 * Design Options tab.
				 */
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),

				/**
				 * Advanced tab.
				 */
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Theme Animation', 'studiare-plus' ),
					'hint'             => esc_html__( 'Use custom theme animations if you want to run them in the slider element.', 'studiare-plus' ),
					'param_name'       => 'wd_animation',
					'group'            => esc_html__( 'Advanced', 'studiare-plus' ),
					'admin_label'      => true,
					'value'            => array(
						esc_html__( 'None', 'studiare-plus' ) => '',
						esc_html__( 'Slide from top', 'studiare-plus' ) => 'slide-from-top',
						esc_html__( 'Slide from bottom', 'studiare-plus' ) => 'slide-from-bottom',
						esc_html__( 'Slide from left', 'studiare-plus' ) => 'slide-from-left',
						esc_html__( 'Slide from right', 'studiare-plus' ) => 'slide-from-right',
						esc_html__( 'Slide short from left', 'studiare-plus' ) => 'slide-short-from-left',
						esc_html__( 'Slide short from right', 'studiare-plus' ) => 'slide-short-from-right',
						esc_html__( 'Flip X bottom', 'studiare-plus' ) => 'bottom-flip-x',
						esc_html__( 'Flip X top', 'studiare-plus' ) => 'top-flip-x',
						esc_html__( 'Flip Y left', 'studiare-plus' ) => 'left-flip-y',
						esc_html__( 'Flip Y right', 'studiare-plus' ) => 'right-flip-y',
						esc_html__( 'Zoom in', 'studiare-plus' ) => 'zoom-in',
					),
					'std'              => '',
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Theme Animation Delay (ms)', 'studiare-plus' ),
					'param_name'       => 'wd_animation_delay',
					'group'            => esc_html__( 'Advanced', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'dependency'       => array(
						'element'            => 'wd_animation',
						'value_not_equal_to' => array( '' ),
					),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Theme Animation duration', 'studiare-plus' ),
					'param_name'       => 'wd_animation_duration',
					'group'            => esc_html__( 'Advanced', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'value'            => array(
						esc_html__( 'Slow', 'studiare-plus' )   => 'slow',
						esc_html__( 'Normal', 'studiare-plus' ) => 'normal',
						esc_html__( 'Fast', 'studiare-plus' )   => 'fast',
					),
					'dependency'       => array(
						'element'            => 'wd_animation',
						'value_not_equal_to' => array( '' ),
					),
					'std'              => 'normal',
				),
				woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ),
				woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ),
			),
		);
	}
}

if ( ! function_exists( 'woodmart_get_vc_map_tab' ) ) {
	function woodmart_get_vc_map_tab() {
		return array(
			'base'            => 'woodmart_tab',
			'name'            => esc_html__( 'Tab', 'studiare-plus' ),
			'description'     => esc_html__( 'Add tab in tabs area', 'studiare-plus' ),
			'category'        => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/tab.svg',
			'as_child'        => array( 'only' => 'woodmart_tabs' ),
			'content_element' => true,
			'params'          => array(
				/**
				 * Title.
				 */
				array(
					'param_name' => 'title',
					'type'       => 'textarea',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Title', 'studiare-plus' ),
				),
				/**
				 * Content.
				 */
				array(
					'param_name' => 'tabs_content_divider',
					'type'       => 'woodmart_title_divider',
					'title'      => esc_html__( 'Content', 'studiare-plus' ),
				),
				array(
					'param_name'       => 'content_type',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Content type', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Text', 'studiare-plus' ) => 'text',
						esc_html__( 'HTML Block', 'studiare-plus' ) => 'html_block',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name' => 'content',
					'type'       => 'textarea_html',
					'heading'    => esc_html__( 'Content', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'content_type',
						'value'   => array( 'text' ),
					),
				),
				array(
					'param_name' => 'html_block_id',
					'type'       => 'woodmart_dropdown',
					'heading'    => esc_html__( 'Select block', 'studiare-plus' ),
					'callback'   => 'woodmart_get_html_blocks_array_with_empty',
					'dependency' => array(
						'element' => 'content_type',
						'value'   => array( 'html_block' ),
					),
				),

				/**
				 * Icon.
				 */
				array(
					'param_name' => 'icon_divider',
					'type'       => 'woodmart_title_divider',
					'title'      => esc_html__( 'Icon settings', 'studiare-plus' ),
					'holder'     => 'div',
				),
				array(
					'param_name'       => 'tabs_title_icon_type',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'List type', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'With icon', 'studiare-plus' ) => 'icon',
						esc_html__( 'With image', 'studiare-plus' ) => 'image',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_image',
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'value'            => '',
					'dependency'       => array(
						'element' => 'tabs_title_icon_type',
						'value'   => array( 'image' ),
					),
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_image_size',
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'tabs_title_icon_type',
						'value'   => array( 'image' ),
					),
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name'       => 'tabs_icon_libraries',
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Icon library', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Font Awesome', 'studiare-plus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'studiare-plus' ) => 'openiconic',
						esc_html__( 'Typicons', 'studiare-plus' ) => 'typicons',
						esc_html__( 'Entypo', 'studiare-plus' ) => 'entypo',
						esc_html__( 'Linecons', 'studiare-plus' ) => 'linecons',
						esc_html__( 'Mono Social', 'studiare-plus' ) => 'monosocial',
						esc_html__( 'Material', 'studiare-plus' ) => 'material',
					),
					'dependency'       => array(
						'element' => 'tabs_title_icon_type',
						'value'   => 'icon',
					),
					'hint'             => esc_html__( 'Select icon library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'param_name' => 'icon_fontawesome',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'fontawesome',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'param_name' => 'icon_openiconic',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'openiconic',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'openiconic',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'param_name' => 'icon_typicons',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'typicons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'typicons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'param_name' => 'icon_entypo',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'entypo',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'entypo',
					),
				),
				array(
					'param_name' => 'icon_linecons',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'linecons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'linecons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'param_name' => 'icon_monosocial',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'monosocial',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'monosocial',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'param_name' => 'icon_material',
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'material',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'tabs_icon_libraries',
						'value'   => 'material',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
			),
		);
	}
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Create woodmart tabs wrapper.
	 */
	class WPBakeryShortCode_woodmart_tabs extends WPBakeryShortCodesContainer {}
}
