<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
 * ------------------------------------------------------------------------------------------------
 * Section table element map
 * ------------------------------------------------------------------------------------------------
 */

if ( ! function_exists( 'woodmart_get_vc_map_table' ) ) {
	function woodmart_get_vc_map_table() {
		return array(
			'name'            => esc_html__( 'Table', 'studiare-plus' ),
			'base'            => 'woodmart_table',
			'as_parent'       => array( 'only' => 'woodmart_table_row' ),
			'content_element' => true,
			'category'        => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'description'     => esc_html__( 'Customizable HTML table', 'studiare-plus' ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/table.svg',
			'js_view'         => 'VcColumnView',
			'params'          => array(
				array(
					'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'alignment',
					'style'            => 'images',
					'selectors'        => array(),
					'devices'          => array(
						'desktop' => array(
							'value' => 'left',
						),
					),
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images'           => array(
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				// Background.
				array(
					'title'      => esc_html__( 'Background', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'background_divider',
				),

				array(
					'param_name' => 'background_type',
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Background type', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Body', 'studiare-plus' ) => 'body',
						__( 'Horizontal even & odd', 'studiare-plus' )  => 'h_even_odd',
						__( 'Vertical even & odd', 'studiare-plus' )  => 'v_even_odd',
					),
					'std'        => 'body',
				),

				array(
					'heading'          => esc_html__( 'Body background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'body_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th, {{WRAPPER}} .wd-el-table td' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'body' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Body text color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'body_text_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th, {{WRAPPER}} .wd-el-table td' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'body' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Horizontal even background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'h_even_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table tr:nth-child(even)' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'h_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Horizontal odd background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'h_odd_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table tr:nth-child(odd)' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'h_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Horizontal even text color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'h_even_text_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table tr:nth-child(even)' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'h_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Horizontal odd text color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'h_odd_text_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table tr:nth-child(odd)' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'h_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Vertical even background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'v_even_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th:nth-child(even), {{WRAPPER}} .wd-el-table td:nth-child(even)' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'v_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Vertical odd background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'v_odd_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th:nth-child(odd), {{WRAPPER}} .wd-el-table td:nth-child(odd)' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'v_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Vertical even text color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'v_even_text_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th:nth-child(even), {{WRAPPER}} .wd-el-table td:nth-child(even)' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'v_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Vertical odd text color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'v_odd_text_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-table th:nth-child(odd), {{WRAPPER}} .wd-el-table td:nth-child(odd)' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'background_type',
						'value'   => array( 'v_even_odd' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				// Border.
				array(
					'title'      => esc_html__( 'Border', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'border_divider',
				),

				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'border_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )    => 'none',
						esc_html__( 'Solid', 'studiare-plus' )   => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' )  => 'dotted',
						esc_html__( 'Double', 'studiare-plus' )  => 'double',
						esc_html__( 'Dashed', 'studiare-plus' )  => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' )  => 'groove',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Border color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'border_color',
					'selectors'        => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'Border width', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'wd_dimensions',
					'param_name' => 'border_width',
					'selectors'  => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-top-width: {{TOP}}px;',
							'border-right-width: {{RIGHT}}px;',
							'border-bottom-width: {{BOTTOM}}px;',
							'border-left-width: {{LEFT}}px;',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'      => array(
						'px' => array(),
					),
				),

				// Padding.
				array(
					'title'      => esc_html__( 'Padding', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'padding_divider',
				),

				array(
					'heading'    => esc_html__( 'Table cell padding', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'wd_dimensions',
					'param_name' => 'table_cell_padding',
					'selectors'  => array(
						'{{WRAPPER}} .wd-el-table th, {{WRAPPER}} .wd-el-table td' => array(
							'padding-top: {{TOP}}px;',
							'padding-right: {{RIGHT}}px;',
							'padding-bottom: {{BOTTOM}}px;',
							'padding-left: {{LEFT}}px;',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'      => array(
						'px' => array(),
					),
				),

				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),

				/**
				 * Advanced Tab.
				 */
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
			'default_content' => '[woodmart_table_row table_column="%5B%7B%22column_content%22%3A%22Heading%20%231%22%2C%22column_cell_type%22%3A%22heading%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Heading%20%232%22%2C%22column_cell_type%22%3A%22heading%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Heading%20%233%22%2C%22column_cell_type%22%3A%22heading%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Heading%20%234%22%2C%22column_cell_type%22%3A%22heading%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%5D" ][woodmart_table_row table_column="%5B%7B%22column_content%22%3A%22Row%20%231%20Content%20%231%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%231%20Content%20%232%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%231%20Content%20%233%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%231%20Content%20%234%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%5D" ][woodmart_table_row table_column="%5B%7B%22column_content%22%3A%22Row%20%232%20Content%20%231%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%232%20Content%20%232%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%232%20Content%20%233%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%232%20Content%20%234%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%5D" ][woodmart_table_row table_column="%5B%7B%22column_content%22%3A%22Row%20%233%20Content%20%231%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%233%20Content%20%232%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%233%20Content%20%233%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%2C%7B%22column_content%22%3A%22Row%20%233%20Content%20%234%22%2C%22column_cell_type%22%3A%22default%22%2C%22column_cell_span%22%3A%221%22%2C%22column_cell_row%22%3A%221%22%7D%5D" ]',
		);
	}
}

if ( ! function_exists( 'woodmart_get_vc_map_table_row' ) ) {
	function woodmart_get_vc_map_table_row() {
		$typography = woodmart_get_typography_map(
			array(
				'key'      => 'table_row',
				'selector' => '{{WRAPPER}} th, {{WRAPPER}} td',
				'group'    => esc_html__( 'Settings', 'studiare-plus' ),
			)
		);

		return array(
			'name'            => esc_html__( 'Table row', 'studiare-plus' ),
			'base'            => 'woodmart_table_row',
			'as_child'        => array( 'only' => 'woodmart_table' ),
			'content_element' => true,
			'category'        => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/wpb-table-element-row.svg',
			'params'          => array(
				array(
					'type'       => 'param_group',
					'param_name' => 'table_column',
					'group'      => esc_html__( 'Column', 'studiare-plus' ),
					'params'     => array(
						array(
							'type'       => 'textarea',
							'heading'    => esc_html__( 'Content', 'studiare-plus' ),
							'param_name' => 'column_content',
						),
						array(
							'param_name'       => 'column_cell_type',
							'type'             => 'dropdown',
							'heading'          => esc_html__( 'Cell Type', 'studiare-plus' ),
							'value'            => array(
								esc_html__( 'Default', 'studiare-plus' ) => 'default',
								esc_html__( 'Heading', 'studiare-plus' ) => 'heading',
							),
							'std'              => 'default',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'param_name'       => 'row_item_alignment',
							'type'             => 'dropdown',
							'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
							'value'            => array(
								esc_html__( 'Inherit', 'studiare-plus' )   => '',
								esc_html__( 'Left', 'studiare-plus' )   => 'left',
								esc_html__( 'Center', 'studiare-plus' ) => 'center',
								esc_html__( 'Right', 'studiare-plus' )  => 'right',
							),
							'std'              => '',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'heading'          => esc_html__( 'Column Span', 'studiare-plus' ),
							'param_name'       => 'column_cell_span',
							'type'             => 'textfield',
							'value'            => '1',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'heading'          => esc_html__( 'Row Span', 'studiare-plus' ),
							'param_name'       => 'column_cell_row',
							'type'             => 'textfield',
							'value'            => '1',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'heading'          => esc_html__( 'Color', 'studiare-plus' ),
							'type'             => 'wd_colorpicker',
							'param_name'       => 'row_item_color',
							'selectors'        => array(),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
							'type'             => 'wd_colorpicker',
							'param_name'       => 'row_item_bg_color',
							'selectors'        => array(),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
					),
				),
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
				),

				array(
					'title'      => esc_html__( 'General', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'general_divider',
				),

				$typography['font_family'],
				$typography['font_size'],
				$typography['font_weight'],
				$typography['text_transform'],
				$typography['font_style'],
				$typography['line_height'],

				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'table_row_color',
					'selectors'        => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'table_row_bg_color',
					'selectors'        => array(
						'{{WRAPPER}}' => array(
							'background-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				// Border.
				array(
					'title'      => esc_html__( 'Border', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'woodmart_title_divider',
					'param_name' => 'border_divider',
				),

				array(
					'heading'          => esc_html__( 'Border type', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_select',
					'param_name'       => 'border_type',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-style: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'None', 'studiare-plus' )    => 'none',
						esc_html__( 'Solid', 'studiare-plus' )   => 'solid',
						esc_html__( 'Dotted', 'studiare-plus' )  => 'dotted',
						esc_html__( 'Double', 'studiare-plus' )  => 'double',
						esc_html__( 'Dashed', 'studiare-plus' )  => 'dashed',
						esc_html__( 'Groove', 'studiare-plus' )  => 'groove',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Border color', 'studiare-plus' ),
					'group'            => esc_html__( 'Settings', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'border_color',
					'selectors'        => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'    => esc_html__( 'Border width', 'studiare-plus' ),
					'group'      => esc_html__( 'Settings', 'studiare-plus' ),
					'type'       => 'wd_dimensions',
					'param_name' => 'border_width',
					'selectors'  => array(
						'{{WRAPPER}} th, {{WRAPPER}} td' => array(
							'border-top-width: {{TOP}}px;',
							'border-right-width: {{RIGHT}}px;',
							'border-bottom-width: {{BOTTOM}}px;',
							'border-left-width: {{LEFT}}px;',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'unit' => 'px',
						),
					),
					'range'      => array(
						'px' => array(),
					),
				),
			),
		);
	}
}

// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_woodmart_table extends WPBakeryShortCodesContainer {}
}

// Replace Wbc_Inner_Item with your base name from mapping for nested element
if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_woodmart_table_row extends WPBakeryShortCode {}
}
