<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
* Social buttons element map
* ------------------------------------------------------------------------------------------------
*/

if( ! function_exists( 'woodmart_get_social_buttons_shortcode_args' ) ) {
	function woodmart_get_social_buttons_shortcode_args() {
		return array(
			'name' => esc_html__( 'Social buttons', 'studiare-plus' ),
			'base' => 'social_buttons',
			'category' => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ? woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description' => esc_html__( 'Follow or share buttons', 'studiare-plus' ),
        	'icon' => WOODMART_ASSETS . '/images/vc-icon/social-buttons.svg',
			'params' => woodmart_get_social_shortcode_params()
		);
	}
}

if( ! function_exists( 'woodmart_get_social_shortcode_params' ) ) {
	function woodmart_get_social_shortcode_params() {
		$typography = array();

		if ( function_exists( 'woodmart_get_typography_map' ) ) {
			$typography = woodmart_get_typography_map(
				array(
					'key'        => 'label',
					'selector'   => '{{WRAPPER}}.wd-social-icons .wd-label',
					'dependency' => array(
						'element' => 'show_label',
						'value'   => 'yes',
					),
					'group'      => esc_html__( 'Style', 'js_composer' ),
				)
			);
		}

		return apply_filters( 'woodmart_get_social_shortcode_params', array(
			/**
			* Type
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'General', 'studiare-plus' ),
				'param_name' => 'type_divider'
			),

			array(
				'type'       => 'woodmart_css_id',
				'param_name' => 'woodmart_css_id',
			),

			array(
				'heading'          => esc_html__( 'Label', 'studiare-plus' ),
				'type'             => 'woodmart_switch',
				'param_name'       => 'show_label',
				'true_state'       => 'yes',
				'false_state'      => 'no',
				'default'          => 'no',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),

			array(
				'heading'          => esc_html__( 'Label text', 'studiare-plus' ),
				'type'             => 'textfield',
				'param_name'       => 'label_text',
				'value'            => esc_html__( 'Share: ', 'studiare-plus' ),
				'dependency'       => array(
					'element' => 'show_label',
					'value'   => 'yes',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),

			array(
				'type'             => 'woodmart_button_set',
				'heading'          => esc_html__( 'Buttons type', 'studiare-plus' ),
				'param_name'       => 'type',
				'value'            => array(
					esc_html__( 'Share', 'studiare-plus' )  => 'share',
					esc_html__( 'Follow', 'studiare-plus' ) => 'follow',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),

			array(
				'type'             => 'woodmart_button_set',
				'heading'          => esc_html__( 'Social links source', 'studiare-plus' ),
				'param_name'       => 'social_links_source',
				'value'            => array(
					esc_html__( 'Theme settings', 'studiare-plus' ) => 'theme_settings',
					esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
				),
				'dependency'       => array(
					'element' => 'type',
					'value'   => 'follow',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),

			/**
			 * Links to social profiles.
			 */
			array(
				'type'       => 'woodmart_title_divider',
				'holder'     => 'div',
				'title'      => esc_html__( 'Links to social profiles', 'studiare-plus' ),
				'param_name' => 'social_links_divider',
				'dependency' => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Facebook link', 'studiare-plus' ),
				'param_name'       => 'fb_link',
				'std'              => '#',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'X link', 'studiare-plus' ),
				'param_name'       => 'twitter_link',
				'std'              => '#',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Bluesky link', 'studiare-plus' ),
				'param_name'       => 'bluesky_link',
				'std'              => '',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Instagram link', 'studiare-plus' ),
				'param_name'       => 'isntagram_link',
				'std'              => '#',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Threads link', 'studiare-plus' ),
				'param_name'       => 'threads_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Pinterest link', 'studiare-plus' ),
				'param_name'       => 'pinterest_link',
				'std'              => '#',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'YouTube link', 'studiare-plus' ),
				'param_name'       => 'youtube_link',
				'std'              => '#',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Tumblr link', 'studiare-plus' ),
				'param_name'       => 'tumblr_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'LinkedIn link', 'studiare-plus' ),
				'param_name'       => 'linkedin_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Vimeo link', 'studiare-plus' ),
				'param_name'       => 'vimeo_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Flickr link', 'studiare-plus' ),
				'param_name'       => 'flickr_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Github link', 'studiare-plus' ),
				'param_name'       => 'github_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Dribbble link', 'studiare-plus' ),
				'param_name'       => 'dribbble_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Behance link', 'studiare-plus' ),
				'param_name'       => 'behance_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'SoundCloud link', 'studiare-plus' ),
				'param_name'       => 'soundcloud_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Spotify link', 'studiare-plus' ),
				'param_name'       => 'spotify_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'WhatsApp link', 'studiare-plus' ),
				'param_name'       => 'whatsapp_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Snapchat link', 'studiare-plus' ),
				'param_name'       => 'snapchat_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Telegram link', 'studiare-plus' ),
				'param_name'       => 'tg_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Viber link', 'studiare-plus' ),
				'param_name'       => 'viber_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'TikTok link', 'studiare-plus' ),
				'param_name'       => 'tiktok_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Discord link', 'studiare-plus' ),
				'param_name'       => 'discord_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Yelp link', 'studiare-plus' ),
				'param_name'       => 'yelp_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'VK link', 'studiare-plus' ),
				'param_name'       => 'vk_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'OK link', 'studiare-plus' ),
				'param_name'       => 'ok_link',
				'save_always'      => true,
				'dependency'       => array(
					'element' => 'social_links_source',
					'value'   => 'custom',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),

			/**
			* Extra
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Extra options', 'studiare-plus' ),
				'param_name' => 'extra_divider'
			),
			( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
				'param_name' => 'el_class',
				'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
			),

			/**
			 * Style tab.
			 */
			// General.
			array(
				'type'       => 'woodmart_title_divider',
				'holder'     => 'div',
				'title'      => esc_html__( 'General', 'studiare-plus' ),
				'param_name' => 'style_general_divider',
				'group'      => esc_html__( 'Style', 'js_composer' ),
			),
			array(
				'heading'          => esc_html__( 'Layout', 'studiare-plus' ),
				'type'             => 'dropdown',
				'param_name'       => 'layout',
				'value'            => array(
					esc_html__( 'Default', 'studiare-plus' ) => 'default',
					esc_html__( 'Inline', 'studiare-plus' )  => 'inline',
					esc_html__( 'Justify', 'studiare-plus' ) => 'justify',
				),
				'dependency'       => array(
					'element' => 'show_label',
					'value'   => 'yes',
				),
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'woodmart_image_select',
				'heading'          => esc_html__( 'Align ', 'studiare-plus' ),
				'param_name'       => 'align',
				'value'            => array(
					esc_html__( 'Left', 'studiare-plus' )   => 'left',
					esc_html__( 'Center', 'studiare-plus' ) => 'center',
					esc_html__( 'Right', 'studiare-plus' )  => 'right',
				),
				'images_value'     => array(
					'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
					'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
					'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
				),
				'std'              => 'center',
				'wood_tooltip'     => true,
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
			),
			// Icons.
			array(
				'type'       => 'woodmart_title_divider',
				'holder'     => 'div',
				'title'      => esc_html__( 'Icons', 'studiare-plus' ),
				'param_name' => 'style_icons_divider',
				'group'      => esc_html__( 'Style', 'js_composer' ),
			),

			array(
				'type'             => 'woodmart_image_select',
				'heading'          => esc_html__( 'Button style', 'studiare-plus' ),
				'param_name'       => 'style',
				'value'            => array(
					esc_html__( 'Default', 'studiare-plus' )  => '',
					esc_html__( 'Simple', 'studiare-plus' )   => 'simple',
					esc_html__( 'Colored', 'studiare-plus' )  => 'colored',
					esc_html__( 'Colored alternative', 'studiare-plus' ) => 'colored-alt',
					esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
					esc_html__( 'Primary color', 'studiare-plus' ) => 'primary',
				),
				'images_value'     => array(
					''            => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/default.png',
					'simple'      => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/simple.png',
					'colored'     => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/colored.png',
					'colored-alt' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/colored-alt.png',
					'bordered'    => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/bordered.png',
					'primary'     => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/style/primary.png',
				),
				'wood_tooltip'     => true,
				'std'              => '',
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-xs-12 vc_column social-style',
			),
			array(
				'type'             => 'woodmart_image_select',
				'heading'          => esc_html__( 'Button shape', 'studiare-plus' ),
				'param_name'       => 'form',
				'value'            => array(
					esc_html__( 'Circle', 'studiare-plus' )  => 'circle',
					esc_html__( 'Square', 'studiare-plus' )  => 'square',
					esc_html__( 'Rounded', 'studiare-plus' ) => 'rounded',
				),
				'images_value'     => array(
					'circle'  => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/circle.png',
					'square'  => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/square.png',
					'rounded' => WOODMART_ASSETS_IMAGES . '/settings/social-buttons/shape/rounded.png',
				),
				'wood_tooltip'     => true,
				'std'              => 'circle',
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-xs-12 vc_column social-form',
			),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__( 'Buttons size', 'studiare-plus' ),
				'param_name'       => 'size',
				'value'            => array(
					esc_html__( 'Default', 'studiare-plus' ) => '',
					esc_html__( 'Small', 'studiare-plus' )   => 'small',
					esc_html__( 'Large', 'studiare-plus' )   => 'large',
				),
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type'             => 'woodmart_button_set',
				'heading'          => esc_html__( 'Color', 'studiare-plus' ),
				'param_name'       => 'color',
				'value'            => array(
					esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					esc_html__( 'Light', 'studiare-plus' ) => 'light',
				),
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'default'          => 'dark',
				'save_always'      => true,
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			// Label.
			array(
				'type'       => 'woodmart_title_divider',
				'holder'     => 'div',
				'title'      => esc_html__( 'Label', 'studiare-plus' ),
				'param_name' => 'style_label_divider',
				'dependency' => array(
					'element' => 'show_label',
					'value'   => 'yes',
				),
				'group'      => esc_html__( 'Style', 'js_composer' ),
			),
			function_exists( 'woodmart_get_typography_map' ) ? $typography['font_family'] : '',
			function_exists( 'woodmart_get_typography_map' ) ? $typography['font_size'] : '',
			function_exists( 'woodmart_get_typography_map' ) ? $typography['font_weight'] : '',
			function_exists( 'woodmart_get_typography_map' ) ? $typography['text_transform'] : '',
			function_exists( 'woodmart_get_typography_map' ) ? $typography['font_style'] : '',
			function_exists( 'woodmart_get_typography_map' ) ? $typography['line_height'] : '',
			array(
				'heading'          => esc_html__( 'Label color', 'studiare-plus' ),
				'type'             => 'wd_colorpicker',
				'param_name'       => 'label_color',
				'selectors'        => array(
					'{{WRAPPER}}.wd-social-icons .wd-label' => array(
						'color: {{VALUE}};',
					),
				),
				'dependency'       => array(
					'element' => 'show_label',
					'value'   => 'yes',
				),
				'group'            => esc_html__( 'Style', 'js_composer' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			/**
			 * Design Options tab.
			 */
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'js_composer' ),
			),
			function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',

			/**
			 * Advanced tab.
			 */

			// Width option (with dependency Columns option, responsive).
			woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
			woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
			woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
			woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
			woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
			woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
			woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
		) );
	}
}
