<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
* ------------------------------------------------------------------------------------------------
* Promo Banner element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_promo_banner' ) ) {
	function woodmart_get_vc_map_promo_banner() {
		return array(
			'name'        => esc_html__( 'Promo Banner', 'studiare-plus' ),
			'base'        => 'promo_banner',
			'class'       => '',
			'category'    => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ?
				woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description' => esc_html__( 'Promo image with text and hover effect', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/promo-banner.svg',
			'params'      => woodmart_get_banner_params(),
		);
	}
}

if ( ! function_exists( 'woodmart_get_vc_map_banners_carousel' ) ) {
	function woodmart_get_vc_map_banners_carousel() {
		return array(
			'name'                    => esc_html__( 'Banners carousel', 'studiare-plus' ),
			'base'                    => 'banners_carousel',
			'as_parent'               => array( 'only' => 'promo_banner' ),
			'content_element'         => true,
			'show_settings_on_create' => true,
			'category'                => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ?
				woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description'             => esc_html__( 'Show your banners as a carousel', 'studiare-plus' ),
			'icon'                    => WOODMART_ASSETS . '/images/vc-icon/banners-carousel.svg',
			'params'                  => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Carousel', 'studiare-plus' ),
					'param_name' => 'slider_divider',
				),

				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'group'      => esc_html__( 'Advanced', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'group'      => esc_html__( 'Advanced', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
			),
			'js_view'                 => 'VcColumnView',
		);
	}
}

if ( ! function_exists( 'woodmart_get_banner_params' ) ) {
	function woodmart_get_banner_params() {
		$secondary_font = woodmart_get_opt( 'secondary-font' );
		$text_font      = woodmart_get_opt( 'text-font' );
		$primary_font   = woodmart_get_opt( 'primary-font' );

		$secondary_font_title = isset( $secondary_font[0]['font-family'] ) ? esc_html__( 'Secondary font', 'studiare-plus' ) . ' (' . $secondary_font[0]['font-family'] . ')' : esc_html__( 'Secondary font', 'studiare-plus' );
		$text_font_title      = isset( $text_font[0]['font-family'] ) ? esc_html__( 'Text font', 'studiare-plus' ) . ' (' . $text_font[0]['font-family'] . ')' : esc_html__( 'Text', 'studiare-plus' );
		$primary_font_title   = isset( $primary_font[0]['font-family'] ) ? esc_html__( 'Title font', 'studiare-plus' ) . ' (' . $primary_font[0]['font-family'] . ')' : esc_html__( 'Title font', 'studiare-plus' );

		return apply_filters(
			'woodmart_get_banner_params',
			array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				* Image
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Background', 'studiare-plus' ),
					'param_name' => 'image_divider',
				),
				array(
					'type'       => 'woodmart_button_set',
					'heading'    => esc_html__( 'Source', 'studiare-plus' ),
					'param_name' => 'source_type',
					'value'      => array(
						esc_html__( 'Image', 'studiare-plus' ) => 'image',
						esc_html__( 'Video', 'studiare-plus' ) => 'video',
					),
					'default'    => 'image',
				),
				array(
					'type'            => 'wd_upload',
					'heading'         => esc_html__( 'Video', 'studiare-plus' ),
					'param_name'      => 'video',
					'attachment_type' => 'video',
					'value'           => '',
					'hint'            => esc_html__( 'Select video from media library.', 'studiare-plus' ),
					'dependency'      => array(
						'element' => 'source_type',
						'value'   => array( 'video' ),
					),
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Fallback image', 'studiare-plus' ),
					'param_name'       => 'video_poster',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'source_type',
						'value'   => array( 'video' ),
					),
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Fallback image size', 'studiare-plus' ),
					'param_name'       => 'video_poster_size',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'description'      => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'source_type',
						'value'   => array( 'video' ),
					),
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'source_type',
						'value'   => array( 'image' ),
					),
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'source_type',
						'value'   => array( 'image' ),
					),
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Fixed height', 'studiare-plus' ),
					'param_name'       => 'custom_height',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
				),
				array(
					'type'             => 'wd_slider',
					'heading'          => esc_html__( 'Banner Height', 'studiare-plus' ),
					'param_name'       => 'new_height',
					'selectors'  => array(
						'{{WRAPPER}}' => array(
							'--wd-img-height: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
						'tablet'  => array(
							'value' => '',
							'unit'  => 'px',
						),
						'mobile'  => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 2000,
							'step' => 1,
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'hint'             => esc_html__( 'Default: 0', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'custom_height',
						'value'   => array( 'yes' ),
					),
					'transfer'         => 'height',
				),
				array(
					'type'             => 'woodmart_slider',
					'heading'          => esc_html__( 'Image Height', 'studiare-plus' ),
					'param_name'       => 'height',
					'min'              => '0',
					'max'              => '2000',
					'step'             => '1',
					'default'          => '0',
					'units'            => 'px',
					'value'            => array(
						'600' => '600',
						'500' => '500',
						'400' => '400',
						'350' => '350',
						'300' => '300',
						'250' => '250',
						'200' => '200',
						'150' => '150',
						'100' => '100',
						'0'   => '0',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column xts-hidden',
					'hint'             => esc_html__( 'Default: 0', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'custom_height',
						'value'   => array( 'yes' ),
					),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Image Position', 'studiare-plus' ),
					'param_name'       => 'image_bg_position',
					'value'            => array(
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Top', 'studiare-plus' )    => 'top',
						esc_html__( 'Bottom', 'studiare-plus' ) => 'bottom',
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'custom_height',
						'value'   => array( 'yes' ),
					),
					'wd_dependency'    => array(
						'element' => 'source_type',
						'value'   => array( 'image' ),
					),
				),
				array(
					'heading'       => esc_html__( 'Rounding', 'studiare-plus' ),
					'type'          => 'wd_select',
					'param_name'    => 'rounding_size',
					'style'         => 'select',
					'selectors'     => array(
						'{{WRAPPER}}' => array(
							'--wd-brd-radius: {{VALUE}}px;',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'         => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( '0', 'studiare-plus' )      => '0',
						esc_html__( '5', 'studiare-plus' )      => '5',
						esc_html__( '8', 'studiare-plus' )      => '8',
						esc_html__( '12', 'studiare-plus' )     => '12',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'generate_zero' => true,
				),
				array(
					'heading'       => esc_html__( 'Custom rounding', 'studiare-plus' ),
					'type'          => 'wd_slider',
					'param_name'    => 'custom_rounding_size',
					'selectors'     => array(
						'{{WRAPPER}}' => array(
							'--wd-brd-radius: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 300,
							'step' => 1,
						),
						'%'  => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
					),
					'dependency'    => array(
						'element' => 'rounding_size',
						'value'   => function_exists( 'woodmart_compress' ) ? woodmart_compress(
							wp_json_encode(
								array(
									'devices' => array(
										'desktop' => array(
											'value' => 'custom',
										),
									),
								)
							)
						) : '',
					),
					'generate_zero' => true,
				),
				array(
					'type'       => 'vc_link',
					'heading'    => esc_html__( 'Banner link', 'studiare-plus' ),
					'param_name' => 'link',
					'hint'       => esc_html__( 'Enter URL if you want this banner to have a link.', 'studiare-plus' ),
				),
				/**
				* Style
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'style_divider',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Banner style', 'studiare-plus' ),
					'param_name'       => 'style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Color mask', 'studiare-plus' ) => 'mask',
						esc_html__( 'Mask with shadow', 'studiare-plus' ) => 'shadow',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'border',
						esc_html__( 'Bordered background', 'studiare-plus' ) => 'background',
						esc_html__( 'Content background', 'studiare-plus' ) => 'content-background',
					),
					'images_value'     => array(
						'default'            => WOODMART_ASSETS_IMAGES . '/settings/banner-style/default.png',
						'mask'               => WOODMART_ASSETS_IMAGES . '/settings/banner-style/mask.png',
						'shadow'             => WOODMART_ASSETS_IMAGES . '/settings/banner-style/shadow.png',
						'border'             => WOODMART_ASSETS_IMAGES . '/settings/banner-style/border.png',
						'background'         => WOODMART_ASSETS_IMAGES . '/settings/banner-style/background.png',
						'content-background' => WOODMART_ASSETS_IMAGES . '/settings/banner-style/content-background.png',
					),
					'wood_tooltip'     => true,
					'hint'             => esc_html__( 'You can use some of our predefined styles for your banner content.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-xs-12 vc_column banner-style',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Hover effect', 'studiare-plus' ),
					'param_name'       => 'hover',
					'value'            => array(
						esc_html__( 'Zoom image', 'studiare-plus' ) => 'zoom',
						esc_html__( 'Parallax', 'studiare-plus' ) => 'parallax',
						esc_html__( 'Background', 'studiare-plus' ) => 'background',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'border',
						esc_html__( 'Zoom reverse', 'studiare-plus' ) => 'zoom-reverse',
						esc_html__( 'Disable', 'studiare-plus' ) => 'none',
					),
					'hint'             => esc_html__( 'Set beautiful hover effects for your banner.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Color Scheme', 'studiare-plus' ),
					'param_name'       => 'woodmart_color_scheme',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Content background color', 'studiare-plus' ),
					'param_name'       => 'custom_content_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .wrapper-content-banner',
						),
					),
					'dependency'       => array(
						'element' => 'style',
						'value'   => array( 'content-background' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				* Extra
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				/**
				* Title
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Title', 'studiare-plus' ),
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title',
					'holder'     => 'div',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_font',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						$text_font_title      => 'text',
						$primary_font_title   => 'primary',
						$secondary_font_title => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Title tag', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_tag',
					'value'            => array(
						'h1'   => 'h1',
						'h2'   => 'h2',
						'h3'   => 'h3',
						'h4'   => 'h4',
						'h5'   => 'h5',
						'h6'   => 'h6',
						'p'    => 'p',
						'div'  => 'div',
						'span' => 'span',
					),
					'std'              => 'h4',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Predefined title size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_size',
					'value'            => array(
						esc_html__( 'Default (22px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Small (16px)', 'studiare-plus' ) => 'small',
						esc_html__( 'Large (26px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large (36px)', 'studiare-plus' ) => 'extra-large',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom font size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_title_size',
					'css_args'         => array(
						'font-size' => array(
							' .banner-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_title_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .banner-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_title_color',
					'css_args'         => array(
						'color' => array(
							' .banner-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Highlight text style', 'studiare-plus' ),
					'hint'             => esc_html__( 'The text must be wrapped with the <u></u> tag to highlight it.', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_decoration_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' )  => 'default',
						esc_html__( 'Primary color', 'studiare-plus' )  => 'colored',
						esc_html__( 'Primary color + secondary font', 'studiare-plus' ) => 'colored-alt',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Gradient', 'studiare-plus' ) => 'gradient',
					),
					'std'              => 'colored',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_gradient',
					'heading'    => esc_html__( 'Highlight text gradient', 'studiare-plus' ),
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name' => 'title_decoration_gradient',
					'selectors'  => array(
						'{{WRAPPER}} .wd-underline-gradient .banner-title u' => array(
							'background-image: {{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'title_decoration_style',
						'value'   => array( 'gradient' ),
					),
				),
				/**
				* Subtitle
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Subtitle', 'studiare-plus' ),
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name' => 'subtitle_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Sub title', 'studiare-plus' ),
					'param_name' => 'subtitle',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						$text_font_title      => 'text',
						$primary_font_title   => 'primary',
						$secondary_font_title => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_subtitle_size',
					'css_args'         => array(
						'font-size' => array(
							' .banner-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_subtitle_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .banner-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_dropdown',
					'heading'          => esc_html__( 'Predefined subtitle color scheme', 'studiare-plus' ),
					'param_name'       => 'subtitle_color',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Primary', 'studiare-plus' ) => 'primary',
						esc_html__( 'Alternative', 'studiare-plus' ) => 'alt',
					),
					'style'            => array(
						'default' => '#f3f3f3',
						'primary' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
						'alt'     => woodmart_get_color_value( 'secondary-color', '#fbbc34' ),
					),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Custom color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_subtitle_color',
					'css_args'         => array(
						'color' => array(
							' .banner-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Subtitle style', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Background', 'studiare-plus' ) => 'background',
					),
					'images_value'     => array(
						'default'    => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/default.png',
						'background' => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/background.png',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'custom_subtitle_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .banner-subtitle',
						),
					),
					'dependency'       => array(
						'element' => 'subtitle_style',
						'value'   => array( 'background' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				* Content
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Content', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'param_name' => 'content_divider',
				),
				array(
					'type'       => 'textarea_html',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Banner content', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'param_name' => 'content',
					'hint'       => esc_html__( 'Add here few words to your banner image.', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Text size', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'content_text_size',
					'value'            => array(
						esc_html__( 'Default (14px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Medium (16px)', 'studiare-plus' ) => 'medium',
						esc_html__( 'Large (18px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_color',
					'css_args'         => array(
						'color' => array(
							' .banner-inner',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_size',
					'css_args'         => array(
						'font-size' => array(
							' .banner-inner',
						),
					),
					'dependency'       => array(
						'element' => 'content_text_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .banner-inner',
						),
					),
					'dependency'       => array(
						'element' => 'content_text_size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Countdown.
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Date', 'studiare-plus' ),
					'group'      => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name' => 'countdown_date_divider',
				),
				array(
					'type'             => 'woodmart_datepicker',
					'heading'          => esc_html__( 'Date', 'studiare-plus' ),
					'group'            => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name'       => 'date',
					'hint'             => esc_html__( 'Final date in the format Y/m/d. For example 2020/12/12 13:00', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Hide countdown on finish', 'studiare-plus' ),
					'group'            => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name'       => 'hide_countdown_on_finish',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Style', 'studiare-plus' ),
					'group'      => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name' => 'countdown_style_divider',
				),
				array(
					'type'       => 'woodmart_dropdown',
					'heading'    => esc_html__( 'Background', 'studiare-plus' ),
					'group'      => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name' => 'countdown_style',
					'value'      => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'simple',
						esc_html__( 'Primary color', 'studiare-plus' ) => 'active',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'std'        => 'simple',
					'style'      => array(
						'active' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
					),
				),
				array(
					'type'             => 'wd_colorpicker',
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name'       => 'countdown_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-timer' => array(
							'--wd-timer-bg:{{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency'       => array(
						'element' => 'countdown_style',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'woodmart_button_set',
					'heading'    => esc_html__( 'Color Scheme', 'studiare-plus' ),
					'group'      => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name' => 'countdown_color_scheme',
					'value'      => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' ) => 'dark',
					),
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Box shadow', 'studiare-plus' ),
					'group'            => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name'       => 'enable_shadow',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'wd_box_shadow',
					'group'            => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name'       => 'items_shadow',
					'selectors'        => array(
						'{{WRAPPER}} .wd-item' => array(
							'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
					'dependency'       => array(
						'element' => 'enable_shadow',
						'value'   => array( 'yes' ),
					),
					'default'          => array(
						'horizontal' => '0',
						'vertical'   => '0',
						'blur'       => '9',
						'spread'     => '0',
						'color'      => '',
					),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Size', 'studiare-plus' ),
					'group'      => esc_html__( 'Countdown', 'studiare-plus' ),
					'param_name' => 'countdown_size',
					'value'      => array(
						esc_html__( 'Medium (24px)', 'studiare-plus' ) => 'medium',
						esc_html__( 'Small (20px)', 'studiare-plus' ) => 'small',
						esc_html__( 'Large (28px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large (42px)', 'studiare-plus' ) => 'xlarge',
					),
				),
				/**
				* Button
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Button', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'button_divider',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Button text', 'studiare-plus' ),
					'param_name'       => 'btn_text',
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Button position', 'studiare-plus' ),
					'param_name'       => 'btn_position',
					'value'            => array(
						esc_html__( 'Show on hover', 'studiare-plus' ) => 'hover',
						esc_html__( 'Static', 'studiare-plus' ) => 'static',
					),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'dependency'       => array(
						'element'            => 'style',
						'value_not_equal_to' => array( 'content-background' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Button style', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_style',
					'value'            => array(
						esc_html__( 'Flat', 'studiare-plus' ) => 'default',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Link button', 'studiare-plus' ) => 'link',
						esc_html__( '3D', 'studiare-plus' ) => '3d',
					),
					'images_value'     => array(
						'default'  => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/default.png',
						'bordered' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/bordered.png',
						'link'     => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/link.png',
						'3d'       => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/3d.png',
					),
					'title'            => false,
					'std'              => 'default',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-style',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Button shape', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_shape',
					'value'            => array(
						esc_html__( 'Rectangle', 'studiare-plus' ) => 'rectangle',
						esc_html__( 'Circle', 'studiare-plus' ) => 'round',
						esc_html__( 'Round', 'studiare-plus' )  => 'semi-round',
					),
					'images_value'     => array(
						'rectangle'  => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/rectangle.jpeg',
						'round'      => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/circle.jpeg',
						'semi-round' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/round.jpeg',
					),
					'dependency'       => array(
						'element'            => 'btn_style',
						'value_not_equal_to' => array( 'round', 'link' ),
					),
					'title'            => false,
					'std'              => 'rectangle',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-shape',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Button size', 'studiare-plus' ),
					'param_name'       => 'btn_size',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Extra Small', 'studiare-plus' ) => 'extra-small',
						esc_html__( 'Small', 'studiare-plus' ) => 'small',
						esc_html__( 'Large', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large', 'studiare-plus' ) => 'extra-large',
					),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_dropdown',
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'heading'          => esc_html__( 'Predefined button color', 'studiare-plus' ),
					'param_name'       => 'btn_color',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Primary color', 'studiare-plus' ) => 'primary',
						esc_html__( 'Alternative color', 'studiare-plus' ) => 'alt',
						esc_html__( 'White', 'studiare-plus' ) => 'white',
						esc_html__( 'Black', 'studiare-plus' ) => 'black',
					),
					'style'            => array(
						'default' => '#f3f3f3',
						'primary' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
						'alt'     => woodmart_get_color_value( 'secondary-color', '#fbbc34' ),
						'black'   => '#212121',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Idle background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'btn_bg_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-button-wrapper a' => array(
							'background-color: {{VALUE}};',
							'border-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Idle text color scheme', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_color_scheme',
					'value'            => array(
						esc_html__( 'Light', 'studiare-plus' )  => 'light',
						esc_html__( 'Dark', 'studiare-plus' )   => 'dark',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'    => esc_html__( 'Custom text color', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'type'       => 'wd_colorpicker',
					'param_name' => 'btn_custom_color_scheme',
					'selectors'  => array(
						'{{WRAPPER}} .wd-button-wrapper a' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'btn_color_scheme',
						'value'   => 'custom',
					),
				),

				array(
					'heading'          => esc_html__( 'Background color on hover', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'btn_bg_color_hover',
					'selectors'        => array(
						'{{WRAPPER}} .wd-button-wrapper a:hover' => array(
							'background-color: {{VALUE}};',
							'border-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Text color scheme on hover', 'studiare-plus' ),
					'param_name'       => 'btn_color_scheme_hover',
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Light', 'studiare-plus' )  => 'light',
						esc_html__( 'Dark', 'studiare-plus' )   => 'dark',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'    => esc_html__( 'Custom text color on hover', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'type'       => 'wd_colorpicker',
					'param_name' => 'btn_custom_color_scheme_hover',
					'selectors'  => array(
						'{{WRAPPER}} .wd-button-wrapper a:hover' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'btn_color_scheme_hover',
						'value'   => 'custom',
					),
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Hide button on tablet', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'hide_btn_tablet',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Hide button on mobile', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'hide_btn_mobile',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Button icon
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'btn_icon_divider',
				),
				array(
					'type'       => 'woodmart_button_set',
					'heading'    => esc_html__( 'Type', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'btn_icon_type',
					'value'      => array(
						esc_html__( 'Icon', 'studiare-plus' )  => 'icon',
						esc_html__( 'Image', 'studiare-plus' ) => 'image',
					),
					'default'    => 'icon',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_image',
					'value'            => '',
					'dependency'       => array(
						'element' => 'btn_icon_type',
						'value'   => 'image',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_img_size',
					'description'      => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'btn_icon_type',
						'value'   => 'image',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon library', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Font Awesome', 'studiare-plus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'studiare-plus' ) => 'openiconic',
						esc_html__( 'Typicons', 'studiare-plus' ) => 'typicons',
						esc_html__( 'Entypo', 'studiare-plus' ) => 'entypo',
						esc_html__( 'Linecons', 'studiare-plus' ) => 'linecons',
						esc_html__( 'Mono Social', 'studiare-plus' ) => 'monosocial',
						esc_html__( 'Material', 'studiare-plus' ) => 'material',
					),
					'param_name' => 'icon_library',
					'hint'       => esc_html__( 'Select icon library.', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'btn_icon_type',
						'value'   => 'icon',
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_fontawesome',
					'value'      => '',
					'settings'   => array(
						'emptyIcon'    => true,
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'fontawesome' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_openiconic',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'openiconic',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'openiconic' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_typicons',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'typicons',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'typicons' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_entypo',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'entypo',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'entypo' ),
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_linecons',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'linecons',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'linecons' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_monosocial',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'monosocial',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'monosocial' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_material',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'material',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'material' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Button icon position', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_icon_position',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
					),
					'std'              => 'right',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-style',
				),
				/**
				* Layouts
				*/
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Layouts', 'studiare-plus' ),
					'group'      => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name' => 'positioning_divider',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Content horizontal alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'horizontal_alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/content-align/horizontal/left.png',
						'center' => WOODMART_ASSETS_IMAGES . '/settings/content-align/horizontal/center.png',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/content-align/horizontal/right.png',
					),
					'std'              => 'left',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column content-position',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Content vertical alignment', 'studiare-plus' ),
					'param_name'       => 'vertical_alignment',
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Top', 'studiare-plus' )    => 'top',
						esc_html__( 'Middle', 'studiare-plus' ) => 'middle',
						esc_html__( 'Bottom', 'studiare-plus' ) => 'bottom',
					),
					'images_value'     => array(
						'top'    => WOODMART_ASSETS_IMAGES . '/settings/content-align/vertical/top.png',
						'middle' => WOODMART_ASSETS_IMAGES . '/settings/content-align/vertical/middle.png',
						'bottom' => WOODMART_ASSETS_IMAGES . '/settings/content-align/vertical/bottom.png',
					),
					'std'              => 'top',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column content-position',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Text alignment', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'text_alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'left',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Content width', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'content_width',
					'value'            => array(
						'100%'                             => '100',
						'90%'                              => '90',
						'80%'                              => '80',
						'70%'                              => '70',
						'60%'                              => '60',
						'50%'                              => '50',
						'40%'                              => '40',
						'30%'                              => '30',
						'20%'                              => '20',
						'10%'                              => '10',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Custom content width', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'custom_content_width',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'default'          => 'desktop',
					'edit_field_class' => 'wd-res-control vc_col-sm-12 vc_column wd-custom-width',
					'dependency'       => array(
						'element' => 'content_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'content_desktop_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '600',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'desktop',
					),
					'wd_dependency'    => array(
						'element' => 'custom_content_width',
						'value'   => array( 'desktop' ),
					),
					'dependency'       => array(
						'element' => 'content_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'content_tablet_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '0',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'tablet',
					),
					'wd_dependency'    => array(
						'element' => 'custom_content_width',
						'value'   => array( 'tablet' ),
					),
					'dependency'       => array(
						'element' => 'content_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'woodmart_slider',
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'content_mobile_width',
					'min'              => '0',
					'max'              => '1000',
					'step'             => '1',
					'default'          => '0',
					'units'            => 'px',
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					'css_args'         => array(
						'--wd-max-width' => array(
							'',
						),
					),
					'css_params'       => array(
						'device' => 'mobile',
					),
					'wd_dependency'    => array(
						'element' => 'custom_content_width',
						'value'   => array( 'mobile' ),
					),
					'dependency'       => array(
						'element' => 'content_width',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'content_height',
					'heading'          => esc_html__( 'Content height', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit'  => '%',
							'value' => '',
						),
						'tablet'  => array(
							'unit'  => '%',
							'value' => '',
						),
						'mobile'  => array(
							'unit'  => '%',
							'value' => '',
						),
					),
					'range'            => array(
						'%'  => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
						'px' => array(
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}} .promo-banner:not(.banner-content-background) .content-banner, {{WRAPPER}} .promo-banner.banner-content-background .wrapper-content-banner' => array(
							'min-height: {{VALUE}}{{UNIT}};',
						),
					),
					'dependency'       => array(
						'element' => 'style',
						'value'   => array( 'content-background' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Increase spaces', 'studiare-plus' ),
					'group'            => esc_html__( 'Layouts', 'studiare-plus' ),
					'param_name'       => 'increase_spaces',
					'hint'             => esc_html__( 'Suggest to use this option if you have large banners. Padding will be set in percentage to your screen width.', 'studiare-plus' ),
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',
				/**
				* Deprecated
				*/
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title desktop text size ( > 1024px )', 'studiare-plus' ),
					'param_name' => 'title_desktop_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title tablet text size ( < 1024px )', 'studiare-plus' ),
					'param_name' => 'title_tablet_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title mobile text size ( < 767px )', 'studiare-plus' ),
					'param_name' => 'title_mobile_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				// Subtitle custom size
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Subtitle desktop text size ( > 1024px )', 'studiare-plus' ),
					'param_name' => 'subtitle_desktop_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Subtitle tablet text size ( < 1024px )', 'studiare-plus' ),
					'param_name' => 'subtitle_tablet_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Subtitle mobile text size ( < 767px )', 'studiare-plus' ),
					'param_name' => 'subtitle_mobile_text_size',
					'hint'       => esc_html__( 'Only number without px.', 'studiare-plus' ),
					'group'      => esc_html__( 'Custom size', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'title_size',
						'value'   => array( 'custom' ),
					),
				),
				/**
				 * Advanced.
				 */
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ) : '',
			)
		);
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_banners_carousel extends WPBakeryShortCodesContainer {}
}
