<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
*  WC products widget element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_shortcode_products_widget' ) ) {
	function woodmart_get_vc_map_shortcode_products_widget() {
		return array(
			'name' => esc_html__( 'WC products widget', 'studiare-plus' ),
			'base' => 'woodmart_shortcode_products_widget',
			'category' => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'description' => esc_html__( 'Small products list widget', 'studiare-plus' ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/wc-product-widget.svg',
			'params' => array(
				array(
					'param_name' => 'woodmart_css_id',
					'type'       => 'woodmart_css_id',
				),
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Widget title', 'studiare-plus' ),
					'param_name' => 'title',
				),
				/**
				 * Data settings
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Data settings', 'studiare-plus' ),
					'param_name' => 'data_divider',
				),
				array(
					'type' => 'woodmart_slider',
					'heading' => esc_html__( 'Number of products to show', 'studiare-plus' ),
					'param_name' => 'number',
					'min' => '1',
					'max' => '7',
					'step' => '1',
					'default' => '3',
					'units' => '',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency' => array(
						'element' => 'show',
						'value_not_equal_to' => array( 'product_ids' ),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Show', 'studiare-plus' ),
					'param_name' => 'show',
					'value' => array(
						esc_html__( 'All Products', 'studiare-plus' ) => '',
						esc_html__( 'Featured Products', 'studiare-plus' ) => 'featured',
						esc_html__( 'On-sale Products', 'studiare-plus' ) => 'onsale',
						esc_html__( 'List of IDs', 'studiare-plus' ) => 'product_ids'

					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Include only', 'studiare-plus' ),
					'param_name' => 'include_products',
					'hint' => esc_html__( 'Add products by title.', 'studiare-plus' ),
					'settings' => array(
						'multiple' => true,
						'sortable' => true,
						'unique_values' => true,
						// In UI show results except selected. NB! You should manually check values in backend
					),
					'save_always' => true,
					'dependency' => array(
						'element' => 'show',
						'value' => array( 'product_ids' )
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Order by', 'studiare-plus' ),
					'param_name' => 'orderby',
					'value' => array(
						esc_html__( 'Date', 'studiare-plus' ) => 'date',
						esc_html__( 'Price', 'studiare-plus' ) => 'price',
						esc_html__( 'Random', 'studiare-plus' ) => 'rand',
						esc_html__( 'Sales', 'studiare-plus' ) => 'sales'
					),
					'dependency' => array(
						'element' => 'show',
						'value_not_equal_to' => array( 'product_ids' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_button_set',
					'heading' => esc_html__( 'Order', 'studiare-plus' ),
					'param_name' => 'order',
					'value' => array(
						esc_html__( 'ASC', 'studiare-plus' ) => 'asc',
						esc_html__( 'DESC', 'studiare-plus' ) => 'desc'
					),
					'dependency' => array(
						'element' => 'show',
						'value_not_equal_to' => array( 'product_ids' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Categories', 'studiare-plus' ),
					'param_name' => 'ids',
					'settings' => array(
						'multiple' => true,
						'sortable' => true
					),
					'save_always' => true,
					'hint' => esc_html__( 'List of product categories', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'dependency' => array(
						'element' => 'show',
						'value_not_equal_to' => array( 'product_ids' ),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Images size', 'studiare-plus' ),
					'param_name' => 'images_size',
					'hint' => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Extra
				 */
				array(
					'type' => 'woodmart_title_divider',
					'holder' => 'div',
					'title' => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				array(
					'type' => 'woodmart_switch',
					'heading' => esc_html__( 'Hide free products', 'studiare-plus' ),
					'param_name' => 'hide_free',
					'true_state' => 1,
					'false_state' => 0,
					'default' => 0,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'woodmart_switch',
					'heading' => esc_html__( 'Show hidden products', 'studiare-plus' ),
					'param_name' => 'show_hidden',
					'true_state' => 1,
					'false_state' => 0,
					'default' => 0,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
		);
	}
}

//Filters For autocomplete param:
//For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
add_filter( 'vc_autocomplete_woodmart_shortcode_products_widget_ids_callback', 'woodmart_productCategoryCategoryAutocompleteSuggester', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_woodmart_shortcode_products_widget_ids_render', 'woodmart_productCategoryCategoryRenderByIdExact', 10, 1 );

add_filter( 'vc_autocomplete_woodmart_shortcode_products_widget_include_products_callback',	'woodmart_productIdAutocompleteSuggester', 10, 1 );
add_filter( 'vc_autocomplete_woodmart_shortcode_products_widget_include_products_render',	'woodmart_productIdAutocompleteRender', 10, 1 );
