<?php
/**
 * Marquee map.
 *
 * @package Elements
 */

if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

if ( ! function_exists( 'woodmart_get_vc_map_marquee' ) ) {
	/**
	 * Displays the shortcode settings fields in the admin.
	 */
	function woodmart_get_vc_map_marquee() {
		$marquee_typography = woodmart_get_typography_map(
			array(
				'title'    => esc_html__( 'Typography', 'studiare-plus' ),
				'key'      => 'marquee_typography',
				'selector' => '{{WRAPPER}} .wd-marquee',
			)
		);

		return array(
			'base'        => 'woodmart_marquee',
			'name'        => esc_html__( 'Marquee', 'studiare-plus' ),
			'description' => esc_html__( 'Text scrolling area', 'studiare-plus' ),
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/marquee.svg',
			'params'      => array(
				array(
					'param_name' => 'woodmart_css_id',
					'type'       => 'woodmart_css_id',
				),
				/**
				 * Settings.
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Settings', 'studiare-plus' ),
					'param_name' => 'general_settings_divider',
				),

				array(
					'type'             => 'wd_number',
					'heading'          => esc_html__( 'Scrolling speed', 'studiare-plus' ),
					'param_name'       => 'speed',
					'hint'             => esc_html__( 'Duration of one animation cycle (in seconds)', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'placeholder' => '5',
						),
						'tablet'  => array(
							'placeholder' => '5',
						),
						'mobile'  => array(
							'placeholder' => '5',
						),
					),
					'selectors'        => array(
						'{{WRAPPER}} .wd-marquee' => array(
							'--wd-marquee-speed: {{VALUE}}s;',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),

				array(
					'type'             => 'wd_select',
					'heading'          => esc_html__( 'Scrolling direction', 'studiare-plus' ),
					'param_name'       => 'direction',
					'style'            => 'select',
					'selectors'        => array(
						'{{WRAPPER}} .wd-marquee' => array(
							'--wd-marquee-direction: {{VALUE}};',
						),
					),
					'devices'          => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'            => array(
						esc_html__( 'Right to left', 'studiare-plus' ) => '',
						esc_html__( 'Left to right', 'studiare-plus' ) => 'reverse',
						esc_html__( 'Right to left and reverse', 'studiare-plus' ) => 'alternate',
						esc_html__( 'Left to right and reverse', 'studiare-plus' ) => 'alternate-reverse',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),

				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Pause on hover', 'studiare-plus' ),
					'param_name'       => 'paused_on_hover',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),

				$marquee_typography['font_family'],
				$marquee_typography['font_size'],
				$marquee_typography['font_weight'],
				$marquee_typography['text_transform'],
				$marquee_typography['font_style'],
				$marquee_typography['line_height'],

				array(
					'type'             => 'wd_colorpicker',
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'param_name'       => 'marquee_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-marquee' => array(
							'color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'       => esc_html__( 'Items gap', 'studiare-plus' ),
					'type'          => 'wd_slider',
					'param_name'    => 'content_gap',
					'selectors'     => array(
						'{{WRAPPER}} .wd-marquee' => array(
							'--wd-marquee-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 200,
							'step' => 1,
						),
					),
					'generate_zero' => true,
				),

				/**
				 * Content.
				 */
				array(
					'type'       => 'param_group',
					'param_name' => 'marquee_contents',
					'heading'    => esc_html__( 'Content', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'value'      => rawurlencode(
						wp_json_encode(
							array(
								array(
									'text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
								),
							)
						)
					),
					'params'     => array(
						array(
							'type'       => 'vc_link',
							'heading'    => esc_html__( 'Link', 'studiare-plus' ),
							'param_name' => 'link',
						),
						array(
							'param_name' => 'text',
							'type'       => 'textarea',
							'heading'    => esc_html__( 'Text', 'studiare-plus' ),
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__( 'Icon type', 'studiare-plus' ),
							'value'      => array(
								esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
								esc_html__( 'With image', 'studiare-plus' ) => 'image',
							),
							'param_name' => 'icon_type',
						),
						array(
							'type'             => 'attach_image',
							'heading'          => esc_html__( 'Custom image', 'studiare-plus' ),
							'param_name'       => 'image_id',
							'value'            => '',
							'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency'       => array(
								'element' => 'icon_type',
								'value'   => array( 'image' ),
							),
						),
						array(
							'type'             => 'textfield',
							'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
							'param_name'       => 'image_size',
							'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x50 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
							'dependency'       => array(
								'element' => 'icon_type',
								'value'   => array( 'image' ),
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
					),
				),
				/**
				 * Icon.
				 */
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon type', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Without icon', 'studiare-plus' ) => 'without',
						esc_html__( 'With icon', 'studiare-plus' ) => 'icon',
						esc_html__( 'With image', 'studiare-plus' ) => 'image',
					),
					'param_name' => 'icon_type',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x50 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon library', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Font Awesome', 'studiare-plus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'studiare-plus' ) => 'openiconic',
						esc_html__( 'Typicons', 'studiare-plus' ) => 'typicons',
						esc_html__( 'Entypo', 'studiare-plus' ) => 'entypo',
						esc_html__( 'Linecons', 'studiare-plus' ) => 'linecons',
						esc_html__( 'Mono Social', 'studiare-plus' ) => 'monosocial',
						esc_html__( 'Material', 'studiare-plus' ) => 'material',
					),
					'param_name' => 'icon_library',
					'hint'       => esc_html__( 'Select icon library.', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'icon_type',
						'value'   => 'icon',
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_fontawesome',
					'value'      => 'far fa-bell',
					'settings'   => array(
						'emptyIcon'    => false,
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'fontawesome',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_openiconic',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'openiconic',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'openiconic',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_typicons',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'typicons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'typicons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_entypo',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'entypo',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'entypo',
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_linecons',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'linecons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'linecons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_monosocial',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'monosocial',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'monosocial',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_material',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'material',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'material',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				// array(
				// 'type'       => 'woodmart_title_divider',
				// 'holder'     => 'div',
				// 'title'      => esc_html__( 'Icon', 'studiare-plus' ),
				// 'group'      => esc_html__( 'Icon', 'studiare-plus' ),
				// 'param_name' => 'style_icon_divider',
				// ),
					array(
						'type'             => 'woodmart_colorpicker',
						'heading'          => esc_html__( 'Icons color', 'studiare-plus' ),
						'group'            => esc_html__( 'Icon', 'studiare-plus' ),
						'param_name'       => 'marquee_icon_color',
						'css_args'         => array(
							'color' => array(
								' .wd-icon',
							),
						),
						'dependency'       => array(
							'element' => 'icon_type',
							'value'   => array( 'icon' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
				array(
					'heading'    => esc_html__( 'Icon size', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'type'       => 'wd_slider',
					'param_name' => 'icon_size',
					'selectors'  => array(
						'{{WRAPPER}} .wd-marquee .wd-icon' => array(
							'font-size: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'      => array(
						'px' => array(
							'min'  => 1,
							'max'  => 100,
							'step' => 1,
						),
					),
					'dependency' => array(
						'element' => 'icon_type',
						'value'   => array( 'icon' ),
					),
				),

				/**
				 * Design Options.
				 */
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',

				woodmart_get_vc_z_index_map('wd_z_index'),
				woodmart_get_vc_z_index_map('wd_z_index_custom'),

				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
