<?php

if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

if ( ! function_exists( 'woodmart_get_vc_map_list' ) ) {
	function woodmart_get_vc_map_list() {
		$typography = woodmart_get_typography_map(
			array(
				'key'      => 'typography',
				'selector' => '{{WRAPPER}} .wd-list-content',
			)
		);

		return array(
			'name'        => esc_html__( 'List', 'studiare-plus' ),
			'base'        => 'woodmart_list',
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'description' => esc_html__( 'Display a list with icon', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/list.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				// General.
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'General settings', 'studiare-plus' ),
					'param_name' => 'general_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Design', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
					),
					'param_name'       => 'design',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'List items font size', 'studiare-plus' ),
					'param_name'       => 'size',
					'value'            => array(
						esc_html__( 'Default (14px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Medium (16px)', 'studiare-plus' ) => 'medium',
						esc_html__( 'Large (18px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large (22px)', 'studiare-plus' ) => 'extra-large',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'param_name'       => 'color_scheme',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
						esc_html__( 'Custom', 'studiare-plus' )  => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Link color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'link_color',
					'selectors'        => array(
						'{{WRAPPER}} li a' => array(
							'color: {{VALUE}};',
						),
					),
					'dependency'       => array(
						'element' => 'color_scheme',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Link color hover', 'studiare-plus' ),
					'param_name'       => 'text_color_hover',
					'css_args'         => array(
						'color' => array(
							' li a:hover',
						),
					),
					'dependency'       => array(
						'element' => 'color_scheme',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Text color', 'studiare-plus' ),
					'param_name'       => 'text_color',
					'css_args'         => array(
						'color' => array(
							' li',
						),
					),
					'dependency'       => array(
						'element' => 'color_scheme',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				$typography['font_family'],
				$typography['font_size'],
				$typography['font_weight'],
				$typography['text_transform'],
				$typography['font_style'],
				$typography['line_height'],
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Align', 'studiare-plus' ),
					'param_name'       => 'align',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'left',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'type'             => 'wd_slider',
					'param_name'       => 'list_items_gap',
					'heading'          => esc_html__( 'List items gap', 'studiare-plus' ),
					'devices'          => array(
						'desktop' => array(
							'unit' => 'px',
						),
						'tablet'  => array(
							'unit' => 'px',
						),
						'mobile'  => array(
							'unit' => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-list' => array(
							'--wd-row-gap: {{VALUE}}{{UNIT}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra settings', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				// List.
				array(
					'type'       => 'param_group',
					'param_name' => 'list',
					'group'      => esc_html__( 'List', 'studiare-plus' ),
					'params'     => array(
						array(
							'type'       => 'vc_link',
							'heading'    => esc_html__( 'Link', 'studiare-plus' ),
							'param_name' => 'link',
						),
						array(
							'type'       => 'textarea',
							'heading'    => esc_html__( 'Content', 'studiare-plus' ),
							'param_name' => 'list-content',
						),
						array(
							'type'             => 'dropdown',
							'heading'          => esc_html__( 'Item icon type', 'studiare-plus' ),
							'value'            => array(
								esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
								esc_html__( 'With image', 'studiare-plus' ) => 'image',
							),
							'param_name'       => 'item_type',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
						array(
							'type'             => 'attach_image',
							'heading'          => esc_html__( 'Custom image', 'studiare-plus' ),
							'param_name'       => 'image_id',
							'value'            => '',
							'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency'       => array(
								'element' => 'item_type',
								'value'   => array( 'image' ),
							),
						),
						array(
							'type'             => 'textfield',
							'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
							'param_name'       => 'item_image_size',
							'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x50 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
							'dependency'       => array(
								'element' => 'item_type',
								'value'   => array( 'image' ),
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),
					),
				),
				// Icon.
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Icon settings', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_divider',
				),
				array(
					'type'             => 'dropdown',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'List icon type', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'With icon', 'studiare-plus' ) => 'icon',
						esc_html__( 'With image', 'studiare-plus' ) => 'image',
						esc_html__( 'With numbers', 'studiare-plus' ) => 'ordered',
						esc_html__( 'With arrows', 'studiare-plus' ) => 'unordered',
						esc_html__( 'With bullets', 'studiare-plus' ) => 'unordered-2',
						esc_html__( 'Without icon', 'studiare-plus' ) => 'without',
					),
					'std'              => 'icon',
					'param_name'       => 'list_type',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'List style', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Round', 'studiare-plus' )  => 'rounded',
						esc_html__( 'Square', 'studiare-plus' ) => 'square',
					),
					'param_name'       => 'list_style',
					'dependency'       => array(
						'element' => 'list_type',
						'value'   => array( 'icon', 'ordered', 'unordered', 'unordered-2', 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'list_type',
						'value'   => array( 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x50 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'list_type',
						'value'   => array( 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon library', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Font Awesome', 'studiare-plus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'studiare-plus' ) => 'openiconic',
						esc_html__( 'Typicons', 'studiare-plus' ) => 'typicons',
						esc_html__( 'Entypo', 'studiare-plus' ) => 'entypo',
						esc_html__( 'Linecons', 'studiare-plus' ) => 'linecons',
						esc_html__( 'Mono Social', 'studiare-plus' ) => 'monosocial',
						esc_html__( 'Material', 'studiare-plus' ) => 'material',
					),
					'param_name' => 'icon_library',
					'hint'       => esc_html__( 'Select icon library.', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'list_type',
						'value'   => 'icon',
					),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_fontawesome',
					'value'      => 'far fa-bell',
					'settings'   => array(
						'emptyIcon'    => false,
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'fontawesome',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_openiconic',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'openiconic',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'openiconic',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_typicons',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'typicons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'typicons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_entypo',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'entypo',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'entypo',
					),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_linecons',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'linecons',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'linecons',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_monosocial',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'monosocial',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'monosocial',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_material',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'material',
						'iconsPerPage' => 50,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => 'material',
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'Icons color', 'studiare-plus' ),
					'param_name'       => 'icons_color',
					'css_args'         => array(
						'color' => array(
							' .wd-icon',
						),
					),
					'dependency'       => array(
						'element' => 'list_type',
						'value'   => array( 'icon', 'ordered', 'unordered', 'unordered-2', 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'Icons color hover', 'studiare-plus' ),
					'param_name'       => 'icons_color_hover',
					'css_args'         => array(
						'color' => array(
							' li:hover .wd-icon',
						),
					),
					'dependency'       => array(
						'element' => 'list_type',
						'value'   => array( 'icon', 'ordered', 'unordered', 'unordered-2', 'image' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'Icons background color', 'studiare-plus' ),
					'param_name'       => 'icons_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .wd-icon',
						),
					),
					'dependency'       => array(
						'element' => 'list_style',
						'value'   => array( 'rounded', 'square' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'group'            => esc_html__( 'Icon', 'studiare-plus' ),
					'heading'          => esc_html__( 'Icons background color hover', 'studiare-plus' ),
					'param_name'       => 'icons_bg_color_hover',
					'css_args'         => array(
						'background-color' => array(
							' li:hover .wd-icon',
						),
					),
					'dependency'       => array(
						'element' => 'list_style',
						'value'   => array( 'rounded', 'square' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'    => esc_html__( 'Icon size', 'studiare-plus' ),
					'group'      => esc_html__( 'Icon', 'studiare-plus' ),
					'type'       => 'wd_slider',
					'param_name' => 'icon_size',
					'selectors'  => array(
						'{{WRAPPER}}' => array(
							'--li-icon-s: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'    => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'      => array(
						'px' => array(
							'min'  => 1,
							'max'  => 100,
							'step' => 1,
						),
					),
				),
				// Style.
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
		);
	}
}
