<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
* ------------------------------------------------------------------------------------------------
* Information box element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_info_box_carousel' ) ) {
	function woodmart_get_vc_map_info_box_carousel() {
		return array(
			'name'                    => esc_html__( 'Information box carousel', 'studiare-plus' ),
			'base'                    => 'woodmart_info_box_carousel',
			'as_parent'               => array( 'only' => 'woodmart_info_box' ),
			'content_element'         => true,
			'show_settings_on_create' => true,
			'category'                => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ? woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description'             => esc_html__( 'Show your brief information as a carousel', 'studiare-plus' ),
			'icon'                    => WOODMART_ASSETS . '/images/vc-icon/infobox-slider.svg',
			'params'                  => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				 * Slider
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Carousel', 'studiare-plus' ),
					'param_name' => 'slider_divider',
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'group'      => esc_html__( 'Advanced', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'group'      => esc_html__( 'Advanced', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
			),
			'js_view'                 => 'VcColumnView',
		);
	}
}

if ( ! function_exists( 'woodmart_get_woodmart_info_box_shortcode_args' ) ) {
	function woodmart_get_woodmart_info_box_shortcode_args() {
		return array(
			'name'            => esc_html__( 'Information box', 'studiare-plus' ),
			'base'            => 'woodmart_info_box',
			'content_element' => true,
			'category'        => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ? woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description'     => esc_html__( 'Show some brief information', 'studiare-plus' ),
			'icon'            => WOODMART_ASSETS . '/images/vc-icon/information-box.svg',
			'params'          => woodmart_get_info_box_shortcode_params(),
		);
	}
}

if ( ! function_exists( 'woodmart_get_info_box_shortcode_params' ) ) {
	function woodmart_get_info_box_shortcode_params() {
		$secondary_font = woodmart_get_opt( 'secondary-font' );
		$text_font      = woodmart_get_opt( 'text-font' );
		$primary_font   = woodmart_get_opt( 'primary-font' );

		$secondary_font_title = isset( $secondary_font[0]['font-family'] ) ? esc_html__( 'Secondary font', 'studiare-plus' ) . ' (' . $secondary_font[0]['font-family'] . ')' : esc_html__( 'Secondary font', 'studiare-plus' );
		$text_font_title      = isset( $text_font[0]['font-family']  ) ? esc_html__( 'Text font', 'studiare-plus' ) . ' (' . $text_font[0]['font-family'] . ')' : esc_html__( 'Text', 'studiare-plus' );
		$primary_font_title   = isset( $primary_font[0]['font-family']  ) ? esc_html__( 'Title font', 'studiare-plus' ) . ' (' . $primary_font[0]['font-family'] . ')' : esc_html__( 'Title font', 'studiare-plus' );

		return apply_filters(
			'woodmart_get_info_box_shortcode_params',
			array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				 * Icon
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Icon', 'studiare-plus' ),
					'param_name' => 'icon_divider',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Icon style', 'studiare-plus' ),
					'param_name'       => 'icon_style',
					'value'            => array(
						esc_html__( 'Simple', 'studiare-plus' ) => 'simple',
						esc_html__( 'With background', 'studiare-plus' ) => 'with-bg',
						esc_html__( 'With border', 'studiare-plus' ) => 'with-border',
					),
					'wood_tooltip'     => true,
					'images_value'     => array(
						'simple'      => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/simple.png',
						'with-bg'     => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/with-bg.png',
						'with-border' => WOODMART_ASSETS_IMAGES . '/settings/infobox/style/with-border.png',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column info-icon',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Icon type', 'studiare-plus' ),
					'hint'             => esc_html__( 'You can display icon based on image or just write some text like 01., 02., M, X etc.', 'studiare-plus' ),
					'param_name'       => 'icon_type',
					'value'            => array(
						esc_html__( 'Icon', 'studiare-plus' ) => 'icon',
						esc_html__( 'Text', 'studiare-plus' ) => 'text',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Icon background color', 'studiare-plus' ),
					'param_name'       => 'icon_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .info-box-icon',
						),
					),
					'dependency'       => array(
						'element' => 'icon_style',
						'value'   => array( 'with-bg' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Icon background color on hover', 'studiare-plus' ),
					'param_name'       => 'icon_bg_hover_color',
					'css_args'         => array(
						'background-color' => array(
							':hover .info-box-icon',
						),
					),
					'dependency'       => array(
						'element' => 'icon_style',
						'value'   => array( 'with-bg' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Icon border color', 'studiare-plus' ),
					'param_name'       => 'icon_border_color',
					'css_args'         => array(
						'border-color' => array(
							' .info-box-icon',
						),
					),
					'dependency'       => array(
						'element' => 'icon_style',
						'value'   => array( 'with-border' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Icon border color on hover', 'studiare-plus' ),
					'param_name'       => 'icon_border_hover_color',
					'css_args'         => array(
						'border-color' => array(
							':hover .info-box-icon',
						),
					),
					'dependency'       => array(
						'element' => 'icon_style',
						'value'   => array( 'with-border' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Icon text', 'studiare-plus' ),
					'param_name'       => 'icon_text',
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'text' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Icon text size', 'studiare-plus' ),
					'param_name'       => 'icon_text_size',
					'value'            => array(
						esc_html__( 'Default (52px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Small (38px)', 'studiare-plus' ) => 'small',
						esc_html__( 'Large (74px)', 'studiare-plus' ) => 'large',
					),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'text' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Icon text color', 'studiare-plus' ),
					'param_name'       => 'icon_text_color',
					'css_args'         => array(
						'color' => array(
							' .box-with-text',
						),
					),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'text' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'param_name'       => 'image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'icon' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'param_name'       => 'img_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'icon_type',
						'value'   => array( 'icon' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Spacing', 'studiare-plus' ),
					'type'             => 'wd_slider',
					'param_name'       => 'icon_spacing',
					'devices'          => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 5,
							'max'  => 50,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}}.wd-info-box' => array(
							'--ib-icon-sp: {{VALUE}}px;',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				/**
				 * Box style
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Box style', 'studiare-plus' ),
					'param_name' => 'style_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Box style', 'studiare-plus' ),
					'param_name'       => 'style',
					'value'            => array(
						esc_html__( 'Base', 'studiare-plus' )   => 'base',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'border',
						esc_html__( 'Shadow', 'studiare-plus' ) => 'shadow',
						esc_html__( 'Background on hover', 'studiare-plus' ) => 'bg-hover',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'       => esc_html__( 'Rounding', 'studiare-plus' ),
					'type'          => 'wd_select',
					'param_name'    => 'rounding_size',
					'style'         => 'select',
					'selectors'     => array(
						'{{WRAPPER}}' => array(
							'--wd-brd-radius: {{VALUE}}px;',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'         => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( '0', 'studiare-plus' )      => '0',
						esc_html__( '5', 'studiare-plus' )      => '5',
						esc_html__( '8', 'studiare-plus' )      => '8',
						esc_html__( '12', 'studiare-plus' )     => '12',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'dependency'    => array(
						'element' => 'icon_type',
						'value'   => array( 'icon' ),
					),
					'generate_zero' => true,
				),
				array(
					'heading'       => esc_html__( 'Custom rounding', 'studiare-plus' ),
					'type'          => 'wd_slider',
					'param_name'    => 'custom_rounding_size',
					'selectors'     => array(
						'{{WRAPPER}}' => array(
							'--wd-brd-radius: {{VALUE}}{{UNIT}};',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
							'unit'  => 'px',
						),
					),
					'range'         => array(
						'px' => array(
							'min'  => 0,
							'max'  => 300,
							'step' => 1,
						),
						'%'  => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
					),
					'dependency'    => array(
						'element' => 'rounding_size',
						'value'   => function_exists( 'woodmart_compress' ) ? woodmart_compress(
							wp_json_encode(
								array(
									'devices' => array(
										'desktop' => array(
											'value' => 'custom',
										),
									),
								)
							)
						) : '',
					),
					'generate_zero' => true,
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'param_name'       => 'woodmart_color_scheme',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Background', 'studiare-plus' ),
					'param_name' => 'hover_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Background type', 'studiare-plus' ),
					'param_name'       => 'bg_hover_colorpicker',
					'value'            => array(
						esc_html__( 'Color or image', 'studiare-plus' ) => 'colorpicker',
						esc_html__( 'Gradient', 'studiare-plus' ) => 'gradient',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'heading'    => esc_html__( 'Background color', 'studiare-plus' ),
					'type'       => 'wd_colorpicker',
					'param_name' => 'bg_color',
					'selectors'  => array(
						'{{WRAPPER}}.wd-info-box' => array(
							'background-color: {{VALUE}};',
						),
					),
					'dependency' => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Background image', 'studiare-plus' ),
					'param_name'       => 'bg_image_box',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Background image size', 'studiare-plus' ),
					'param_name'       => 'bg_image_box_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Background position', 'studiare-plus' ),
					'param_name'       => 'bg_image_box_position',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Center Center', 'studiare-plus' ) => 'center center',
						esc_html__( 'Center Left', 'studiare-plus' ) => 'center left',
						esc_html__( 'Center Right', 'studiare-plus' ) => 'center right',
						esc_html__( 'Top Center', 'studiare-plus' ) => 'top center',
						esc_html__( 'Top Left', 'studiare-plus' ) => 'top left',
						esc_html__( 'Top Right', 'studiare-plus' ) => 'top right',
						esc_html__( 'Bottom Center', 'studiare-plus' ) => 'bottom center',
						esc_html__( 'Bottom Left', 'studiare-plus' ) => 'bottom left',
						esc_html__( 'Bottom Right', 'studiare-plus' ) => 'bottom right',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Background repeat', 'studiare-plus' ),
					'param_name'       => 'bg_image_box_repeat',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'No-repeat', 'studiare-plus' ) => 'no-repeat',
						esc_html__( 'Repeat', 'studiare-plus' ) => 'repeat',
						esc_html__( 'Repeat-x', 'studiare-plus' ) => 'repeat-x',
						esc_html__( 'Repeat-y', 'studiare-plus' ) => 'repeat-y',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Background size', 'studiare-plus' ),
					'param_name'       => 'bg_image_box_sizes',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Cover', 'studiare-plus' ) => 'cover',
						esc_html__( 'Contain', 'studiare-plus' ) => 'contain',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Hover background color', 'studiare-plus' ),
					'param_name'       => 'bg_hover_color',
					'css_args'         => array(
						'background-color' => array(
							':after',
						),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Hover background image', 'studiare-plus' ),
					'param_name'       => 'bg_hover_image',
					'value'            => '',
					'hint'             => esc_html__( 'Select image from media library.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Hover background image size', 'studiare-plus' ),
					'param_name'       => 'bg_hover_image_size',
					'hint'             => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Hover background position', 'studiare-plus' ),
					'param_name'       => 'bg_hover_image_position',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Center Center', 'studiare-plus' ) => 'center center',
						esc_html__( 'Center Left', 'studiare-plus' ) => 'center left',
						esc_html__( 'Center Right', 'studiare-plus' ) => 'center right',
						esc_html__( 'Top Center', 'studiare-plus' ) => 'top center',
						esc_html__( 'Top Left', 'studiare-plus' ) => 'top left',
						esc_html__( 'Top Right', 'studiare-plus' ) => 'top right',
						esc_html__( 'Bottom Center', 'studiare-plus' ) => 'bottom center',
						esc_html__( 'Bottom Left', 'studiare-plus' ) => 'bottom left',
						esc_html__( 'Bottom Right', 'studiare-plus' ) => 'bottom right',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Hover background repeat', 'studiare-plus' ),
					'param_name'       => 'bg_hover_image_repeat',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'No-repeat', 'studiare-plus' ) => 'no-repeat',
						esc_html__( 'Repeat', 'studiare-plus' ) => 'repeat',
						esc_html__( 'Repeat-x', 'studiare-plus' ) => 'repeat-x',
						esc_html__( 'Repeat-y', 'studiare-plus' ) => 'repeat-y',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Hover background size', 'studiare-plus' ),
					'param_name'       => 'bg_hover_image_sizes',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Auto', 'studiare-plus' )  => 'auto',
						esc_html__( 'Cover', 'studiare-plus' ) => 'cover',
						esc_html__( 'Contain', 'studiare-plus' ) => 'contain',
					),
					'dependency'       => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'colorpicker' ),
					),
					'wd_dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_gradient',
					'heading'    => esc_html__( 'Background gradient', 'studiare-plus' ),
					'param_name' => 'bg_color_gradient',
					'dependency' => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'gradient' ),
					),
				),
				array(
					'type'          => 'woodmart_gradient',
					'heading'       => esc_html__( 'Hover background gradient', 'studiare-plus' ),
					'param_name'    => 'bg_hover_color_gradient',
					'wd_dependency' => array(
						'element' => 'bg_hover_colorpicker',
						'value'   => array( 'gradient' ),
					),
					'dependency'    => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Color scheme on hover', 'studiare-plus' ),
					'param_name'       => 'woodmart_hover_color_scheme',
					'value'            => array(
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					),
					'dependency'       => array(
						'element' => 'style',
						'value'   => array( 'bg-hover' ),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				/**
				 * Layout
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Layout', 'studiare-plus' ),
					'param_name' => 'layout_divider',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Text alignment', 'studiare-plus' ),
					'param_name'       => 'alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'left',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Image alignment', 'studiare-plus' ),
					'param_name'       => 'image_alignment',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Top', 'studiare-plus' )   => 'top',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
					),
					'images_value'     => array(
						'top'   => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/top.png',
						'left'  => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/left.png',
						'right' => WOODMART_ASSETS_IMAGES . '/settings/infobox/position/right.png',
					),
					'std'              => 'top',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Vertical alignment', 'studiare-plus' ),
					'param_name'       => 'image_vertical_alignment',
					'value'            => array(
						esc_html__( 'Top', 'studiare-plus' )    => 'top',
						esc_html__( 'Middle', 'studiare-plus' ) => 'middle',
						esc_html__( 'Bottom', 'studiare-plus' ) => 'bottom',
					),
					'images_value'     => array(
						'top'    => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/top.png',
						'middle' => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/middle.png',
						'bottom' => WOODMART_ASSETS_IMAGES . '/settings/infobox/vertical-position/bottom.png',
					),
					'std'              => 'top',
					'wood_tooltip'     => true,
					'dependency'       => array(
						'element' => 'image_alignment',
						'value'   => array( 'left', 'right' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Title
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Title', 'studiare-plus' ),
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Title text', 'studiare-plus' ),
					'param_name' => 'title',
					'holder'     => 'div',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_font',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						$text_font_title      => 'text',
						$primary_font_title   => 'primary',
						$secondary_font_title => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Title tag', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_tag',
					'value'            => array(
						'h1'   => 'h1',
						'h2'   => 'h2',
						'h3'   => 'h3',
						'h4'   => 'h4',
						'h5'   => 'h5',
						'h6'   => 'h6',
						'p'    => 'p',
						'div'  => 'div',
						'span' => 'span',
					),
					'std'              => 'h4',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Predefined title size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_size',
					'value'            => array(
						esc_html__( 'Default (18px)', 'studiare-plus' ) => 'default',
						esc_html__( 'Small (16px)', 'studiare-plus' ) => 'small',
						esc_html__( 'Large (26px)', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large (36px)', 'studiare-plus' ) => 'extra-large',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'selectors'        => array(
						'{{WRAPPER}} .info-box-title' => array(
							'font-weight: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom font size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_font_size',
					'css_args'         => array(
						'font-size' => array(
							' .info-box-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .info-box-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Title style', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Underline', 'studiare-plus' ) => 'underlined',
					),
					'images_value'     => array(
						'default'    => WOODMART_ASSETS_IMAGES . '/settings/infobox/title-style/default.png',
						'underlined' => WOODMART_ASSETS_IMAGES . '/settings/infobox/title-style/underlined.png',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'title_color',
					'css_args'         => array(
						'color' => array(
							' .info-box-title',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Subtitle
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Subtitle', 'studiare-plus' ),
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name' => 'subtitle_divider',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Sub title text', 'studiare-plus' ),
					'param_name' => 'subtitle',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						$text_font_title      => 'text',
						$primary_font_title   => 'primary',
						$secondary_font_title => 'alt',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Font weight', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'selectors'        => array(
						'{{WRAPPER}} .info-box-subtitle' => array(
							'--wd-font-weight: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_font_size',
					'css_args'         => array(
						'font-size' => array(
							' .info-box-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .info-box-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_dropdown',
					'heading'          => esc_html__( 'Predefined subtitle color', 'studiare-plus' ),
					'param_name'       => 'subtitle_color',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Primary', 'studiare-plus' ) => 'primary',
						esc_html__( 'Alternative', 'studiare-plus' ) => 'alt',
					),
					'style'            => array(
						'default' => '#f3f3f3',
						'primary' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
						'alt'     => woodmart_get_color_value( 'secondary-color', '#fbbc34' ),
					),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Custom color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_custom_color',
					'css_args'         => array(
						'color' => array(
							' .info-box-subtitle',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Subtitle style', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Background', 'studiare-plus' ) => 'background',
					),
					'images_value'     => array(
						'default'    => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/default.png',
						'background' => WOODMART_ASSETS_IMAGES . '/settings/subtitle-style/background.png',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'group'            => esc_html__( 'Title and Subtitle', 'studiare-plus' ),
					'param_name'       => 'subtitle_custom_bg_color',
					'css_args'         => array(
						'background-color' => array(
							' .info-box-subtitle',
						),
					),
					'dependency'       => array(
						'element' => 'subtitle_style',
						'value'   => array( 'background' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Content
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Content', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'param_name' => 'style_divider',
				),
				array(
					'type'       => 'textarea_html',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Brief content', 'studiare-plus' ),
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
					'param_name' => 'content',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_size',
					'css_args'         => array(
						'font-size' => array(
							' .info-box-inner',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Line height', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .info-box-inner',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_empty_space',
					'param_name' => 'woodmart_empty_space',
					'group'      => esc_html__( 'Content', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_colorpicker',
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'group'            => esc_html__( 'Content', 'studiare-plus' ),
					'param_name'       => 'custom_text_color',
					'css_args'         => array(
						'color' => array(
							' .info-box-inner',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Button
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Button', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'button_divider',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Button text', 'studiare-plus' ),
					'param_name'       => 'btn_text',
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Button position', 'studiare-plus' ),
					'param_name'       => 'btn_position',
					'value'            => array(
						esc_html__( 'Show on hover', 'studiare-plus' ) => 'hover',
						esc_html__( 'Static', 'studiare-plus' ) => 'static',
					),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_dropdown',
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'heading'          => esc_html__( 'Predefined button color', 'studiare-plus' ),
					'param_name'       => 'btn_color',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Primary color', 'studiare-plus' ) => 'primary',
						esc_html__( 'Alternative color', 'studiare-plus' ) => 'alt',
						esc_html__( 'White', 'studiare-plus' ) => 'white',
						esc_html__( 'Black', 'studiare-plus' ) => 'black',
					),
					'style'            => array(
						'default' => '#f3f3f3',
						'primary' => woodmart_get_color_value( 'primary-color', '#7eb934' ),
						'alt'     => woodmart_get_color_value( 'secondary-color', '#fbbc34' ),
						'black'   => '#212121',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Button size', 'studiare-plus' ),
					'param_name'       => 'btn_size',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Extra Small', 'studiare-plus' ) => 'extra-small',
						esc_html__( 'Small', 'studiare-plus' ) => 'small',
						esc_html__( 'Large', 'studiare-plus' ) => 'large',
						esc_html__( 'Extra Large', 'studiare-plus' ) => 'extra-large',
					),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Button style', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Link button', 'studiare-plus' ) => 'link',
						esc_html__( '3D', 'studiare-plus' ) => '3d',
					),
					'images_value'     => array(
						'default'  => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/default.png',
						'bordered' => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/bordered.png',
						'link'     => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/link.png',
						'3d'       => WOODMART_ASSETS_IMAGES . '/settings/buttons/style/3d.png',
					),
					'title'            => false,
					'std'              => 'default',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-style',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Button shape', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_shape',
					'value'            => array(
						esc_html__( 'Rectangle', 'studiare-plus' ) => 'rectangle',
						esc_html__( 'Circle', 'studiare-plus' ) => 'round',
						esc_html__( 'Round', 'studiare-plus' )  => 'semi-round',
					),
					'images_value'     => array(
						'rectangle'  => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/rectangle.jpeg',
						'round'      => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/circle.jpeg',
						'semi-round' => WOODMART_ASSETS_IMAGES . '/settings/buttons/shape/round.jpeg',
					),
					'dependency'       => array(
						'element'            => 'btn_style',
						'value_not_equal_to' => array( 'round', 'link' ),
					),
					'title'            => false,
					'std'              => 'rectangle',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-shape',
				),
				/**
				 * Button icon
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'btn_icon_divider',
				),
				array(
					'type'       => 'woodmart_button_set',
					'heading'    => esc_html__( 'Type', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'btn_icon_type',
					'value'      => array(
						esc_html__( 'Icon', 'studiare-plus' )  => 'icon',
						esc_html__( 'Image', 'studiare-plus' ) => 'image',
					),
					'default'    => 'icon',
				),
				array(
					'type'             => 'attach_image',
					'heading'          => esc_html__( 'Image', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_image',
					'value'            => '',
					'dependency'       => array(
						'element' => 'btn_icon_type',
						'value'   => 'image',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Image size', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_img_size',
					'description'      => esc_html__( 'Example: \'thumbnail\', \'medium\', \'large\', \'full\' or enter image size in pixels: \'200x100\'.', 'studiare-plus' ),
					'dependency'       => array(
						'element' => 'btn_icon_type',
						'value'   => 'image',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon library', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'value'      => array(
						esc_html__( 'Font Awesome', 'studiare-plus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'studiare-plus' ) => 'openiconic',
						esc_html__( 'Typicons', 'studiare-plus' ) => 'typicons',
						esc_html__( 'Entypo', 'studiare-plus' ) => 'entypo',
						esc_html__( 'Linecons', 'studiare-plus' ) => 'linecons',
						esc_html__( 'Mono Social', 'studiare-plus' ) => 'monosocial',
						esc_html__( 'Material', 'studiare-plus' ) => 'material',
					),
					'param_name' => 'icon_library',
					'hint'       => esc_html__( 'Select icon library.', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'btn_icon_type',
						'value'   => 'icon',
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_fontawesome',
					'value'      => '',
					'settings'   => array(
						'emptyIcon'    => true,
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'fontawesome' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_openiconic',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'openiconic',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'openiconic' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_typicons',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'typicons',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'typicons' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_entypo',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'entypo',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'entypo' ),
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_linecons',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'linecons',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'linecons' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_monosocial',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'monosocial',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'monosocial' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'studiare-plus' ),
					'group'      => esc_html__( 'Button', 'studiare-plus' ),
					'param_name' => 'icon_material',
					'settings'   => array(
						'emptyIcon'    => true,
						'type'         => 'material',
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value'   => array( 'material' ),
					),
					'hint'       => esc_html__( 'Select icon from library.', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Button icon position', 'studiare-plus' ),
					'group'            => esc_html__( 'Button', 'studiare-plus' ),
					'param_name'       => 'btn_icon_position',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )  => 'left',
						esc_html__( 'Right', 'studiare-plus' ) => 'right',
					),
					'std'              => 'right',
					'edit_field_class' => 'vc_col-xs-12 vc_column button-style',
				),
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'SVG animation', 'studiare-plus' ),
					'param_name'       => 'svg_animation',
					'hint'             => esc_html__( 'By default, your SVG files will not be animated.', 'studiare-plus' ),
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Information box inline', 'studiare-plus' ),
					'param_name'       => 'info_box_inline',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'vc_link',
					'heading'          => esc_html__( 'Link', 'studiare-plus' ),
					'param_name'       => 'link',
					'hint'             => esc_html__( 'Enter URL if you want this box to have a link.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-xs-12 vc_column',
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',
				( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',

				function_exists( 'woodmart_get_vc_animation_map' ) ? woodmart_get_vc_animation_map( 'wd_animation' ) : '',
				function_exists( 'woodmart_get_vc_animation_map' ) ? woodmart_get_vc_animation_map( 'wd_animation_delay' ) : '',
				function_exists( 'woodmart_get_vc_animation_map' ) ? woodmart_get_vc_animation_map( 'wd_animation_duration' ) : '',

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Background position', 'studiare-plus' ),
					'param_name'       => 'woodmart_bg_position',
					'group'            => esc_html__( 'Design Options', 'js_composer' ),
					'value'            => array(
						esc_html__( 'None', 'studiare-plus' ) => '',
						esc_html__( 'Left top', 'studiare-plus' ) => 'left-top',
						esc_html__( 'Left center', 'studiare-plus' ) => 'left-center',
						esc_html__( 'Left bottom', 'studiare-plus' ) => 'left-bottom',
						esc_html__( 'Right top', 'studiare-plus' ) => 'right-top',
						esc_html__( 'Right center', 'studiare-plus' ) => 'right-center',
						esc_html__( 'Right bottom', 'studiare-plus' ) => 'right-bottom',
						esc_html__( 'Center top', 'studiare-plus' ) => 'center-top',
						esc_html__( 'Center center', 'studiare-plus' ) => 'center-center',
						esc_html__( 'Center bottom', 'studiare-plus' ) => 'center-bottom',
					),
					'edit_field_class' => 'vc_col-xs-5',
				),
				/**
				 * Advanced.
				 */
				woodmart_get_vc_z_index_map('wd_z_index'),
				woodmart_get_vc_z_index_map('wd_z_index_custom'),
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'responsive_tabs_hide' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_desktop' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_tablet' ) : '',
				function_exists( 'woodmart_get_vc_responsive_visible_map' ) ? woodmart_get_vc_responsive_visible_map( 'wd_hide_on_mobile' ) : '',
			)
		);
	}
}

// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_woodmart_info_box_carousel extends WPBakeryShortCodesContainer {}
}

// Replace Wbc_Inner_Item with your base name from mapping for nested element
if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_woodmart_info_box extends WPBakeryShortCode {}
}
