<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
* ------------------------------------------------------------------------------------------------
* Animated counter element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_animated_counter' ) ) {
	function woodmart_get_vc_map_animated_counter() {
		return array(
			'name'        => esc_html__( 'Animated Counter', 'studiare-plus' ),
			'description' => esc_html__( 'Shows animated counter with label', 'studiare-plus' ),
			'base'        => 'woodmart_counter',
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/animated-counter.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				 * Text
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Text', 'studiare-plus' ),
					'param_name' => 'text_divider',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Label', 'studiare-plus' ),
					'param_name'       => 'label',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Start value', 'studiare-plus' ),
					'param_name'       => 'start_value',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Actual value', 'studiare-plus' ),
					'param_name'       => 'value',
					'hint'             => esc_html__( 'Our final point. For ex.: 95', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Style
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Style', 'studiare-plus' ),
					'param_name' => 'style_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Size', 'studiare-plus' ),
					'param_name'       => 'size',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => '',
						esc_html__( 'Small', 'studiare-plus' )  => 'small',
						esc_html__( 'Large', 'studiare-plus' )  => 'large',
						esc_html__( 'Extra large', 'studiare-plus' ) => 'extra-large',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom font size', 'studiare-plus' ),
					'param_name'       => 'custom_value_size',
					'css_args'         => array(
						'font-size' => array(
							' .counter-value',
						),
					),
					'dependency'       => array(
						'element' => 'size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_responsive_size',
					'heading'          => esc_html__( 'Custom line height', 'studiare-plus' ),
					'param_name'       => 'custom_value_line_height',
					'css_args'         => array(
						'line-height' => array(
							' .counter-value',
						),
					),
					'dependency'       => array(
						'element' => 'size',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Countdown number font weight', 'studiare-plus' ),
					'param_name'       => 'font_weight',
					'value'            => array(
						'' => '',
						esc_html__( 'Ultra-Light 100', 'studiare-plus' ) => 100,
						esc_html__( 'Light 200', 'studiare-plus' ) => 200,
						esc_html__( 'Book 300', 'studiare-plus' ) => 300,
						esc_html__( 'Normal 400', 'studiare-plus' ) => 400,
						esc_html__( 'Medium 500', 'studiare-plus' ) => 500,
						esc_html__( 'Semi-Bold 600', 'studiare-plus' ) => 600,
						esc_html__( 'Bold 700', 'studiare-plus' ) => 700,
						esc_html__( 'Extra-Bold 800', 'studiare-plus' ) => 800,
						esc_html__( 'Ultra-Bold 900', 'studiare-plus' ) => 900,
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_image_select',
					'heading'          => esc_html__( 'Align', 'studiare-plus' ),
					'param_name'       => 'align',
					'value'            => array(
						esc_html__( 'Left', 'studiare-plus' )   => 'left',
						esc_html__( 'Center', 'studiare-plus' ) => 'center',
						esc_html__( 'Right', 'studiare-plus' )  => 'right',
					),
					'images_value'     => array(
						'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
						'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
						'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
					'std'              => 'center',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
					'param_name'       => 'color_scheme',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' )  => 'light',
						esc_html__( 'Dark', 'studiare-plus' )   => 'dark',
						esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'woodmart_colorpicker',
					'heading'    => esc_html__( 'Custom color', 'studiare-plus' ),
					'param_name' => 'color',
					'css_args'   => array(
						'color' => array(
							'.woodmart-counter',
						),
					),
					'dependency' => array(
						'element' => 'color_scheme',
						'value'   => array( 'custom' ),
					),
				),
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				/**
				 * Advanced
				 */

				// Width option (with dependency Columns option, responsive).
				woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
				woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
				woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
				woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
				woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
			),
		);
	}
}
