<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
* Categories element map
* ------------------------------------------------------------------------------------------------
*/

if( ! function_exists( 'woodmart_get_vc_shortcode_categories' ) ) {
	function woodmart_get_vc_shortcode_categories() {
		$order_by_values = array(
			'',
			esc_html__( 'Date', 'studiare-plus' ) => 'date',
			esc_html__( 'ID', 'studiare-plus' ) => 'ID',
			esc_html__( 'Title', 'studiare-plus' ) => 'title',
			esc_html__( 'Modified', 'studiare-plus' ) => 'modified',
			esc_html__( 'Menu order', 'studiare-plus' ) => 'menu_order',
			esc_html__( 'As IDs or slugs provided order', 'studiare-plus' ) => 'include',
		);

		$order_way_values = array(
			esc_html__( 'Inherit', 'studiare-plus' ) => '',
			esc_html__( 'Descending', 'studiare-plus' ) => 'DESC',
			esc_html__( 'Ascending', 'studiare-plus' ) => 'ASC',
		);

		$title_typography = woodmart_get_typography_map(
			array(
				'title'    => esc_html__( 'Title typography', 'studiare-plus' ),
				'key'      => 'title_typography',
				'selector' => '{{WRAPPER}} div.product-category .wd-entities-title, {{WRAPPER}} .wd-nav-product-cat>li>a',
				'group'    => esc_html__( 'Style', 'studiare-plus' ),
			)
		);

		return array(
				'name'        => esc_html__( 'Product categories', 'studiare-plus' ),
				'base'        => 'woodmart_categories',
				'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
				'description' => esc_html__( 'Product categories grid', 'studiare-plus' ),
				'icon'        => WOODMART_ASSETS . '/images/vc-icon/product-categories.svg',
				'params'      => array(
					/**
					 * Data settings
					 */
					array(
						'group'      => esc_html__( 'Content', 'studiare-plus' ),
						'type'       => 'woodmart_css_id',
						'param_name' => 'woodmart_css_id',
					),

					array(
						'title'      => esc_html__( 'General', 'studiare-plus' ),
						'group'      => esc_html__( 'Content', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'param_name' => 'data_divider',
					),

					array(
						'heading'          => esc_html__( 'Data source', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'hint'             => esc_html__( 'Use WooCommerce query when you display this element as a part of the shop page in WoodMart Layouts builder.', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'data_source',
						'value'            => array(
							esc_html__( 'Custom query', 'studiare-plus' ) => 'custom_query',
							esc_html__( 'WooCommerce query', 'studiare-plus' ) => 'wc_query',
						),
						'std'              => 'custom_query',
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Type', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'type',
						'value'            => array(
							esc_html__( 'Navigation', 'studiare-plus' ) => 'navigation',
							esc_html__( 'Grid', 'studiare-plus' ) => 'grid',
						),
						'std'              => 'grid',
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Enable icons', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'images',
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'yes',
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Enable product count', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'product_count',
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'yes',
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Mobile categories layout', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'hint'             => esc_html__( 'Turn categories navigation into accordion or hidden sidebar on mobile devices', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'mobile_accordion',
						'value'            => array(
							esc_html__( 'Default', 'studiare-plus' ) => 'no',
							esc_html__( 'Accordion', 'studiare-plus' ) => 'yes',
							esc_html__( 'Hidden sidebar', 'studiare-plus' ) => 'side-hidden',
						),
						'std'              => 'yes',
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-12 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Show current category ancestors', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'descriptions'     => esc_html__( 'This option works with WooCommerce query Data source only. They are dedicated to the shop page layout.', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'shop_categories_ancestors',
						'hint'             => esc_html__( 'If you visit category Man, for example, only man\'s subcategories will be shown in the page title like T-shirts, Coats, Shoes etc.', 'studiare-plus' ),
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'no',
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Show category neighbors if there is no children', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'descriptions'     => esc_html__( 'This option works with WooCommerce query Data source only. They are dedicated to the shop page layout.', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'show_categories_neighbors',
						'hint'             => esc_html__( 'If the category you visit doesn\'t contain any subcategories, the page title menu will display this category\'s neighbors categories.', 'studiare-plus' ),
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'no',
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Number', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'textfield',
						'param_name'       => 'number',
						'hint'             => esc_html__( 'Enter the number of categories to display for this element.', 'studiare-plus' ),
						'dependency'       => array(
							'element' => 'data_source',
							'value'   => array( 'custom_query' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'heading'          => esc_html__( 'Order by', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'orderby',
						'value'            => $order_by_values,
						'save_always'      => true,
						'hint'             => sprintf( wp_kses(  __( 'Select how to sort retrieved categories. More at %s.', 'studiare-plus' ), array(
							'a' => array(
								'href'   => array(),
								'target' => array()
							)
						)), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'dependency'       => array(
							'element' => 'data_source',
							'value'   => array( 'custom_query' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'          => esc_html__( 'Sort order', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'woodmart_button_set',
						'param_name'       => 'order',
						'value'            => $order_way_values,
						'save_always'      => true,
						'hint'             => sprintf( wp_kses(  __( 'Designates the ascending or descending order. More at %s.', 'studiare-plus' ), array(
							'a' => array(
								'href' => array(),
								'target' => array()
							)
						)), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'dependency'       => array(
							'element' => 'data_source',
							'value'   => array( 'custom_query' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'          => esc_html__( 'Categories', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'autocomplete',
						'param_name'       => 'ids',
						'settings'         => array(
							'multiple' => true,
							'sortable' => true,
						),
						'save_always'      => true,
						'hint'             => esc_html__( 'List of product categories', 'studiare-plus' ),
						'dependency'       => array(
							'element' => 'data_source',
							'value'   => array( 'custom_query' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'          => esc_html__( 'Hide empty', 'studiare-plus' ),
						'group'            => esc_html__( 'Content', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'hide_empty',
						'hint'             => esc_html__( 'Don\'t display categories that don\'t have any products assigned.', 'studiare-plus' ),
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'yes',
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					/**
					 * Design
					 */
					array(
						'title'      => esc_html__( 'Design', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'param_name' => 'design_divider',
					),
					array(
						'heading'      => esc_html__( 'Categories design', 'studiare-plus' ),
						'group'        => esc_html__( 'Style', 'studiare-plus' ),
						'type'         => 'woodmart_image_select',
						'param_name'   => 'categories_design',
						'value'        => array(
							esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
							esc_html__( 'Default', 'studiare-plus' ) => 'default',
							esc_html__( 'Alternative', 'studiare-plus' ) => 'alt',
							esc_html__( 'Center title', 'studiare-plus' ) => 'center',
							esc_html__( 'Replace title', 'studiare-plus' ) => 'replace-title',
							esc_html__( 'Mask', 'studiare-plus' ) => 'mask-subcat',
							esc_html__( 'Side', 'studiare-plus' ) => 'side',
							esc_html__( 'Zoom out', 'studiare-plus' ) => 'zoom-out',
						),
						'images_value' => array(
							'inherit'       => WOODMART_ASSETS_IMAGES . '/settings/empty.jpg',
							'default'       => WOODMART_ASSETS_IMAGES . '/settings/categories/default.jpg',
							'alt'           => WOODMART_ASSETS_IMAGES . '/settings/categories/alt.jpg',
							'center'        => WOODMART_ASSETS_IMAGES . '/settings/categories/center.jpg',
							'replace-title' => WOODMART_ASSETS_IMAGES . '/settings/categories/replace-title.jpg',
							'mask-subcat'   => WOODMART_ASSETS_IMAGES . '/settings/categories/subcat.jpg',
							'side'          => WOODMART_ASSETS_IMAGES . '/settings/categories/side.jpg',
							'zoom-out'      => WOODMART_ASSETS_IMAGES . '/settings/categories/zoom-out.jpg',
						),
						'hint'         => esc_html__( 'Overrides option from Theme Settings -> Shop', 'studiare-plus' ),
						'dependency'   => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),
					array(
						'heading'    => esc_html__( 'Image size', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'textfield',
						'param_name' => 'img_size',
						'hint'       => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
						'dependency' => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),
					array(
						'type'        => 'woodmart_switch',
						'heading'     => esc_html__( 'Bordered grid', 'studiare-plus' ),
						'hint'        => esc_html__( 'Add borders between the categories in your grid', 'studiare-plus' ),
						'group'       => esc_html__( 'Style', 'studiare-plus' ),
						'param_name'  => 'categories_bordered_grid',
						'true_state'  => 1,
						'false_state' => 0,
						'default'     => 0,
						'dependency'  => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),
					array(
						'type'          => 'woodmart_button_set',
						'heading'       => esc_html__( 'Bordered grid style', 'studiare-plus' ),
						'param_name'    => 'categories_bordered_grid_style',
						'value'         => array(
							esc_html__( 'Outside', 'studiare-plus' ) => 'outside',
							esc_html__( 'Inside', 'studiare-plus' )  => 'inside',
						),
						'group'         => esc_html__( 'Style', 'studiare-plus' ),
						'dependency'    => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
						'wd_dependency' => array(
							'element' => 'categories_bordered_grid',
							'value'   => '1',
						),
					),
					array(
						'heading'          => esc_html__( 'Custom category border color', 'studiare-plus' ),
						'hint'             => esc_html__( 'Set custom border color for category.', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'wd_colorpicker',
						'param_name'       => 'category_border_color',
						'selectors'        => array(
							'{{WRAPPER}} [class*="products-bordered-grid"], {{WRAPPER}} [class*="products-bordered-grid"] .wd-cat, {{WRAPPER}}[class*="products-bordered-grid"], {{WRAPPER}}[class*="products-bordered-grid"] .wd-cat' => array(
								'--wd-bordered-brd:{{VALUE}};',
							),
						),
						'dependency'       => array(
							'element' => 'categories_bordered_grid',
							'value'   => '1',
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'     => esc_html__( 'Categories background', 'studiare-plus' ),
						'hint'        => esc_html__( 'Add a background to the categories in your grid.', 'studiare-plus' ),
						'group'       => esc_html__( 'Style', 'studiare-plus' ),
						'type'        => 'woodmart_switch',
						'param_name'  => 'categories_with_background',
						'true_state'  => 1,
						'false_state' => 0,
						'default'     => 0,
						'dependency'  => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),
					array(
						'heading'          => esc_html__( 'Custom background color', 'studiare-plus' ),
						'hint'             => esc_html__( 'Set custom background color for categories.', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'wd_colorpicker',
						'param_name'       => 'categories_background',
						'selectors'        => array(
							'{{WRAPPER}} .wd-products-with-bg, {{WRAPPER}}.wd-products-with-bg, {{WRAPPER}} .wd-products-with-bg .wd-cat, {{WRAPPER}}.wd-products-with-bg .wd-cat' => array(
								'--wd-prod-bg:{{VALUE}}; --wd-bordered-bg:{{VALUE}};',
							),
						),
						'dependency'       => array(
							'element' => 'categories_with_background',
							'value'   => array( '1' ),
						),
					),
					array(
						'heading'    => esc_html__( 'Image width', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'wd_slider',
						'param_name' => 'image_container_width',
						'selectors'  => array(
							'{{WRAPPER}}' => array(
								'--wd-cat-img-width: {{VALUE}}{{UNIT}};',
							),
						),
						'devices'    => array(
							'desktop' => array(
								'unit'  => 'px',
								'value' => '',
							),
							'tablet'  => array(
								'unit'  => 'px',
								'value' => '',
							),
							'mobile'  => array(
								'unit'  => 'px',
								'value' => '',
							),
						),
						'range'      => array(
							'px' => array(
								'min'  => 0,
								'max'  => 1000,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'dependency' => array(
							'element' => 'categories_design',
							'value'   => array( 'alt', 'side' ),
						),
					),
					array(
						'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'woodmart_dropdown',
						'param_name'       => 'color_scheme',
						'value'            => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => 'inherit',
							esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
							esc_html__( 'Light', 'studiare-plus' ) => 'light',
						),
						'style'            => array(
							'dark' => '#2d2a2a',
						),
						'std'              => '',
						'dependency'       => array(
							'element' => 'categories_design',
							'value'   => array( 'default', 'mask-subcat' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'    => esc_html__( 'Categories with shadow', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'woodmart_button_set',
						'param_name' => 'categories_with_shadow',
						'value'      => array(
							esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => '',
							esc_html__( 'Enable', 'studiare-plus' ) => 'enable',
							esc_html__( 'Disable', 'studiare-plus' ) => 'disable',
						),
						'dependency' => array(
							'element' => 'categories_design',
							'value'   => array( 'alt', 'default' ),
						),
					),

					array(
						'heading'          => esc_html__( 'Alignment', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'wd_select',
						'param_name'       => 'nav_alignment',
						'style'            => 'images',
						'selectors'        => array(),
						'devices'          => array(
							'desktop' => array(
								'value' => 'left',
							),
						),
						'value'            => array(
							esc_html__( 'Left', 'studiare-plus' )   => 'left',
							esc_html__( 'Center', 'studiare-plus' ) => 'center',
							esc_html__( 'Right', 'studiare-plus' )  => 'right',
						),
						'images'           => array(
							'left'   => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
							'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
							'right'  => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'woodmart_dropdown',
						'param_name'       => 'nav_color_scheme',
						'value'            => array(
							esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => 'inherit',
							esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
							esc_html__( 'Light', 'studiare-plus' ) => 'light',
							esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'type'             => 'wd_colorpicker',
						'heading'          => esc_html__( 'Idle color', 'studiare-plus' ),
						'param_name'       => 'title_idle_color',
						'selectors'        => array(
							'{{WRAPPER}} .wd-nav[class*=wd-style-] > li > a' => array(
								'color: {{VALUE}};',
							),
						),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
						'dependency'       => array(
							'element' => 'nav_color_scheme',
							'value'   => array( 'custom' ),
						),
					),
					array(
						'type'             => 'wd_colorpicker',
						'heading'          => esc_html__( 'Hover color', 'studiare-plus' ),
						'param_name'       => 'title_hover_color',
						'selectors'        => array(
							'{{WRAPPER}} .wd-nav[class*=wd-style-] > li:hover > a' => array(
								'color: {{VALUE}};',
							),
						),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
						'dependency'       => array(
							'element' => 'nav_color_scheme',
							'value'   => array( 'custom' ),
						),
					),
					array(
						'heading'       => esc_html__( 'Rounding', 'studiare-plus' ),
						'group'         => esc_html__( 'Style', 'studiare-plus' ),
						'type'          => 'wd_select',
						'param_name'    => 'rounding_size',
						'style'         => 'select',
						'selectors'     => array(
							'{{WRAPPER}}' => array(
								'--wd-cat-brd-radius: {{VALUE}}px;',
							),
						),
						'devices'       => array(
							'desktop' => array(
								'value' => '',
							),
						),
						'value'         => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => '',
							esc_html__( '0', 'studiare-plus' )      => '0',
							esc_html__( '5', 'studiare-plus' )      => '5',
							esc_html__( '8', 'studiare-plus' )      => '8',
							esc_html__( '12', 'studiare-plus' )     => '12',
							esc_html__( 'Custom', 'studiare-plus' ) => 'custom',
						),
						'dependency'    => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
						'generate_zero' => true,
					),
					array(
						'heading'       => esc_html__( 'Custom rounding', 'studiare-plus' ),
						'group'         => esc_html__( 'Style', 'studiare-plus' ),
						'type'          => 'wd_slider',
						'param_name'    => 'custom_rounding_size',
						'selectors'     => array(
							'{{WRAPPER}}' => array(
								'--wd-cat-brd-radius: {{VALUE}}{{UNIT}};',
							),
						),
						'devices'       => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'         => array(
							'px' => array(
								'min'  => 0,
								'max'  => 300,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'dependency'    => array(
							'element' => 'rounding_size',
							'value'   => function_exists( 'woodmart_compress' ) ? woodmart_compress(
								wp_json_encode(
									array(
										'devices' => array(
											'desktop' => array(
												'value' => 'custom',
											),
										),
									)
								)
							) : '',
						),
						'generate_zero' => true,
					),

					array(
						'type'          => 'woodmart_button_set',
						'heading'       => esc_html__( 'Subcategories', 'studiare-plus' ),
						'param_name'    => 'subcategories',
						'value'         => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => '',
							esc_html__( 'Enable', 'studiare-plus' ) => 'enable',
							esc_html__( 'Disable', 'studiare-plus' ) => 'disable',
						),
						'group'         => esc_html__( 'Style', 'studiare-plus' ),
						'dependency'    => array(
							'element' => 'categories_design',
							'value'   => array( 'mask-subcat', 'side' ),
						),
						'wd_dependency' => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),

					array(
						'type'       => 'woodmart_button_set',
						'heading'    => esc_html__( 'Product count', 'studiare-plus' ),
						'param_name' => 'grid_product_count',
						'value'      => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => '',
							esc_html__( 'Enable', 'studiare-plus' ) => 'enable',
							esc_html__( 'Disable', 'studiare-plus' ) => 'disable',
						),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'dependency' => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),

					$title_typography['font_family'],
					$title_typography['font_size'],
					$title_typography['font_weight'],
					$title_typography['text_transform'],
					$title_typography['font_style'],
					$title_typography['line_height'],

					/**
					 * Layout
					 */
					array(
						'title'      => esc_html__( 'Layout', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'param_name' => 'layout_divider',
						'holder'     => 'div',
						'dependency' => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
					),
					array(
						'heading'          => esc_html__( 'Layout', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'style',
						'save_always'      => true,
						'hint'             => esc_html__( 'Try out our creative styles for categories block', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Grid', 'studiare-plus' )                   => 'default',
							esc_html__( 'Masonry', 'studiare-plus' )                   => 'masonry',
							esc_html__( 'Masonry (with first wide)', 'studiare-plus' ) => 'masonry-first',
							esc_html__( 'Carousel', 'studiare-plus' )                  => 'carousel',
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'grid' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'          => esc_html__( 'Columns', 'studiare-plus' ),
						'hint'             => esc_html__( 'Number of columns in the grid.', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'wd_slider',
						'param_name'       => 'columns',
						'devices'          => array(
							'desktop' => array(
								'unit'  => '-',
								'value' => 4,
							),
							'tablet'  => array(
								'unit'  => '-',
								'value' => '',
							),
							'mobile'  => array(
								'unit'  => '-',
								'value' => '',
							),
						),
						'range'            => array(
							'-' => array(
								'min'  => 1,
								'max'  => 12,
								'step' => 1,
							),
						),
						'selectors'        => array(),
						'dependency'       => array(
							'element' => 'style',
							'value'   => array( 'masonry', 'default' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'    => esc_html__( 'Grid items with different sizes', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'hint'       => esc_html__( 'Specify certain grid items to be doubled in size. Example: “1,3,5', 'studiare-plus' ),
						'type'       => 'textfield',
						'param_name' => 'grid_different_sizes',
						'value'      => '',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( 'default' ),
						),
					),
					array(
						'type'             => 'woodmart_button_set',
						'heading'          => esc_html__( 'Space between categories', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'param_name'       => 'spacing_tabs',
						'tabs'             => true,
						'value'            => array(
							esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
							esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
							esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
						),
						'default'          => 'desktop',
						'edit_field_class' => 'wd-res-control wd-custom-width vc_col-sm-12 vc_column',
					),
					array(
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'spacing',
						'value'            => array(
							esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => '',
							0  => 0,
							2  => 2,
							6  => 6,
							10 => 10,
							20 => 20,
							30 => 30,
						),
						'std'              => '',
						'wd_dependency'    => array(
							'element' => 'spacing_tabs',
							'value'   => array( 'desktop' ),
						),
						'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					),
					array(
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'spacing_tablet',
						'value'            => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => '',
							0  => 0,
							2  => 2,
							6  => 6,
							10 => 10,
							20 => 20,
							30 => 30,
						),
						'std'              => '',
						'wd_dependency'    => array(
							'element' => 'spacing_tabs',
							'value'   => array( 'tablet' ),
						),
						'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					),
					array(
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'dropdown',
						'param_name'       => 'spacing_mobile',
						'value'            => array(
							esc_html__( 'Inherit', 'studiare-plus' ) => '',
							0  => 0,
							2  => 2,
							6  => 6,
							10 => 10,
							20 => 20,
							30 => 30,
						),
						'std'              => '',
						'wd_dependency'    => array(
							'element' => 'spacing_tabs',
							'value'   => array( 'mobile' ),
						),
						'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
					),

					/**
					 * Hidden sidebar settings.
					 */
					array(
						'title'      => esc_html__( 'Hidden sidebar', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'param_name' => 'side_hidden_style_section',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'wd_dependency'    => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
					),
					array(
						'param_name'       => 'mobile_categories_menu_layout',
						'type'             => 'dropdown',
						'heading'          => esc_html__( 'Menu layout', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Dropdown', 'studiare-plus' )  => 'dropdown',
							esc_html__( 'Drilldown', 'studiare-plus' ) => 'drilldown',
						),
						'std'              => 'dropdown',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'param_name'       => 'mobile_categories_drilldown_animation',
						'type'             => 'dropdown',
						'heading'          => esc_html__( 'Drilldown animation', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Slide', 'studiare-plus' )   => 'slide',
							esc_html__( 'Fade in', 'studiare-plus' ) => 'fade-in',
						),
						'std'              => 'slide',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'wd_dependency'    => array(
							'element' => 'mobile_categories_menu_layout',
							'value'   => array( 'drilldown' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'param_name'       => 'mobile_categories_submenu_opening_action',
						'type'             => 'dropdown',
						'heading'          => esc_html__( 'Opening action', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Arrow', 'studiare-plus' ) => 'only_arrow',
							esc_html__( 'Label and arrow', 'studiare-plus' ) => 'item_and_arrow',
						),
						'std'              => 'only_arrow',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'param_name'       => 'mobile_categories_position',
						'type'             => 'woodmart_image_select',
						'heading'          => esc_html__( 'Position', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Left', 'studiare-plus' )   => 'left',
							esc_html__( 'Right', 'studiare-plus' )  => 'right',
						),
						'images_value'     => array(
							'left'   => WOODMART_ASSETS_IMAGES . '/settings/sidebar-layout/left.png',
							'right'  => WOODMART_ASSETS_IMAGES . '/settings/sidebar-layout/right.png',
						),
						'std'              => 'left',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'wood_tooltip'     => true,
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'param_name'       => 'mobile_categories_color_scheme',
						'type'             => 'dropdown',
						'heading'          => esc_html__( 'Color scheme', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'value'            => array(
							esc_html__( 'Default', 'studiare-plus' ) => 'default',
							esc_html__( 'Dark', 'studiare-plus' )    => 'dark',
							esc_html__( 'Light', 'studiare-plus' )   => 'light',
						),
						'std'              => 'default',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'param_name'       => 'mobile_categories_close_btn',
						'type'             => 'woodmart_switch',
						'heading'          => esc_html__( 'Show close button', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'no',
						'dependency'       => array(
							'element' => 'mobile_accordion',
							'value'   => array( 'side-hidden' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),

					array(
						'type'       => 'woodmart_title_divider',
						'holder'     => 'div',
						'title'      => esc_html__( 'Icon options', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'param_name' => 'icon_divider',
						'dependency' => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Alignment', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'param_name' => 'icon_alignment',
						'value'      => array(
							esc_html__( 'Default', 'studiare-plus' ) => 'inherit',
							esc_html__( 'Left', 'studiare-plus' )  => 'left',
							esc_html__( 'Right', 'studiare-plus' ) => 'right',
						),
						'dependency' => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
					),
					array(
						'type'             => 'wd_slider',
						'heading'          => esc_html__( 'Width', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'param_name'       => 'icon_width',
						'selectors'        => array(
							'{{WRAPPER}} .wd-nav-product-cat > li > a .wd-nav-img' => array(
								'--nav-img-width: {{VALUE}}{{UNIT}};',
							),
						),
						'devices'          => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
							'tablet'  => array(
								'value' => '',
								'unit'  => 'px',
							),
							'mobile'  => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'            => array(
							'px' => array(
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							),
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'type'             => 'wd_slider',
						'heading'          => esc_html__( 'Height', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'param_name'       => 'icon_height',
						'selectors'        => array(
							'{{WRAPPER}} .wd-nav-product-cat > li > a .wd-nav-img' => array(
								'--nav-img-height: {{VALUE}}{{UNIT}};',
							),
						),
						'devices'          => array(
							'desktop' => array(
								'value' => '',
								'unit'  => 'px',
							),
							'tablet'  => array(
								'value' => '',
								'unit'  => 'px',
							),
							'mobile'  => array(
								'value' => '',
								'unit'  => 'px',
							),
						),
						'range'            => array(
							'px' => array(
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							),
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => array( 'navigation' ),
						),
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					/**
					 * Carousel
					 */
					array(
						'title'      => esc_html__( 'Carousel', 'studiare-plus' ),
						'group'      => esc_html__( 'Carousel', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'holder'     => 'div',
						'param_name' => 'carousel_divider',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( 'carousel' ),
						),
					),
					/**
					 * Extra
					 */
					array(
						'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'woodmart_title_divider',
						'param_name' => 'extra_divider',
					),
					array(
						'heading'          => esc_html__( 'Lazy loading for images', 'studiare-plus' ),
						'group'            => esc_html__( 'Style', 'studiare-plus' ),
						'type'             => 'woodmart_switch',
						'param_name'       => 'lazy_loading',
						'hint'             => esc_html__( 'Enable lazy loading for images for this element.', 'studiare-plus' ),
						'true_state'       => 'yes',
						'false_state'      => 'no',
						'default'          => 'no',
						'edit_field_class' => 'vc_col-sm-6 vc_column',
					),
					array(
						'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
						'group'      => esc_html__( 'Style', 'studiare-plus' ),
						'type'       => 'textfield',
						'param_name' => 'el_class',
						'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
					),
					array(
						'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
						'group'      => esc_html__( 'Design Options', 'js_composer' ),
						'type'       => 'css_editor',
						'param_name' => 'css',
					),
					woodmart_get_vc_responsive_spacing_map(),

					// Width option (with dependency Columns option, responsive).
					woodmart_get_responsive_dependency_width_map( 'responsive_tabs' ),
					woodmart_get_responsive_dependency_width_map( 'width_desktop' ),
					woodmart_get_responsive_dependency_width_map( 'custom_width_desktop' ),
					woodmart_get_responsive_dependency_width_map( 'width_tablet' ),
					woodmart_get_responsive_dependency_width_map( 'custom_width_tablet' ),
					woodmart_get_responsive_dependency_width_map( 'width_mobile' ),
					woodmart_get_responsive_dependency_width_map( 'custom_width_mobile' ),
				)
			);
	}
}

//Filters For autocomplete param:
//For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
add_filter( 'vc_autocomplete_woodmart_categories_ids_callback', 'woodmart_productCategoryCategoryAutocompleteSuggester', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_woodmart_categories_ids_render', 'woodmart_productCategoryCategoryRenderByIdExact', 10, 1 );

if( ! function_exists( 'woodmart_productCategoryCategoryAutocompleteSuggester' ) ) {
	function woodmart_productCategoryCategoryAutocompleteSuggester( $query, $slug = false ) {
		global $wpdb;
		$cat_id = (int) $query;
		$query = trim( $query );
		$post_meta_infos = $wpdb->get_results(
			$wpdb->prepare( "SELECT a.term_id AS id, b.name as name, b.slug AS slug
						FROM {$wpdb->term_taxonomy} AS a
						INNER JOIN {$wpdb->terms} AS b ON b.term_id = a.term_id
						WHERE a.taxonomy = 'product_cat' AND (a.term_id = '%d' OR b.slug LIKE '%%%s%%' OR b.name LIKE '%%%s%%' )",
				$cat_id > 0 ? $cat_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

		$result = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data = array();
				$data['value'] = $slug ? $value['slug'] : $value['id'];
				$data['label'] = esc_html__( 'Id', 'studiare-plus' ) . ': ' .
				                 $value['id'] .
				                 ( ( strlen( $value['name'] ) > 0 ) ? ' - ' . esc_html__( 'Name', 'studiare-plus' ) . ': ' .
				                                                      $value['name'] : '' ) .
				                 ( ( strlen( $value['slug'] ) > 0 ) ? ' - ' . esc_html__( 'Slug', 'studiare-plus' ) . ': ' .
				                                                      $value['slug'] : '' );
				$result[] = $data;
			}
		}

		return $result;
	}
}
if( ! function_exists( 'woodmart_productCategoryCategoryRenderByIdExact' ) ) {
	function woodmart_productCategoryCategoryRenderByIdExact( $query ) {
		global $wpdb;
		$query = $query['value'];
		$cat_id = (int) $query;
		$term = get_term( $cat_id, 'product_cat' );

		return woodmart_productCategoryTermOutput( $term );
	}
}

if( ! function_exists( 'woodmart_productCategoryTermOutput' ) ) {
	function woodmart_productCategoryTermOutput( $term ) {
		if ( !$term || !is_object( $term ) ) {
			return false;
		}

		$term_slug = $term->slug;
		$term_title = $term->name;
		$term_id = $term->term_id;

		$term_slug_display = '';
		if ( ! empty( $term_slug ) ) {
			$term_slug_display = ' - ' . esc_html__( 'Slug', 'studiare-plus' ) . ': ' . $term_slug;
		}

		$term_title_display = '';
		if ( ! empty( $term_title ) ) {
			$term_title_display = ' - ' . esc_html__( 'Name', 'studiare-plus' ) . ': ' . $term_title;
		}

		$term_id_display = esc_html__( 'Id', 'studiare-plus' ) . ': ' . $term_id;

		$data = array();
		$data['value'] = $term_id;
		$data['label'] = $term_id_display . $term_title_display . $term_slug_display;

		return ! empty( $data ) ? $data : false;
	}
}
