<?php use XTS\Modules\Layouts\Main;

if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );}
/**
* ------------------------------------------------------------------------------------------------
*  Blog element map
* ------------------------------------------------------------------------------------------------
*/
if ( ! function_exists( 'woodmart_get_vc_map_blog' ) ) {
	function woodmart_get_vc_map_blog() {
		$post_types_list = array(
			array( 'post', esc_html__( 'Post', 'studiare-plus' ) ),
			array( 'ids', esc_html__( 'List of IDs', 'studiare-plus' ) ),
		);

		if ( Main::is_layout_type( 'single_post' ) ) {
			$post_types_list[] = array( 'related_posts', esc_html__( 'Related posts', 'studiare-plus' ) );
		}

		$typography = woodmart_get_typography_map(
			array(
				'key'      => 'title',
				'selector' => '{{WRAPPER}} .wd-el-title',
			)
		);

		return array(
			'name'        => esc_html__( 'Blog', 'studiare-plus' ),
			'base'        => 'woodmart_blog',
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'description' => esc_html__( 'Show your blog posts on the page', 'studiare-plus' ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/blog.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),

				/**
				 * Blog title
				 */

				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Title', 'studiare-plus' ),
					'param_name' => 'title_divider',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Element title', 'studiare-plus' ),
					'param_name' => 'element_title',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Tag', 'studiare-plus' ),
					'param_name'       => 'element_title_tag',
					'value'            => array(
						esc_html__( 'h1', 'studiare-plus' )   => 'h1',
						esc_html__( 'h2', 'studiare-plus' )   => 'h2',
						esc_html__( 'h3', 'studiare-plus' )   => 'h3',
						esc_html__( 'h4', 'studiare-plus' )   => 'h4',
						esc_html__( 'h5', 'studiare-plus' )   => 'h5',
						esc_html__( 'h6', 'studiare-plus' )   => 'h6',
						esc_html__( 'div', 'studiare-plus' )  => 'div',
						esc_html__( 'p', 'studiare-plus' )    => 'p',
						esc_html__( 'span', 'studiare-plus' ) => 'span',
					),
					'std'              => 'h4',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'heading'          => esc_html__( 'Color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'title_color',
					'selectors'        => array(
						'{{WRAPPER}} .wd-el-title' => array(
							'color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				$typography['font_family'],
				$typography['font_size'],
				$typography['font_weight'],
				$typography['text_transform'],
				$typography['font_style'],
				$typography['line_height'],

				/**
				 * Post source
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Post source', 'studiare-plus' ),
					'param_name' => 'source_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Data source', 'studiare-plus' ),
					'param_name'       => 'post_type',
					'value'            => $post_types_list,
					'hint'             => esc_html__( 'Select content type for your grid.', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'autocomplete',
					'heading'          => esc_html__( 'Include only', 'studiare-plus' ),
					'param_name'       => 'include',
					'hint'             => esc_html__( 'Add posts, pages, etc. by title.', 'studiare-plus' ),
					'settings'         => array(
						'multiple' => true,
						'sortable' => true,
						'groups'   => true,
					),
					'dependency'       => array(
						'element' => 'post_type',
						'value'   => array( 'ids' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				// Custom query tab
				array(
					'type'             => 'textarea_safe',
					'heading'          => esc_html__( 'Custom query', 'studiare-plus' ),
					'param_name'       => 'custom_query',
					'hint'             => wp_kses(
						__( 'Build custom query according to <a href="http://codex.wordpress.org/Function_Reference/query_posts">WordPress Codex</a>.', 'studiare-plus' ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						)
					),
					'dependency'       => array(
						'element' => 'post_type',
						'value'   => array( 'custom' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'               => 'autocomplete',
					'heading'            => esc_html__( 'Narrow data source', 'studiare-plus' ),
					'param_name'         => 'taxonomies',
					'settings'           => array(
						'multiple'       => true,
						// is multiple values allowed? default false
						// 'sortable' => true, // is values are sortable? default false
						'min_length'     => 1,
						// min length to start search -> default 2
						// 'no_hide' => true, // In UI after select doesn't hide an select list, default false
						'groups'         => true,
						// In UI show results grouped by groups, default false
						'unique_values'  => true,
						// In UI show results except selected. NB! You should manually check values in backend, default false
						'display_inline' => true,
						// In UI show results inline view, default false (each value in own line)
						'delay'          => 500,
						// delay for search. default 500
						'auto_focus'     => true,
						// auto focus input, default true
						// 'values' => $taxonomies_for_filter,
					),
					'param_holder_class' => 'vc_not-for-custom',
					'hint'               => esc_html__( 'Enter categories, tags or custom taxonomies.', 'studiare-plus' ),
					'dependency'         => array(
						'element'            => 'post_type',
						'value_not_equal_to' => array( 'ids', 'related_posts' ),
					),
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Pagination
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Pagination', 'studiare-plus' ),
					'param_name' => 'pagination_divider',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Items per page', 'studiare-plus' ),
					'param_name'       => 'items_per_page',
					'hint'             => esc_html__( 'Number of items to show per page.', 'studiare-plus' ),
					'value'            => '10',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Pagination', 'studiare-plus' ),
					'param_name'       => 'pagination',
					'value'            => array(
						'' => '',
						esc_html__( 'Pagination', 'studiare-plus' ) => 'pagination',
						wp_kses( __( 'Load more button', 'studiare-plus' ), 'entities' ) => 'more-btn',
						esc_html__( 'Infinit scrolling', 'studiare-plus' ) => 'infinit',
					),
					'dependency'       => array(
						'element'            => 'blog_design',
						'value_not_equal_to' => array( 'carousel' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Design
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Design', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'param_name' => 'design_divider',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Blog design', 'studiare-plus' ),
					'param_name'       => 'blog_design',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Default alternative', 'studiare-plus' ) => 'default-alt',
						esc_html__( 'Small images', 'studiare-plus' ) => 'small-images',
						esc_html__( 'Chess', 'studiare-plus' ) => 'chess',
						esc_html__( 'Grid', 'studiare-plus' )  => 'masonry',
						esc_html__( 'Mask on image', 'studiare-plus' ) => 'mask',
						esc_html__( 'Meta on image', 'studiare-plus' ) => 'meta-image',
						esc_html__( 'Carousel', 'studiare-plus' ) => 'carousel',
						esc_html__( 'List', 'studiare-plus' )  => 'list',
					),
					'hint'             => esc_html__( 'You can use different design for your blog styled for the theme', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Blog carousel design', 'studiare-plus' ),
					'param_name' => 'blog_carousel_design',
					'value'      => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'masonry',
						esc_html__( 'Small images', 'studiare-plus' ) => 'small-images',
						esc_html__( 'Mask on image', 'studiare-plus' ) => 'mask',
						esc_html__( 'Meta on image', 'studiare-plus' ) => 'meta-image',
					),
					'hint'       => esc_html__( 'You can use different design for your blog carousel', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'dependency' => array(
						'element' => 'blog_design',
						'value'   => array( 'carousel' ),
					),
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Masonry', 'studiare-plus' ),
					'param_name'       => 'blog_masonry',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 0,
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'masonry', 'mask' ),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Images size', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'param_name' => 'img_size',
					'hint'       => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Columns', 'studiare-plus' ),
					'hint'             => esc_html__( 'Number of columns in the grid.', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'param_name'       => 'columns_tabs',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'masonry', 'mask', 'meta-image' ),
					),
					'default'          => 'desktop',
					'edit_field_class' => 'wd-res-control wd-custom-width vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'blog_columns',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'value'            => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'std'              => '3',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'masonry', 'mask', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'desktop' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'blog_columns_tablet',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Auto', 'studiare-plus' ) => 'auto',
						'1'                              => '1',
						'2'                              => '2',
						'3'                              => '3',
						'4'                              => '4',
					),
					'std'              => 'auto',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'masonry', 'mask', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'tablet' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'param_name'       => 'blog_columns_mobile',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'value'            => array(
						esc_html__( 'Auto', 'studiare-plus' ) => 'auto',
						'1'                              => '1',
						'2'                              => '2',
						'3'                              => '3',
						'4'                              => '4',
					),
					'std'              => 'auto',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'masonry', 'mask', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'columns_tabs',
						'value'   => array( 'mobile' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Space between posts', 'studiare-plus' ),
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'param_name'       => 'blog_spacing_tabs',
					'tabs'             => true,
					'value'            => array(
						esc_html__( 'Desktop', 'studiare-plus' ) => 'desktop',
						esc_html__( 'Tablet', 'studiare-plus' ) => 'tablet',
						esc_html__( 'Mobile', 'studiare-plus' ) => 'mobile',
					),
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'mask', 'masonry', 'carousel', 'meta-image' ),
					),
					'default'          => 'desktop',
					'edit_field_class' => 'wd-res-control wd-custom-width vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'param_name'       => 'blog_spacing',
					'value'            => array(
						esc_html__( 'Inherit from Theme Settings', 'studiare-plus' ) => '',
						0  => 0,
						2  => 2,
						6  => 6,
						10 => 10,
						20 => 20,
						30 => 30,
					),
					'std'              => '',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'mask', 'masonry', 'carousel', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'blog_spacing_tabs',
						'value'   => array( 'desktop' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'param_name'       => 'blog_spacing_tablet',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						0  => 0,
						2  => 2,
						6  => 6,
						10 => 10,
						20 => 20,
						30 => 30,
					),
					'std'              => '',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'mask', 'masonry', 'carousel', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'blog_spacing_tabs',
						'value'   => array( 'tablet' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				array(
					'type'             => 'dropdown',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'param_name'       => 'blog_spacing_mobile',
					'value'            => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						0  => 0,
						2  => 2,
						6  => 6,
						10 => 10,
						20 => 20,
						30 => 30,
					),
					'std'              => '',
					'dependency'       => array(
						'element' => 'blog_design',
						'value'   => array( 'mask', 'masonry', 'carousel', 'meta-image' ),
					),
					'wd_dependency'    => array(
						'element' => 'blog_spacing_tabs',
						'value'   => array( 'mobile' ),
					),
					'edit_field_class' => 'wd-res-item vc_col-sm-12 vc_column',
				),
				/**
				 * Carousel
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Carousel', 'studiare-plus' ),
					'group'      => esc_html__( 'Carousel', 'studiare-plus' ),
					'param_name' => 'carousel_divider',
					'dependency' => array(
						'element' => 'blog_design',
						'value'   => array( 'carousel' ),
					),
				),
				/**
				 * Elements visibility
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Elements visibility', 'studiare-plus' ),
					'group'      => esc_html__( 'Design', 'studiare-plus' ),
					'param_name' => 'visibility_divider',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Title for posts', 'studiare-plus' ),
					'param_name'       => 'parts_title',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Meta information', 'studiare-plus' ),
					'param_name'       => 'parts_meta',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Post text', 'studiare-plus' ),
					'param_name'       => 'parts_text',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Read more button', 'studiare-plus' ),
					'param_name'       => 'parts_btn',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Published date', 'studiare-plus' ),
					'param_name'       => 'parts_published_date',
					'group'            => esc_html__( 'Design', 'studiare-plus' ),
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				// Data settings
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Data settings', 'studiare-plus' ),
					'group'      => esc_html__( 'Data Settings', 'studiare-plus' ),
					'param_name' => 'data_tab_divider',
				),
				array(
					'type'               => 'dropdown',
					'heading'            => esc_html__( 'Order by', 'studiare-plus' ),
					'param_name'         => 'orderby',
					'value'              => array(
						esc_html__( 'Date', 'studiare-plus' )   => 'date',
						esc_html__( 'Order by post ID', 'studiare-plus' ) => 'ID',
						esc_html__( 'Author', 'studiare-plus' ) => 'author',
						esc_html__( 'Title', 'studiare-plus' )  => 'title',
						esc_html__( 'Last modified date', 'studiare-plus' ) => 'modified',
						esc_html__( 'Post/page parent ID', 'studiare-plus' ) => 'parent',
						esc_html__( 'Number of comments', 'studiare-plus' ) => 'comment_count',
						esc_html__( 'Menu order/Page Order', 'studiare-plus' ) => 'menu_order',
						esc_html__( 'Meta value', 'studiare-plus' ) => 'meta_value',
						esc_html__( 'Meta value number', 'studiare-plus' ) => 'meta_value_num',
						esc_html__( 'Random order', 'studiare-plus' ) => 'rand',
						esc_html__( 'List of IDS', 'studiare-plus' ) => 'post__in',
					),
					'hint'               => esc_html__( 'Select order type. If "Meta value" or "Meta value Number" is chosen then meta key is required.', 'studiare-plus' ),
					'group'              => esc_html__( 'Data Settings', 'studiare-plus' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'               => 'dropdown',
					'heading'            => esc_html__( 'Sorting', 'studiare-plus' ),
					'param_name'         => 'order',
					'group'              => esc_html__( 'Data Settings', 'studiare-plus' ),
					'value'              => array(
						esc_html__( 'Descending', 'studiare-plus' ) => 'DESC',
						esc_html__( 'Ascending', 'studiare-plus' ) => 'ASC',
					),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'hint'               => esc_html__( 'Select sorting order.', 'studiare-plus' ),
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'               => 'textfield',
					'heading'            => esc_html__( 'Meta key', 'studiare-plus' ),
					'param_name'         => 'meta_key',
					'hint'               => esc_html__( 'Input meta key for grid ordering.', 'studiare-plus' ),
					'group'              => esc_html__( 'Data Settings', 'studiare-plus' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency'         => array(
						'element' => 'orderby',
						'value'   => array( 'meta_value', 'meta_value_num' ),
					),
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'               => 'textfield',
					'heading'            => esc_html__( 'Offset', 'studiare-plus' ),
					'param_name'         => 'offset',
					'hint'               => esc_html__( 'Number of grid elements to displace or pass over.', 'studiare-plus' ),
					'group'              => esc_html__( 'Data Settings', 'studiare-plus' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency'         => array(
						'element'            => 'post_type',
						'value_not_equal_to' => array( 'ids' ),
					),
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'               => 'autocomplete',
					'heading'            => esc_html__( 'Exclude', 'studiare-plus' ),
					'param_name'         => 'exclude',
					'hint'               => esc_html__( 'Exclude posts, pages, etc. by title.', 'studiare-plus' ),
					'group'              => esc_html__( 'Data Settings', 'studiare-plus' ),
					'settings'           => array(
						'multiple' => true,
					),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency'         => array(
						'element'            => 'post_type',
						'value_not_equal_to' => array( 'ids', 'related_posts' ),
						'callback'           => 'vc_grid_exclude_dependency_callback',
					),
					'edit_field_class'   => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Extra
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_divider',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Lazy loading for images', 'studiare-plus' ),
					'hint'             => esc_html__( 'Enable lazy loading for images for this element.', 'studiare-plus' ),
					'param_name'       => 'lazy_loading',
					'true_state'       => 'yes',
					'false_state'      => 'no',
					'default'          => 'no',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
		);
	}
}

// Necessary hooks for blog autocomplete fields
add_filter( 'vc_autocomplete_woodmart_blog_include_callback', 'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter(
	'vc_autocomplete_woodmart_blog_include_render',
	'vc_include_field_render',
	10,
	1
); // Render exact product. Must return an array (label,value)

// Narrow data taxonomies
add_filter( 'vc_autocomplete_woodmart_blog_taxonomies_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_woodmart_blog_taxonomies_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

// Narrow data taxonomies for exclude_filter
add_filter( 'vc_autocomplete_woodmart_blog_exclude_filter_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_woodmart_blog_exclude_filter_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

add_filter( 'vc_autocomplete_woodmart_blog_exclude_callback', 'vc_exclude_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_woodmart_blog_exclude_render', 'vc_exclude_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)
